<?php

/**
 * Conference for JohnCMS
 * Display conference
 * @author Screamer
 * @copyright 2013
 */

/**
 * Display conference
 * @param (int) $id ID of conference
 * @param (int) $page Number of page
 * @return (string|void)
 */
function action_view($sys, $id = 0, $page = 0) {
	$data = $sys->jl->model('conference')->get($id);
	$user_id = $sys->jl->get_data('user_data', 'id');
	if (!empty($data)) {
		// Check access
		if ($user_id != $data['owner_id']) {
			if ($data['type'] == 2) {
				// Private access
				if (!$sys->jl->model('private')->is_private($data['id'], $user_id)) {
					jl_redirect();
				}
			} elseif ($data['type'] == 1) {
				// For friends only
				if (!$sys->jl->model('jlayer')->is_friend($data['owner_id'], $user_id)) {
					jl_redirect();
				}
			}
		}
		// Send message
		$error = ''; // Error message
		$message = ''; // Message
		if (!empty($_POST)) {
			$message = isset($_POST['message']) ? trim($_POST['message']) : '';
			$message_len = mb_strlen($message);
			if ($message_len < 2 || $message_len > 3000) {
				$error = sprintf($sys->lng->wrong_string_len, 2, 3000);
			} else {
				if ((time() - $data['last_clean']) >= ($data['autoclean'] * 3600)) {
					// Autoclean log
					$sys->jl->model('messages')->remove($data['id']);
					$sys->jl->model('conference')->clean_update($data['id']);
				}
				$sys->jl->model('messages')->save($data['id'], $user_id, $message);
				jl_redirect('conference/view/' . $data['id']);
			}
		}
		// Get list of messages
		$total = $sys->jl->model('messages')->count($data['id']);
		$pagination = new JL_Pagination(jl_anchor('conference/view/' . $data['id']), $total, $page, $sys->jl->get_data('user_settings', 'kmess'));
		if ($total > 0) {
			$messages = '';
			$limit = $pagination->get_position();
			$get_messages = $sys->jl->model('messages')->get_list($data['id'], $limit['start'], $limit['end']);
			$i = 0;
			foreach ($get_messages as $item) {
				$messages .= $sys->tpl->load('_JL_User_item', array(
					'i'         => (!($i % 2) ? 1 : 2),
					'user_item' => functions::display_user($item, array(
						'header' => '(' . functions::display_date($item['time']) . ')'
							. '&#160;<a href="javascript:answer(\'' . htmlspecialchars($item['name']) . '\')">&gt;&gt;</a>',
						'body'   => functions::smileys(functions::checkout($item['message'], 1, 1), true),
					))
				));
				$i++;
			}
		} else {
			$messages = jl_message($sys->lng->list_empty);
		}
		// Top menu
		$top_menu = array(jl_anchor('conference/download/' . $id . '.txt', $sys->lng->download_log));
		if (($user_id == $data['owner_id']) || $sys->jl->get_data('user_data', 'rights') == 9) {
			if ($user_id == $data['owner_id']) {
				if (($data['type'] == 2)) {
					$top_menu[] = jl_anchor('conference/private/' . $id, $sys->lng->users_list);
				}
				$top_menu[] = jl_anchor('conference/clean/' . $id, $sys->lng->clear_log);
				$top_menu[] = jl_anchor('conference/form/' . $id, $sys->lng->edit);
			}
			$top_menu[] = jl_anchor('conference/remove/' . $id, $sys->lng->remove);
		}
		$data['name'] = htmlspecialchars($data['name'], ENT_QUOTES, 'UTF-8');
		$sys->tpl->set_title($data['name']);
		return $sys->tpl->load('view', array(
			'title'      => $sys->tpl->get_title(),
			'top_menu'   => $top_menu,
			'message'    => htmlspecialchars($message),
			'error'      => $error,
			'messages'   => $messages,
			'pagination' => $pagination->create_links(),
			'lang'       => $sys->lng,
		));
	} else {
		jl_redirect();
	}
}