<?php

/**
 * Conference for JohnCMS
 * Conferences handler
 * @author Screamer
 * @copyright 2013
 */

class Model_Conference extends JL_Model {

	/**
	 * Update time of last clear logs operation
	 * @param (int|null) $cid ID of conference
	 * @return (void)
	 */
	public function clean_update($cid = null) {
		$this->db->query(
			"UPDATE `" . $this->table_prefix . "_list` SET `last_clean` = '" . time() . "' "
			. (!is_null($cid) ? "WHERE `id` = '" . intval($cid) . "'" : "")
		);
	}

	/**
	 * Deal of conferences
	 * @param (int|null) $owner ID of user (optional)
	 * @return (int)
	 */
	public function count($owner = null) {
		$statement = "SELECT COUNT(*) FROM `" . $this->table_prefix . "_list`";
		if (!is_null($owner)) {
			$statement .= " WHERE `owner_id` = '" . intval($owner) . "'";
		}
		return $this->db->result($statement);
	}

	/**
	 * Get data of conference
	 * @param (int) $id ID of conference
	 * @return (array)
	 */
	public function get($id) {
		$result = $this->db->query("SELECT * FROM `" . $this->table_prefix . "_list` WHERE `id` = '" . intval($id) . "'");
		$data = $this->db->fetch_assoc($result);
		return is_array($data) ? $data : array();
	}

	/**
	 * Get list of conferences
	 * @param (int) $start Start position (optional)
	 * @param (int) $end End position (optional)
	 * @param (int|null) $owner ID of user (optional)
	 * @return (array)
	 */
	public function get_list($start = 0, $end = 0, $owner = null) {
		$start = abs(intval($start));
		$end = abs(intval($end));
		$statement = "SELECT * FROM `" . $this->table_prefix . "_list`";
		if (!is_null($owner)) {
			$statement .= " WHERE `owner_id` = '" . intval($owner) . "'";
		}
		$statement .= " ORDER BY `name` ASC";
		if ($start != 0 || $end != 0) {
			$statement .= " LIMIT " . $start . ", " . $end;
		}
		$list = array();
		$result = $this->db->query($statement);
		while ($item = $this->db->fetch_assoc($result)) {
			$list[] = $item;
		}
		return $list;
	}

	/**
	 * Remove conference
	 * @param (int) $id ID of conference
	 * @return (void)
	 */
	public function remove($id) {
		$this->db->query("DELETE FROM `" . $this->table_prefix . "_list` WHERE `id` = '" . intval($id) . "'");
	}

	/**
	 * Save data of conference
	 * @param (string) $name Name of conference
	 * @param (int) $type Type of conference (0 - free; 1 - friends; 2 - private)
	 * @param (int) $owner_id ID of owner user
	 * @param (string) $owner_name Name of owner user
	 * @param (int) $id ID of conference (if is zero, create new conference)
	 * @return (int) ID of conference
	 */
	public function save($name, $type, $owner_id, $owner_name, $id = 0) {
		$id = abs(intval($id));
		$this->db->query(
			($id == 0 ? "INSERT INTO" : "UPDATE")
			. " `" . $this->table_prefix . "_list` SET "
			. "`name` = '" . $this->db->escape_string($name) . "', "
			. "`type` = '" . intval($type) . "', "
			. "`owner_id` = '" . intval($owner_id) . "', "
			. "`owner_name` = '" . $this->db->escape_string($owner_name) . "'"
			. ($id == 0 ? ", `last_clean` = '" . time() . "'" : " WHERE `id` = '" . $id . "'")
		);
		return $id == 0 ? $this->db->insert_id() : $id;
	}

}