<?php

/**
 * Conference for JohnCMS
 * Messages handler
 * @author Screamer
 * @copyright 2013
 */

class Model_Messages extends JL_Model {

	/**
	 * Count messages in conference
	 * @param (int) $cid ID of conference
	 * @return (int)
	 */
	public function count($cid) {
		return $this->db->result("SELECT COUNT(*) FROM `" . $this->table_prefix . "_messages` WHERE `cid` = '" . intval($cid) . "'");
	}

	/**
	 * Get list of messages
	 * @param (int) $cid ID of conference
	 * @param (int) $start Start position
	 * @param (int) $end End position
	 * @return (array)
	 */
	public function get_list($cid, $start = 0, $end = 0) {
		$start = intval($start);
		$end = intval($end);
		$messages_table = "`" . $this->table_prefix . "_messages`";
		$result = $this->db->query(
			"SELECT " . $messages_table . ".*, `users`.* FROM " . $messages_table
			. " LEFT JOIN `users` ON " . $messages_table . ".`uid` = `users`.`id` "
			. " WHERE " . $messages_table . ".`cid` = '" . intval($cid) . "' "
			. "ORDER BY `time` DESC "
			. (($start != 0 && $end != 0) ? "LIMIT " . $start . ", " . $end : "")
		);
		$list = array();
		while ($item = $this->db->fetch_assoc($result)) {
			$list[] = $item;
		}
		return $list;
	}

	/**
	 * Remove message
	 * @param (int) $cid ID of conference
	 * @return (void)
	 */
	public function remove($cid = 0) {
		$this->db->query("DELETE FROM `" . $this->table_prefix . "_messages` " . ($cid != 0 ? "WHERE `cid` = '" . intval($cid) . "'" : ""));
	}

	/**
	 * Add message
	 * @param (int) $cid ID of conference
	 * @param (int) $uid ID of user
	 * @param (string) $message Message
	 * @return (void)
	 */
	public function save($cid, $uid, $message) {
		$this->db->query(
			"INSERT INTO `" . $this->table_prefix . "_messages` SET "
			. "`cid` = '" . intval($cid) . "', "
			. "`uid` = '" . intval($uid) . "', "
			. "`message` = '" . $this->db->escape_string($message) . "', "
			. "`time` = '" . time() . "'"
		);
	}

}