<?php

define( '_IN_JOHNCMS',1);
$headmod = 'fir-tree';
require ( '../incfiles/core.php');
$textl = 'Ёлочка';
require ( '../incfiles/head.php');

//Задаем число пунктов для 1 лвл
$pointLvl = 25;

/*
-----------------------------------------------------------------
Функция отображения ёлки
-----------------------------------------------------------------
*/
function displayFirTree($data, $set = array('image' => 0,  'user' =>  0, 'link' => 0), $comms = true) {
    global $pointLvl;

	$level = floor($data['fir-tree_lvl'] / $pointLvl);
	$rest = $data['fir-tree_lvl'] - $level*$pointLvl;
  	$progress = $rest ? round(100 / $pointLvl * $rest) : 0;

	$out = '';

	if($set['image']) {
		$out .= '<img src="images/fir-tree/' . $data['fir-tree'] . '.jpg" width="70" height="73" alt="+" /><br />';
    }

   	if($data['fir-tree_rating'] > 0) {
   		$data['fir-tree_rating'] = '<span class="green">' . $data['fir-tree_rating'] . '</span>';
   	} else if($data['fir-tree_rating'] < 0) {
   		$data['fir-tree_rating'] = '<span class="red">' . $data['fir-tree_rating'] . '</span>';
   	}

	$plm = explode('|', $data['fir-tree_rating_plm']);

	$out .=
	'<b>Уровень:</b> ' . $level . '<br />' .
    '<b>Прогресс:</b><br /> <img src="progress.php?point=' . $progress . '" width="" height="" alt="level"  /><br />' .
    '<b>Рейтинг:</b> ' . $data['fir-tree_rating'] . ' (+' . $plm[0] . ' / -' . $plm[1] . ')';

	if($set['user']) {
		$out .= '<br /><b>Хозяин:</b> <a href="/users/profile.php?user=' . $data['id'] . '">' . $data['name'] . '</a>';
   	}
    if($comms) {
		$out .= '<br /><a href="index.php?act=comments&amp;id=' . $data['id'] . '">Комментарии</a> (' . $data['fir-tree_comms'] . ')';
   	}
	if($set['link']) {
		$out .= '<br /><a href="index.php?act=user&amp;id=' . $data['id'] . '">Смотреть</a>';
   	}

	return $out;
}

/*
-----------------------------------------------------------------
Проверяем, авторизован ли пользователь
-----------------------------------------------------------------
*/
if ( !$user_id) {
	echo functions::display_error('Только для зарегистрированных посетителей!');
    require ( '../incfiles/end.php');
    exit;
}


/*
-----------------------------------------------------------------
Переключаем режимы работы
-----------------------------------------------------------------
*/
$array = array(
    'choice' => 'includes',
    'user' => 'includes',
    'users' => 'includes',
    'level' => 'includes',
   	'rating' => 'includes',
   	'comments' => 'includes',
   	'top_comms' => 'includes',
   	'gift' => 'includes'
);
$path = !empty($array[$act]) ? $array[$act] . '/' : '';
if (array_key_exists($act, $array) && file_exists($path . $act . '.php')) {
    require_once($path . $act . '.php');
} else {

    /*
    -----------------------------------------------------------------
    Главная страница модуля
    -----------------------------------------------------------------
    */
    echo '<div class="phdr"><b>Ёлочка</b></div>';

    if(!$datauser['fir-tree']) {
		echo '<div class="gmenu"><p><a href="index.php?act=choice">Выбрать ёлку</a></p></div>';
	} else {
		/*
		-----------------------------------------------------------------
		Ухаживаем за ёлкой
		-----------------------------------------------------------------
		*/
        $time = 0;
		$times = $datauser['fir-tree_time'] ? unserialize($datauser['fir-tree_time']) : array(
    												'water' => 1,
    												'fertilize' => 1,
    												'cut' => 1,
    												);

		if(isset($_GET['water'])) {
        	$time = $times['water'];
        	$field = 'water';
        	$point = 1;
        	$period = 3;
        } elseif(isset($_GET['fertilize'])) {
        	$time = $times['fertilize'];
        	$field = 'fertilize';
        	$point = 2;
        	$period = 12;
        } elseif(isset($_GET['cut'])) {
        	$time = $times['cut'];
        	$field = 'cut';
        	$point = 3;
        	$period = 24;
        }

       	if($time) {

            if(time() > ($time + $period*3600)) {
            	$times[$field] = time();
                $datauser['fir-tree_lvl'] = $datauser['fir-tree_lvl'] + $point;
                mysql_query( "UPDATE `users` SET `fir-tree_lvl` = '" . $datauser['fir-tree_lvl'] . "', `fir-tree_time`='" . serialize($times) . "'  WHERE `id` = '$user_id'");
                echo '<div class="rmenu">Действие выполнено</div>';
			} else {
				echo '<div class="rmenu">Нельзя совершить действие</div>';
			}
		}

		/*
		-----------------------------------------------------------------
		Выводим нашу ёлку и меню и управления
		-----------------------------------------------------------------
		*/
		$level = floor($datauser['fir-tree_lvl'] / $pointLvl);
		$rest = $datauser['fir-tree_lvl'] - $level*$pointLvl;
  		$progress = $rest ? round(100 / $pointLvl * $rest) : 0;

		echo '<div class="gmenu"><img src="images/fir-tree/' . $datauser['fir-tree'] . '.jpg" alt="+" />' .
		'<div class="sub"></div>' .
		displayFirTree($datauser) . '</div>' .
		'<div class="phdr"><b>Управление</b></div>' .
		'<div class="list1"><a href="index.php?water">Полить ёлочку</a> [+1 раз в 3 часа]' .
	    '<div class="sub">Последний раз: <span class="green">' . functions::display_date($times['water']) . '</span></div></div>' .
	    '<div class="list2"><a href="index.php?fertilize">Удобрять почву</a> [+2 раз в 12 часов]' .
	    '<div class="sub">Последний раз: <span class="green">' . functions::display_date($times['fertilize']) . '</span></div></div>' .
	    '<div class="list1"><a href="index.php?cut">Обрезать сухие ветки</a> [+3 раз в сутки]' .
	    '<div class="sub">Последний раз: <span class="green">' . functions::display_date($times['cut']) . '</span></div></div>';

		/*
		-----------------------------------------------------------------
		Блок подарков
		-----------------------------------------------------------------
		*/
		$total = mysql_result(mysql_query("SELECT COUNT(*) FROM `fir-tree_gifts` WHERE `fir_tree_id` = $user_id"), 0);
		if($total) {
			echo '<div class="phdr"><b>Подарки под ёлкой</b></div>';

			$req = mysql_query("SELECT `fir-tree_gifts`.*, `fir-tree_gifts`.`id` AS `gid`, `users`.`rights`, `users`.`lastdate`, `users`.`sex`, `users`.`name`, `users`.`status`, `users`.`datereg`, `users`.`id`
	       	FROM `fir-tree_gifts` LEFT JOIN `users` ON `fir-tree_gifts`.`user_id` = `users`.`id`
	       	WHERE `fir-tree_gifts`.`fir_tree_id`='$user_id' ORDER BY `time` DESC LIMIT " . $start . "," . $kmess);

			for($i = 0; ($res = mysql_fetch_assoc($req)) !== false; $i++){

				echo ($i % 2 ? '<div class="list2">' : '<div class="list1">') .
				'<table cellpadding="0" cellspacing="0"><tr><td>' .
				'<img src="images/gifts/' . $res['gid'] . '.png" width="32" height="32" alt="" />&#160;</td><td>';
		         if ($res['sex']) {
		               echo '<img src="' . core::$system_set['homeurl'] . '/theme/' . core::$user_set['skin'] . '/images/' . ($res['sex'] == 'm' ? 'm' : 'w') . ($res['datereg'] > time() - 86400 ? '_new' : '')
		               . '.png" width="16" height="16" align="middle" alt="' . ($res['sex'] == 'm' ? 'М' : 'Ж') . '" />&#160;';
		         } else {
		                echo '<img src="' . core::$system_set['homeurl'] . '/images/del.png" width="12" height="12" align="middle" />&#160;';
		         }
		        echo (core::$user_id || core::$user_id == $res['id'] ? '<b>' . $res['name'] . '</b>' : '<a href="' . core::$system_set['homeurl'] . '/users/profile.php?user=' . $res['id'] . '"><b>' . $res['name'] . '</b></a>') .
		        (time() > $res['lastdate'] + 300 ? '<span class="red"> [Off]</span>' : '<span class="green"> [ON]</span>') . '<br />' .
		        '<small>' . functions::display_date($res['time']) . '</small></td></tr></table></div>';
			}

			echo '<div class="phdr">Всего: ' . $total . '</div>';

			if ($total > $kmess) {
			    echo '<div class="topmenu">' . functions::display_pagination('index.php?act=user&amp;id=' .$id . '&amp;', $start, $total, $kmess) . '</div>' .
			        '<p><form action="index.php?act=user&amp;id=' .$id . '" method="post">' .
			        '<input type="text" name="page" size="2"/>' .
			        '<input type="submit" value="' . $lng['to_page'] . ' &gt;&gt;"/>' .
			        '</form></p>';
			}
		}
	}

	/*
	-----------------------------------------------------------------
	Меню навигации по модулю
	-----------------------------------------------------------------
	*/

    $all = mysql_result(mysql_query("SELECT COUNT(*) FROM `users` WHERE `fir-tree` > 0"), 0);
    echo '<div class="phdr"><b>Меню</b></div>' .
	'<div class="list1"><a href="index.php?act=users">Все ёлочки</a> (' . $all . ')</div>' .
    '<div class="list2"><a href="index.php?act=level">Топ по уровню</a></div>' .
    '<div class="list1"><a href="index.php?act=rating">Топ по рейтингу</a></div>' .
    '<div class="list2"><a href="index.php?act=top_comms">Топ комментируемых</a></div>' .
    '<div class="phdr"><br /></div>';
}

require ( '../incfiles/end.php');
