# Translator

[![Latest Version on Packagist][ico-version]][link-packagist]
[![Software License][ico-license]](LICENSE)
[![Build Status][ico-travis]][link-travis]
[![Quality Score][ico-scrutinizer]][link-scrutinizer]
[![Total Downloads][ico-downloads]][link-downloads]

Created by Oscar Otero <http://oscarotero.com> <oom@oscarotero.com> (MIT License)

Translator functions to use with [gettext/gettext](https://github.com/php-gettext/Gettext). Useful if you don't have the native gettext extension for php or want to avoid problems with it.

## Installation

```
composer require gettext/translator
```

## Translator

```php
use Gettext\Translator;

//Create a new instance of the translator
$t = new Translator();

//Load the translations from php files (generated by Gettext\Extractors\PhpArray)
$t->loadTranslations(
    'locales/gl/domain1.php',
    'locales/gl/domain2.php',
    'locales/gl/domain3.php',
);

//Now you can use it in your templates
echo $t->gettext('apple');
```

## GettextTranslator

The class `Gettext\GettextTranslator` uses the gettext extension. It's useful because combines the performance of using real gettext functions but with the same API than `Translator` class, so you can switch to one or other translator without change code of your app.

```php
use Gettext\GettextTranslator;

//Create a new instance
$t = new GettextTranslator();

//It detects the environment variables to set the locale, but you can change it:
$t->setLanguage('gl');

//Load the domains:
$t->loadDomain('messages', 'project/Locale');
//this means you have the file "project/Locale/gl/LC_MESSAGES/messages.po"

//Now you can use it in your templates
echo $t->gettext('apple');
```

## Translator functions

To ease the use of translations in your php templates, you can use the provided functions:

```php
use Gettext\TranslatorFunctions;

//Register the translator to use the global functions
TranslatorFunctions::register($t);

echo __('apple'); // it's the same than $t->gettext('apple');
```

You can scan the php files containing these functions and extract the values with the PhpCode extractor:

```html
<!-- index.php -->
<html>
    <body>
        <?= __('Hello world'); ?>
    </body>
</html>
```

---

Please see [CHANGELOG](CHANGELOG.md) for more information about recent changes and [CONTRIBUTING](CONTRIBUTING.md) for contributing details.

The MIT License (MIT). Please see [LICENSE](LICENSE) for more information.

[ico-version]: https://img.shields.io/packagist/v/gettext/translator.svg?style=flat-square
[ico-license]: https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat-square
[ico-travis]: https://img.shields.io/travis/php-gettext/PHP-Scanner/Translator.svg?style=flat-square
[ico-scrutinizer]: https://img.shields.io/scrutinizer/g/php-gettext/Translator.svg?style=flat-square
[ico-downloads]: https://img.shields.io/packagist/dt/gettext/translator.svg?style=flat-square

[link-packagist]: https://packagist.org/packages/gettext/translator
[link-travis]: https://travis-ci.org/php-gettext/Translator
[link-scrutinizer]: https://scrutinizer-ci.com/g/php-gettext/Translator
[link-downloads]: https://packagist.org/packages/gettext/translator
