# Changelog 
This project follows [semantic versioning](https://semver.org/).  
All notable changes to this project will be documented in this file.  
Detailed change can see in the [repository log](https://github.com/johncms/johncms/commits).

## 9.2.0 - unreleased

#### Added
- Внедрена библиотека для работы с базой данных [illuminate/database](https://github.com/illuminate/database)
- Для работы с пользователями добавлен класс (модель) [Johncms\Users\User](https://github.com/johncms/johncms/blob/develop/system/src/Users/User.php) Наследует `Illuminate\Database\Eloquent\Model` со всем вытекающим функционалом.
- Для работы с уведомлениями добавлен класс (модель) [Johncms\Notifications\Notification](https://github.com/johncms/johncms/blob/develop/system/src/Notifications/Notification.php) Наследует `Illuminate\Database\Eloquent\Model` со всем вытекающим функционалом.
- Добавлена возможность просмотра списка запросов, которые были выполнены на данной странице (функционал работает только для запросов выполненных через ORM). Запросы через обычный PDO не учитываются.
- В ORM добавлена упрощенная возможность работы с постраничной навигацией. Достаточно вызвать метод `->paginate()`. При этом запрос количества объектов и установка ограничений будет выполнена автоматически. URL адреса так же формируются автоматически исходя из адреса текущей страницы.
- В классе `Johncms\System\Http\Request` добавлен метод `getQueryString()`, который позволяет получить текущий URL с отсечением ненужных параметров.
- В стандартном шаблоне добавлена возможность замены мета тегов keywords и description.

#### Changed
- Модуль кто онлайн переделан для использования ORM.
- Модуль community переделан на новое api пользователей.
- В модуль уведомлений добавлены настройки отображения непрочитанных на форуме
- В модуль уведомлений добавлено оповещение об ответах и цитатах на форуме
- В модуле уведомлений теперь отображаются уведомления о голосах в карме пользователя.
- Сторонние модули могут добавлять свои уведомления в центр уведомлений.
- Рефакторинг страниц личного кабинета для использования ORM. Попутно доработана модель пользователя, она теперь позволяет получить практически все данные пользователя в подготовленном виде в любом месте где используется `Johncms\Users\User`

#### Deprecated

#### Removed

#### Fixed
- Исправлена ошибка на странице профиля. Отображался не последний бан.
- Исправлена ошибка в форуме, когда файл отсутствовал в файловой системе, но был в БД
- Испралвено отображение переводов для должностей
- В библиотеке админ не мог редактировать статьи других пользователей.
- На странице просмотра онлайн на небольших разрешениях экранов съезжали кнопки для выбора списков онлайна.
- Исправлено отображение файлов в почте в ios 10
- Небыло шаблона для страницы модерации статей в библиотеке
- Списке банов отсутствовали переводы фраз типов блокировок
- Не работала страница сброса пользовательских настроек

#### Security


## 9.1.0 - 2020-02-16

#### Added
- Добавлена поддержка php библиотеки GD в том случае если Imagick отсутствует.
- В стандартный шаблон добавлена возможность вставлять свои скрипты и стили $this->push('styles') $this->push('scripts') $this->stop()
- В профиле добавлено отображение информации о том, что пользователь заблокирован, так же добалвена ссылка на страницу истории нарушений.
- Если к посту на форуме прикреплено несколько изображений, то они будут открываться в галерее.
- Скриншоты в загрузках (если их несколько) открываются и листаются в галерее.

#### Changed
- В загрузках увеличено максимальное количество символов в описании.
- Изменен дизайн отдельной страницы просмотра поста

#### Deprecated

#### Removed

#### Fixed
- Исправлена ошибка в постраничной навигации в поиске по форуму
- Исправлено отображение шапки форума на некоторых разрешениях
- Если к посту прикреплено несколько файлов, на странице просмотра поста отображался только один
- Исправлено отображение IP при наличии определенного через прокси реального ip пользователя.
- Исправлена ошибка из-за которой открепленный топик на форуме оставался выше остальных в списке

#### Security

## 9.0.0 - 2020-02-09

#### Added
- Внедрен роутер [nikic/fast-route](https://github.com/nikic/FastRoute)
- Внедрен нативный PHP шаблонизатор [mobicms/render](https://github.com/mobicms/render)
- Для классов модулей используется отдельный автозагрузчик [Aura.Autoload](https://github.com/auraphp/Aura.Autoload)
- Добавлен класс Assets, который формирует ссылки с учетом текущей темы оформления
- Для работы с пользовательскими аватарами используется хелпер шаблонов `avatar()`
- Для подсветки синтаксиса кода в сообщениях используется JS библиотека [Prism](https://prismjs.com)
- Модули используют шаблоны
- Для перевода используется [gettext/translator](https://github.com/php-gettext/Translator)
- С помощью CLI скриптов радикально упрощена процедура подготовки переводов.

#### Changed
- Полный рефакторинг кода системы
- Для работы требуется версия PHP 7.2, или новее
- Строгая типизация, проверка кода по [Style-CI](https://github.styleci.io/repos/30122305)
- Заменена CAPTCHA, используется пакет [mobicms/captcha](https://github.com/mobicms/captcha)
- Весь функционал распределен по модулям и перемещен в папку `/modules`
- Ядро системы выделено в отдельный пакет [johncms/system](https://github.com/johncms/system)
- Оптимизированы ссылки, удалены фрагменты `index.php`

#### Deprecated
- Nothing

#### Removed
- Удалены старые функции перевода `_t()` `_p()`
- Из сканера безопасности удалена функция "Сканирование по дистрибутиву"
- Удален старый метод для вывода картинок `Tools::image()`
- Удалена библиотека geshi/geshi
- Удалены старые темы оформления

#### Fixed
- Исправлены замеченные ошибки

#### Security
- Администратор мог непреднамеренно удалить новость, перейдя по специально сформированной ссылке.


## 8.0.0 - 2019-10-23

#### Added
- Добавлен предпросмотр прикрепленных фотографий к постам на форуме
- Добавлен счетчик просмотров темы на форуме

#### Changed
- Изменена структура таблиц форума для повышения производительности
- Изменено отображение результатов опросов на форуме

#### Fixed
- Исправлена проблема зависания сайта при автоочистке на больших базах
- Исправлена постраничная навигация в списке избранных смайлов
- Исправлены ошибки при добавлении статьи в библиотеке


## 7.1.0 - 2017-04-07  

#### Added
- Добавлен пакет интерфейсов Core API
- Использование [PSR-11](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-11-container.md) интерфейса контейнера
- Объединение идущих подряд постов форума от одного автора
- Возможность индивидуального удаления прикрепленных файлов форума
- BBcode для вставки Youtube видео (доработанный метод от [Gabriel](https://johncms.com/profile/?user=38235))
- Добавлен Украинский язык
- Добавлен Литовский язык
- Добавлен Арабский язык
  
#### Changed
- Доработан класс BBcode
- Доработаны пользовательские настройки
- Добавлено 10 секундное кэширование счетчика Онлайн
- Обновлены библиотеки зависимостей

#### Fixed
- Исправлена ошибка SQL при обновлении директорий загруз центра
- Исправлена ошибка SQL при очистке неактивных профилей
- Исправлен SQL запрос добавления новостей на форум
- Исправлен вывод аннонсов новостей на Главную
- Исправлен счетчик комментариев в альбомах


## 7.0.0 - 2017-01-22  

#### Added
- Новое ядро системы, построенное на DI контейнере zend-servicemanager
- Для работы с базой данных используется PDO
- Для локализации (переводов) используется формат GNU Gettext  
- Новый загруз центр от **_FlySelf_** с доработками от **_AlkatraZ_**
- Поддержка протокола HTTPS
  
#### Changed
- Полный рефакторинг всех скриптов системы
- Системная конфирурация поступает из файла через контейнер
- Папки локалей переименованы в соответствие со стандартом [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes)
- Снято ограничение на длину и символы паролей
- Доработана справочная система

#### Removed
- Таблица базы данных с настройками системы
- Устаревший модуль "Загрузки"
- Устаревший модуль "Галерея"
- Устаревший модуль "Друзья"
- Карта сайта, предназначенная для бирж ссылок
- Валидатор Referer
- Редактор языков
- Транслит

#### Fixed
- В Библиотеке исправлена скачка книг в формате FB
- Исправлены некоторые замеченные ошибки


## 6.2.2 - 2017-04-20

#### Added
- Добавлена возможность задания meta-тегов keywords и description

#### Changed
- Доработан Узбекский перевод

#### Fixed
- Исправлена ошибка пометки прочтения комментария в Альбомах
- Исправлен показ новостей и размер текста
- Исправлен SQL запрос очистки пользователей
- Исправлены BB коды в цитате


## 6.2.1 - 2016-12-15  

#### Added
- Добавлен Киргизский язык

#### Changed
- Папки языков переименованы в соответствие со стандартом [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes)
- Кодировка соединения с MySQL заменена на utf8mb4

#### Fixed
- Исправлена скачка книг в формате FB
- Исправлены замеченные ошибки


## 6.2.0 - 2015-11.18  

#### Added
- Для подсветки исходного кода в сообщениях используется GeSHi
- Добавлен Французский язык

#### Changed
- Доработана панель bbCode, добавлены кнопки вставки исходного кода
- Добавлено сохранение прозрачности (PNG, GIF) картинок в галерее
- Снято ограничение на допустимый размер приватного сообщения

#### Fixed
- Исправлена ошибка с невозможностью удаления пользователя
- Исправлена выгрузка картинок в библиотеку
- Исправлена проблема с PNG изображениями в галерее


## 6.1.2 - 2015-05-25

#### Changed
- Заменена система IP WHOIS
- Увеличен размер изображений в альбомах

#### Fixed
- Исправлена ошибка в панели управления рекламой
- Исправлены замеченные ошибки в библиотеке


## 6.1.1 - 2015-04-18

#### Fixed
- Исправлены права доступа к редактированию статей библиотеки
- Исправлены замеченные ошибки


## 6.1.0 - 2015-03-26

#### Added
- Добавлен Белорусский язык

#### Changed
- Доработка ссылок и внешнего вида библиотеки
  
#### Fixed
- Улучшено быстродействие почты, исправлены некоторые ошибки
- Заявка на дружбу приходила на языке отправителя


## 6.0.0 - 2015-03-04

#### Added
- Новая Библиотека от **_Koenig_**
  
#### Changed
- **Лицензия изменена на GNU GPL v.3**
- Вместо XHTML Mobile используется HTML5
- Доработан парсер BBcode для совместимости с новыми версиями PHP
- Из Форума удалена обрезка длинных постов

#### Fixed
- Исправлены замеченные ошибки

  
## 5.3.0 - 2015-01-21

#### Added
- Добавлен Сербский язык

#### Changed
- Новая функция очистки профилей при их удалении

#### Fixed
- Исправлена ошибка рейтинга файлов в загруз-центре
- Исправлено поле "о себе" редактирования профиля
- Исправлены замеченные ошибки

#### Security
- Устранена возможность комментировать несуществующий файл в загруз-центре

## 5.2.1 - 2013-12-29

#### Fixed
- Исправлены замеченные ошибки


## 5.2.0 - 2013-10-29

#### Added
- В форуме добавлены ссылки на цитируемые посты

#### Changed
- Оптимизация кода
- Доработка каталога аватаров
- Доработан раздел Форума "показать за период"

#### Removed
- Удален "Быстрый переход"
- Удален Автологин по ссылке

#### Fixed
- Исправлена ошибка XHTML при вставке ссылок в спойлеры
- Исправлена постраничная навигация в исходящих письмах

#### Security
- Устранена возможность забаненным пользователям выгружать картинки в свой альбом


## 5.1.0 - 2013-07-07

#### Added
- Добавлено управление правами для отдельных разделов форума
  - возможно разрешить автору темы редактировать 1-й пост
  - возможно включить автоматическое назначение автора темы куратором
  - возможность переводить раздел в режим "только для чтения"
- bbCode для вставки Спойлеров в тексты от **_seg0ro_**
- Закрытие сайта от **_VARG_**
- Добавлена тема оформления от **_selemet_**
- В форуме добавлены ссылки на посты
- При удалении пользователя так же удаляются все файлы из переписки и очищаются таблицы почты и контактов от **_VARG_**
- При добавлении в игнор, юзер удаляется из друзей от **_VARG_**

#### Changed
- Настройки почты объединены с системными настройками пользователя
- В закрытые фотоальбомы из администрации имеют доступ только Админы
- Доработка палитры цветов bbCode от **_seg0ro_**

#### Fixed
- При просмотре текста отдельного поста, не отображались прикрепленные файлы
- Исправлена возможность отправлять заявки на дружбу, если юзер находился в игноре или в бане от **_VARG_**
- Исправлены комментарии в личных альбомах
- При редактировании поста в Гостевой, не работала панель BBcode


## 5.0.0 - 2013-05-04

#### Added
- Модуль "Почта" (приват) от **_Krite_**
- Модуль "Друзья" от **_Krite_**
- Возможность установить доступ к личным альбомам для друзей

#### Changed
- Полная переделка системы игнора
- Обновлен перевод на Казахский язык

#### Fixed
- В голосованиях форума, для администрации не был виден список проголосовавших
- Исправлена ошибка с переносом строк при редактировании своей анкеты
- Исправлено время в цитировании поста форума
- Устранена ошибка XHTML в RSS лентах
- Исправлен ТОП Кармы
- Исправлены другие замеченные ошибки

#### Security
- Устранена возможность посторонним комментировать фотографии из закрытых альбомов


## 4.5.1 - 2012-11-18

#### Changed
- Для Форума, гостевой и привата добавлена валидация форм по токенам
- Добавлена расширенная фильтрация входящих текстовых данных

#### Fixed
- Исправлено множество мелких некритичных ошибок

## 4.5.0 - 2012-10-12

#### Added
- В списках Онлайн добавился новый раздел с IP активностью
- IP WHOIS получение подробных данных об адресе IP из базы данных RIPE
- История личных поисковых запросов Форума
- Добавлено кэширование счетчиков на Главной странице
- Редактор языков от **_k_2_**
- Добавлен Польский язык
- Добавлен Таджикский язык

#### Changed
- Новая функция обработки URL в текстах
- Для Администрации добавлена защита от CSRF (Сross Site Request Forgery) атак
- Усовершенствован алгоритм определения IP via Proxy
- Доработан приват, добавлены страницы подтверждения при удалении
- Доработка предпросмотра изображений Форума от **_Krite_**
- Добавлено ограничение по времени на выгрузку файлов форума

#### Fixed
- На форум можно выгружать файлы с любой длиной имени, с пробелами и на Русском
- В списки Онлайн и на Форум добавлена корректировка вызова несуществующей страницы
- Исправлен постинг в Гостевой для незарегистрированных посетителей
- Исправлено оповещение о комментариях в личных гостевых
- Исправлены многие ошибки и недоработки


## 4.4.0 - 2011-08-12

#### Added
- Возможность назначать Кураторов тем Форума от **_FlySelf_**
- Новый алгоритм разбивки текста на страницы в библиотеке. Для больших статей, радикально уменьшена нагрузка на сервер.
- Список последних комментариев в Фотоальбомах
- Оповещение о новых комментариях к личным фотографиям
- Возможность устанавливать фото в анкету из личного альбома
- Добавлен Китайский язык
- Добавлен Грузинский язык
- Добавлен Узбекский язык

#### Changed
- Для рейтинга фотоальбомов поставлен минимальный порог 3 голоса

#### Fixed
- Исправлен SQL запрос счетчика поиска в истории IP адресов
- Исправлена обработка кавычек для новых тем Форума
- Исправлена ошибка системного времени


## 4.3.0 - 2011-06-28

#### Added
- Простая система очистки от неактивных профилей
- Палитра цветов для bbCode
- В личных настройках можно включать "прямые ссылки", без редиректа
- В Форум добавлен режим "Только для чтения" (не действует для Администрации)
- Предпросмотр сообщений Форума
- Новый, мультиязычный каталог смайлов

#### Changed
- Новый класс для обработки тэгов bbCode и ссылок
- Значительно усовершенствован поиск (Форум, Библиотека, пользователи)
- Переписана регистрация пользователей
- Переписана функция парсинга смайлов
- Согласно стандартам RFC, переписаны HTTP заголовки, управляющие кэшированием
- В многостраничных списках навигация пепреведена на "page"
- Транслит доступен только для Русского и Украинского языков, для остальных скрыт
- Переписана система определения местоположения пользователя на сайте

#### Removed
- Удалены счетчики сжатия, перемеремещений по сайту и времени онлайн

#### Fixed
- При удалении пользователя, не удалялись темы на Форуме
- Не очищалась история посещения гостей

#### Security
- Устранена вззможность в определенных обстоятельствах сбросить чужой пароль (спасибо **_Azq2_** за сигнал)


## 4.2.0 - 2011-04-22

#### Added
- Добавлен переключатель языков вверху сайта
- Добавлен Азербайджанский язык
- Добавлен Казахский язык
- Добавлен Латышский язык

#### Changed
- Фразы языков перенесены в файлы, с разделением по модулям
- Добавлена поддержка Apache mod_expires
- Приват переведен на мультиязычность
- На текстах списков голосований форума, работают тэги


## 4.1.0 - 2011-04-01

#### Added
- Добавлена страница подтверждения при смене аватара в каталоге
- Все внешние ссылки в текстах (форум, комментарии и др.) обработанные tags() теперь идут через локальный редирект (значительно уменьшает число ВС). Добавлена страница с предупреждением о переходе по внешней ссылке
- Новая Карта сайта, с управлением из Админки
- "Быстрые смайлы" для компьютеров
- Добавлена тема оформления от **_=zIp=_**

#### Changed
- Увеличена безопасность механизма авторизации юзеров

#### Fixed
- Исправлены права доступа при назначении на должности
- Для незарегистрированных, в гостевой были видны IP адреса Гостей
- На Форуме была возможность скачать удаленную тему

#### Security
- Исключена возможность обхода CAPTCHA при авторизации (спасибо **_Максиму_** за сигнал)
- Забаненные могли голосовать в Карме


## 4.0.1 - 2011-01-17

#### Changed
- На "обрезанных" постах форума, теперь отображаются тэги и смайлы
- Усовершенствования в личных Фотоальбомах
- Панель BBcode добавлена также для создания тем и редактирования постов

#### Fixed
- Исправлены мелкие, замеченные ошибки и недоработки
- Исправления в некоторых переводах языков


## 4.0.0 - 2010-12-26

#### Added
- Новое, быстродействующее ядро системы
- Мультиязычность, возможность загружать / удалять языки
- Новая Админ Панель
- Новый модуль комментариев
- Карта сайта
- Личные фотоальбомы пользователей
- Личные Гостевые (стена) пользователей
- Новая Анкета пользователя
- Новый модуль Кармы, алгоритм прежний, но переписан код
- Новый Рекламный модуль, возможность ставить "Прямые" ссылки
- Предпросмотр картинок файл-обменника Форума. Оптимизация кода
- Новый модуль модерации регистраций пользователей
- Фиксируется полная история IP адресов для каждого посетителя
- Панель быстрого ввода BBcode от **_seg0ro_**
- Цветные графики голосований от **_VARG_**
- Новый модуль F.A.Q. со встроенными каталогами Аватаров и Смайлов
- Определение мобильного браузера (глобальная переменная с кэшированием)
- Подсветка поисковых запросов форума **_Krite_** + **_AlkatraZ_**

#### Changed
- Полностью переработана функция "история нарушений"
- Общее хранилище /files для выгружаемых файлов всех модулей
- Управление доступом к просмотру Актива сайта для Гостей
- При закрытии модуля, на него скрываются ссылки с Главной

#### Removed
- Из дистрибутива удален Чат

#### Fixed
- В закрытой теме форума, оставались открытыми голосования


## 3.2.2 - 2010-06-02

#### Changed
- Введена проверка на минимальную длину названия темы форума

#### Fixed
- Не обрабатывались внутренние ссылки форума при создании новых тем
- При обработке некоторых ссылок, могли возникать ошибки XHTML
- При удалении бана, в Карме восстанавливается репутация

#### Security
- Устранена возможность создания тем с пустым некликабельным названием


## 3.2.1 - 2010-05-21

#### Changed
- Применен новый алгоритм CAPTCHA


## 3.2.0 - 2010-04-29

#### Added
- Совместимость с PHP 5.3 и выше
- Глобальные настройки Антифлуда в Админке. Несколько режимов работы

#### Changed
- Усовершенствование Гостевой, оптимизация кода
- Новый, надежный алгоритм поиска и бана IP адреса
- Обновлены библиотеки class_upload и class_pclzip
- У простых модеров теперь есть доступ к функциям поиска Админки
- В файле .htaccess включено подавление вывода сообщений об ошибках PHP
- В списках онлайн показываются аватары, изменен внешний вид.

#### Fixed
- Исправлена ошибка деления на 0 в голосованиях форума
- У браузеров Opera Mini были проблемы с обновлением картинки CAPTCHA
- Исправлена работа с ZIP архивами в загруз-центре


## 3.1.1 - 2010-03-25

#### Changed
- Доработана система показа рекламы mobileads.ru код перенесен в функцию

#### Fixed
- В списке проголосовавших не отображался значок пола
- Не работала автоочистка таблицы гостей
- Админ не мог удалить чужую фотографию из анкеты
- Исправлены мелкие недоработки


## 3.1.0 - 2010-02-27

#### Added
- Новая система входа на сайт. После 3-х неверных логинов, будет показана CAPTCHA
- Каталог готовых Аватаров с возможностью выбора от **_VARG_**
- Модуль Кармы пользователей
- Метки, кто удалил / восстановил тему, или пост на форуме
- Предпросмотр прикрепленных картинок Форума

#### Changed
- Каталог смайлов теперь показывает типы файлов GIF, JPG и PNG
  
#### Fixed
- В сканер-антишпион добавлены пропущенные системные файлы
- Админ не мог менять пароль юзера
- Исправлено несколько нерабочих ссылок
- В каталоге смайлов не показывались файлы jpg и png

#### Security
- Подделав запрос, можно было удалить не свое сообщение


## 3.0.0 - 2009-12-15
`Деда Григория с днем рожденья :)`

#### Added
- Новый модуль восстановления забытого пароля
- Установка прав доступа к модулям (все, авторизованные, только админы)
- Файл-менеджер (обменник) для прикрепленных файлов форума
- Новая, быстродействующая система подсчета юзеров/гостей онлайн
- Новая (быстрая, с Кэшированием) функция парсинга Cмайлов и их каталог
- Продвинутый поиск пользователей
- Новая админка
- Блокировка одинаковых сообщений
- "Монитор активности", переход к последнему посту из списка последних 10
- Топ активности посетителей Сайта
- Новый "личный кабинет"
- Новая анкета. По-новому организовано ее редактирование
- Модуль управления рекламными ссылками
- Выгрузка фото в личную Анкету
- Система Аватаров
- Тема оформления от **_oz_**

#### Changed
- Усовершенствованный форум, увеличено быстродействие, оптимизированы SQL запросы
- Серьезное обновление ядра системы, по-новому организованы настройки
- Доработан загруз-центр, оптимизированы SQL запросы
- Новая функция парсинга BBcode для ссылок
- Дайджест показывает события для Администратора сайта (события в Админке)
- Оптимизированы функции статистики, значительно увеличена скорость работы
- Оптимизирован код Гостевой
- Оптимизирован код списка "Онлайн", снижена нагрузка на сервер
- Возможность редактировать статью и ее параметры в Библиотеке
- Администратор может писать даже в закрытые темы форума
- Библиотека в заголовке страницы показывает название раздела / статьи

#### Fixed
- Удаленные юзеры теперь помечаются специальными значками
- При редактировании новости, могла возникать ошибка XHTML
- Устранены ошибки в проверке CAPTCHA
- Исключены ошибки XHTML, которые возникали на заголовках Библиотеки
- Устранена ошибка в модуле HTTP antiFlood


## 2.4.0 - 2009-04-21

#### Added
- Модуль бана по адресу IP
- Модуль управления новостями на Главной странице
- Модуль управления кодами счетчиков из Админ-панели.

#### Changed
- На форуме, в заголовке страницы показывает название раздела / темы
- При удалении с форума темы-комментария к новости, теперь не будет ссылки
- Изменен диапазон чистки новостей. Теперь неделя и месяц
- Новый класс определения IP адреса, более надежный алгоритм
- Модифицирован и оптимизирован код системы комментариев библиотеки
- Оптимизирован код библиотеки, введена новая постраничная навигация
- Все счетчики, из файла end.php  перенесены в отдельные функции
- Оптимизирован код раздела "Последние 10 тем" на форуме 

#### Fixed
- Для гостей, на форуме (в новом) были видны заголовки удаленных тем
- Более надежная проверка данных при смене пароля юзером
- При регистрации слишком длинного имени, в анкете возникала ошибка XHTML
- В Гостевой, на никах гостей могла возникать ошибка XHTML
- Модеры Чата не могли банить
- В комментариях библиотеки, введена проверка на существование статьи
- Исправлена ошибка навигации по страницам в Библиотеке
- Устранена ошибка XHTML в поиске на форуме. Немного оптимизирован код.
- В анкете юзеров, могли возникать ошибки XHTML
- Для гостей, на форуме не работала сортировка "новые вверху / внизу"
- С некоторых браузеров возникала ошибка при добавлении новостей
- Администрация не могла писать на форуме со старых браузеров
- Откорректирован парсинг ссылок, исправлены ошибки XHTML
- В настройках системы иногда могли возникать ошибки XHTML
- У Модеров и Киллеров, при просмотре анкет возникала ошибка XHTML
- В новостях не переносились строки текста

#### Security
- Заслав определенный POST запрос, можно было удалить не свою почту


## 2.3.0 - 2009-03-23

#### Added
- Массовая чистка постов в форуме (чекбоксы)
- Новый модуль Новостей
- Новая система Антиспама (для всего сайта)
- Модуль "Антишпион" (Антивирус), который предназначен для выявления подозрительных и опасных файлов в директориях сайта
- Иммунитет для пользователя (невозможно банить, или удалить).
- Система "Пинка" для модераторов форума
- Новая функция листинга по страницам

#### Changed
- На Главной, вместо даты новостей, показывает их к-во за последние сутки
- В списке ожидающих регистрации (админка), показывает IP и UserAgent
- Модифицирована личная анкета и ее редактирование из Админки
- Оптимизирован код чата, увеличена скорость работы
- Глобальная оптимизация SQL запросов во всех модулях. Значительно увеличена производительность и снижена нагрузка на сервер.
- По многочисленным просьбам, вернулись чередующиеся цвета в списках
- В список разрешенных расширений добавлены *.cab,*.sis,*.sisx,*.exe,*.msi

#### Fixed
- На форуме не работала сортировка "новые вверху / внизу"
- В списке тем на форуме, неправильно отображалось время
- После удаления профиля юзера, в базе оставались некоторые его данные
- В ссылках неправильно обрабатывался знак &
- На форуме невозможно было писать с браузера Internet Explorer
- При цитировании постов форума, содержащих знак & возникала ошибка XHTML
- Ошибочная дата последнего визита для вновь зарегистрированных
- При изменении поста в форуме, теперь возврат на свою страницу
- В Чате не работали счетчики посетителей (кто в комнатах и в чате)
- Исправлен модуль скачки тем с форума
- Из настроек юзера удалено ненужное Ник-меню, оставшееся от старой версии

#### Security
- Был возможен спам привата. Новая система Антиспама исправляет недостаток


## 2.0.0 - 2009-01-07

#### Added
- Новый форум, серьезно переделано его ядро.
- Смена стилей. За основу взят доработанный мод от **_heavi_**
- Амнистия для забаненных (различные варианты)
- Новая система пользовательских настроек
- Новый Дайджест

#### Changed
- По-новому организован "личный кабинет"
- Оптимизирован "Быстрый переход", ускорена работа
- Модифицирован парсинг bbCode, добавлен тэг перечеркивания [s][/s]
- В функции определения IP исключены из обработки нулевые адреса
- Для редактирования описаний в загруз центре, применено многострочное поле
- Оптимизирован код Библиотеки, ускорена работа, снижена нагрузка на сервер
- Оптимизированы функции статистики, удален файл stat.php
- Оптимизирован счетчик Online

#### Fixed
- Из "Игнора" невозможно было удалить некоторых юзеров
- В списке "кто, где" не показывалась Гостевая
- Некорректно отображалось время, проведенное на сайте
- Исправлена админка для Супермодеров
- Исправлена ошибка XHTML в форме бана


## 1.6.0 - 2008-09-14

#### Added
- История нарушений в личных анкетах посетителей
- Дайджест для зарегистрированных посетителей

#### Changed
- Новая, более надежная и быстрая функция парсинга URL в текстах
- Новые пользователи выделяются специальным значком
- Бан из форума, с указанием ссылки на пост, который был причиной бана
- Усовершенствована статистика по Гостевой / Админ-клубу
- Изменена анкета посетителей.

#### Fixed
- В чате и на форуме, невозможно было писать с браузера Internet Explorer
- Из меню "быстрого перехода" не работала ссылка на загруз-центр
- В библиотеку не выгружались статьи из текстовых файлов
- Неправильно записывался адрес IP при регистрации новых юзеров
- Исправлены ошибки XHTML на "новых" в Галерее


## 1.5.0 - 2008-08-19

#### Added
- Система Бана пользователей
- Возможность открывать / закрывать доступ к отдельным модулям
- Добавлена система Бана по IP адресу
- Админ-Клуб в гостевой, в котором могут общаться только Админы / Модеры
- В Гостевой, для незарегистрированных посетителей, добавлен код CAPTCHA
- Новый инсталлятор с парсингом SQL файлов. Заливка ДЕМО данных
- Добавлена защита от TRACE атак

#### Changed
- На Форуме и в Гостевой, для юзеров отображаются статусы под никами
- Новый, надежный алгоритм проверки выгружаемых файлов
- Новые функции обработки ссылок и BBcode и "Antilink" в текстах
- Новая функция навигации по страницам
- Новая система хранения настроек CMS
- Новый набор иконок для форума
- Доработанная Админка. Улучшена работа, исправлены замеченные ошибки
- Изменено форматирование цитат на форуме, добавлен CSS класс .quote
- Изменения в генераторе CAPTCHA. Должен работать более надежно
- Усилена защита в авторизации пользователей, оптимизирован код ядра
- Скачать Java книгу могут только зарегистрированные пользователи
- Изменен "личный кабинет". Он теперь вынесен из файла mainmenu.php

#### Removed
- Удален Админ Чат, его функции перешли в Админ-Клуб Гостевой книги

#### Fixed
- При активизации E-mail адреса, почта приходила в неверной кодировке
- Не назначались модераторы на подфорумы
- Исправлена ссылка листинга по страницам на "Кто в форуме"
- Не работало подтверждение регистраций
- Устранены ошибки XHTML, иногда возникающие на длинных текстах форума
- Исправлены ошибки XHTML, на ссылках (по всему сайту)
- Исправлена ошибка в отображении "Новых" тем на форуме
- Не выбирались подфорумы в списке "новых" на форуме
- На удаленных темах в форуме возникала ошибка XHTML
- В библиотеке неправильно работал листинг по страницам категорий
- В привате мог перезаписаться прикрепленный файл с совпадающим именем
- В списке контактов у всех стояло [Off] независимо в онлайне юзер или нет
- favicon отображалась не на всех страницах сайта
- Из контактов невозможно было удалить юзера
- В Чате не отображалось сообщение о новых входящих письмах
- Исправлено множество мелких недоработок и оптимизирован код

#### Security
- Исправлена "php-injection" уязвимость


## 1.0.0 - 2008-04-27

#### Added
- Новое ядро системы, оптимизированы многие запросы, снижена нагрузка на сервер
- Новая система регистрации пользователей
- Новая библиотека.
- Новая гостевая. Среди изменений функционала:
- Модуль RSS новостей сайта и новостей библиотеки
- Загруз центр, для MP3 файлов, теперь может считывать из ID тэгов файла: Исполнитель, Альбом, Композиция, Год выхода
- Для прикрепленных файлов на форуме, добавлен счетчик скачиваний
- В Админке добавлена возможность поиска юзера как по Нику, так и по ID
- Новая, более надежная система авторизации пользователей

#### Changed
- Применена более эффективная защита от HTTP-Flood атак (анти DOS).
- Увеличено быстродействие загруз центра
- Модифицирована Анкета пользователя
- Модифицирована Админка.

#### Removed
- Удалена за ненадобностью пользовательская настройка цвета

#### Fixed
- Увеличено быстродействие, устранены ошибки в работе форума
- Устранены замеченные ошибки


## 0.3.0 - 2008-02-25

#### Added
- Использование в коде функций mb_string и iconv
- Полный перевод базы данных на UTF-8
- Новая, облегченная версия чата с модифицированным "Умником"
- Новая версия библиотеки с Анонсами статей

#### Fixed
- Исправлены множество замеченных проблем и недоработок


## 0.2.0 - 2008-02-08

Первый релиз системы, доступный для скачивания


## 0.1.0 - 2007-11-10

**Исходная версия от john77**, которая еще не была доступна для свободного скачивания.
Данная версия была установлена на сайте [http://gazenwagen.com](http://gazenwagen.com)  
Тогда же началась совместная доработка и подготовка к публикации в общий доступ. 
