<!-- jQuery -->
<script type="text/javascript" src="/wb-content/js/jquery.pack.js"></script>
<!-- markItUp! -->
<script type="text/javascript" src="/wb-content/js/markitup/jquery.markitup.pack.js"></script>
<!-- markItUp i18n -->
<script type="text/javascript" src="/wb-content/js/markitup/sets/bbcode/i18n/<?php echo get_lang(NULL, TRUE) ?>.js"></script>
<!-- markItUp! toolbar settings -->
<script type="text/javascript" src="/wb-content/js/markitup/sets/bbcode/set.js"></script>
<!-- markItUp! skin -->
<link rel="stylesheet" type="text/css" href="/wb-content/js/markitup/skins/simple/style.css" />
<!--  markItUp! toolbar skin -->
<link rel="stylesheet" type="text/css" href="/wb-content/js/markitup/sets/bbcode/style.css" />

<script type="text/javascript">
<!--
$(document).ready(function()	{
	// Add markItUp! to your textarea in one line
	// $('textarea').markItUp( { Settings }, { OptionalExtraSettings } );
	$('#markItUp').markItUp(mySettings);
	
	// You can add content from anywhere in your page
	// $.markItUp( { Settings } );	
	$('.add').click(function() {
 		$.markItUp( { 	openWith:'<opening tag>',
						closeWith:'<\/closing tag>',
						placeHolder:"New content"
					}
				);
 		return false;
	});
	
	// And you can add/remove markItUp! whenever you want
	// $(textarea).markItUpRemove();
	$('.toggle').click(function() {
		if ($("#markItUp.markItUpEditor").length === 1) {
 			$("#markItUp").markItUpRemove();
			$("span", this).text("get markItUp! back");
		} else {
			$('#markItUp').markItUp(mySettings);
			$("span", this).text("remove markItUp!");
		}
 		return false;
	});
});
-->
</script>

<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li class="current"><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>


<div class="header">
	<h1><?php echo $name ?></h1>
	<div class="skill-rating">
		<div class="rating">
			<?php if ($allow_vote): ?>
				<a href="/vote/blog/positive/<?php echo $blog_data['blog_id'] ?>" class="vote-plus"></a>
			<?php endif ?>
			<div>
				<?php echo get_lang('vote/rating') ?><br />
				<span class="number"><?php echo $blog_data['blog_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $blog_data['blog_count_vote'], declension($blog_data['blog_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
			<?php if ($allow_vote): ?>
				<a href="/vote/blog/negative/<?php echo $blog_data['blog_id'] ?>" class="vote-minus"></a>
			<?php endif ?>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/blog/<?php echo $url ?>"><?php echo get_lang('blog/info') ?></a></div></td>
			<td class="current"><div><a href="/blog/edit/<?php echo $url ?>"><?php echo get_lang('blog/edit_submit') ?></a></div></td>
			<td><div><a href="/blogs/<?php echo $url ?>"><?php echo get_lang('blog/posts') ?></a></div></td>
			<td><div><a href="/blog/users/<?php echo $url ?>"><?php echo get_lang('blog/users') ?> (<?php echo $blog_data['blog_count_users'] ?>)</a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<form action="/blog/edit/<?php echo $url ?>" method="post">
		<div class="card">
			<?php if ($edit_success): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('blog/edit_success') ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($name_error): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('blog/name_error') ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($url_error): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('blog/url_error_valid') ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($url_exists_error): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('blog/url_error_exists') ?></dd>
				</dl>
			<?php endif ?>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('blog/name_notice') ?>"><?php echo get_lang('blog/name') ?>:</dt>
				<dd>
					<input type="text" name="name" size="72" maxlength="255" value="<?php echo $name ?>" />
				</dd>
			</dl>
			
			<dl>
				<dt class="help"><?php echo get_lang('blog/url') ?>:</dt>
				<dd>
					<input type="text" name="url" size="72" maxlength="255" value="<?php echo $url ?>" />
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('blog/description') ?>:</dt>
				<dd>
					<textarea id="markItUp" name="description" maxlength="255"><?php echo $description ?></textarea>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('blog/privacy') ?>:</dt>
				<dd>
					<input type="radio" name="type" value="<?php echo BLOG_OPEN ?>" <?php $type == BLOG_OPEN && print('checked="checked"') ?>/> <?php echo get_lang('blog/privacy_open') ?><br />
					<input type="radio" name="type" value="<?php echo BLOG_ENTRY ?>" <?php $type == BLOG_ENTRY && print('checked="checked"') ?>/> <?php echo get_lang('blog/privacy_entry') ?><br />
					<input type="radio" name="type" value="<?php echo BLOG_CLOSE ?>" <?php $type == BLOG_CLOSE && print('checked="checked"') ?>/> <?php echo get_lang('blog/privacy_close') ?>
				</dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('blog/limit_rating_notice') ?>"><?php echo get_lang('blog/limit_rating') ?>:</dt>
				<dd>
					<input type="text" name="limit_rating" maxlength="12" value="<?php echo $limit_rating ?>" />
				</dd>
			</dl>
			
			<dl>
				<dd>
					<input type="submit" value="<?php echo get_lang('blog/edit_submit') ?>" />
				</dd>
			</dl>
		</div>
	</form>
</div>