<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1>
		<?php echo get_lang('comments/comments') ?> &rarr; <a href="<?php echo $post_data['post_link'] ?>"><?php echo $post_data['post_title'] ?></a>
	</h1>
</div>

<div class="content">
	<?php foreach ($comments_array as $fields): ?>
		<div class="comment" id="<?php echo $fields['comment_id'] ?>">
			<div class="meta">
				<div class="user"><a href="/profile/<?php echo $fields['user_login'] ?>"><?php echo $fields['user_login'] ?></a></div>
				<div class="date"><?php echo fdate($fields['comment_time']) ?></div>
				
				<ul class="options">
					<li><a href="/comments/post/<?php echo $post_data['post_id'] ?>/<?php echo $fields['comment_id'] ?>#<?php echo $fields['comment_id'] ?>" title="<?php echo get_lang('comments/comment_link') ?>">#</a></li>
					
					<?php if (is_logged()): ?>
						<li><a href="/comment/answer/<?php echo $fields['comment_id'] ?>"><?php echo get_lang('comment/answer_submit') ?></a></li>
						<?php if ($fields['allow_edit']): ?><li><a href="/comment/edit/<?php echo $fields['comment_id'] ?>"><?php echo get_lang('comment/edit_submit') ?></a></li><?php endif ?>
						<?php if ($fields['allow_delete']): ?><li><a href="/comment/delete/<?php echo $fields['comment_id'] ?>"><?php echo get_lang('comment/delete_submit') ?></a></li><?php endif ?>
					<?php endif ?>
				</ul>
				
				<ul class="vote<?php echo $fields['comment_positive'] ? ' positive' : ($fields['comment_negative'] ? ' negative' : '') ?>">
					<li><?php echo ($fields['comment_positive'] ? ' +' : '') . $fields['comment_rating'] ?></li>
					<?php if ($fields['allow_vote']): ?>
						<li class="buttons">
							<a href="/vote/comment/negative/<?php echo $fields['comment_id'] ?>" class="vote_minus" title="<?php echo get_lang('comments/comment_bad') ?>"> </a>
							<a href="/vote/comment/positive/<?php echo $fields['comment_id'] ?>" class="vote_plus" title="<?php echo get_lang('comments/comment_good') ?>"> </a>
						</li>
					<?php endif ?>
				</ul>
			</div>
			
			<div class="text">
				<?php echo tags($fields['comment_text']) ?>
			</div>
		</div>
	<?php endforeach ?>
	<?php if (is_logged() && $post_data['privacy_comment']): ?>
		<p><a href="/comment/add/<?php echo $post_data['post_id'] ?>"><?php echo get_lang('comment/add') ?></a></p>
	<?php endif ?>
</div>

<?php view_include('pagination') ?>