<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li class="current"><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $group_data['group_name'] ?></h1>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td class="current"><div><a href="/group/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/info') ?></a></div></td>
			<td><div><a href="/group/users/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/users') ?></a></div></td>
			<?php if (is_admin()): ?>
				<td><div><a href="/group/edit/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/edit_submit') ?></a></div></td>
				<td><div><a href="/group/delete/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/delete_submit') ?></a></div></td>
			<?php endif ?>
		</tr>
	</table>
</div>

<div class="content">
	<div class="card">
		<?php if ($group_data['group_description']): ?>
			<dl>
				<dt><?php echo get_lang('group/description') ?>:</dt>
				<dd><?php echo tags($group_data['group_description']) ?></dd>
			</dl>
		<?php endif ?>
		
		<dl>
			<dt><?php echo get_lang('group/add_date') ?>:</dt>
			<dd><?php echo fdate($group_data['group_add_time']) ?></dd>
		</dl>
		
		<dl class="list">
			<dt><?php echo get_lang('group/users') ?>:</dt>
			<dd>
				<?php if ($users_ship): ?>
					<ul>
						<?php foreach ($users_ship as $user): ?>
							<li><a class="user" href="/profile/<?php echo $user['user_login'] ?>"><?php echo $user['user_login'] ?></a></li>
						<?php endforeach ?>
					</ul>
				<?php else: ?>
					<?php echo get_lang('no') ?>
				<?php endif ?>
			</dd>
		</dl>
	</div>
</div>