<!-- jQuery -->
<script type="text/javascript" src="/wb-content/js/jquery.pack.js"></script>
<!-- markItUp! -->
<script type="text/javascript" src="/wb-content/js/markitup/jquery.markitup.pack.js"></script>
<!-- markItUp i18n -->
<script type="text/javascript" src="/wb-content/js/markitup/sets/bbcode/i18n/<?php echo get_lang(NULL, TRUE) ?>.js"></script>
<!-- markItUp! toolbar settings -->
<script type="text/javascript" src="/wb-content/js/markitup/sets/bbcode/set.js"></script>
<!-- markItUp! skin -->
<link rel="stylesheet" type="text/css" href="/wb-content/js/markitup/skins/simple/style.css" />
<!--  markItUp! toolbar skin -->
<link rel="stylesheet" type="text/css" href="/wb-content/js/markitup/sets/bbcode/style.css" />

<script type="text/javascript">
<!--
$(document).ready(function()	{
	// Add markItUp! to your textarea in one line
	// $('textarea').markItUp( { Settings }, { OptionalExtraSettings } );
	$('#markItUp').markItUp(mySettings);
	
	// You can add content from anywhere in your page
	// $.markItUp( { Settings } );	
	$('.add').click(function() {
 		$.markItUp( { 	openWith:'<opening tag>',
						closeWith:'<\/closing tag>',
						placeHolder:"New content"
					}
				);
 		return false;
	});
	
	// And you can add/remove markItUp! whenever you want
	// $(textarea).markItUpRemove();
	$('.toggle').click(function() {
		if ($("#markItUp.markItUpEditor").length === 1) {
 			$("#markItUp").markItUpRemove();
			$("span", this).text("get markItUp! back");
		} else {
			$('#markItUp').markItUp(mySettings);
			$("span", this).text("remove markItUp!");
		}
 		return false;
	});
});
-->
</script>

<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<h1><?php echo get_lang('post/publish') ?></h1>

<div class="content">
	<form action="/publish/<?php echo $blog ? 'blog' : 'personal' ?>" method="post">
		<div class="card">
			<?php if ($antiflood_error):  ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('antiflood_notice', $antiflood, declension(get_option('flood_time'), get_lang('antiflood_seconds')));  ?></dd>
				</dl>
			<?php endif ?>
				
			<?php if ($title_error):  ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('post/title_error') ?></dd>
				</dl>
			<?php endif ?>
				
			<?php if ($text_error):  ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('post/text_error') ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($tags_error):  ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('post/tags_error') ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($blog): ?>
				<dl>
					<dt><?php echo get_lang('post/select_blog') ?>:</dt>
					<dd>
						<?php if (count($blogs)): ?>
							<select name="blog">
								<?php foreach ($blogs as $fields): ?>
									<option value="<?php echo $fields['blog_id'] ?>" <?php $fields['blog_id'] == $blog_id && print('selected="selected" ') ?>><?php echo $fields['blog_name'] ?></option>
								<?php endforeach ?>
							</select>
						<?php else: ?>
							<?php echo get_lang('post/blogs_empty') ?>
						<?php endif ?>
					</dd>
				</dl>
			<?php endif ?>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_blog_post_title')) ?>"><?php echo get_lang('post/title') ?>:</dt>
				<dd><input type="text" name="title" size="72" value="<?php echo $title ?>" maxlength="<?php echo get_option('length_blog_post_title') ?>" /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('post/text_notice', get_option('length_blog_post')) ?>"><?php echo get_lang('post/text') ?>:</dt>
				<dd><textarea id="markItUp" name="text" maxlength="<?php echo get_option('length_blog_post') ?>"><?php echo $text ?></textarea></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo htmlspecialchars(get_lang('post/tags_notice', get_option('quota_blog_tags'), declension(get_option('quota_blog_tags'), get_lang('post/tags_declension'))))  ?>"><?php echo get_lang('post/tags') ?>:</dt>
				<dd><input type="text" name="tags" size="72" value="<?php echo $tags ?>" /></dd>
			</dl>
			
			<?php if ($blog): ?>
				<dl>
					<dt><?php echo get_lang('post/privacy_post') ?>:</dt>
					<dd>
						<input type="radio" name="privacy_post" value="<?php echo PRIVACY_POST_BLOG_USERS ?>" /> <?php echo get_lang('post/privacy_only_blog_users') ?><br />
						<input type="radio" name="privacy_post" value="<?php echo PRIVACY_POST_USERS ?>" checked="checked" /> <?php echo get_lang('post/privacy_users') ?>
					</dd>
				</dl>
			<?php else: ?>
				<dl>
					<dt><?php echo get_lang('post/privacy_post') ?>:</dt>
					<dd>
						<input type="radio" name="privacy_post" value="<?php echo PRIVACY_POST_FRIENDS ?>" /> <?php echo get_lang('post/privacy_only_friends') ?><br />
						<input type="radio" name="privacy_post" value="<?php echo PRIVACY_POST_USERS ?>" checked="checked" /> <?php echo get_lang('post/privacy_users') ?>
					</dd>
				</dl>
			<?php endif ?>
			
			<dl>
				<dt><?php echo get_lang('post/privacy_comment') ?>:</dt>
				<dd>
					<input type="radio" name="privacy_comment" value="1" checked="checked" /> <?php echo get_lang('yes') ?><br />
					<input type="radio" name="privacy_comment" value="0" /> <?php echo get_lang('no') ?>
				</dd>
			</dl>
			
			<dl>
				<dt></dt>
				<dd><input type="submit" value="<?php echo get_lang('post/publish_submit') ?>" /></dd>
			</dl>
		</div>
	</form>
</div>