<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="content">
	<div class="post">
		<h1>
			<?php if ($post_data['blog_id']): ?>
				<?php echo get_lang('blog', '<a href="/blogs/' . $post_data['blog_url'] . '">' . $post_data['blog_name'] . '</a>') ?>
			<?php else: ?>
				<?php echo get_lang('blog_personal', '<a href="/personal/' . $post_data['user_id'] . '">' . $post_data['user_login']. '</a>') ?>
			<?php endif ?>
			 &rarr; <?php echo $post_data['post_title'] ?>
		</h1>
		
		<div class="data">
			<div style="padding-bottom: 10px">
				<?php echo tags($post_data['post_text']) ?>
			</div>
			
			<?php if (count($tags)): ?>
				<ul class="tags" style="margin-bottom: 10px">
					<?php foreach ($tags as $tag): ?>
						<li title="<?php echo htmlspecialchars(get_lang('tags/search_success', $tag)) ?>"><a href="/tag/<?php echo urlencode($tag) ?>"><?php echo $tag ?></a></li>
					<?php endforeach ?>
				</ul>
			<?php endif ?>
			
			<div class="bar">
				<div class="corner tl"></div>
				<div class="corner tr"></div>
				<div class="text">
					<div class="rating">
						<?php if ($allow_vote): ?><a href="/vote/post/positive/<?php echo $post_data['post_id'] ?>" title="<?php echo get_lang('vote/positive') ?>" class="vote-plus"></a><?php endif ?>
						<span class="number<?php echo $post_data['post_rating'] > 0 ? ' positive' : ($post_data['post_rating'] < 0 ? ' negative' : '') ?>"><?php echo ($post_data['post_rating'] > 0 ? '+' : '') . $post_data['post_rating'] ?></span>
						<?php if ($allow_vote): ?><a href="/vote/post/negative/<?php echo $post_data['post_id'] ?>" title="<?php echo get_lang('vote/negative') ?>" class="vote-minus"></a><?php endif ?>
					</div>
					
					<div><?php echo fdate($post_data['post_add_time']) ?></div>
					<div><a class="user" href="/profile/<?php echo $post_data['user_login'] ?>"><span><?php echo $post_data['user_login'] ?></span></a></div>
					<div><a href="/comments/post/<?php echo $post_data['post_id'] ?>"><span><span><?php echo $post_data['post_count_comments'] ? $post_data['post_count_comments'] : get_lang('post/comment') ?></span></span></a></div>
					
					<?php if ($access['edit_post']): ?><div><a href="/edit/<?php echo $post_data['post_id'] ?>"><span><?php echo get_lang('post/edit_submit') ?></span></a></div><?php endif ?>
					<?php if ($access['delete_post']): ?><div><a href="/post/delete/<?php echo $post_data['post_id'] ?>/<?php echo get_privacy_key() ?>"><span><?php echo get_lang('post/delete_submit') ?></span></a></div><?php endif ?>
				</div>
				<div class="corner bl"></div>
				<div class="corner br"></div>
			</div>
		</div>
	</div>
</div>

<?php if (count($liked_posts)): ?>
	<div class="content">
		<div class="post" style="padding-bottom: 0px">
			<h1><?php echo get_lang('post/liked') ?> &#8595;</h1>
			<div class="data">
				<?php foreach ($liked_posts as $post_data): ?>
					<div>
						<?php echo fdate($post_data['post_add_time'], 'd.m.y') ?> &#8594;
						<?php if ($post_data['blog_id']): ?>
							<a href="/blogs/<?php echo $post_data['blog_url'] ?>"><?php echo $post_data['blog_name'] ?></a> &#8594; 
							<a href="/blogs/<?php echo $post_data['blog_url'] ?>/<?php echo $post_data['post_id'] ?>"><?php echo $post_data['post_title'] ?></a>
						<?php else: ?>
							<a href="/personal/<?php echo $post_data['user_id'] ?>"><?php echo get_lang('blog_personal', $post_data['user_login']) ?></a> &#8594; 
							<a href="/personal/<?php echo $post_data['user_id'] ?>/<?php echo $post_data['post_id'] ?>"><?php echo $post_data['post_title'] ?></a>
						<?php endif ?>
					</div>
				<?php endforeach ?>
			</div>
			</div>
	</div>
<?php endif ?>