<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li class="current"><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>


<div class="header">
	<h1><?php echo $current_user['user_login'] ?></h1>
	<div class="skill-rating">
		<div class="skill">
			<div>
				<?php echo get_lang('user/skill') ?><br />
				<span class="number"><?php echo $current_user['user_skill'] ?></span>
			</div>
		</div>
		<div class="rating">
			<?php if ($allow_vote_rating): ?><a href="/vote/user/positive/<?php echo $current_user['user_id'] ?>" class="vote-plus"></a><?php endif ?>
			<div>
				<?php echo get_lang('user/rating') ?><br />
				<span class="number"><?php echo $current_user['user_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $current_user['user_count_vote'], declension($current_user['user_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
			<?php if ($allow_vote_rating): ?><a href="/vote/user/negative/<?php echo $current_user['user_id'] ?>" class="vote-minus"></a><?php endif ?>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td class="current"><div><a href="/profile/<?php echo $current_user['user_login'] ?>"><?php echo get_lang('profile') ?></a></div></td>
			<td><div><a href="/friends/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('friends') ?></a></div></td>
			<td><div><a href="/personal/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('blog') ?></a></div></td>
			<td><div><a href="/comments/user/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('comments') ?> (<?php echo $current_user['user_count_comments'] ?>)</a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<div class="card">
		<?php if ($avatar): ?>
			<div style="float:right; clear: none">
				<img src="/wb-content/avatars/<?php echo $current_user['user_id'] ?>.png" <?php echo $avatar_sizes ?> alt="<?php echo get_lang('user/avatar') ?>" />
			</div>
		<?php endif ?>
		
		<?php if ($current_user['user_name'] or $current_user['user_surname']): ?>
			<dl>
				<dt></dt>
				<dd><?php echo $current_user['user_name'] ?> <?php echo $current_user['user_surname'] ?></dd>
			</dl>
		<?php endif ?>
		
		<?php if ($current_user['user_status']): ?>
			<dl>
				<dt></dt>
				<dd><?php echo $current_user['user_status'] ?></dd>
			</dl>
		<?php endif; ?>
		
		<dl>
			<dt><?php echo get_lang('user/sex') ?>:</dt>
			<dd><?php echo $sex ?></dd>
		</dl>
		
		<?php if ($current_user['user_about']): ?>
			<dl>
				<dt><?php echo get_lang('user/about') ?>:</dt>
				<dd><?php echo tags($current_user['user_about']) ?></dd>
			</dl>
		<?php endif ?>
		
		
		<?php if ($current_user['user_interests']): ?>
			<dl>
				<dt><?php echo get_lang('user/interests') ?>:</dt>
				<dd><?php echo tags($current_user['user_interests']) ?></dd>
			</dl>
		<?php endif ?>
		
		<?php if ($current_user['user_im']): ?>
		<dl>
			<dt><?php echo get_lang('user/im') ?>:</dt>
			<dd><?php echo $current_user['user_im'] ?></dd>
		</dl>
		<?php endif ?>
		
		<?php if ($current_user['user_phone']): ?>
		<dl>
			<dt><?php echo get_lang('user/phone') ?>:</dt>
			<dd><?php echo $current_user['user_phone'] ?></dd>
		</dl>
		<?php endif ?>
		
		<?php if ($current_user['user_url']): ?>
			<dl>
				<dt><?php echo get_lang('user/url') ?>:</dt>
				<dd><?php echo tags($current_user['user_url']) ?></dd>
			</dl>
		<?php endif ?>
		
		<dl class="list">
			<dt><?php echo get_lang('user/participation_groups') ?>:</dt>
			<dd>
				<ul>
					<?php if (count($groups)): ?>
						<?php foreach ($groups as $group): ?>
						<li><a class="group" href="/groups/<?php echo $group['group_id'] ?>"><?php echo $group['group_name'] ?></a></li>
						<?php endforeach ?>
					<?php else: ?>
						<li><?php echo get_lang('no') ?></li>
					<?php endif ?>
				</ul>
			</dd>
		</dl>
		
		<dl class="list">
			<dt><?php echo get_lang('user/participation_blogs') ?>:</dt>
			<dd>
				<ul>
					<?php if (count($blogs)): ?>
						<?php foreach ($blogs as $blog): ?>
						<li><a class="blog" href="/blog/<?php echo $blog['blog_url'] ?>"><?php echo $blog['blog_name'] ?></a></li>
						<?php endforeach ?>
					<?php else: ?>
						<li><?php echo get_lang('no') ?></li>
					<?php endif ?>
				</ul>
			</dd>
		</dl>
		
		<dl>
			<dt><?php echo get_lang('user/registration') ?>:</dt>
			<dd><?php echo fdate($current_user['user_registration']) ?></dd>
		</dl>
		
		<dl>
			<dt><?php echo get_lang('user/last_visit') ?>:</dt>
			<dd><?php echo fdate($current_user['user_last_visit']) ?></dd>
		</dl>
		
		<?php if ($allow_edit_profile): ?>
			<dl>
				<dt></dt>
				<dd><a href="/user/profile"><?php echo get_lang('user/profile_edit') ?></a></dd>
			</dl>
		<?php endif ?>
		
		<?php if ($allow_friendship): ?>
			<dl>
				<dt></dt>
				<dd><a href="/friends/add/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('friends/ship_submit') ?></a></dd>
			</dl>
		<?php endif ?>
		
		<?php if ($allow_privmsgs_send): ?>
			<dl>
				<dt></dt>
				<dd><a href="/privsmgs/write/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('privmsgs/write') ?></a></dd>
			</dl>
		<?php endif ?>
		
		<?php if (is_admin() && !$current_user['user_admin_privilege'] && user_id() != $current_user['user_id']): ?>
			<dl>
				<dt></dt>
				<dd><a href="/ban/set/<?php echo $current_user['user_login'] ?>"><?php echo get_lang('ban/set_submit') ?></a></dd>
			</dl>
		<?php endif ?>
	</div>
</div>