<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td class="current"><div><a href="/user/settings"><?php echo get_lang('settings') ?></a></div></td>
			<td><div><a href="/user/profile"><?php echo get_lang('user/profile') ?></a></div></td>
			<td><div><a href="/user/password"><?php echo get_lang('user/password') ?></a></div></td>
			<td><div><a href="/user/avatar"><?php echo get_lang('user/avatar') ?></a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<form action="/user/settings" method="post">
		<div class="card">
			<?php if ($message): ?>
				<dl>
					<dt></dt>
					<dd><?php echo $message ?></dd>
				</dl>
			<?php endif ?>
			
			<dl>
				<dt><?php echo get_lang('settings/wap_template') ?>:</dt>
				<dd>
					<select name="wap_template">
						<?php foreach ($templates as $template): ?>
							<option value="<?php echo $template ?>" <?php $template == user_data('user_wap_template') && print(' selected="selected" ') ?>><?php echo $template ?></option>
						<?php endforeach ?>
					</select>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/web_template') ?>:</dt>
				<dd>
					<select name="web_template">
						<?php foreach ($templates as $template): ?>
							<option value="<?php echo $template ?>" <?php $template == user_data('user_web_template') && print(' selected="selected" ') ?>><?php echo $template ?></option>
						<?php endforeach ?>
					</select>
				</dd>
			</dl>
			
			
			<dl>
				<dt><?php echo get_lang('settings/locale') ?>:</dt>
				<dd>
					<select name="locale">
						<?php foreach ($locales as $locale_data): ?>
							<option value="<?php echo $locale_data['locale'] ?>" <?php $locale_data['locale'] == user_data('user_locale') && print(' selected="selected" ') ?>><?php echo $locale_data['name'] ?></option>
						<?php endforeach ?>
					</select>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/date_adjust') ?>:</dt>
				<dd><input type="text" name="date_adjust" value="<?php echo user_data('user_date_adjust') ?>" size="3" /></dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/translit') ?>:</dt>
				<dd>
					<input type="radio" name="allow_translit" value="1" <?php user_data('user_allow_translit') && print('checked="checked" ') ?>/> <?php echo get_lang('yes') ?> 
					<input type="radio" name="allow_translit" value="0" <?php user_data('user_allow_translit') || print('checked="checked" ') ?>/> <?php echo get_lang('no') ?>
				</dd>
			</dl>
			
			
			<dl>
				<dt><?php echo get_lang('settings/privmsgs_to_email') ?>:</dt>
				<dd>
					<input type="radio" name="privmsgs_to_email" value="1" <?php user_data('user_privmsgs_to_email') && print('checked="checked" ') ?>/> <?php echo get_lang('yes') ?> 
					<input type="radio" name="privmsgs_to_email" value="0" <?php user_data('user_privmsgs_to_email') || print('checked="checked" ') ?>/> <?php echo get_lang('no') ?>
				</dd>
			</dl>
			
			
			<dl>
				<dt><?php echo get_lang('settings/images') ?>:</dt>
				<dd>
					<input type="radio" name="allow_images" value="1" <?php user_data('user_allow_images') && print('checked="checked" ') ?>/> <?php echo get_lang('yes') ?> 
					<input type="radio" name="allow_images" value="0" <?php user_data('user_allow_images') || print('checked="checked" ') ?>/> <?php echo get_lang('no') ?>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/hide_online') ?>:</dt>
				<dd>
					<input type="radio" name="hide_online" value="1" <?php user_data('user_hide_online') && print('checked="checked" ') ?>/> <?php echo get_lang('yes') ?> 
					<input type="radio" name="hide_online" value="0" <?php user_data('user_hide_online') || print('checked="checked" ') ?>/> <?php echo get_lang('no') ?>
				</dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('settings/cookies_notice') ?>"><?php echo get_lang('settings/cookies') ?>:</dt>
				<dd>
					<input type="radio" name="allow_cookies" value="1" <?php user_data('user_allow_cookies') && print('checked="checked" ') ?>/> <?php echo get_lang('yes') ?> 
					<input type="radio" name="allow_cookies" value="0" <?php user_data('user_allow_cookies') || print('checked="checked" ') ?>/> <?php echo get_lang('no') ?>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/friends_privacy') ?>:</dt>
				<dd>
					<input type="radio" name="friends_privacy" value="<?php echo FRIENDS_ME ?>" <?php user_data('user_friends_privacy') == FRIENDS_ME && print('checked="checked" ') ?>/> <?php echo get_lang('settings/only_me') ?><br />
					<input type="radio" name="friends_privacy" value="<?php echo FRIENDS_FRIENDS ?>" <?php user_data('user_friends_privacy') == FRIENDS_FRIENDS && print('checked="checked" ') ?>/> <?php echo get_lang('settings/only_friends') ?><br />
					<input type="radio" name="friends_privacy" value="<?php echo FRIENDS_USERS ?>" <?php user_data('user_friends_privacy') == FRIENDS_USERS && print('checked="checked" ') ?>/> <?php echo get_lang('settings/users') ?>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/friendship_privacy') ?>:</dt>
				<dd>
					<input type="radio" name="friendship_privacy" value="<?php echo FRIENDSHIP_DISABLE ?>" <?php user_data('user_friendship_privacy') == FRIENDSHIP_DISABLE && print('checked="checked" ') ?>/> <?php echo get_lang('settings/nobody') ?><br />
					<input type="radio" name="friendship_privacy" value="<?php echo FRIENDSHIP_USERS_WITH_ENTRY ?>" <?php user_data('user_friendship_privacy') == FRIENDSHIP_USERS_WITH_ENTRY && print('checked="checked" ') ?>/> <?php echo get_lang('settings/users') ?> (<?php echo get_lang('settings/friendship_with_entry') ?>)<br />
					<input type="radio" name="friendship_privacy" value="<?php echo FRIENDSHIP_USERS ?>" <?php user_data('user_friendship_privacy') == FRIENDSHIP_USERS && print('checked="checked" ') ?>/> <?php echo get_lang('settings/users') ?><br />
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/privmsgs_privacy') ?>:</dt>
				<dd>
					<input type="radio" name="privmsgs_privacy" value="<?php echo PRIVMSGS_FRIENDS ?>" <?php user_data('user_privmsgs_privacy') == PRIVMSGS_FRIENDS && print('checked="checked" ') ?>/> <?php echo get_lang('settings/only_friends') ?><br />
					<input type="radio" name="privmsgs_privacy" value="<?php echo PRIVMSGS_USERS ?>" <?php user_data('user_privmsgs_privacy') == PRIVMSGS_USERS && print('checked="checked" ') ?>/> <?php echo get_lang('settings/users') ?>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('settings/wall_privacy') ?>:</dt>
				<dd>
					<input type="radio" name="wall_privacy" value="<?php echo WALL_ME ?>"  <?php user_data('user_wall_privacy') == WALL_ME && print('checked="checked" ') ?>/> <?php echo get_lang('settings/only_me') ?><br />
					<input type="radio" name="wall_privacy" value="<?php echo WALL_FRIENDS ?>" <?php user_data('user_wall_privacy') == WALL_FRIENDS && print('checked="checked" ') ?>/> <?php echo get_lang('settings/only_friends') ?><br />
					<input type="radio" name="wall_privacy" value="<?php echo WALL_USERS ?>" <?php user_data('user_wall_privacy') == WALL_USERS && print('checked="checked" ') ?>/> <?php echo get_lang('settings/users') ?><br />
				</dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('settings/nav_posts_notice') ?>"><?php echo get_lang('settings/nav_posts') ?>:</dt>
				<dd><input type="text" name="nav_posts" value="<?php echo user_data('user_nav_posts') ?>" size="3" /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('settings/nav_comments_notice') ?>"><?php echo get_lang('settings/nav_comments') ?>:</dt>
				<dd><input type="text" name="nav_comments" value="<?php echo user_data('user_nav_comments') ?>" size="3" /></dd>
			</dl>
			
			<dl>
				<dt></dt>
				<dd>
					<input type="submit" value="<?php echo get_lang('save') ?>" />
					<input type="submit" name="reset" value="<?php echo get_lang('reset') ?>" /> 
				</dd>
			</dl>
		</div>
	</form>
</div>