<?php
define('IN_WBENGINE', TRUE);
define('TIME', microtime());

// Запуск сессии
session_name('SID');
session_start();

// Установка контроля ошибок
error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);

// Установка кодировки
mb_internal_encoding('UTF-8');

// Выключение Magic Quotes
set_magic_quotes_runtime(0);

// Установка соединения с БД
require_once('wb-system/includes/db.php');

// Константы
require_once('wb-system/includes/constants.php');

// Библиотеки функций
require_once('wb-system/includes/functions.php');
require_once('wb-system/includes/functions_acl.php');
require_once('wb-system/includes/functions_env.php');
require_once('wb-system/includes/functions_view.php');

// Установка завершающей функции
register_shutdown_function('set_privacy_key');

// Запуск буферизации
ob_start('output');

// Установка используемго типа (WAP / WEB) шаблонов
if (isset($_COOKIE['web_browser'])) {
	define('WEB_BROWSER', (bool) $_COOKIE['web_browser']);
} else {
	define('WEB_BROWSER', user_agent('is_browser') && !user_agent('is_mobile'));
}

// Установка используемой локали
if (isset($_COOKIE['locale'])) {
	foreach (get_locales() as $locale) {
		if ($_COOKIE['locale'] == $locale['locale']) {
			define('LOCALE', $_COOKIE['locale']);
			break;
		}
	}
}
if (!defined('LOCALE')) {
	define('LOCALE', get_option('locale'));
}


// Получение настроек роутера
$router_config = require_once('wb-system/configuration/router.php');

// Обработка URI
$request = preg_replace('/\/+/', '/', $_SERVER['REQUEST_URI']);
$request = preg_replace('/^\/(.*)\/?$/', '\\1', $request);
$request = preg_replace('/[^A-z\d\/\%-_\.\+]/', '', $request);
$request = urldecode($request);

// Получение параметров, для удаления номера страницы.
// Т.к. для обработки локальным Rewrite Rule должна подойти "чистая" строка (но и параметр переданной страницы нужно сохранить).
$router_data = explode('/', $request);
$current_page = 0;

if (count($router_data)) {
	foreach ($router_data as $key => $param) {
		if (preg_match('/^page(\d+)$/', $param, & $matches) && is_unsigned($matches[1], TRUE)) {
			$current_page = $matches[1];
			
			unset($router_data[$key]); // Удаляем текущую запись с ключом
			array_merge($router_data, array()); // Сбрасываем ключи
			break;
		}
	}
}


// Локальный Rewrite Rule
foreach ($router_config['rewrite_rule'] as $rule => $replace) {
	if (preg_match($rule, $request)) {
		$request = preg_replace($rule, $replace, $request);
		
		// Произошла замена, заменяем массив данных, полученных роутером
		$router_data = explode('/', $request);
	}
}

// Получение контроллера
$router_controller = array_shift($router_data);


// Запуск контроллера.
// Поиск соответствующего реального контроллера для полученного роутером адреса
do {
	// Используемый контроллер не был передан роутеру - 
	// используется дефолтовый контроллер (т.е. заглавная страница по умолчанию)
	if (!$router_controller) {
		$ussed_controller = $router_config['default_controller'];
		break;
	}
	
	// Пробегает по конфигу роутера - ищет реальный контроллер, 
	// к которому подойдет переданное значение роутера.
	foreach ($router_config['pages'] as $page => $controller) {
		if (($page{0} == '/' && preg_match($page, $router_controller) || $router_controller == $page) && is_file("wb-system/controllers/{$controller}.php")) {
			$ussed_controller = $controller;
			break 2;
		}
	}
	
	// Реальный контроллер не был найден, используем страницу 404
	// Можно заменить на дефолтовый контроллер.
	$ussed_controller = $router_config['error_404_controller'];
} while (0);

// Запуск сессий.
require_once('wb-system/includes/sessions.php');

// Уборщики мусора
//require_once('wb-system/includes/clears.php');

if (is_banned()) {
	// Пользователь забанен
	$ussed_controller = $router_config['banned_controller'];
}


// Запуск контроллера
require_once('wb-system/controllers/' . $ussed_controller . '.php');

if (!empty($view_instance)) {
	// Вывод шаблона, если шаблонный движок был инициализирован
	view_render('main', TRUE);
}

// Завершение буферизации.
ob_end_flush();