<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td class="current"><div><a href=""><?php echo get_lang('ban/list') ?></a></div></td>
			<td><div><a href="/ban/unset/<?php echo get_privacy_key() ?>"><?php echo get_lang('ban/unset') ?></a></div></td>
			<td><div><a href="/ban/set"><?php echo get_lang('ban/set') ?></a></div></td>
		</tr>
	</table>
</div>
	
<form action="/ban/refresh" method="post">
	<div class="content">
		<?php foreach ($ban_list_array as $fields): ?>
			<div class="block">
				<div class="title">
					<a href="/profile/<?php echo $fields['user_login'] ?>"><?php echo $fields['user_login'] ?></a>
					<?php
						switch (user_online($fields['user_id'])):
							case USER_ONLINE:
								?><span class="online"><?php echo get_lang('user/online') ?></span><?php
								break;
							
							case USER_OFFLINE:
								?><span class="offline"><?php echo get_lang('user/offline') ?></span><?php
								break;
								
							case USER_HIDE:
								?><span class="hide"><?php echo get_lang('user/hidden') ?></span><?php
						endswitch;
						?>
				</div>
				
				<p class="text"><?php echo get_lang('ban/time') ?>:<br /><?php fdate($fields['time']); ?></p>
				
				<?php if ($fields['description']): ?>
					<p class="text"><?php echo get_lang('ban/description'); ?>:<br /><?php echo $fields['description']; ?></p>
				<?php endif; ?>
				
				<p class="text">
					<input type="hidden" name="data[<?php echo $fields['user_id'] ?>]" />
					<input type="checkbox" name="data[<?php echo $fields['user_id'] ?>][deny_site]" value="1" <?php $fields['deny_site'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_site') ?><br />
					<input type="checkbox" name="data[<?php echo $fields['user_id'] ?>][deny_add_post]" value="1" <?php $fields['deny_add_post'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_post') ?><br />
					<input type="checkbox" name="data[<?php echo $fields['user_id'] ?>][deny_add_comment]" value="1" <?php $fields['deny_add_comment'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_comment') ?><br />
					<input type="checkbox" name="data[<?php echo $fields['user_id'] ?>][deny_vote_user]" value="1" <?php $fields['deny_vote_user'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_user') ?><br />
					<input type="checkbox" name="data[<?php echo $fields['user_id'] ?>][deny_vote_blog]" value="1" <?php $fields['deny_vote_blog'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_blog') ?><br />
					<input type="checkbox" name="data[<?php echo $fields['user_id'] ?>][deny_vote_post]" value="1" <?php $fields['deny_vote_post'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_post') ?><br />
					<input type="checkbox" name="data[<?php echo $fields['user_id'] ?>][deny_vote_comment]" value="1" <?php $fields['deny_vote_comment'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_comment') ?>
					</p>
				</div>
			</div>
		<?php endforeach; ?>
		
		<p class="text"><input type="submit" value="<?php echo get_lang('save') ?>" /></p>
		</form>
</div>

<?php view_include('pagination') ?>