<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>


<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/ban"><?php echo get_lang('ban/list') ?></a></div></td>
			<td><div><a href="/ban/unset/<?php echo get_privacy_key() ?>"><?php echo get_lang('ban/unset') ?></a></div></td>
			<td class="current"><div><a href="/ban/set"><?php echo get_lang('ban/set') ?></a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<form action="/ban/set" method="post">
	
	<p class="text">
		<?php echo get_lang('user/login') ?> <?php echo get_lang('or') ?> <?php echo get_lang('user/id') ?>:<br />
		<?php if ($error): ?>
			<span class="error"><?php echo get_lang('user/login_error'); ?></span><br />
		<?php endif; ?>
		<input type="text" name="user" maxlength="30" value="<?php echo $b_user ?>" />
	</p>
	
	<p class="text">
		<?php echo get_lang('ban/time') ?>:<br />
		<input type="date" name="date" size="7" value="<?php echo fdate(-1, 'Y-m-d'); ?>" />
		<input type="time" name="time" size="2" value="<?php echo fdate(-1, 'H:i'); ?>" />
	</p>
	
	<p class="text">
		<?php echo get_lang('ban/description'); ?>:<br />
		<span class="notice"><?php echo get_lang('ban/description_notice'); ?></span><br />
		<input type="text" name="description" maxlength="255" value="<?php echo $b_description; ?>" />
	</p>
	
	<p class="text">
		<input type="checkbox" name="deny_site" value="1" <?php $b_data['deny_site'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_site') ?><br />
		<input type="checkbox" name="deny_add_post" value="1" <?php $b_data['deny_add_post'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_post') ?><br />
		<input type="checkbox" name="deny_add_comment" value="1" <?php $b_data['deny_add_comment'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_comment') ?><br />
		<input type="checkbox" name="deny_vote_user" value="1" <?php $b_data['deny_vote_user'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_user') ?><br />
		<input type="checkbox" name="deny_vote_blog" value="1" <?php $b_data['deny_vote_blog'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_blog') ?><br />
		<input type="checkbox" name="deny_vote_post" value="1" <?php $b_data['deny_vote_post'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_post') ?><br />
		<input type="checkbox" name="deny_vote_comment" value="1" <?php $b_data['deny_vote_comment'] && print('checked="checked" ') ?>/> <?php echo get_lang('ban/deny_vote_comment') ?>
	</p>
	
	<p class="text">
		<input type="submit" value="<?php echo get_lang('ban/set_submit') ?>" />
	</p>
	
	</form>
</div>