<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $current_user['user_login'] ?></h1>
	<div class="skill-rating">
		<div class="skill">
			<div>
				<?php echo get_lang('user/skill') ?><br />
				<span class="number"><?php echo $current_user['user_skill'] ?></span>
			</div>
		</div>
		<div class="rating">
			<div>
				<?php echo get_lang('user/rating') ?><br />
				<span class="number"><?php echo $current_user['user_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $current_user['user_count_vote'], declension($current_user['user_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/profile/<?php echo $current_user['user_login'] ?>"><?php echo get_lang('profile') ?></a></div></td>
			<td  class="current"><div><a href="/friends/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('friends') ?></a></div></td>
			<?php if ($count_entries): ?>
				<td><div><a href="/friends/entries"><?php echo get_lang('friends/entries') ?> (<?php echo $count_entries ?>)</a></div></td>
			<?php endif ?>
			<td><div><a href="/personal/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('blog') ?></a></div></td>
			<td><div><a href="/comments/user/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('comments') ?> (<?php echo $current_user['user_count_comments'] ?>)</a></div></td>
		</tr>
	</table>
</div>

<form action="/friends" name="delete_form" method="post">
	<div class="live">
		<div class="br">
		<div class="bl">
		<div class="tr">
		<div class="text">
			<table>
				<tr>
					<td width="5%"><input type="checkbox" id="set" onclick="setAllCheckboxesRange('delete_form', 'id', 'set');  return false;" /></td>
					<th width="5%"></th>
					<th width="40%"></th>
					<th width="20%"></th>
					<th width="15%"><?php echo get_lang('user/skill') ?></th>
					<th width="15%"><?php echo get_lang('user/rating') ?></th>
				</tr>
				
				<?php $i = 1; foreach ($users_array as $fields): ?>
					<tr>
						<td>
							<input type="checkbox" id="id<?php echo $i++ ?>" name="users[]"  value="<?php echo $fields['user_id'] ?>" />
						</td>
						
						<td>
							<a href="/privmsgs/write/<?php echo $fields['user_id'] ?>"><img src="/wb-content/templates/HabraLight/images/write-icon.png" /></a>
						</td>
						
						<td>
							<a href="/profile/<?php echo $fields['user_login'] ?>"><?php echo $fields['user_login'] ?></a>
						</td>
						
						<td>
							<?php user_online($fields['user_id']) == USER_ONLINE && print(get_lang('user/online')) ?>
						</td>
						
						<td class="skill" style="text-align: center;">
							<span class="number"><?php echo $fields['user_skill'] ?></span>
						</td>
						
						<td class="rating" style="text-align: center;">
							<span class="number"><?php echo $fields['user_rating'] ?></span>
						</td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		</div>
		</div>
		</div>
	</div>

	<?php view_include('pagination') ?>

	<div  style="float: right;">
		<input type="submit" name="delete" value="<?php echo get_lang('friends_delete_checked') ?>" />
	</div>
</form>
