<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li class="current"><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $group_data['group_name'] ?></h1>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/group/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/info') ?></a></div></td>
			<td class="current"><div><a href="/group/users/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/users') ?></a></div></td>
			
			<?php if (is_admin()): ?>
				<td><div><a href="/group/adduser/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/add_user_submit') ?></a></div></td>
				<td><div><a href="/group/edit/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/edit_submit') ?></a></div></td>
				<td><div><a href="/group/delete/<?php echo $group_data['group_id'] ?>"><?php echo get_lang('group/delete_submit') ?></a></div></td>
			<?php endif ?>
		</tr>
	</table>
</div>

<form action="/groups/users/<?php echo $group_data['group_id'] ?>" name="delete_form" method="post">
	<div class="live">
		<div class="br">
		<div class="bl">
		<div class="tr">
		<div class="text">
			<table>
				<tr>
					<td width="5%"><input type="checkbox" id="set" onclick="setAllCheckboxesRange('delete_form', 'id', 'set');  return false;" /></td>
					<th width="50%"></th>
					<th width="20%"></th>
					<th width="15%"><?php echo get_lang('user/skill') ?></th>
					<th width="15%"><?php echo get_lang('user/rating') ?></th>
				</tr>
				
				<?php $i = 1; foreach ($users_array as $fields): ?>
					<tr>
						<td>
							<input type="checkbox" id="id<?php echo $i++ ?>" name="users[]"  value="<?php echo $fields['user_id'] ?>" />
						</td>
						
						<td>
							<a href="/profile/<?php echo $fields['user_login'] ?>"><?php echo $fields['user_login'] ?></a>
						</td>
						
						<td>
							<?php user_online($fields['user_id']) == USER_ONLINE && print(get_lang('user/online')) ?>
						</td>
						
						<td class="skill" style="text-align: center;">
							<span class="number"><?php echo $fields['user_skill'] ?></span>
						</td>
						
						<td class="rating" style="text-align: center;">
							<span class="number"><?php echo $fields['user_rating'] ?></span>
						</td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		</div>
		</div>
		</div>
	</div>
	
	<div  style="float: right;">
		<input type="submit" name="delete" value="<?php echo get_lang('group/delete_submit') ?>" />
	</div>
</form>