<?php if ($pagination['count_pages'] > 1): ?>
	<div class="pagination">
		<ul>
			<?php if ($pagination['prev_page']): ?>
				<li><a href="<?php echo sprintf($pagination['url'], $pagination['prev_page']) ?>"><?php echo get_lang('pagination/prev_page') ?></a></li>
			<?php endif ?>
				
			<?php
			if ($pagination['pages_left']) {
				foreach($pagination['pages_left'] as $page) {
					?><li><a href="<?php echo sprintf($pagination['url'], $page) ?>"><?php echo $page ?></a></li><?php
				}
				
				if ($pagination['page'] > 5) {
					?><li><em style="background: #fff; color: #000">...</em></li><?php
				}
			}
			if ($pagination['pages_center']) {
				foreach($pagination['pages_center'] as $page) {
					if ($page == $pagination['page']) {
						?><li><em><?php echo $page ?></em></li><?php
					} else {
						?><li><a href="<?php echo sprintf($pagination['url'], $page) ?>"><?php echo $page ?></a></li><?php
					}
				}
			}
			if ($pagination['pages_right']) {
				if ($pagination['page'] < $pagination['count_pages'] - 4) {
					?><li><em style="background: #fff; color: #000">...</em></li><?php
				}
				
				foreach($pagination['pages_right'] as $page) {
					?><li><a href="<?php echo sprintf($pagination['url'], $page) ?>"><?php echo $page ?></a></li><?php
				}
			}
			?>
			
			<?php if ($pagination['next_page']): ?>
				<li><a href="<?php echo sprintf($pagination['url'], $pagination['next_page']) ?>"><?php echo get_lang('pagination/next_page') ?></a></li>
			<?php endif ?>
		</ul>
	</div>
<?php endif ?>