<ul class="panel-nav-top">
	<li class="current"><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $current_user['user_login'] ?></h1>
	<div class="skill-rating">
		<div class="skill">
			<div>
				<?php echo get_lang('user/skill') ?><br />
				<span class="number"><?php echo $current_user['user_skill'] ?></span>
			</div>
		</div>
		<div class="rating">
			<?php if ($allow_vote): ?><a href="/vote/user/positive/<?php echo $current_user['user_id'] ?>" class="vote-plus"></a><?php endif ?>
			<div>
				<?php echo get_lang('user/rating') ?><br />
				<span class="number"><?php echo $current_user['user_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $current_user['user_count_vote'], declension($current_user['user_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
			<?php if ($allow_vote): ?><a href="/vote/user/negative/<?php echo $current_user['user_id'] ?>" class="vote-minus"></a><?php endif ?>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/profile/<?php echo $current_user['user_login'] ?>">Профиль</a></div></td>
			<td<?php $view_all or print(' class="current"') ?>><div><a href="/personal/<?php echo $current_user['user_id'] ?>">Личный блог</a></div></td>
			<td<?php $view_all && print(' class="current"') ?>><div><a href="/personal/<?php echo $current_user['user_id'] ?>/all">Посты (<?php echo $current_user['user_count_posts'] ?>)</a></div></td>
			<td><div><a href="/comments/user/<?php echo $current_user['user_id'] ?>">Комментарии (<?php echo $current_user['user_count_comments'] ?>)</a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<?php foreach ($posts_array as $fields): ?>
		<div class="post">
			<h1>
				<?php if ($fields['blog_id']): ?>
					<?php echo get_lang('blog', '<a href="/blogs/' . $fields['blog_url'] . '">' . $fields['blog_name'] . '</a>') ?>
					 &rarr; <a href="/blogs/<?php echo $fields['blog_url'] ?>/<?php echo $fields['post_id'] ?>"><?php echo $fields['post_title'] ?></a>
				<?php else: ?>
					<?php echo get_lang('blog_personal', '<a href="/personal/' . $current_user['user_id'] . '"> ' . $current_user['user_login'] . '</a>') ?>
					 &rarr; <a href="/personal/<?php echo $current_user['user_id'] ?>/<?php echo $fields['post_id'] ?>"><?php echo $fields['post_title'] ?></a>
				<?php endif ?>
			</h1>
			
			<div class="data">
				<div style="padding-bottom: 10px">
					<?php echo tags($fields['post_text']) ?>
					<?php if ($fields['post_cut_text']): ?>
						<?php if ($fields['blog_id']): ?>
							 <a href="/blogs/<?php echo $fields['blog_url'] ?>/<?php echo $fields['post_id'] ?>#cut"><?php echo $fields['post_cut_text'] ?></a>
						<?php else: ?>
							 <a href="/personal/<?php echo $current_user['user_id'] ?>/<?php echo $fields['post_id'] ?>#cut"><?php echo $fields['post_cut_text'] ?></a>
						<?php endif ?>
					<?php endif ?>
				</div>
				
				<div class="bar">
					<div class="corner tl"></div>
					<div class="corner tr"></div>
					<div class="text">
						<div class="rating"><span class="number<?php echo $fields['post_rating'] > 0 ? ' positive' : ($fields['post_rating'] < 0 ? ' negative' : '') ?>"><?php echo ($fields['post_rating'] > 0 ? '+' : '') . $fields['post_rating'] ?></span></div>
						<div><?php echo fdate($fields['post_add_time']) ?></div>
						<div><a class="user" href="/profile/<?php echo $current_user['user_login'] ?>"><span><?php echo $current_user['user_login'] ?></span></a></div>
						<div><a class="comments" href="/comments/post/<?php echo $fields['post_id'] ?>"><span><?php echo $fields['post_count_comments'] ? $fields['post_count_comments'] : get_lang('post/comment') ?></span></a></div>
					</div>
					<div class="corner bl"></div>
					<div class="corner br"></div>
				</div>
			</div>
		</div>
	<?php endforeach ?>
</div>

<?php view_include('pagination') ?>