DROP TABLE IF EXISTS `blog_access`;
CREATE TABLE `blog_access` (
  `blog_id` int(11) unsigned NOT NULL default '0',
  `user_id` int(11) unsigned default NULL,
  `group_id` int(11) unsigned default NULL,
  `allow_approve_user` enum('0','1') default '1',
  `allow_delete_user` enum('0','1') default '1',
  `allow_edit_post` enum('0','1') default '1',
  `allow_delete_post` enum('0','1') default '1',
  `allow_edit_comment` enum('0','1') default '0',
  `allow_delete_comment` enum('0','1') default '1',
  UNIQUE KEY `blog_user_id` (`blog_id`,`user_id`),
  UNIQUE KEY `blog_group_id` (`blog_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `blog_personal_access`;
CREATE TABLE `blog_personal_access` (
  `group_id` int(11) unsigned default NULL,
  `user_id` int(11) unsigned default NULL,
  `allow_view_post` enum('0','1') default '0',
  `allow_edit_post` enum('0','1') default '1',
  `allow_delete_post` enum('0','1') default '1',
  `allow_edit_comment` enum('0','1') default '0',
  `allow_delete_comment` enum('0','1') default '1',
  UNIQUE KEY `group_id` (`group_id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `blog_vote`;
CREATE TABLE `blog_vote` (
  `voter_id` int(11) unsigned NOT NULL default '0',
  `blog_id` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `user_blog_id` (`voter_id`,`blog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `blogs`;
CREATE TABLE `blogs` (
  `blog_id` int(11) unsigned NOT NULL auto_increment,
  `blog_type` enum('0','1','2') NOT NULL default '0',
  `blog_name` varchar(255) NOT NULL,
  `blog_url` varchar(50) NOT NULL,
  `blog_description` varchar(255) NOT NULL default '',
  `blog_add_time` int(11) unsigned default '0',
  `blog_count_users` int(11) unsigned NOT NULL default '0',
  `blog_limit_rating` float(9,3) unsigned NOT NULL default '0.000',
  `blog_rating` float(9,3) unsigned default '0.000',
  `blog_count_vote` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`blog_id`),
  KEY `blog_rating` (`blog_rating`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `comment_vote`;
CREATE TABLE `comment_vote` (
  `voter_id` int(11) unsigned default '0',
  `comment_id` int(11) unsigned default '0',
  UNIQUE KEY `voter_comment_id` (`voter_id`,`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `comment_id` int(11) unsigned NOT NULL auto_increment,
  `post_id` int(11) unsigned NOT NULL default '0',
  `user_id` int(11) unsigned NOT NULL default '0',
  `comment_time` int(11) unsigned NOT NULL default '0',
  `comment_text` text NOT NULL,
  `comment_user_ip` varchar(15) NOT NULL default '0.0.0.0',
  `comment_rating` int(11) default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `post_id` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `group_id` int(11) unsigned NOT NULL auto_increment,
  `group_name` varchar(255) NOT NULL default '',
  `group_description` varchar(255) NOT NULL default '',
  `group_add_time` int(11) unsigned NOT NULL default '0',
  `group_count_users` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`group_id`),
  KEY `count_users` (`group_count_users`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `post_vote`;
CREATE TABLE `post_vote` (
  `voter_id` int(11) unsigned default '0',
  `post_id` int(11) unsigned NOT NULL default '0',
  KEY `user_post_id` (`voter_id`,`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `posts`;
CREATE TABLE `posts` (
  `post_id` int(11) unsigned NOT NULL auto_increment,
  `blog_id` int(11) unsigned NOT NULL default '0',
  `user_id` int(11) unsigned NOT NULL default '0',
  `post_title` varchar(255) NOT NULL default '',
  `post_text` text NOT NULL,
  `post_add_time` int(11) unsigned NOT NULL default '0',
  `post_edit_time` int(11) unsigned NOT NULL default '0',
  `post_edit_user_id` int(11) unsigned NOT NULL default '0',
  `privacy_post` enum('0','1','2') default '2',
  `privacy_comment` enum('0','1') default '1',
  `post_count_comments` int(11) unsigned NOT NULL default '0',
  `post_rating` int(11) default '0',
  `post_count_vote` int(11) unsigned NOT NULL default '0',
  `post_last_comment_id` int(11) unsigned NOT NULL,
  PRIMARY KEY  (`post_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `privmsgs_in`;
CREATE TABLE `privmsgs_in` (
  `privmsgs_id` int(11) NOT NULL auto_increment,
  `privmsgs_user_id` int(11) NOT NULL default '0',
  `privmsgs_user_id_from` int(11) NOT NULL default '0',
  `privmsgs_read` enum('1','0') NOT NULL default '0',
  `privmsgs_time` int(11) NOT NULL default '0',
  `privmsgs_subject` varchar(255) NOT NULL default '',
  `privmsgs_message` text NOT NULL,
  PRIMARY KEY  (`privmsgs_id`),
  KEY `privmsgs_user_id` (`privmsgs_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `privmsgs_out`;
CREATE TABLE `privmsgs_out` (
  `privmsgs_id` int(11) NOT NULL auto_increment,
  `privmsgs_user_id` int(11) NOT NULL default '0',
  `privmsgs_user_id_to` int(11) NOT NULL default '0',
  `privmsgs_read` int(1) NOT NULL default '0',
  `privmsgs_time` int(11) NOT NULL default '0',
  `privmsgs_subject` varchar(255) NOT NULL default '',
  `privmsgs_message` text NOT NULL,
  PRIMARY KEY  (`privmsgs_id`),
  KEY `privmsgs_user_id` (`privmsgs_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `ip` varchar(15) NOT NULL default '',
  `user_agent` varchar(100) default NULL,
  `page` varchar(255) NOT NULL default '',
  `user_id` int(11) unsigned NOT NULL default '0',
  `start_time` int(11) unsigned NOT NULL default '0',
  `last_time` int(11) unsigned NOT NULL default '0',
  `count_clicks` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `post_id` int(11) unsigned NOT NULL default '0',
  `post_tag` varchar(50) NOT NULL,
  KEY `post_id_tag` (`post_id`,`post_tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `user_ban`;
CREATE TABLE `user_ban` (
  `user_id` int(11) unsigned default '0',
  `time` int(11) unsigned NOT NULL default '0',
  `description` varchar(255) NOT NULL,
  `deny_add_post` enum('0','1') default '0',
  `deny_add_comment` enum('0','1') default '0',
  `deny_vote_post` enum('0','1') default '0',
  `deny_vote_blog` enum('0','1') default '0',
  `deny_vote_user` enum('0','1') default '0',
  `deny_vote_comment` enum('0','1') default '0',
  `deny_site` enum('0','1') NOT NULL default '0',
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `user_blog`;
CREATE TABLE `user_blog` (
  `blog_id` int(11) unsigned NOT NULL default '0',
  `user_id` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `blog_user_id` (`blog_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `user_blog_entry`;
CREATE TABLE `user_blog_entry` (
  `blog_id` int(11) unsigned NOT NULL default '0',
  `user_id` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `blog_user_id` (`blog_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `user_friend`;
CREATE TABLE `user_friend` (
  `user_id` int(11) unsigned NOT NULL default '0',
  `friend_user_id` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `user_friend_id` (`user_id`,`friend_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `user_friend_entry`;
CREATE TABLE `user_friend_entry` (
  `user_id` int(11) unsigned NOT NULL default '0',
  `friend_user_id` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `user_friend_id` (`user_id`,`friend_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `user_group`;
CREATE TABLE `user_group` (
  `group_id` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  UNIQUE KEY `group_user_id` (`group_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `user_vote`;
CREATE TABLE `user_vote` (
  `voter_id` int(11) unsigned default '0',
  `user_id` int(11) unsigned NOT NULL default '0',
  `time` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `voter_user_id` (`voter_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(11) NOT NULL auto_increment,
  `user_login` varchar(25) NOT NULL default '',
  `user_password` varchar(32) NOT NULL default '',
  `user_email` varchar(80) NOT NULL default '',
  `user_admin_privilege` enum('0','1') NOT NULL default '0',
  `user_registration` int(11) unsigned NOT NULL default '0',
  `user_last_visit` int(11) unsigned NOT NULL default '0',
  `user_locale` char(5) NOT NULL default 'ru_RU',
  `user_date_adjust` tinyint(2) NOT NULL default '0',
  `user_wap_template` varchar(255) NOT NULL default '',
  `user_web_template` varchar(255) NOT NULL default '',
  `user_skill` float(9,3) unsigned NOT NULL default '0.000',
  `user_rating` float(9,3) NOT NULL default '0.000',
  `user_count_vote` int(11) unsigned NOT NULL default '0',
  `user_unread_privmsgs` int(11) unsigned NOT NULL default '0',
  `user_count_posts` int(11) unsigned NOT NULL default '0',
  `user_count_comments` int(11) unsigned NOT NULL default '0',
  `user_last_post_time` int(11) unsigned NOT NULL default '0',
  `user_allow_cookies` enum('0','1') NOT NULL default '1',
  `user_allow_images` enum('0','1') NOT NULL default '1',
  `user_allow_translit` enum('0','1') NOT NULL default '0',
  `user_privmsgs_to_email` enum('0','1') NOT NULL default '0',
  `user_hide_online` enum('0','1') NOT NULL default '0',
  `user_friends_privacy` enum('0','1','2') NOT NULL default '2',
  `user_friendship_privacy` enum('0','1','2') NOT NULL default '2',
  `user_privmsgs_privacy` enum('0','1') NOT NULL default '1',
  `user_wall_privacy` enum('0','1','2') NOT NULL default '2',
  `user_nav_posts` tinyint(2) unsigned NOT NULL default '5',
  `user_nav_comments` tinyint(2) unsigned NOT NULL default '5',
  `user_status` varchar(255) NOT NULL default '',
  `user_sex` enum('m','w') NOT NULL default 'm',
  `user_name` varchar(50) NOT NULL default '',
  `user_surname` varchar(150) NOT NULL default '',
  `user_phone` varchar(50) NOT NULL default '',
  `user_im` varchar(50) NOT NULL default '',
  `user_url` varchar(100) NOT NULL default '',
  `user_interests` text NOT NULL,
  `user_about` text NOT NULL,
  PRIMARY KEY  (`user_id`),
  UNIQUE KEY `user_login` (`user_login`),
  UNIQUE KEY `user_email` (`user_email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';