<?php defined('IN_WBENGINE') or die('Hacking attempt');

// Конфигурация роутера
return array (
	// Дефолтовые контроллеры
	'banned_controller' => 'banned/index',
	'error_404_controller' => '404/index',
	'default_controller' => 'posts/all/index',
	
	// Дополнительный разруливатель, заменяет всю строку роутера, в случае совпадения
	'rewrite_rule' => array (
		// Псевдо-линки
		'#^personal/([0-9+])/([0-9]+)(/?)+$#' => 'read/\\2',
		'#^blogs/([a-z0-9\-_]+)/([0-9]+)(/?)+$#' => 'read/\\2',
		'#^blog$#' => 'blogs',
		'#^group/(.*)$#' => 'groups/\\1'
	),
	
	// Основные страницы
	'pages' => array (
		// Все записи
		'index' => 'posts/all/index',
		
		// Записи из тематических блогов
		'blogs' => 'posts/blogs/index',
		
		// Записи из личных блогов
		'personal' => 'posts/personal/index',
		
		// Публикация записи
		'publish' => 'post/add/index',
		
		// Редактирование записи
		'edit' => 'post/edit/index',
		
		// Чтение и работа с постом
		'read' => 'post/index/index',
		'post' => 'post/index/index',
		
		// Блоги
		'blog' => 'blog/index',
		
		// Редактирование доступа к блогам
		'access' => 'access/index',
		
		// Группы
		'groups' => 'groups/index',
		
		// Поиск по метке
		'tag' => 'tags/index',
		'tags' => 'tags/index',
		
		// Комментарий
		'comment' => 'comment/index',
		
		// Комментарии
		'comments' => 'comments/index',
		
		// Люди
		'users' => 'users/index',
		
		// Профиль
		'profile' => 'profile/index',
		
		// Друзья
		'friends' => 'friends/index',
		
		// Личный кабинет
		'user' => 'user/index',
		
		// Авторизация
		'login' => 'login/index',
		
		// Выход
		'exit' => 'exit/index',
		
		// Регистрация
		'registration' => 'registration/index',
		
		// Голосование
		'vote' => 'vote/index',
		
		// Установки
		'set' => 'set/index',
		
		// Captcha
		'captcha' => 'kcaptcha/index',
		
		// Список изменений
		'change' => 'change/index',
		
		// Бан
		'ban' => 'ban/index',
		
		// Список разделов админ-панели
		'admin' => 'admin/index',
		
		// Приватные сообщения
		'privmsgs' => 'privmsgs/index'
	)
);