<?php
/**
 * project:
 * WB Engine (Multi User)
 *
 * version:
 * 2.0
 *
 * authors:
 * Egorov Artem
 *
 * last edit:
 * 20/08/2009 13:01
 *
 * GNU General Public License, version 2:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

defined('IN_WBENGINE') or die('Hacking attempt');

/**
 * Переменная, хранящая объект класса.
 */
$view_instance = null;

/**
 * Уничтожает данные шаблона.
 *
 * @param string Имя шаблона
 * @return void
 */
function view_destroy($template) {
	if (is_object($view_instance)) {
		$view_instance->destroy($template);
	}
}

/**
 * Подключает другой шаблонов внутри шаблона.
 *
 * @param string Путь к файлу
 * @return mixed
 */
function view_include($path) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	return $GLOBALS['view_instance']->include_template($path);
}

/**
 * Инициализация main-шаблона.
 *
 * @return void
 */
function view_initialize() {
	$version = WEB_BROWSER ? 'web' : 'wap';
	$template = get_option($version. '_template');
	
	if (is_logged()) {
		if (!is_dir('wb-content/templates/ ' . user_data('user_' . $version . '_template'))) {
			$sql = 'update ' . USERS_TABLE . ' set user_' . $version . '_template = "' . $template . '" 
			where user_' . $version . '_template = "' . user_data('user_' . $version . '_template') . '"';
			
			mysql_query($sql);
		} else {
			$template = user_data('user_' . $version . '_template');
		}
	}
	
	/**
	 * Создание объекта view.
	 */
	$GLOBALS['view_instance'] =& new view('wb-content/templates/' . $template . '/%s.php');
	
	/**
	 * Открытие основного шаблона main.
	 * Если main-шаблон не нужен - достаточно переоткрыть с именем main.
	 */
	$GLOBALS['view_instance']->open('main', 'main');
}

/**
 * Определяет, установлена ли переменная.
 *
 * @param string Имя шаблона
 * @param string Имя переменной
 * @return boolean
 */
function view_isset_var($template, $key) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	return $GLOBALS['view_instance']->isset_var($template, $key);
}

/**
 * Создает данные шаблона.
 *
 * @param string Имя объекта
 * @param string Путь к шаблону
 * @param array Массив данных
 * @return mixed
 */
function view_open($template, $path, $data = array()) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	$GLOBALS['view_instance']->open($template, $path, $data);
}

/**
 * Воспроизводит шаблон.
 *
 * @param string Имя шаблона
 * @param boolean Вывести результат
 * @param mixed Функция-обработчик
 * @return mixed
 */
function view_render($name, $print = false, $renderer = false) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	return $GLOBALS['view_instance']->render($name, $print, $renderer);
}

/**
 * Устанавливает переменную.
 *
 * @param string Имя шаблона
 * @param string Имя переменной
 * @param string Значение
 * @return void
 */
function view_set_var($template, $key, $value = null) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	
	if (func_num_args() == 2) { // 3-ий аргумент не передан
		$GLOBALS['view_instance']->set_var($template, $key);
	} else {
		$GLOBALS['view_instance']->set_var($template, $key, $value);
	}
}

/**
 * Устанавливает линкованую переменную.
 *
 * @param string Имя шаблона
 * @param string Имя переменной
 * @param string Значение
 * @return void
 */
function view_set_link_var($template, $key, & $value = null) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	
	if (func_num_args() == 2) { // 3-ий аргумент не передан
		$GLOBALS['view_instance']->set_link_var($template, $key);
	} else {
		$GLOBALS['view_instance']->set_link_var($template, $key, & $value);
	}
}

/**
 * Устанавливает глобальную переменную.
 *
 * @param string Имя переменной
 * @param string Значение
 * @return void
 */
function view_set_global_var($template, $key, & $value) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	$GLOBALS['view_instance']->set_global_var($key, & $value);
}

/**
 * Устанавливает глобальную линкованую переменную.
 *
 * @param string Имя переменной
 * @param string Значение
 * @return void
 */
function view_set_global_link_var($template, $key, & $value) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	$GLOBALS['view_instance']->set_global_link_var($key, & $value);
}

/**
 * Разустанавливает переменную.
 *
 * @param string Имя шаблона
 * @param string Имя переменной
 * @return void
 */
function view_unset_var($template, $key) {
	is_object($GLOBALS['view_instance']) or view_initialize();
	$GLOBALS['view_instance']->unset_var($template, $key);
}

/**
 * Класс для работы с шаблоном.
 */
class view {
	// Полный путь к шаблонам
	var $path = null;
	
	// Хранилище данных
	var $data = array();
	
	// Хранилище глобальных данных
	var $global_data = array();
	
	// Хранилище путей к шаблонам
	var $templates = array();
	
	// Воспроизводимый шаблон
	var $current_template = null;
	
	/**
	 * Конструктор. Устанавливает текущий полный путь к шаблонам.
	 *
	 * @return void
	 */
	function view($path = '%s') {
		$this->path = $path;
	}
	
	/**
	 * Уничтожает данные шаблона.
	 *
	 * @param string Имя шаблона
	 * @return void
	 */
	function destroy($name) {
		unset($templates[$name], $data[$name]);
	}
	
	/**
	 * Подключает другой шаблонов внутри шаблона.
	 *
	 * @param string Путь к файлу
	 * @return void
	 */
	function include_template($path) {
		if (!is_null($this->current_template)) {
			/**
			 * Экспорт переменных
			 */
			extract($this->data[$this->current_template]);
			extract($this->global_data, EXTR_SKIP);
			
			include(sprintf($this->path, $path));
		}
	}
	
	/**
	 * Определяет, установлена ли переменная.
	 *
	 * @param string Имя шаблона
	 * @param string Имя переменной
	 * @return boolean
	 */
	function isset_var($name, $key) {
		if (is_array($key)) {
			$result = array();
			foreach ($key as $property) {
				$result[$property] = isset($this->data[$name][$property]);
			}
		} else {
			$result = isset($this->data[$name][$key]);
		}
		
		return $result;
	}
	
	/**
	 * Создает данные шаблона.
	 *
	 * @param string Имя шаблона
	 * @param string Относительный путь к шаблону
	 * @param array Переменные
	 * @return void
	 */
	function open($name, $path, $data = array()) {
		$this->templates[$name] = sprintf($this->path, $path);
		
		if (count($data)) {
			foreach ($data as $array) {
				if (count($array) == 2) {
					$this->set_var($name, $array[0], $array[1]); // значение непосредственно передано
				} else {
					$this->set_var($name, $array[0]); // значение будет получено из глобальной области видимости
				}
			}
		}
		
		isset($this->data[$name]) or $this->data[$name] = array();
	}
	
	/**
	 * Воспроизводит шаблон.
	 *
	 * @param string Имя шаблона
	 * @param boolean Вывести результат
	 * @param mixed Функция-обработчик
	 * @return mixed
	 */
	function render($__name__, $__print__ = false, $__renderer__ = false) {
		if (isset($this->templates[$__name__], $this->data[$__name__])) {
			/**
			 * Установка воспроизводящего шаблона.
			 * Нужно что бы при подключении шаблона (include_template) последний мог использовать переменные основного шаблона.
			 */
			$this->current_template = $__name__;
			
			/**
			 * Экспорт переменных
			 */
			extract($this->data[$__name__], EXTR_SKIP);
			extract($this->global_data, EXTR_SKIP);
			ob_start();
			
			if (is_file($this->templates[$__name__])) {
				include($this->templates[$__name__]);
			}
			
			$output = ob_get_clean();
			
			/**
			 * Обработка полученного результата указанной функцией-обработчиком.
			 */
			if ($__renderer__ !== false && is_callable($__renderer__, true)) {
				$output = call_user_func($__renderer__, $output);
			}
			
			/**
			 * Очищаем переменную.
			 */
			$this->current_template = null;
			
			if ($__print__) {
				echo $output;
				return;
			}
			
			return $output;
		} else {
			die("view render: template '{$__name__}' not open");
		}
	}
	
	/**
	 * Устанавливает переменную.
	 *
	 * @param string Имя шаблона
	 * @param string Имя переменной
	 * @param string Значение
	 * @return void
	 */
	function set_var($name, $key, $value = null) {
		if (func_num_args() == 2) { // 3-ий аргумент не передан
			$this->data[$name][$key] = isset($GLOBALS[$key]) ? $GLOBALS[$key] : null;
		} else {
			$this->data[$name][$key] = $value;
		}
	}
	
	/**
	 * Устанавливает линкованую переменную.
	 *
	 * @param string Имя шаблона
	 * @param string Имя переменной
	 * @param string Значение
	 * @return void
	 */
	function set_link_var($name, $key, & $value = null) {
		if (func_num_args() == 2) { // 3-ий аргумент не передан
			if (isset($GLOBALS[$key])) { // и существует глобальная одноименная переменная
				$this->data[$name][$key] =& $GLOBALS[$key];
			}
		} else {
			$this->data[$name][$key] =& $value;
		}
	}
	
	/**
	 * Устанавливает глобальную переменную.
	 *
	 * @param string Имя переменной
	 * @param string Значение
	 * @return void
	 */
	function set_global_var($key, $value = null) {
		$this->global_data[$key] = $value;
	}
	
	/**
	 * Устанавливает глобальную линкованую переменную.
	 *
	 * @param string Имя переменной
	 * @param string Значение
	 * @return void
	 */
	function set_global_link_var($key, & $value) {
		$this->global_data[$key] =& $value;
	}
	
	/**
	 * Разустанавливает переменную.
	 *
	 * @param string Имя шаблона
	 * @param string Имя переменной
	 * @return void
	 */
	function unset_var($name, $key) {
		unset($this->data[$name][$key]);
	}
}
?>