﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Приложение C.</title></head>\n";
echo "<body>\n";
echo "<h1>Приложение C</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<h1>Некоторые общие нестандартные средства SQL</h1>\n";
echo "<p>Имеется ряд особенностей языка SQL, которые пока не определены как часть \n";
echo "стандарта ANSI или стандарта ISO (Международная Организация По Стандартизации), \n";
echo "и являются общими для многочисленных реализаций, так как они были получены для \n";
echo "практического использования. Конечно, эти особенности меняются от программы к \n";
echo "программе, и их обсуждение предназначено только для того, чтобы показать \n";
echo "некоторые общие подходы к ним.</p>\n";
echo "<h3>ТИПЫ ДАННЫХ</h3>\n";
echo "<p>Типы данных, поддерживаемые стандартом SQL, собраны в <a href=\"b.php\">Приложении B</a>. Это \n";
echo "CHARACTER и разнообразные числовые типы. Реализация их может оказаться \n";
echo "значительно сложнее, чем показано в терминах типов, которые они фактически могут \n";
echo "использовать. Мы будем здесь обсуждать ряд таких нестандартных типов данных.</p>\n";
echo "<h4>ТИПЫ DATE И TIME</h4>\n";
echo "<p>Как упомянуто в<a href=\"ch2.php\"> Главе 2</a>, тип DATE широко \n";
echo "поддерживается, хотя он не является частью стандарта. Мы использовали ранее в \n";
echo "нашей таблице Заказов этот тип в формате mm/dd/yyyy. Это стандартный формат IBM \n";
echo "в США. Разумеется, возможны и другие форматы, и программные реализации часто \n";
echo "поддерживают несколько форматов, позволяя вам выбирать наиболее подходящий.</p>\n";
echo "<p>Реализация, которая предлагает эту особенность, должна быть способна \n";
echo "преобразовывать дату одного формата в другой автоматически.</p>\n";
echo "<p>Имеются несколько основных форматов даты с которыми вы можете столкнуться:</p>\n";
echo "<table>\n";
echo "<tr><th>Стандарт</th><th>Формат</th><th>Пример</th></tr>\n";
echo "<tr><td>Международная Организация По Стандартизации (ISO)</td><td>yyyy-mm-dd</td><td>1990-10-31</td></tr>\n";
echo "<tr><td>Японский Индустриальный Стандарт (JIS)</td><td>yyyy-mm-dd</td><td>1990-10-31</td></tr>\n";
echo "<tr><td>IBM Европейский Стандарт (EUR)</td><td>dd.mm.yyyy</td><td>10.31.1990</td></tr></table>\n";
echo "<p>Наличие специального типа даты даёт возможность выполнять арифметические \n";
echo "операции с датами. Например, вы можете добавлять число дней к дате и получать \n";
echo "другую дату в программе, самостоятельно следящей за числом дней в месяцах, \n";
echo "високосными годами и т.д.</p>\n";
echo "<p>Даты могут также сравниваться; например фраза, \n";
echo "дата A &lt; дата B , означает, что дата A предшествует дате B по времени. Помимо \n";
echo "даты, большое количество программ определяют специальный тип для времени, \n";
echo "который может также быть представлен в ряде форматов, включая следующие:</p>\n";
echo "<table>\n";
echo "<tr><th>Стандарт</th><th>Формат</th><th>Пример</th></tr><tr><td>МЕЖДУНАРОДНАЯ ОРГАНИЗАЦИЯ ПО СТАНДАРТИЗАЦИИ (ISO)</td>\n";
echo "<td>hh-mm-ss</td><td>21.04.37</td></tr>\n";
echo "<tr><td>Японский Индустриальный Стандарт (JIS )</td><td>hh-mm-ss</td><td>21.04.37</td></tr>\n";
echo "<tr><td>IBM Европейский Стандарт</td><td>hh-mm-ss</td><td>21.04.37</td></tr>\n";
echo "<tr><td>IBM USA Стандарт (USA)</td><td>hh.mm AM/PM</td><td>9.04 PM</td></tr></table>\n";
echo "<p>Время может добавляться или сравниваться точно так же, как дата, с \n";
echo "автоматической коррекцией числа секунд в минутах или часах. Кроме того, \n";
echo "специально встроенные константы, указывающие текущую дату или время (CURDATE или \n";
echo "CURTIME), являются общими. Они похожи на константу USER (Пользователь) в которой \n";
echo "их значение будет непрерывно меняться.</p>\n";
echo "<p>Можете ли вы включать время и дату в одно \n";
echo "поле? Некоторые реализации определяют тип DATE достаточно точно, чтобы включать \n";
echo "туда ещё и TIME. В качестве альтернативы третий обобщающий тип, TIMESTAMP, может \n";
echo "быть определен как комбинация этих двух.</p>\n";
echo "<hr width=\"70%\">\n";
echo "<h3>ТИПЫ ТЕКСТОВОЙ СТРОКИ</h3>\n";
echo "<p>ANSI поддерживает только один тип для представления текста. Это тип CHAR. \n";
echo "Любое поле такого типа должно иметь определённую длину. Если строка, вставленная \n";
echo "в поле, меньше длины поля, она дополняется пробелами; строка не может быть длиннее поля.</p>\n";
echo "<p>Хотя и достаточно удобное, это определение всё же имеет некоторые ограничения \n";
echo "для пользователя. Например, символьные поля должны иметь одинаковую длину, чтобы \n";
echo "можно было выполнить команду UNION. Большинство реализаций поддерживают строки \n";
echo "переменной длины для типов данных VARCHAR и LONG VARCHAR (или просто LONG). В то \n";
echo "время как поле типа CHAR всегда может распределить память для максимального числа \n";
echo "символов, которое может сохраняться в поле, поле VARCHAR при любом количестве \n";
echo "символов может распределить только определённое количество памяти, чтобы \n";
echo "сохранить фактическое содержание поля, хотя SQL может установить извне некоторое \n";
echo "дополнительное пространство памяти, чтобы следить за текущей длиной поля.<br>\n";
echo "Поле VARCHAR может быть любой длины, включая реализационно определяемый максимум. \n";
echo "Этот максимум может меняться от 254 до 2048 символов для VARCHAR и до 16000 \n";
echo "символов для LONG. LONG обычно используется для текста пояснительного характера \n";
echo "или для данных, которые не могут легко сжиматься в простые значения полей; \n";
echo "VARCHAR может использоваться для любой текстовой строки, чья длина может \n";
echo "меняться. Между прочим, не всегда хорошо использовать VARCHAR вместо CHAR. \n";
echo "Извлечение и модифицирование полей VARCHAR - более сложный и, следовательно, \n";
echo "более медленный процесс, чем извлечение и модифицирование полей CHAR. Кроме \n";
echo "того, некоторое количество памяти VARCHAR остается всегда неиспользованной (в \n";
echo "резерве) для гарантии вмещения всей строки. Вы должны просчитывать, насколько \n";
echo "значения полей могут меняться по длине, а также - способны ли они к объединению \n";
echo "с другими полями, перед тем как решить, использовать CHAR или VARCHAR. Часто тип \n";
echo "LONG используется для сохранения двоичных данных. Естественно, что использование \n";
echo "размера такого &quot;неуклюжего&quot; поля будет ограничивать оперативность SQL. \n";
echo "Проконсультируйтесь с вашим руководством.</p>\n";
echo "<hr width=\"70%\">\n";
echo "<h3>КОМАНДА FORMAT</h3>\n";
echo "<p>Как мы подчеркивали в Главе 7, процесс вывода выполняемого в стандарте SQL, \n";
echo "имеет ограничения. Хотя большинство реализаций включают SQL в пакеты, имеющие \n";
echo "другие средства для управления этой функцией, некоторые реализации также \n";
echo "используют команду типа FORMAT внутри SQL чтобы навязывать выводу запроса \n";
echo "определённые формы структуры или ограничения.</p>\n";
echo "<p>Среди возможных функций команды FORMAT существуют такие:</p>\n";
echo "<ul>\n";
echo "<li>определение ширины столбцов (при печати)</li>\n";
echo "<li>определение представления NULL-значений</li>\n";
echo "<li>обеспечение (новых) заголовков для столбцов</li>\n";
echo "<li>обеспечение заголовков внизу или вверху страниц, выводимых на печать</li>\n";
echo "<li>навязывает присвоение или изменение форматам полей, содержащих значения даты, времени или денежной суммы</li>\n";
echo "<li>вычисляет общие и промежуточные суммы, не исключая возможности обобщения поля, как это делает, например, SUM<br>\n";
echo "<font size=\"2\">(Альтернативным подходом к этой проблеме в некоторых программах \n";
echo "является предложение COMPUTE.)</font></li></ul>\n";
echo "<p>Команда FORMAT может вводиться сразу перед или сразу после запроса, к \n";
echo "которому она применяется, в зависимости от реализации. Одна команда FORMAT \n";
echo "обычно может применяться только к одному запросу, хотя любое число команд FORMAT \n";
echo "может применяться к одному и тому же запросу.</p>\n";
echo "<p>Вот некоторые примеры команды FORMAT:</p>\n";
echo "<pre>       FORMAT NULL '_ _ _ _ _ _ _';\n";
echo "       FORMAT BTITLE 'Orders Grouped by Salesperson';\n";
echo "       FORMAT EXCLUDE (2, 3);</pre>\n";
echo "<p>Первая команда<b> NULL</b> представляется в виде<b> ' _ _ _ _ _ _ _ '</b> при \n";
echo "выводе на печать; вторая вставляет заголовок<b> 'Orders Grouped by Salesperson'</b> \n";
echo "в нижнюю часть каждой страницы; третья исключает второй и третий столбцы из \n";
echo "вывода предыдущего запроса. Вы могли бы использовать последнюю, если выбираете \n";
echo "конкретные столбцы, чтобы использовать их в предложении <b>ORDER BY</b> в вашем \n";
echo "выводе. Так как указанные функции команды FORMAT могут выполняться по разному, \n";
echo "все варианты их использования не могут быть здесь показаны.</p>\n";
echo "<p>Имеются другие команды, которые могут использоваться для выполнения тех же \n";
echo "функций. Команда SET подобна команде FORMAT; она является вариантом или \n";
echo "дополнением к команде, которая применяется во всех запросах текущего сеанса \n";
echo "пользователя, а не просто в одиночном запросе. В следующей реализации, команда \n";
echo "FORMAT начинается ключевым словом COLUMN следующим образом:<br>\n";
echo "<br>\n";
echo "<b>COLUMN odate FORMAT dd-mon-yy;</b><br>\n";
echo "<br>\n";
echo "что форсирует формат типа 10-Oct-90 в поле даты, использующемся в выводе \n";
echo "запроса на печать. Предложение COMPUTE, упомянутое ранее, вставляется в запрос, \n";
echo "следующим образом:</p>\n";
echo "<pre>        SELECT odate, amt\n";
echo "           FROM Orders\n";
echo "           WHERE snum = 1001\n";
echo "           COMPUTE SUM (amt);</pre>\n";
echo "<p>Оно выводит все заказы продавца Peel с датой и суммой приобретения по каждой \n";
echo "дате, а в конце - общую сумму приобретений. Другая реализация выводит \n";
echo "промежуточные суммы приобретений, используя COMPUTE в качестве команды. Сначала, \n";
echo "она определяет разбивку</p>\n";
echo "<pre>            BREAK ON odate;</pre>\n";
echo "<p>вывода вышеупомянутого запроса на страницы, сгруппировав по датам, поэтому \n";
echo "все значения odate в каждой группе - одинаковые. Затем вы можете ввести \n";
echo "следующее предложение:</p>\n";
echo "<pre>           COMPUTE SUM OF amt ON odate;</pre>\n";
echo "<p>Столбец в предложении ON предварительно должен быть использован в команде BREAK.</p>\n";
echo "<hr width=\"70%\">\n";
echo "<h3>ФУНКЦИИ</h3>\n";
echo "<p>Для SQL в стандарте ANSI вы можете применять агрегатные функции для столбцов \n";
echo "или использовать их значения в скалярных выражениях, таких, например, как comm * \n";
echo "100. Имеется много других полезных функций, которые вы, вероятно, встречали на \n";
echo "практике.</p>\n";
echo "<p>Имеется список некоторых общих функций SQL, отличающихся от стандартных \n";
echo "агрегатов. Они могут использоваться в предложениях SELECT-запросов точно так \n";
echo "же, как агрегатные функции, но эти функции выполняются для одиночных значений, а \n";
echo "не для групповых. В следующем списке они классифицированы согласно типам данных, \n";
echo "с которыми они работают. Если нет примечаний, то переменные в этом списке \n";
echo "стандартизированы для любого выражения значений соответствующего типа, которые могут быть использованы в предложении SELECT.</p>\n";
echo "<h4>МАТЕМАТИЧЕСКИЕ ФУНКЦИИ</h4>\n";
echo "<p>Эти функции применяются для работы с числами.</p>\n";
echo "<table>\n";
echo "<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr>\n";
echo "<tr><td>ABX(X)</td><td>Абсолютное значение X (преобразование отрицательного или положительного значения в положительное).</td></tr>\n";
echo "<tr><td>CEIL (X)</td><td>X является десятичным значением, которое будет округляться сверху.</td></tr>\n";
echo "<tr><td>FLOOR (X)</td><td>X является десятичным значением, которое будет округляться снизу.</td></tr>\n";
echo "<tr><td>GREATEST(X,Y)</td><td>Возвращает большее из двух значений.</td></tr>\n";
echo "<tr><td>LEAST(X,Y)</td><td>Возвращает меньшее из двух значений.</td></tr>\n";
echo "<tr><td>MOD(X,Y)</td><td>Возвращает остаток от деления X на Y.</td></tr>\n";
echo "<tr><td>POWER(X,Y)</td><td>Возвращает значение X в степени Y.</td></tr>\n";
echo "<tr><td>ROUND(X,Y)</td><td>Цикл от X до десятичного Y. Если Y отсутствует, цикл до целого числа.</td></tr>\n";
echo "<tr><td>SING(X)</td><td>Возвращает минус если X &lt; 0, или плюс если X &gt; 0.</td></tr>\n";
echo "<tr><td>SQRT (X)</td><td>Возвращает квадратный корень из X.</td></tr></table>\n";
echo "<h4>СИМВОЛЬНЫЕ ФУНКЦИИ</h4>\n";
echo "<p>Эти функции могут быть применены для строк текста из столбцов текстовых типов \n";
echo "данных, либо из строк литерных текстов, или же из комбинации этих двух.</p>\n";
echo "<table>\n";
echo "<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr>\n";
echo "<tr><td>LEFT(&lt;string&gt;,X)</td><td>Возвращает крайние левые (старшие) символы X из строки.</td></tr>\n";
echo "<tr><td>RICHT(&lt;string&gt;,X)</td><td>Возвращает символы X младшего разряда из строки </td></tr>\n";
echo "<tr><td>ASCII(&lt;string&gt;)</td><td>Возвращает код ASCII, которым строка представляется в памяти компьютера.</td></tr>\n";
echo "<tr><td>CHR(&lt;asciicode&gt;)</td><td>Возвращает принтерные символы кода ASCII.</td></tr>\n";
echo "<tr><td>VALUE(&lt;string&gt;)</td><td>Возвращает математическое значение для строки. Считается, что строка \n";
echo "имеет тип CHAR или VARCHAR, но состоит из чисел. VALUE('3') произведёт число 3 типа INTEGER.</td></tr>\n";
echo "<tr><td>UPPER(&lt;string&gt;)</td><td>Преобразует все символы строки в символы верхнего регистра.</td></tr>\n";
echo "<tr><td>LOWER(&lt;string&gt;)</td><td>Преобразует все символы строки в символы нижнего регистра.</td></tr>\n";
echo "<tr><td>INlTCAP(&lt;string&gt;)</td><td>Преобразует начальные символы строки в заглавные буквы. В некоторых реализациях может иметь название PROPER.</td></tr>\n";
echo "<tr><td>LENGTH(&lt;string&gt;)</td><td>Возвращает число символов в строке.</td></tr>\n";
echo "<tr><td>&lt;string&gt;||</td>\n";
echo "<td>Объединяет две строки в выводе, так чтобы после первой немедленно следовала вторая. (значок || называется оператором сцепления).</td></tr>\n";
echo "<tr><td>LPAD(&lt;string&gt;,X,'*' )</td>\n";
echo "<td>Дополняет строку слева звездочками '*' или любым другим указанным символом в количестве, определяемом X.</td></tr>\n";
echo "<tr><td>RPAD(&lt;string&gt;,X, &quot;)</td>\n";
echo "<td>То же самое что и LPAD, за исключением того, что дополнение делается справа.</td></tr>\n";
echo "<tr><td>SUBSTR(&lt;string&gt;,X,Y)</td><td>Извлекает Y символов из строки, начиная с позиции X.</td></tr></table>\n";
echo "<h4>ФУНКЦИИ ДАТЫ И ВРЕМЕНИ</h4>\n";
echo "<p>Эти функции выполняются только для допустимых значений даты или времени.</p>\n";
echo "<table>\n";
echo "<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr><tr><td>DAY(<date>)</date></td>\n";
echo "<td>Извлекает день месяца из даты. Подобные же функции существуют для MONTH \n";
echo "(МЕСЯЦ), YEAR (ГОД), HOUR (ЧАС), SECOND (СЕКУНДА) и так далее.</td></tr>\n";
echo "<tr><td>WEEKDAY(<date>)</date></td><td>Извлекает день недели из даты.</td></tr></table>\n";
echo "<h4>ДРУГИЕ ФУНКЦИИ</h4>\n";
echo "<p>Эта функция может быть применена к любому типу данных.</p>\n";
echo "<table>\n";
echo "<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr>\n";
echo "<tr>\n";
echo "<td>NVL(&lt;column&gt;,&lt;value&gt;)</td>\n";
echo "<td>NVL (NULL-значение) будет менять на\n";
echo "&lt;value&gt; каждое NULL значение, найденное в столбце &lt;column&gt;. Если полученное значение\n";
echo "&lt;column&gt; не = NULL, NVL ничего не делает.</td></tr></table>\n";
echo "<hr>\n";
echo "<h3>INTERSECT И MINUS</h3>\n";
echo "<p>Команда UNION, как вы уже видели в Главе 14, может объединить два запроса, \n";
echo "объединив их вывод в один. Два других, обычно имеющихся способа объединения \n";
echo "отдельных запросов, - это INTERSECT (Плюс) и MINUS (Минус). INTERSECT выводит \n";
echo "только строки, произведённые обоими перекрестными запросами, в то время как MINUS выводит строки, которые производятся одним запросом, но не другим.</p>\n";
echo "<p>Следовательно, следующие два запроса</p>\n";
echo "<pre>      SELECT *\n";
echo "         FROM Salespeople\n";
echo "         WHERE city = 'London'\n";
echo "\n";
echo "         INTERSECT\n";
echo "\n";
echo "      SELECT *\n";
echo "         FROM Salespeople\n";
echo "         WHERE 'London' IN\n";
echo "            (SELECT city\n";
echo "                FROM Customers\n";
echo "                WHERE Customers.snum =\n";
echo "                 Salespeople.snum);</pre>\n";
echo "<p>выведут строки, произведённые обоими запросами, выдающими всех продавцов в \n";
echo "Лондоне, которые имели по крайней мере одного заказчика, размещённого там также. \n";
echo "С другой стороны, запрос</p>\n";
echo "<pre>      SELECT *\n";
echo "         FROM Salespeople\n";
echo "         WHERE city = 'London'\n";
echo "\n";
echo "         MINUS\n";
echo "\n";
echo "      SELECT *\n";
echo "         FROM Salespeople\n";
echo "         WHERE 'London' IN\n";
echo "            (SELECT sity\n";
echo "                FROM Customers\n";
echo "                WHERE Customers.snum =\n";
echo "                 Salespeople.snum);</pre>\n";
echo "<p>удалит строки, выбранные вторым запросом, из вывода первого, и, таким \n";
echo "образом, будут выведены все продавцы в Лондоне, которые не имели там заказчиков.</p>\n";
echo "<p>MINUS иногда ещё называют DIFFERENCE (ОТЛИЧИЕ).</p>\n";
echo "<hr>\n";
echo "<h3>АВТОМАТИЧЕСКИЕ ВНЕШНИЕ ОБЪЕДИНЕНИЯ</h3>\n";
echo "<p>В<a href=\"ch14.php\"> Главе 14</a> мы обсуждали внешнее объединение и \n";
echo "показывали вам, как выполнять его, используя команду UNION. Некоторые программы \n";
echo "баз данных имеют более непосредственный способ выполнения внешних объединений. \n";
echo "В некоторых реализациях вводимый знак &quot; + &quot; после предиката может выводить \n";
echo "строки, которые удовлетворяют условию, так же как и строки, которые ему не \n";
echo "удовлетворяют. В условии предиката может содержаться поле, совпадающее для обеих \n";
echo "таблиц, и NULL-значения будут вставлены там, где такого совпадения не будет \n";
echo "найдено.</p>\n";
echo "<p>Например, предположим, вы хотите видеть ваших продавцов и \n";
echo "соответствующих им заказчиков, не исключая тех продавцов, которым не назначено \n";
echo "ни одного заказчика (хотя такого нет в наших типовых таблицах, но в \n";
echo "действительности это возможно):</p>\n";
echo "<pre>        SELECT a.snum, sname, cname\n";
echo "           FROM Salespeople a, Customers b\n";
echo "           WHEREa.snum = b.snum(+);</pre>\n";
echo "<p>Это является эквивалентом следующего объединения (UNION):</p>\n";
echo "<pre>        SELECT a.snum, sname, cname\n";
echo "           FROM Salespeople a, Customers b\n";
echo "           WHERE a.snum = b.snum\n";
echo "\n";
echo "           UNION\n";
echo "\n";
echo "        SELECT snum, sname, '_ _ _ _ _ _ _ _ _ _'\n";
echo "           FROM Salespeople\n";
echo "           WHERE snum NOT IN\n";
echo "              (SELECT snum\n";
echo "                  FROM Customers);\n";
echo "</pre>\n";
echo "<p>Предполагается, что подчёркивания будут отображены NULL-значениями (см. \n";
echo "команду FORMAT ранее в этом приложении, где описывалось отображение NULL-значениями).</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3>ОТСЛЕЖИВАНИЕ ДЕЙСТВИЙ</h3>\n";
echo "<p>Ваша SQL-реализация достаточна хороша, если она доступна многим \n";
echo "пользователям, чтобы обеспечивать им некий способ слежения за действиями, \n";
echo "выполняемыми в базе данных.</p>\n";
echo "<p>Имеются две основные формы, чтобы реализовать это: Journaling (Протоколирование) и&nbsp; Auditing (Ревизия).</p>\n";
echo "<p>Эти формы отличаются по назначению.</p>\n";
echo "<p>Journaling применяется с целью защиты ваших данных при разрушении вашей \n";
echo "системы. Сначала вы используете реализационно зависимую процедуру, чтобы архивировать текущее содержание вашей базы данных, \n";
echo "поэтому копия её содержания где-нибудь будет сохранена. Затем вы просматриваете \n";
echo "протокол изменений, сделанных в базе данных. Он сохраняется в некоторой области \n";
echo "памяти, но не в главной памяти базы данных, а желательно на отдельном \n";
echo "устройстве, и содержит список всех команд, которые произвели изменения в \n";
echo "структуре или в содержании базы данных.<br>\n";
echo "Если у вас вдруг появились проблемы и \n";
echo "текущее содержание вашей базы данных оказалось нарушенным, вы можете повторно \n";
echo "выполнить все изменения, зарегистрированные в протоколе на резервной копии вашей \n";
echo "базы данных, и снова привести вашу базу данных в состояние, которое было до \n";
echo "момента последней записи в протокол. Типичной командой для начала \n";
echo "протоколирования будет следующая:</p>\n";
echo "<pre>             SET JOURNAL ON;</pre>\n";
echo "<p>Auditing используется с целью защиты. Она следит за тем, кто и какие действия \n";
echo "выполнял в базе данных, и сохраняет эту информацию в таблице, доступной только \n";
echo "очень немногим привилегированным пользователям. Конечно, вы редко будете \n";
echo "прибегать к процедуре ревизии, потому что очень скоро она займет много памяти и \n";
echo "вам будет сложно работать в вашей БД. Но вы можете устанавливать ревизию для \n";
echo "определённых пользователей, определённых действий или определённых объектов \n";
echo "данных. Имеется такая форма команды AUDIT:</p>\n";
echo "<pre>        AUDIT INSERT ON Salespeople BY Diane;</pre>\n";
echo "<p>Или предложение ON, или предложение BY могут быть исключены, устанавливая \n";
echo "ревизию либо всех объектов, либо всех пользователей, соответственно. Применение AUDIT ALL вместо AUDIT INSERT приведет к отслеживанию всех действий Diane в \n";
echo "таблице Продавцов.</p></body></html>\n";
require_once ("../incfiles/end.php");  

?> 
