﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 14.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 14. ИСПОЛЬЗОВАНИЕ ПРЕДЛОЖЕНИЯ UNION</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В предшествующих главах мы обсуждали различные способы вложения запросов \n";
echo "друг в друга. Имеется другой способ объединения нескольких запросов - \n";
echo "формирование их в объединение.<br>\n";
echo "В этой главе вы научитесь использовать \n";
echo "предложение UNION в SQL. UNION отличается от подзапросов тем, что в нём ни один \n";
echo "из двух (или более) запросов не управляется другим запросом. Все запросы \n";
echo "выполняются независимо друг от друга, а уже вывод их объединяется.</p>\n";
echo "<h3><a name=\"14.1\">О</a>БЪЕДИНЕНИЕ НЕСКОЛЬКИХ ЗАПРОСОВ В ОДИН</h3>\n";
echo "<p>Вы можете поместить несколько запросов вместе и объединить их вывод, \n";
echo "используя предложение UNION. Предложение UNION объединяет вывод двух или более \n";
echo "SQL-запросов в единый набор строк и столбцов. Например, чтобы получить всех \n";
echo "продавцов и заказчиков, размещённых в Лондоне, и вывести их как единое целое, вы \n";
echo "могли бы ввести:</p>\n";
echo "<pre>                  SELECT snum, sname\n";
echo "                     FROM Salespeople\n";
echo "                     WHERE city = 'London'\n";
echo "\n";
echo "                     UNION\n";
echo "\n";
echo "                  SELECT cnum, cname\n";
echo "                     FROM Customers\n";
echo "                     WHERE city = 'London';</pre>\n";
echo "<p>и получить вывод, показанный в Рисунке 14.1.</p>\n";
echo "<p>Как  видите, столбцы, выбранные двумя командами, выведены так, как \n";
echo "если бы это была одна команда. Заголовки столбца исключены, потому что ни один из \n";
echo "столбцов, выведённых объединением, не был извлечён непосредственно из одной \n";
echo "таблицы. Следовательно, все эти столбцы вывода не имеют никаких имён (смотрите\n";
echo "<a href=\"ch7.php\">Главу 7</a>, в которой&nbsp; обсуждается вывод столбцов).</p>\n";
echo "<p>Кроме того, обратите внимание, что только последний запрос заканчивается \n";
echo "точкой с запятой.</p>\n";
echo "<p>Отсутствие точки с запятой дает понять SQL, что имеется ещё один или более \n";
echo "запросов.</p>\n";
echo "<pre>                ===============  SQL Execution Log ============\n";
echo "               |                                               |\n";
echo "               | SELECT snum, sname                            |\n";
echo "               | FROM  Salespeople                             |\n";
echo "               | WHERE city = 'London'                         |\n";
echo "               | UNION                                         |\n";
echo "               | SELECT cnum, cname                            |\n";
echo "               | FROM Customers                                |\n";
echo "               | WHERE city = 'London';                        |\n";
echo "               | ============================================= |\n";
echo "               |                                               |\n";
echo "               |  -----    --------                            |\n";
echo "               |   1001    Peel                                |\n";
echo "               |   1004    Motika                              |\n";
echo "               |   2001    Hoffman                             |\n";
echo "               |   2006    Climens                             |\n";
echo "               |                                               |\n";
echo "                 =============================================\n";
echo "\n";
echo "		Рисунок 14.1 Формирование объединения из двух запросов</pre>\n";
echo "<h3><a name=\"14.2\">К</a>ОГДА ВЫ МОЖЕТЕ ДЕЛАТЬ ОБЪЕДИНЕНИЕ ЗАПРОСОВ?</h3>\n";
echo "<p>Когда два (или более) запроса подвергаются объединению, их столбцы вывода \n";
echo "должны быть совместимы для объединения. Это означает, что каждый запрос должен \n";
echo "указывать одинаковое количество столбцов и в том же порядке и каждый должен иметь тип, совместимый с каждым. Значение \n";
echo "совместимости типов меняется. ANSI следит за этим очень строго, и поэтому \n";
echo "числовые поля должны иметь одинаковый числовой тип и размер, хотя некоторые \n";
echo "имена, используемые ANSI для этих типов, являются синонимами. (Смотрите в \n";
echo "Приложении B подробности о числовых типах ANSI.) Кроме того, символьные поля \n";
echo "должны иметь одинаковое количество символов (значение предназначенного числа - \n";
echo "не обязательно такое же, как используемое число).</p>\n";
echo "<p>Хорошо, что некоторые SQL-программы обладают большей гибкостью, чем это \n";
echo "определяется ANSI. Типы, не определённые ANSI, такие как DATA и BINARY, обычно \n";
echo "должны совпадать с другими столбцами такого же нестандартного типа.</p>\n";
echo "<p>Длина строки \n";
echo "также может стать проблемой. Большинство программ разрешают поля переменной \n";
echo "длины, но они не обязательно будут использоваться с UNION. С другой стороны, \n";
echo "некоторые программы (и ANSI тоже) требуют, чтобы символьные поля были точно \n";
echo "одинаковой длины. В этих вопросах вы должны проконсультироваться с документацией \n";
echo "вашей собственной программы.</p>\n";
echo "<p>Другое ограничение на совместимость: пустые значения (NULL) запрещены в любом \n";
echo "столбце объединения, причем эти значения необходимо запретить и для всех \n";
echo "соответствующих столбцов в других запросах объединения. Пустые значения (NULL) \n";
echo "запрещены ограничением NOT NULL, которое будет обсуждаться в <a href=\"ch18.php\">\n";
echo "Главе 18</a>. Кроме того, вы не можете использовать UNION в подзапросах, а также \n";
echo "не можете использовать агрегатные функции в предложении SELECT-запроса в \n";
echo "объединении. (Большинство программ пренебрегают этими ограничениями.)</p>\n";
echo "<h3><a name=\"14.3\">U</a>NION И УСТРАНЕНИЕ ДУБЛИКАТОВ</h3>\n";
echo "<p>UNION будет автоматически исключать дубликаты строк из вывода. Это нечто, не \n";
echo "свойственное SQL, так как одиночные запросы обычно содержат DISTINCT для \n";
echo "устранения дубликатов.</p>\n";
echo "<p>Например, запрос, вывод которого показан на Рисунке 14.2,</p>\n";
echo "<pre>                 SELECT snum, city\n";
echo "                    FROM Customers;</pre>\n";
echo "<p>имеет двойную комбинацию значений (snum=1001, city=London), потому что мы не \n";
echo "указали, чтобы SQL устранил дубликаты. Однако, если мы используем</p>\n";
echo "<pre>                ===============  SQL Execution Log ============\n";
echo "               |                                               |\n";
echo "               | SELECT snum, city                             |\n";
echo "               | FROM Customers;                               |\n";
echo "               | ============================================= |\n";
echo "               |  snum     city                                |\n";
echo "               |  -----    --------                            |\n";
echo "               |   1001    London                              |\n";
echo "               |   1003    Rome                                |\n";
echo "               |   1002    San Jose                            |\n";
echo "               |   1002    Berlin                              |\n";
echo "               |   1001    London                              |\n";
echo "               |   1004    Rome                                |\n";
echo "               |   1007    San Jose                            |\n";
echo "               |                                               |\n";
echo "                 =============================================\n";
echo "\n";
echo "	    Рисунок 14.2 Одиночный запрос с дублированным выводом</pre>\n";
echo "<p>UNION в комбинации этого запроса с ему подобным в таблице Продавцов, то эта \n";
echo "избыточная комбинация будет устранена. Рисунок 14.3&nbsp; показывает вывод следующего \n";
echo "запроса.</p>\n";
echo "<pre>             SELECT snum, city\n";
echo "                FROM Customers\n";
echo "\n";
echo "                UNION\n";
echo "\n";
echo "             SELECT snum, city\n";
echo "                FROM Salespeople.;\n";
echo "\n";
echo "\n";
echo "                ===============  SQL Execution Log ============\n";
echo "               |                                               |\n";
echo "               | FROM Customers                                |\n";
echo "               | UNION                                         |\n";
echo "               | SELECT snum, sity                             |\n";
echo "               | FROM Salespeople;                             |\n";
echo "               | ============================================= |\n";
echo "               |                                               |\n";
echo "               |  -----    --------                            |\n";
echo "               |   1001    London                              |\n";
echo "               |   1002    Berlin                              |\n";
echo "               |   1007    San Jose                            |\n";
echo "               |   1007    New York                            |\n";
echo "               |   1003    Rome                                |\n";
echo "               |   1001    London                              |\n";
echo "               |   1003    Rome                                |\n";
echo "               |   1002    Barcelona                           |\n";
echo "               |   1007    San Jose                            |\n";
echo "               |                                               |\n";
echo "                -----------------------------------------------\n";
echo "\n";
echo "		Рисунок 14.3 UNION устраняет вывод дубликатов</pre>\n";
echo "<p>Вы можете получить нечто похожее (в некоторых программах SQL), используя UNION \n";
echo "ALL вместо просто UNION, наподобие этого:</p>\n";
echo "<pre>             SELECT snum, city\n";
echo "                FROM Customers\n";
echo "\n";
echo "                UNION ALL\n";
echo "\n";
echo "             SELECT snum, city\n";
echo "                FROM Salespeople;</pre>\n";
echo "<h3><a name=\"14.4\">И</a>СПОЛЬЗОВАНИЕ СТРОК И ВЫРАЖЕНИЙ С UNION</h3>\n";
echo "<p>Иногда вы можете вставлять константы и выражения в предложения SELECT, \n";
echo "используемые с UNION. Это не следует строго указаниям ANSI, но это полезная и \n";
echo "необычно используемая возможность. Константы и выражения, используемые вами, \n";
echo "должны соответствовать совместимым стандартам, как мы говорили ранее. Эта \n";
echo "свойство полезно, например, чтобы устанавливать комментарии, указывающие, какой \n";
echo "запрос вывел данную строку. Предположим, что вы должны сделать отчёт о том, \n";
echo "какие продавцы выполняют наибольшие и наименьшие заказы по датам. Мы можем \n";
echo "объединить два запроса, вставив туда текст, чтобы различать вывод  каждого из \n";
echo "них.</p>\n";
echo "<pre>     SELECT a.snum, sname, onum, 'Highest on', odate\n";
echo "        FROM (Salespeople a, Orders b\n";
echo "        WHERE a.snum = b.snum\n";
echo "        AND b.amt =\n";
echo "          (SELECT MAX (amt)\n";
echo "               FROM Orders c\n";
echo "               WHERE c.odate = b.odate)\n";
echo "\n";
echo "        UNION\n";
echo "\n";
echo "     SELECT a.snum, (sname, (onum ' Lowest on', odate\n";
echo "        FROM (Salespeople a, Orders b\n";
echo "        WHERE a.snum = b.snum\n";
echo "        AND b.amt =\n";
echo "           (SELECT  MIN (amt)\n";
echo "                FROM Orders c\n";
echo "                WHERE c.odate = b.odate);</pre>\n";
echo "<p>Вывод этой команды&nbsp; показан на Рисунке 14.4. Мы должны были добавить \n";
echo "дополнительный пробел в строку 'Lowest on', чтобы сделать её совпадающей по \n";
echo "длине со строкой 'Highest on'. Обратите внимание, что Peel выбран при наличии и \n";
echo "самого высокого, и самого низкого (фактически он единственный) заказов на 5 \n";
echo "октября. Так как вставляемые строки двух этих запросов различны, строки не будут \n";
echo "устранены как дубликаты.</p>\n";
echo "<pre>                ===============  SQL Execution Log ============\n";
echo "               |                                               |\n";
echo "               | AND b.amt =                                   | \n";
echo "               | (SELECT min (amt)                             |\n";
echo "               | FROM Orders c                                 |\n";
echo "               | WHERE c.odate = b.odate);                     |\n";
echo "               | ============================================= |\n";
echo "               |                                               |\n";
echo "               | -----  ------- ------  ---------- ----------- |\n";
echo "               |  1001  Peel     3008   Highest on  10/05/1990 |\n";
echo "               |  1001  Peel     3008   Lowest  on  10/05/1990 |\n";
echo "               |  1001  Peel     3011   Highest on  10/06/1990 |\n";
echo "               |  1002  Serres   3005   Highest on  10/03/1990 |\n";
echo "               |  1002  Serres   3007   Lowest  on  10/04/1990 |\n";
echo "               |  1002  Serres   3010   Lowest  on  10/06/1990 |\n";
echo "               |  1003  Axelrod  3009   Highest on  10/04/1990 |\n";
echo "               |  1007  Rifkin   3001   Lowest  on  10/03/1990 |\n";
echo "                ===============================================\n";
echo "\n";
echo "	Рисунок 14.4 Выбор наивысших и наинизших заказов, определяемых с помощью строк</pre>\n";
echo "<h3><a name=\"14.5\">И</a>СПОЛЬЗОВАНИЕ UNION С ORDER BY</h3>\n";
echo "<p>До сих пор мы не оговаривали, что данные нескольких запросов будут \n";
echo "выводиться в каком-то особом порядке. Мы просто показывали вывод сначала из \n";
echo "одного запроса, а затем из другого. Конечно, вы не можете полагаться на вывод, \n";
echo "приходящий в произвольном порядке. Мы как раз сделаем так, чтобы этот способ  выполнения примеров был более простым. Вы можете использовать предложение ORDER \n";
echo "BY, чтобы упорядочить вывод из объединения, точно так же, как это делается в \n";
echo "индивидуальных запросах. Давайте пересмотрим наш последний пример, чтобы \n";
echo "упорядочить имена с помощью их порядковых номеров. Это может внести \n";
echo "противоречие, такое как повторение имени Peel в последней команде, как вы \n";
echo "сможете увидеть из вывода показанного в Рисунке 14.5.</p>\n";
echo "<pre>SELECT a.snum, sname, onum, 'Highest on', odate\n";
echo "   FROM Salespeople a, Orders b\n";
echo "   WHERE a.snum = b.snum\n";
echo "   AND b.amt =\n";
echo "     (SELECT MAX (amt)\n";
echo "	  FROM Orders c\n";
echo "	  WHERE c.odate = b.odate)\n";
echo "\n";
echo "   UNION\n";
echo "\n";
echo "SELECT a.snum, sname, onum, 'Lowest on', odat\n";
echo "   FROM Salespeople a, Orders b\n";
echo "   WHEREa.snum = b.snu \n";
echo "   AND b.amt =\n";
echo "      (SELECT MIN (amt)\n";
echo "	   FROM Orders c\n";
echo "	   WHERE c.odate = b.odate)\n";
echo "\n";
echo "ORDER BY 3;\n";
echo "\n";
echo "        ===============  SQL Execution Log ============\n";
echo "       | (SELECT min (amt)                             |\n";
echo "       | FROM Orders c                                 |\n";
echo "       | WHERE c.odate = b.odate)                      |\n";
echo "       | ORDER BY 3;                                   |\n";
echo "       | ============================================= |\n";
echo "       |                                               |\n";
echo "       | -----  ------- ------  ---------- ----------- |\n";
echo "       |  1007  Rifkin   3001   Lowest  on  10/03/1990 |\n";
echo "       |  1002  Serres   3005   Highest on  10/03/1990 |\n";
echo "       |  1002  Serres   3007   Lowest  on  10/04/1990 |\n";
echo "       |  1001  Peel     3008   Highest on  10/05/1990 |\n";
echo "       |  1001  Peel     3008   Lowest  on  10/05/1990 |\n";
echo "       |  1003  Axelrod  3009   Highest on  10/04/1990 |\n";
echo "       |  1002  Serres   3010   Lowest  on  10/06/1990 |\n";
echo "       |  1001  Peel     3011   Highest on  10/06/1990 |\n";
echo "	===============================================\n";
echo "\n";
echo " Рисунок 14.5 Формирование объединения с использованием ORDER BY</pre>\n";
echo "<p>Пока ORDER BY используется по умолчанию, мы не должны его указывать. Мы можем \n";
echo "упорядочить наш вывод с помощью нескольких полей, одно внутри другого, и указать \n";
echo "ASC или DESC для каждого, точно так же, как мы делали это для одиночных \n";
echo "запросов. Заметьте, что номер 3 в предложении ORDER BY указывает, какой столбец \n";
echo "из предложения SELECT будет упорядочен. Так как столбцы объединения это столбцы \n";
echo "вывода, они не имеют имён, и, следовательно, должны определяться по номеру. Этот \n";
echo "номер указывает  их место среди других столбцов вывода. (Смотрите\n";
echo "<a href=\"ch7.php\">Главу 7</a>, обсуждающую столбцы вывода.)</p>\n";
echo "<h3><a name=\"14.6\">В</a>НЕШНЕЕ ОБЪЕДИНЕНИЕ</h3>\n";
echo "<p>Операция, которая бывает часто полезна, это объединение  двух запросов, в \n";
echo "котором второй запрос выбирает строки, исключённые первым. Наиболее часто вы \n";
echo "будете делать это, чтобы не исключать строки, которые не удовлетворили \n";
echo "предикату при объединении таблиц. Это называется внешним объединением.</p>\n";
echo "<p>Предположим, что некоторые из ваших заказчиков ещё не были назначены  \n";
echo "продавцам. Вы можете захотеть увидеть имена и города всех ваших заказчиков, с \n";
echo "именами  продавцов, не учитывая тех, кто ещё не был назначен. Вы можете \n";
echo "достичь этого, формируя объединение из двух запросов, один из которых выполняет \n";
echo "объединение, а другой выбирает заказчиков с пустыми (NULL) значениями поля snum. \n";
echo "Этот последний запрос должен вставлять пробелы в поля, соответствующие полю \n";
echo "sname в первом запросе. Как и раньше, вы можете вставлять текстовые строки в ваш \n";
echo "вывод чтобы идентифицировать запрос, который вывел данную строку.<br>\n";
echo "Использование \n";
echo "этой методики во внешнем объединении дает возможность использовать предикаты для \n";
echo "классификации, а не для исключения. Мы и раньше использовали пример нахождения продавцов \n";
echo "с заказчиками, размещёнными в их городах. Однако, вместо просто выбора \n";
echo "только этих строк, вы, возможно, захотите, чтобы ваш вывод перечислял всех \n";
echo "продавцов и указывал тех, кто не имел заказчиков в их городах, и кто имел. \n";
echo "Следующий запрос, чей вывод показан на Рисунке 14.6, выполнит это:</p>\n";
echo "<pre>     SELECT Salespeople.snum, sname, cname, comm\n";
echo "	FROM Salespeople, Customers\n";
echo "	WHERE Salespeople.city = Customers.city.\n";
echo "\n";
echo "	UNION\n";
echo "\n";
echo "     SELECT snum, sname, ' NO MATCH ', comm\n";
echo "	FROM Salespeople\n";
echo "	WHERE NOT city = ANY\n";
echo "	   (SELECT city\n";
echo "		FROM Customers)\n";
echo "\n";
echo "	ORDER BY 2 DESC;\n";
echo "\n";
echo "\n";
echo "	===============  SQL Execution Log ============\n";
echo "       |                                               |\n";
echo "       | FROM Salespeople                              |\n";
echo "       | WHERE NOT city = ANYate)                      |\n";
echo "       | (SELECT city                                  |\n";
echo "       | FROM Customers)                               |\n";
echo "       | ORDER BY 2 DESC;                              |\n";
echo "       | ============================================= |\n";
echo "       |                                               |\n";
echo "       | -----  -------  ---------     ------------    |\n";
echo "       |  1002  Serres   Cisneros           0.1300     |\n";
echo "       |  1002  Serres   Liu                0.1300     |\n";
echo "       |  1007  Rifkin   NO MATCH           0.1500     |\n";
echo "       |  1001  Peel     Clemens            0.1200     |\n";
echo "       |  1001  Peel     Hoffman            0.1200     |\n";
echo "       |  1004  Motika   Clemens            0.1100     |\n";
echo "       |  1004  Motika   Hoffman            0.1100     |\n";
echo "       |  1003  Axelrod  NO MATCH           0.1000     |\n";
echo "       |                                               |\n";
echo "	===============================================\n";
echo "\n";
echo "		Рисунок 14.6 Внешнее объединение</pre>\n";
echo "<p>Строка ' NO MATCH ' была дополнена пробелами, чтобы получить совпадение поля \n";
echo "cname по длине (не во всех реализациях SQL). Второй запрос выбирает даже те \n";
echo "строки, которые исключил первый. Вы можете также добавить комментарий или \n";
echo "выражение в ваш запрос в виде дополнительного поля. Если вы сделаете это, вы \n";
echo "должны будете добавить некоторый дополнительный комментарий или выражение в той \n";
echo "же самой позиции среди выбранных полей для каждого запроса в операции \n";
echo "объединения. Совмещение UNION предотвращает добавление дополнительного поля \n";
echo "для первого запроса, но не для второго. Вот запрос, который добавляет строки \n";
echo "к выбранным полям и указывает, совпадает ли данный продавец с его заказчиком в \n";
echo "его городе:</p>\n";
echo "<pre>  SELECT a.snum, sname, a.city, ' MATCHED '\n";
echo "     FROM Salespeople a, Customers b\n";
echo "     WHERE a.city = b.city\n";
echo "\n";
echo "     UNION\n";
echo "\n";
echo "  SELECT snum, sname, city, 'NO MATCH'\n";
echo "     FROM Salespeople \n";
echo "     WHERE NOT city = ANY\n";
echo "	(SELECT city\n";
echo "	    FROM Customers)\n";
echo "\n";
echo "     ORDER BY 2 DESC;</pre>\n";
echo "<p>Рисунок 14.7&nbsp; показывает вывод этого запроса.</p>\n";
echo "<pre>	===============  SQL Execution Log ============\n";
echo "       |                                               |\n";
echo "       | WHERE a.city = b.city                         |\n";
echo "       | UNION                                         |\n";
echo "       | SELECT snum,sname,city, 'NO MATCH'            |\n";
echo "       | FROM Salespeople                              |\n";
echo "       | WHERE NOT city = ANYate)                      |\n";
echo "       | (SELECT city                                  |\n";
echo "       | FROM Customers)                               |\n";
echo "       | ORDER BY 2 DESC;                              |\n";
echo "       | ============================================= |\n";
echo "       |                                               |\n";
echo "       | -----  -------   ------------  ---------      |\n";
echo "       |  1002  Serres     San Jose     MATCHED        |\n";
echo "       |  1007  Rifkin     Barselona    NO MATCH       |\n";
echo "       |  1001  Peel       London       MATCHED        |\n";
echo "       |  1004  Motika     London       MATCHED        |\n";
echo "       |  1003  Axelrod    New York     NO MATCH       |\n";
echo "       |                                               |\n";
echo "	===============================================\n";
echo "\n";
echo "     Рисунок 14.7 Внешнее объединение с полем комментария</pre>\n";
echo "<p>Это неполное внешнее объединение, так как оно включает только несовпадающие \n";
echo "поля одной из объединяемых таблиц. Полное внешнее объединение должно включать \n";
echo "всех заказчиков, имеющих и не имеющих продавцов в их городах. Такое условие \n";
echo "будет более полным, как вы это сможете увидеть (вывод следующего запроса показан \n";
echo "на Рисунке 14,8):</p>\n";
echo "<pre>SELECT snum, city, 'SALESPERSON - MATCH'\n";
echo " FROM Salespeople\n";
echo " WHERE NOT city = ANY\n";
echo "   (SELECT city\n";
echo "	FROM Customers)\n";
echo "\n";
echo " UNION\n";
echo "\n";
echo "\n";
echo "SELECT snum, city, 'SALESPERSON - NO MATCH'\n";
echo " FROM Salespeople\n";
echo " WHERE NOT city = ANY\n";
echo "   (SELECT city\n";
echo "	FROM Customers))\n";
echo "\n";
echo " UNION\n";
echo "\n";
echo "(SELECT cnum, city, 'CUSTOMER - MATCHED'\n";
echo " FROM Customers\n";
echo " WHERE city = ANY\n";
echo "    (SELECT city\n";
echo "	 FROM Salespeople)\n";
echo "\n";
echo " UNION\n";
echo "\n";
echo "SELECT cnum, city, 'CUSTOMER - NO MATCH'\n";
echo " FROM Customers\n";
echo " WHERE NOT city = ANY\n";
echo "   (SELECT city\n";
echo "       FROM Salespeople))\n";
echo "\n";
echo " ORDER BY 2 DESC;\n";
echo "\n";
echo "\n";
echo "   ===============  SQL Execution Log ===============\n";
echo "  |                                                  |\n";
echo "  | FROM  Salespeople)                               |\n";
echo "  | ORDER BY 2 DESC;                                 |\n";
echo "  |                                                  |\n";
echo "  | ================================================ |\n";
echo "  |                                                  |\n";
echo "  |  ----   --------     ------------------------    |\n";
echo "  |  2003   San Jose     CUSTOMER     -   MATCHED    |\n";
echo "  |  2008   San Jose     CUSTOMER     -   MATCHED    |\n";
echo "  |  2002   Rome         CUSTOMER     -   NO MATCH   |\n";
echo "  |  2007   Rome         CUSTOMER     -   NO MATCH   |\n";
echo "  |  1003   New York     SALESPERSON  -   MATCHED    |\n";
echo "  |  1003   New York     SALESPERSON  -   NO MATCH   |\n";
echo "  |  2001   London       CUSTOMER     -   MATCHED    |\n";
echo "  |  2006   London       CUSTOMER     -   MATCHED    |\n";
echo "  |  2004   Berlin       CUSTOMER     -   NO MATCH   |\n";
echo "  |  1007   Barcelona    SALESPERSON  -   MATCHED    |\n";
echo "  |  1007   Barcelona    SALESPERSON  -   NO MATCH   |\n";
echo "  |                                                  |\n";
echo "   ==================================================\n";
echo "\n";
echo "	Рисунок 14.8 Полное внешнее объединение</pre>\n";
echo "<p>(Понятно, что эта формула, использующая ANY, эквивалентна объединению в \n";
echo "предыдущем примере.) Сокращённое внешнее объединение, с которого мы начинали, \n";
echo "используется чаще, чем  последний пример. Этот пример, однако, имеет другой \n";
echo "смысл. Всякий раз, когда вы выполняете объединение более чем двух запросов, вы \n";
echo "можете использовать круглые скобки, чтобы определить порядок оценки. Другими \n";
echo "словами, вместо</p>\n";
echo "<pre>    query X UNION query Y UNION query Z;</pre>\n";
echo "<p>вы должны указать, или</p>\n";
echo "<pre>   (query X UNION query Y)UNION query Z;</pre>\n";
echo "<p>или</p>\n";
echo "<pre>    query X UNION (query Y UNION query Z);</pre>\n";
echo "<p>Это потому, что UNION и UNION ALL могут быть скомбинированы, чтобы удалять \n";
echo "одни дубликаты, не удаляя другие.</p>\n";
echo "<p>Предложение</p>\n";
echo "<pre>   (query X UNION ALL query Y)UNION query Z;</pre>\n";
echo "<p>не обязательно воспроизведёт те же результаты, что и предложение</p>\n";
echo "<pre>    query X UNION ALL(query Y UNION query Z);</pre>\n";
echo "<p>если дублирующие строки в нём, будут удалены.</p>\n";
echo "<h3><a name=\"14.7\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы знаете, как использовать предложение UNION, которое даёт \n";
echo "возможность объединять любое число запросов в единое тело вывода. Если вы имеете \n";
echo "ряд подобных таблиц - таблиц, содержащих похожую информацию, но принадлежащих \n";
echo "разным пользователям и охватывающих различные особенности, - возможно, что \n";
echo "объединение сможет обеспечить простой способ для слияния и упорядочивания \n";
echo "вывода. Аналогично внешние объединения дают вам новый способ использования \n";
echo "условий не для исключения вывода, а для его маркировки или обработки его частей, \n";
echo "когда встречается условие, отличающееся от того, которое не выполняется.</p>\n";
echo "<p>Этим \n";
echo "заканчиваются наши главы о запросах. Вы теперь имеете довольно полное \n";
echo "представление о поиске данных в SQL. Следующий шаг - изучение того, как значения \n";
echo "вводятся в таблицы и как таблицы создаются &quot;с нуля&quot;. Как вы увидите, запросы \n";
echo "иногда используются внутри других типов команд так же хорошо, как и сами по \n";
echo "себе.</p>\n";
echo "<h3><a name=\"14.8\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Создайте объединение из двух запросов, которое показало бы имена,\n";
echo "   города и оценки всех заказчиков. Те из них, которые имеют поле\n";
echo "   rating=200 и более, должны, кроме того, иметь слова - &quot;Высокий\n";
echo "   Рейтинг&quot;, а остальные должны иметь слова &quot;Низкий Рейтинг&quot;.\n";
echo "\n";
echo "2. Напишите команду, которая вывела бы имена и номера каждого продавца и\n";
echo "   каждого заказчика, которые имеют больше чем один текущий\n";
echo "   заказ. Результат представьте в алфавитном порядке.\n";
echo "\n";
echo "3. Сформируйте объединение из трех запросов. Первый выбирает поля\n";
echo "   snum всех продавцов в San Jose; второй, поля cnum всех заказчиков в\n";
echo "   San Jose; и третий - поля onum всех заказов на 3 октября.\n";
echo "   Сохраните дубликаты между последними двумя запросами, но\n";
echo "   устраните любую избыточность вывода между каждым из них и самым первым.\n";
echo "\n";
echo " (Примечание: в данных типовых таблицах не содержится никакой избыточности.\n";
echo "  Это только пример.)\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>  
