﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 15.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 15. ВВОД, УДАЛЕНИЕ И ИЗМЕНЕНИЕ ЗНАЧЕНИЯ ПОЛЯ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе представлены команды, управляющие значениями, представляемыми в \n";
echo "таблице. Когда вы закончите эту главу, вы будете способны помещать строки в \n";
echo "таблицу, удалять их и изменять индивидуальные значения, представленные в каждой \n";
echo "строке.</p>\n";
echo "<p>Будет показано использование запросов при формировании полной группы строк \n";
echo "для вставки, а также - как может использоваться предикат для управления \n";
echo "изменением значений и удаления строк.</p>\n";
echo "<p>Материал в этой главе составляет полный \n";
echo "объём знаний, показывающий, как создавать и управлять информацией в базе данных \n";
echo "(БД). Более мощные способы проектирования предикатов будут обсуждены в\n";
echo "<a href=\"ch16.php\">следующей главе</a>.</p>\n";
echo "<h3><a name=\"15.1\">К</a>ОМАНДЫ МОДИФИКАЦИИ ЯЗЫКА DML</h3>\n";
echo "<p>Значения могут быть помещены и удалены из полей тремя командами языка DML \n";
echo "(Язык Манипулирования Данными):</p>\n";
echo "<pre>INSERT  (ВСТАВИТЬ),\n";
echo "UPDATE  (МОДИФИЦИРОВАТЬ),\n";
echo "DELETE  (УДАЛИТЬ).</pre>\n";
echo "<p>Не удивляйтесь, все они упоминались ранее в SQL как команды модификации.</p>\n";
echo "<h3><a name=\"15.2\">В</a>ВОД ЗНАЧЕНИЙ</h3>\n";
echo "<p>Все значения в SQL вводятся с использованием команды модификации INSERT.</p>\n";
echo "<p>В \n";
echo "самой простой форме INSERT использует следующий синтаксис:</p>\n";
echo "<pre>INSERT INTO</pre>\n";
echo "<pre>VALUES (&lt;value&gt;,  . . .);</pre>\n";
echo "<p>Так, например, чтобы ввести строку в таблицу Продавцов, вы можете \n";
echo "использовать следующее условие:</p>\n";
echo "<pre>INSERT INTO Salespeople\n";
echo "    VALUES (1001, 'Peel', 'London', .12);</pre>\n";
echo "<p>Команды DML не производят никакого вывода, но ваша программа должна дать вам \n";
echo "некоторое подтверждение того, что данные были использованы.</p>\n";
echo "<p>Имя таблицы (в нашем случае - Salespeople (Продавцы)) должно быть \n";
echo "предварительно определено в команде CREATE TABLE (см. <a href=\"ch17.php\">Главу 17</a>), а каждое \n";
echo "значение в предложении значений должно совпадать с типом \n";
echo "данных столбца, в который оно вставляется. В ANSI эти значения не могут \n";
echo "являться выражениями, что означает, что 3 разрешено, а выражение 2 + 1 - нет. \n";
echo "Значения, конечно же, вводятся в таблицу в поимённом порядке, поэтому первое \n";
echo "значение с именем автоматически попадает в столбец (поле) 1, второе в столбец 2, и так \n";
echo "далее.</p>\n";
echo "<h3><a name=\"15.3\">В</a>СТАВКА NULL</h3>\n";
echo "<p>Если вам нужно ввести пустое значение (NULL), вы вводите его точно так же, \n";
echo "как и обычное значение. Предположим, что ещё  нет поля city для мистера \n";
echo "Peel. Вы можете вставить в строку  значение=NULL в это поле следующим \n";
echo "образом:</p>\n";
echo "<pre>  INSERT INTO Salespeople\n";
echo "    VALUES (1001, 'Peel', NULL, .12);</pre>\n";
echo "<p>Так как значение NULL это специальный маркёр, а не просто символьное \n";
echo "значение, оно не заключается в одинарные кавычки.</p>\n";
echo "<h3><a name=\"15.4\">И</a>МЕНОВАНИЕ СТОЛБЦА ДЛЯ ВСТАВКИ (INSERT)</h3>\n";
echo "<p>Вы можете также указывать столбцы, куда вы хотите вставить значение имени. \n";
echo "Это позволяет вам вставлять имена в любом порядке.<br>\n";
echo "Предположим, что вы берёте \n";
echo "значения для таблицы Заказчиков из отчёта, выводимого на принтер, который \n";
echo "помещает их в таком порядке: city, cname, cnum; и, для упрощения, вы хотите \n";
echo "ввести значения в том же порядке:</p>\n";
echo "<pre>    INSERT INTO Customers (city, cnamе, cnum)\n";
echo "       VALUES ('London', 'Honman', 2001);</pre>\n";
echo "<p>Обратите внимание, что столбцы rating и snum отсутствуют. Это значит, что в \n";
echo "эти строки автоматически установлены значения по умолчанию. По умолчанию может \n";
echo "быть введено значение NULL или другое значение, определяемое по умолчанию. Если \n";
echo "ограничение запрещает использование значения NULL в данном столбце и в этот \n";
echo "столбец не установлено значение по умолчанию, этот столбец должен быть обеспечен \n";
echo "значением для любой команды INSERT, которая относится к таблице (смотри в\n";
echo "<a href=\"ch18.php\">Главе 18</a> информацию об ограничениях на значения NULL и \n";
echo "&quot;по умолчанию&quot;).</p>\n";
echo "<h3><a name=\"15.5\">В</a>СТАВКА РЕЗУЛЬТАТОВ ЗАПРОСА</h3>\n";
echo "<p>Вы можете также использовать команду INSERT, чтобы получать или выбирать \n";
echo "значения из одной таблицы и помещать их в другую для использования их вместе с \n";
echo "запросом. Чтобы сделать это, вы просто заменяете предложение VALUES (из \n";
echo "предыдущего примера) на соответствующий запрос:</p>\n";
echo "<pre>      INSERT INTO Londonstaff\n";
echo "         SELECT *\n";
echo "  	  FROM Salespeople\n";
echo "  	  WHERE city = 'London';</pre>\n";
echo "<p>Здесь выбираются все значения произведённые запросом - то есть все строки из \n";
echo "таблицы Продавцов со значениями city = &quot;London&quot; - и помещаются в таблицу Londonstaff. Чтобы это работало, таблица Londonstaff должна отвечать \n";
echo "следующим условиям:</p>\n";
echo "<ul>\n";
echo "  <li>она должна уже быть создана командой CREATE TABLE;</li>\n";
echo "  <li>она должна иметь четыре столбца, которые совпадают с таблицей Продавцов  \n";
echo "типами данных; то есть первый, второй и т.д. столбцы каждой таблицы должны \n";
echo "иметь одинаковый тип данных (причем они не должны иметь одинаковых имён).</li>\n";
echo "</ul>\n";
echo "<p>Общее правило таково, что вставляемые столбцы таблицы должны совпадать со \n";
echo "столбцами, выводимыми подзапросом, в данном случае - для всей таблицы Продавцов.</p>\n";
echo "<p>Londonstaff это теперь независимая таблица, которая получила некоторые \n";
echo "значения из таблицы Продавцов (Salespeople). Если значения в таблице Продавцов \n";
echo "будут вдруг изменены, это никак не отразится на таблице Londonstaff (хотя вы \n";
echo "могли бы создать такой эффект с помощью Представления (VIEW), описанного в\n";
echo "<a href=\"ch20.php\">Главе 20</a>).<br>\n";
echo "Так как или запрос, или команда INSERT могут \n";
echo "указывать столбцы по имени, вы можете, если захотите, переместить только \n";
echo "выбранные столбцы, а также переупорядочить только те столбцы, которые вы \n";
echo "выбрали.</p>\n";
echo "<p>Предположим, например, что вы решили сформировать новую таблицу с \n";
echo "именем Daytotals, которая просто будет следить за общим количеством долларов \n";
echo "сумм приобретений, упорядоченных по каждому дню. Вы можете ввести эти данные \n";
echo "независимо от таблицы Заказов, но сначала вы должны заполнить таблицу Daytotals \n";
echo "информацией, ранее представленной в таблице Заказов. Учитывая, что таблица \n";
echo "Заказов охватывает последний финансовый год, а не только несколько дней, как в \n";
echo "нашем примере, вы можете увидеть преимущество использования следующего условия \n";
echo "INSERT в подсчёте и вводе значений:</p>\n";
echo "<pre>      INSERT INTO Daytotals (date, total)\n";
echo "         SELECT odate, SUM (amt)\n";
echo "  	  FROM Orders\n";
echo "  	  GROUP BY odate;</pre>\n";
echo "<p>Обратите внимание, что, как предложено ранее, имена столбцов таблицы Заказов \n";
echo "и таблицы Daytotals не должны быть одинаковыми. Кроме того, если дата \n";
echo "приобретения и общее количество это единственные столбцы в таблице и они \n";
echo "находятся в данном заказе, их имена могут быть исключены из вывода из-за их \n";
echo "очевидной простоты.</p>\n";
echo "<h3><a name=\"15.6\">У</a>ДАЛЕНИЕ СТРОК ИЗ ТАБЛИЦ</h3>\n";
echo "<p>Вы можете удалять строки из таблицы командой модификации DELETE. Она может \n";
echo "удалять только строки, а не индивидуальные значения полей, так что параметр поля \n";
echo "является необязательным или недоступным. Чтобы удалить всё содержание таблицы \n";
echo "Продавцов, вы можете ввести следующее условие:</p>\n";
echo "<pre>       DELETE FROM Salespeople;</pre>\n";
echo "<p>Теперь, когда таблица пуста, её можно окончательно удалить командой DROP \n";
echo "TABLE (это объясняется в <a href=\"ch17.php\">Главе 17</a>). Обычно вам нужно удалить только некоторые \n";
echo "определённые строки из таблицы. Чтобы определить, какие строки будут удалены, вы \n";
echo "используете предикат так же, как вы это делали для запросов. Например, чтобы \n";
echo "удалить продавца Axelrod из таблицы, вы можете ввести</p>\n";
echo "<pre>         DELETE FROM Salespeople\n";
echo "  	  WHERE snum = 1003;</pre>\n";
echo "<p>Мы использовали поле snum вместо поля sname, потому что  лучшая тактика \n";
echo "- использование первичных ключей, когда вы хотите, чтобы действию подвергалась \n";
echo "одна, и только одна, строка. Для вас это аналогично действию первичного ключа. \n";
echo "Конечно, вы можете также использовать DELETE с предикатом, который выбирал бы \n";
echo "группу строк, как показано в этом примере:</p>\n";
echo "<pre>       DELETE FROM Salespeople\n";
echo "  	WHERE city = 'London';</pre>\n";
echo "<h3><a name=\"15.7\">И</a>ЗМЕНЕНИЕ ЗНАЧЕНИЙ ПОЛЯ</h3>\n";
echo "<p>Теперь, когда вы уже можете вводить и удалять строки таблицы, вы должны \n";
echo "узнать, как изменять некоторые или все значения в существующей строке. Это \n";
echo "выполняется командой UPDATE. Эта команда содержит предложение UPDATE, в котором \n";
echo "указано имя используемой таблицы, и предложение SET, которое указывает на \n";
echo "изменение, выполняемое для определенного столбца. Например, чтобы изменить \n";
echo "оценки всех заказчиков на 200, вы можете ввести</p>\n";
echo "<pre>       UPDATE Customers\n";
echo "  	SET rating = 200;</pre>\n";
echo "<h3><a name=\"15.8\">М</a>ОДИФИЦИРОВАНИЕ ТОЛЬКО ОПРЕДЕЛЕННЫХ СТРОК</h3>\n";
echo "<p>Конечно, вы не всегда захотите указывать все строки таблицы для изменения \n";
echo "единственного значения, так что UPDATE, наподобие DELETE, может использовать предикаты. \n";
echo "Вот как, например, можно выполнить изменение, одинаковое для всех заказчиков \n";
echo "продавца Peel (имеющего snum=1001):</p>\n";
echo "<pre>  	UPDATE Customers\n";
echo "  	   SET rating = 200\n";
echo "  	   WHERE snum = 1001;</pre>\n";
echo "<h3><a name=\"15.9\">К</a>ОМАНДА UPDATE ДЛЯ НЕСКОЛЬКИХ СТОЛБЦОВ</h3>\n";
echo "<p>Однако вы не обязаны ограничивать себя модифицированием единственного столбца \n";
echo "с помощью команды UPDATE. Предложение SET может назначать любое число столбцов, \n";
echo "отделяемых запятыми. Все указанные назначения могут быть сделаны для любой \n";
echo "табличной строки, но только для одной в каждый момент времени. Предположим, что \n";
echo "продавец Motika ушел на пенсию и мы хотим переназначить его номер новому \n";
echo "продавцу:</p>\n";
echo "<pre>       UPDATE Salespeople\n";
echo "  	SET sname = 'Gibson', city = 'Boston', comm = .10\n";
echo "  	WHERE snum = 1004;</pre>\n";
echo "<p>Эта команда передаст новому продавцу Gibson, всех текущих заказчиков бывшего \n";
echo "продавца Motika и заказы в том виде, в котором они были скомпонованы для Motika, \n";
echo "с помощью поля snum. Вы не можете, однако, модифицировать сразу несколько таблиц в \n";
echo "одной команде, отчасти потому, что вы не можете использовать префиксы таблиц со \n";
echo "столбцами, изменёнными предложением SET. Другими словами, вы не можете сказать \n";
echo "&quot;SET Salespeople.sname = Gibson&quot; в команде UPDATE, вы можете сказать только так: \n";
echo "&quot;SET sname = Gibson&quot;.</p>\n";
echo "<h3><a name=\"15.10\">И</a>СПОЛЬЗОВАНИЕ ВЫРАЖЕНИЙ ДЛЯ МОДИФИКАЦИИ</h3>\n";
echo "<p>Вы можете использовать скалярные выражения в предложении SET команды UPDATE, \n";
echo "включив его в выражение поля, которое будет изменено. В этом их отличие от \n";
echo "предложения VALUES команды INSERT, в котором выражения не могут использоваться; \n";
echo "это свойство скалярных выражений - весьма полезная особенность. Предположим, что \n";
echo "вы решили удвоить комиссионные всем вашим продавцам. Вы можете использовать \n";
echo "следующее выражение:</p>\n";
echo "<pre>             UPDATE Salespeople\n";
echo "                 SET comm = comm * 2;</pre>\n";
echo "<p>Всякий раз, когда вы обращаетесь к указанному значению столбца в предложении \n";
echo "SET, произведённое значение может получится из текущей строки; прежде в ней \n";
echo "будут сделаны какие-то изменения с помощью команды UPDATE. Естественно, вы \n";
echo "можете скомбинировать эти особенности и сказать &quot;удвоить комиссию всем продавцам \n";
echo "в Лондоне&quot; таким предложением:</p>\n";
echo "<pre>                 UPDATE Salespeople\n";
echo "                    SET comm = comm * 2\n";
echo "                    WHERE city = 'London';</pre>\n";
echo "<h3><a name=\"15.11\">М</a>ОДИФИЦИРОВАНИЕ  NULL-ЗНАЧЕНИЙ</h3>\n";
echo "<p>Предложение SET это не предикат. Оно может вводить пустые NULL-значения так \n";
echo "же, как оно вводило значения, не используя какого-то специального синтаксиса \n";
echo "(такого, например, как IS NULL). Так что, если вы хотите установить все оценки \n";
echo "заказчиков в Лондоне в NULL, вы можете ввести следующее предложение:</p>\n";
echo "<pre>               UPDATE customers\n";
echo "                  SET rating = NULL\n";
echo "                  WHERE city = 'London';</pre>\n";
echo "<p>что обнулит все оценки заказчиков в Лондоне.</p>\n";
echo "<h3><a name=\"15.12\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы овладели мастерством управления содержанием вашей базы данных с \n";
echo "помощью трёх простых команд:</p>\n";
echo "<pre>    INSERT     - используемой, чтобы помещать строки в базу данных;\n";
echo "    DELETE     - чтобы удалять их;\n";
echo "    REFERENCES - чтобы изменять значения в уже вставленных строках.</pre>\n";
echo "<p>Вы обучались использованию предиката с командами UPDATE и DELETE, чтобы \n";
echo "определять, на которую из строк будет воздействовать команда. Конечно, предикаты \n";
echo "как таковые не значимы для INSERT, потому что обсуждаемая строка не существует в \n";
echo "таблице до окончания выполнения команды INSERT. Однако вы можете использовать \n";
echo "запросы с INSERT, чтобы сразу помещать все наборы строк в таблицу. Причём  вы \n";
echo "можете делать это со столбцами в любом порядке.</p>\n";
echo "<p>Вы узнали, что значения по умолчанию \n";
echo "могут помещаться в столбцы, если вы не устанавливаете эти значения явно.</p>\n";
echo "<p>Вы \n";
echo "также видели использование стандартного значения по умолчанию, каковым является \n";
echo "NULL.<br>\n";
echo "Кроме того, вы поняли, что UPDATE может использовать выражение, тогда как \n";
echo "INSERT не может.</p>\n";
echo "<p>Следующая глава расширит ваше познания, показав вам, как \n";
echo "использовать подзапросы с этими командами. Эти подзапросы напоминают те, с \n";
echo "которыми вы уже знакомы, но имеются некоторые специальные выводы и ограничения \n";
echo "при использовании подзапросов в командах DML, что мы обсудим в\n";
echo "<a href=\"ch16.php\">Главе 16</a>.</p>\n";
echo "<h3><a name=\"15.13\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Напишите команду, которая поместила бы следующие значения в\n";
echo "   указанном заказе в таблицу Продавцов:\n";
echo "\n";
echo "                 city - San Jose,\n";
echo "                 name - Bianco,\n";
echo "                 comm - NULL,\n";
echo "                 cnum - 1100.\n";
echo "\n";
echo "  2. Напишите команду, которая удалила бы все заказы заказчика Clemens\n";
echo "     из таблицы Заказов.\n";
echo "\n";
echo "  3. Напишите команду, которая увеличила бы оценку всех заказчиков в Риме на 100.\n";
echo "\n";
echo "  4. Продавец Serres оставил компанию. Переназначьте его заказчиков продавцу Motika.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#15\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>  
