﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 17.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 17. СОЗДАНИЕ ТАБЛИЦ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>До этой главы мы запрашивали таблицы данных и выполняли команды по извлечению \n";
echo "этих данных, считая, что эти таблицы уже были созданы кем-то до нас.</p>\n";
echo "<p>Это действительно наиболее реальная ситуация, когда несколько человек создают таблицы, которые затем используются другими людьми. Наша цель \n";
echo "состоит в том, чтобы, охватив информацию сначала более широко, перейти затем к \n";
echo "более узким вопросам.</p>\n";
echo "<p>В этой главе мы будем обсуждать создание, изменение и удаление таблиц. Всё \n";
echo "это относится к самим таблицам, а не к данным, которые в них содержатся. Будете \n";
echo "вы или не будете выполнять эти операции самостоятельно, но их концептуальное \n";
echo "понимание увеличит ваше понимание языка SQL и природу таблиц.</p>\n";
echo "<p>Эта глава вводит \n";
echo "нас в область SQL, называемую DDL (Язык \n";
echo "Определения Данных), где создаются объекты данных SQL.</p>\n";
echo "<p>Эта глава также покажет другой вид объектов данных SQL - Индекс. Индексы \n";
echo "используются, чтобы сделать поиск более эффективным и (иногда) заставлять значения \n";
echo "отличаться друга от друга. Они обычно работают незаметно для вас, но если вы \n";
echo "попробуете поместить значения в таблицу и они будут отклонены из-за их неуникальности, это будет означать, что другая строка имеет то же самое значение \n";
echo "для этого поля и что это поле имеет уникальный индекс или ограничение, которое \n";
echo "предписывает ему уникальность. Обсуждение этого продолжится в\n";
echo "<a href=\"ch18.php\">Главе 18</a>.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.1\">К</a>ОМАНДА СОЗДАНИЯ ТАБЛИЦЫ</h3>\n";
echo "<p>Таблицы создаются командой CREATE TABLE. Эта команда создает пустую таблицу - \n";
echo "таблицу без строк. Значения вводятся с помощью DML-команды INSERT (См. \n";
echo "<a href=\"ch15.php\">Главу \n";
echo "15</a>). Команда CREATE TABLE определяет имя таблицы и описание \n";
echo "набора имён столбцов, указанных в определенном порядке. Она также определяет \n";
echo "типы данных и размеры столбцов. Каждая таблица должна иметь по крайней мере один \n";
echo "столбец.</p>\n";
echo "<p>Синтаксис команды CREATE TABLE:</p>\n";
echo "<pre>    CREATE TABLE table-name\n";
echo "         (&lt;column name&gt;  &lt;data type&gt;[(size)],\n";
echo "         &lt;column name&gt; &lt;data type&gt; [(size)] ...);</pre>\n";
echo "<p>Как сказано в <a href=\"ch2.php\">Главе 2</a>, типы данных значительно \n";
echo "меняются от программы к программе. Для совместимости со стандартом, все они \n";
echo "должны по крайней мере поддерживать стандарт типа ANSI. Он описан в\n";
echo "<a href=\"b.php\">Приложении B</a>.</p>\n";
echo "<p>Так как пробелы используются для разделения \n";
echo "частей команды SQL, они не могут быть частью имени таблицы (или любого другого \n";
echo "объекта, такого как индекс).</p>\n";
echo "<p>Знак подчеркивания ( _ ) обычно используется для \n";
echo "разделения слов в именах таблиц.<br>\n";
echo "Значение аргумента размера зависит от типа \n";
echo "данных. Если вы его не указываете, ваша система сама будет назначать значение \n";
echo "автоматически. Для числовых значений, это - лучший выход, потому что в этом \n";
echo "случае все ваши поля такого типа получат один и тот же размер, что освобождает \n";
echo "вас от проблем их совместимости (см. <a href=\"ch14.php\">Главу 14</a>). \n";
echo "Кроме того, использование аргумента размера с некоторыми числовым наборами - не \n";
echo "совсем простой вопрос. Если вам нужно хранить большие числа, вам, несомненно, \n";
echo "понадобятся гарантии, что поля достаточно велики, чтобы вместить их.</p>\n";
echo "<p>Тип \n";
echo "данных, для которого вы, в основном, должны назначать размер, это CHAR.</p>\n";
echo "<p>Аргумент \n";
echo "размера это целое число, определяющее максимальное число символов, которые может \n";
echo "вместить поле. Фактически число символов поля может быть от нуля (если поле - \n";
echo "NULL) до этого числа. По умолчанию аргумент размера = 1, что означает, что поле \n";
echo "может содержать только одну букву. Это, конечно, не совсем то, что вам нужно.</p>\n";
echo "<p>Таблицы принадлежат пользователю, который их создал, и имена всех таблиц, \n";
echo "принадлежащих данному пользователю, должны отличаться друга от друга, как и \n";
echo "имена всех столбцов внутри данной таблицы. Отдельные таблицы могут использовать \n";
echo "одинаковые имена столбцов, даже если они принадлежат одному и тому же \n";
echo "пользователю. Пример этого - столбец city в таблице Заказчиков и в таблице \n";
echo "Продавцов. Пользователи, не являющиеся владельцами таблиц, могут обращаться к \n";
echo "этим таблицам с помощью имени владельца этих таблиц, сопровождаемого точкой; \n";
echo "например, таблица Employees, созданная Smith, будет называться Smith.Employees, \n";
echo "когда она упоминается каким-то другим пользователем (мы понимаем, что Smith это \n";
echo "идентификатор (ID). ID, сообщаемый пользователем (ваш ID - это ваше имя в SQL. \n";
echo "Этот вывод обсуждался в <a href=\"ch2.php\">Главе 2</a> и будет продолжен в\n";
echo "<a href=\"ch22.php\">Главе 22</a>).</p>\n";
echo "<p>Эта команда создаст таблицу Продавцов:</p>\n";
echo "<pre>  CREATE TABLE Saleepeople\n";
echo "	(snum   integer,\n";
echo "         sname  char (10),\n";
echo "         city   char (10),\n";
echo "         comm   declmal);</pre>\n";
echo "<p>Порядок столбцов в таблице определяется порядком, в котором они указаны. Имена \n";
echo "столбца не должны разделяться при переносе строки (что  делается для \n";
echo "удобочитаемости) и отделяются запятыми.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.2\">И</a>НДЕКСЫ</h3>\n";
echo "<p>Индекс это упорядоченный (буквенный или числовой) список столбцов или групп \n";
echo "столбцов в таблице. Таблицы могут иметь большое количество строк, а, так как \n";
echo "строки не находятся в каком-нибудь определенном порядке, их поиск по указанному \n";
echo "значению может потребовать времени. Индексный адрес это и забота, и в то же \n";
echo "время обеспечение способа объединения всех значений в группы из одной или больше \n";
echo "строк, которые отличаются одна от другой.</p>\n";
echo "<p>В <a href=\"ch18.php\">Главе 18</a> мы \n";
echo "будем описывать более непосредственный способ, который заставит ваши значения \n";
echo "быть уникальными. Но этот метод не существует в ранних версиях SQL. Так как \n";
echo "уникальность часто необходима, индексы и использовались с этой целью. Индексы \n";
echo "это средство SQL, которое породил сам рынок, а не ANSI. Поэтому сам по себе \n";
echo "стандарт ANSI в настоящее время не поддерживает индексы, хотя они очень полезны \n";
echo "и широко применяются.</p>\n";
echo "<p>Когда вы создаёте индекс в поле, ваша база данных (БД) \n";
echo "запоминает соответствующий порядок всех значений этого поля в области памяти. \n";
echo "Предположим, что наша таблица Заказчиков имеет тысячи входов, а вы хотите найти \n";
echo "заказчика с номером=2999. Так как строки не упорядочены, ваша программа будет \n";
echo "просматривать всю таблицу, строку за строкой, проверяя каждый раз значение поля cnum на равенство значению 2999. Однако, если бы имелся индекс в поле cnum, то \n";
echo "программа могла бы выйти на номер 2999 прямо по индексу и дать информацию о том, \n";
echo "как найти правильную строку таблицы.</p>\n";
echo "<p>Хотя индекс значительно улучшает \n";
echo "эффективность запросов, использование индекса несколько замедляет операции \n";
echo "модификации DML (такие как INSERT и DELETE), а сам индекс занимает память. \n";
echo "Следовательно, каждый раз, когда вы создаёте таблицу, вы должны принять решение, \n";
echo "индексировать её или нет.</p>\n";
echo "<p>Индексы могут состоять из нескольких полей. Если \n";
echo "больше чем одно поле указывается для одного индекса, второе упорядочивается \n";
echo "внутри первого, третье внутри второго, и так далее. Если вы имели первое и \n";
echo "последнее имя в двух различных полях таблицы, вы могли бы создать индекс, \n";
echo "который упорядочил бы предыдущее поле внутри последующего. Это может быть \n";
echo "выполнено независимо от способа упорядочивали столбцов в таблице.</p>\n";
echo "<p>Синтаксис для \n";
echo "создания индекса обычно следующий (помните, что это не ANSI-стандарт):</p>\n";
echo "<pre>         CREATE INDEX ON\n";
echo "  (column name [,column name]...);</pre>\n";
echo "<p>Таблица, конечно, должна уже быть создана и должна содержать имя столбца. Имя \n";
echo "индекса не может быть использовано для чего-то другого в БД (любым \n";
echo "пользователем). Однажды созданный, индекс будет невидим пользователю. SQL сам \n";
echo "решает, когда он необходим, чтобы ссылаться на него, и делает это автоматически. \n";
echo "Если, например, таблица Заказчиков будет наиболее часто упоминаться в запросах \n";
echo "продавцов к их собственной клиентуре, было бы правильно создать такой индекс в \n";
echo "поле snum таблицы Заказчиков:</p>\n";
echo "<pre>     CREATE INDEX Clientgroup ON Customers (snum);</pre>\n";
echo "<p>Теперь тот продавец, который имеет отношение к этой таблице, сможет найти \n";
echo "собственную клиентуру очень быстро.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.3\">У</a>НИКАЛЬНОСТЬ&nbsp; ИНДЕКСА</h3>\n";
echo "<p>Индексу в предыдущем примере, к счастью, не предписывается уникальность, \n";
echo "несмотря на наше замечание, что это является одним из назначений индекса. Данный \n";
echo "продавец может иметь любое число заказчиков. Однако этого не случится, если мы \n";
echo "используем ключевое слово UNIQUE перед ключевым словом INDEX. Поле сnum, в \n";
echo "качестве первичного ключа, станет первым кандидатом для уникального индекса:</p>\n";
echo "<pre>       CREATE UNIQUE INDEX Custid ON Customers (cnum);</pre>\n";
echo "<h6><b>ПРИМЕЧАНИЕ:</b> эта команда будет отклонена, если уже имеются идентичные \n";
echo "значения в поле cnum. Лучший способ работы с индексами состоит в том, чтобы \n";
echo "создавать их сразу после того, как таблица создана, и прежде чем введены любые \n";
echo "значения. Также обратите внимание, что для уникального индекса более чем одного \n";
echo "поля, это - комбинация значений, каждое из которых может и не быть уникальным.</h6>\n";
echo "<p>Предыдущий пример - косвенный способ заставить поле cnum работать как \n";
echo "первичный ключ таблицы Заказчиков. Базы данных воздействуют на первичные и \n";
echo "другие ключи более непосредственно. Мы будем обсуждать это далее в\n";
echo "<a href=\"ch18.php\">Главах 18</a> и <a href=\"ch19.php\">19</a>.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.4\">У</a>ДАЛЕНИЕ ИНДЕКСОВ</h3>\n";
echo "<p>Главным признаком индекса является его имя, поэтому он может быть удален. \n";
echo "Обычно пользователи не знают о существовании индекса. SQL автоматически \n";
echo "определяет, разрешено ли пользователю использовать индекс, и, если да, разрешает \n";
echo "использовать его. Однако, если вы хотите удалить индекс, вы должны знать его \n";
echo "имя.</p>\n";
echo "<p>Синтаксис  для удаления индекса:</p>\n";
echo "<pre>              DROP INDEX index name;</pre>\n";
echo "<p>Удаление индекса не влияет на содержимое полей.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.5\">И</a>ЗМЕНЕНИЕ ТАБЛИЦЫ, ПОСЛЕ ТОГО КАК ОНА БЫЛА СОЗДАНА</h3>\n";
echo "<p>Команда ALTER TABLE не является частью стандарта ANSI, но это широко \n";
echo "распространённая и \n";
echo "довольно содержательная форма, хотя её возможности несколько ограничены. Она \n";
echo "используется для того, чтобы изменить определение существующей таблицы. Обычно \n";
echo "она добавляет столбцы к таблице. Иногда она может удалять столбцы или изменять \n";
echo "их размеры, а также, в некоторых программах, добавлять или удалять ограничения \n";
echo "(рассмотренные в <a href=\"ch18.php\">Главе 18</a>). Типичный синтаксис добавления столбца к таблице:</p>\n";
echo "<pre> ALTER TABLE</pre>\n";
echo "<pre> ADD &lt;column name&gt; &lt;data type&gt; &lt;size&gt;;</pre>\n";
echo "<p>Столбец будет добавлен со значениями NULL для всех строк таблицы. Новый \n";
echo "столбец станет последним по порядку столбцом таблицы. Вообще-то можно добавить \n";
echo "сразу несколько новых столбцов, отделив их запятыми, в одной команде. Имеется \n";
echo "возможность удалять или изменять столбцы. Наиболее частым изменением столбца \n";
echo "может быть просто увеличение его размера или добавление (удаление) ограничения.</p>\n";
echo "<p>Ваша система должна убедиться, что любые изменения не противоречат \n";
echo "существующим данным: например, при попытке добавить ограничение к столбцу, \n";
echo "который уже имел значение, при нарушении которого ограничение будет отклонено. \n";
echo "Лучше всего дважды проверить это. Как минимум - посмотрите документацию вашей \n";
echo "системы чтобы убедиться, гарантирует ли она, что именно это было причиной. Из-за \n";
echo "нестандартного характера команды ALTER TABLE вам всё равно необходимо \n";
echo "посмотреть тот раздел вашей системной документации, где говорится об особых \n";
echo "случаях.</p>\n";
echo "<p>ALTER TABLE не действует, когда таблица должна быть переопределена, но вы \n";
echo "должны разрабатывать вашу БД по возможности так, чтобы не слишком ей в этом \n";
echo "доверяться. Изменять структуры таблицы, когда она уже в использовании, опасно! \n";
echo "Просмотрите внимательно таблицы, которые, являясь вторичными таблицами с \n";
echo "извлеченными данными из другой таблицы (см. <a href=\"ch20.php\">Главу 20</a>), \n";
echo "не долго будут работать правильно, а программы, использующие вложенный SQL (<a href=\"ch25.php\">Глава \n";
echo "25</a>), начнут работать неправильно или не всегда правильно. Кроме того, изменение \n";
echo "может стереть всех пользователей, имеющих разрешение на обращение к таблице.</p>\n";
echo "<p>По этим причинам вы должны разрабатывать ваши таблицы так, чтобы использовать \n";
echo "ALTER TABLE только в крайнем случае. Если ваша система не поддерживает ALTER \n";
echo "TABLE, или если вы хотите избежать её использования, вы можете просто создать \n";
echo "новую таблицу, с необходимыми изменениями при создании, и использовать команду \n";
echo "INSERT с SELECT * запросом чтобы переписать в нее данные из старой таблицы. \n";
echo "Пользователям, которым был предоставлен доступ к старой таблице (см.\n";
echo "<a href=\"ch22.php\">Главу 22</a>), должен быть предоставлен доступ к новой \n";
echo "таблице.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.6\">У</a>ДАЛЕНИЕ ТАБЛИЦЫ</h3>\n";
echo "<p>Вы должны быть владельцем (т.е. создателем) таблицы, чтобы иметь возможность \n";
echo "удалить её. Поэтому не беспокойтесь о случайном разрушении ваших данных, SQL \n";
echo "сначала потребует, чтобы вы очистили таблицу прежде чем удалить её из БД. Таблица \n";
echo "с находящимися в ней строками не может быть удалена. Обратитесь к\n";
echo "<a href=\"ch15.php\">Главе 15</a> за подробностями относительно того, как удалять \n";
echo "строки из таблицы.</p>\n";
echo "<p>Синтаксис для удаления вашей таблицы, если конечно она \n";
echo "является пустой, следующий:</p>\n";
echo "<pre>          DROP TABLE &lt;table name&gt;;</pre>\n";
echo "<p>При подаче этой команды имя таблицы больше не распознаётся, и нет такой \n";
echo "команды, которая могла бы быть дана этому объекту. Вы должны убедиться, что эта \n";
echo "таблица не ссылается внешним ключом к другой таблице (внешние ключи обсуждаются \n";
echo "в <a href=\"ch19.php\">Главе 19</a>) и что она не используется в определении \n";
echo "представления (<a href=\"ch20.php\">Глава 20</a>). Эта команда фактически не \n";
echo "является частью стандарта ANSI, но она поддерживается и полезна. К счастью, она \n";
echo "более проста и, следовательно, более непротиворечива, чем ALTER TABLE. ANSI \n";
echo "просто не имеет способа для определения разрушенных или неправильных таблиц.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.7\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы уже бегло ориентируетесь в основах определений данных. Вы можете \n";
echo "создавать, изменять и удалять таблицы. В то время как только первая из этих \n";
echo "функций - часть официального стандарта SQL, другие будут время от времени \n";
echo "меняться, особенно ALTER TABLE.</p>\n";
echo "<p>DROP TABLE позволяет вам избавиться от ненужных таблиц. Она уничтожает только \n";
echo "пустые таблицы и, следовательно, не разрушает данные.</p>\n";
echo "<p>Вы теперь знаете об \n";
echo "индексах, а также, как их создавать и удалять. SQL не даёт вам большого контроля \n";
echo "над ними, так как реализация, которую вы используете, сама определяет, \n";
echo "как быстро выполняются различные команды. Индексы это один из инструментов, \n";
echo "дающий вам возможность воздействовать непосредственно на эффективность ваших \n";
echo "команд в SQL. Мы рассмотрели индексы здесь, чтобы отличать их от ограничений, с \n";
echo "которыми их нельзя путать. Ограничения это тема <a href=\"ch18.php\">Главы 18</a> \n";
echo "и <a href=\"ch19.php\">Главы 19</a>.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"17.8\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Напишите предложение CREATE TABLE, которое вывело бы нашу таблицу Заказчиков.\n";
echo "\n";
echo "2. Напишите команду, которая давала бы возможность пользователю\n";
echo "   быстро извлекать заказы, сгруппированные по датам, из таблицы Заказов.\n";
echo "\n";
echo "3. Если таблица Заказов уже создана, как вы можете заставить поле\n";
echo "   onum быть уникальным (если допустить что все текущие значения уникальны)?\n";
echo "\n";
echo "4. Создайте индекс, который разрешал бы каждому продавцу быстро\n";
echo "   отыскивать его заказы, сгруппированные по датам.\n";
echo "\n";
echo "5. Предположим, что каждый продавец имеет только одного заказчика \n";
echo "   с данной оценкой. Введите команду, которая его извлечет.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#17\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
