﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 19.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 19. ПОДДЕРЖКА ЦЕЛОСТНОСТИ ВАШИХ ДАННЫХ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>Ранее в этой книге мы указывали на определённые связи, которые существуют \n";
echo "между некоторыми полями типовых таблиц. Поле snum таблицы Заказчиков, например, \n";
echo "соответствует полю snum в таблице Продавцов и таблице Заказов. Поле cnum таблицы \n";
echo "Заказчиков также соответствует полю cnum таблицы Заказов. Мы назвали этот тип \n";
echo "связи справочной целостностью, и в ходе обсуждения вы видели, как её можно \n";
echo "использовать.</p>\n";
echo "<p>В этой главе мы будем исследовать справочную целостность более подробно и \n";
echo "выясним всё относительно ограничений, которые вы можете использовать, чтобы её \n";
echo "поддерживать. Вы также увидите, как предписывается это ограничение, когда вы \n";
echo "используете команды модификации DML.</p>\n";
echo "<p>Поскольку справочная целостность включает в себя связь полей или групп полей, \n";
echo "часто в разных таблицах, это действие может быть несколько сложнее, чем другие \n";
echo "ограничения. По этой причине хорошо иметь с ней полное знакомство, даже если вы \n";
echo "не планируете создавать таблицы.</p>\n";
echo "<p>Ваши команды модификации могут стать \n";
echo "эффективнее с помощью ограничения справочной целостности (как и с помощью других \n";
echo "ограничений, но ограничение справочной целостности может воздействовать на \n";
echo "другие таблицы помимо тех, в которых оно определено), а определённые функции \n";
echo "запроса, такие как объединения, являются многократно структурированными, в терминах \n";
echo "связей справочной целостности (как подчеркивалось в <a href=\"ch8.php\">Главе 8</a>).</p>\n";
echo "<h3><a name=\"19.1\">В</a>НЕШНИЙ КЛЮЧ И РОДИТЕЛЬСКИЙ КЛЮЧ</h3>\n";
echo "<p>Когда все значения в  поле одной таблицы представлены в поле другой таблицы, \n";
echo "мы говорим, что первое поле ссылается на второе. Это указывает на прямую связь \n";
echo "между значениями двух полей. Например, каждый из заказчиков в таблице Заказчиков \n";
echo "имеет поле snum, которое указывает на продавца, назначенного в таблице \n";
echo "Продавцов. Для каждого заказа в таблице Заказов имеется один, и только этот, \n";
echo "продавец и один, и только этот, заказчик. Это отображается с помощью полей snum и cnum в таблице Заказов.</p>\n";
echo "<p>Когда одно поле в таблице ссылается на другое, оно называется внешним ключом, \n";
echo "а поле, на которое оно ссылается, называется родительским ключом. Так что поле \n";
echo "snum таблицы Заказчиков это внешний ключ, а поле snum, на которое оно ссылается \n";
echo "в таблице Продавцов, это родительский ключ.</p>\n";
echo "<p>Аналогично, поля cnum и snum таблицы Заказов это внешние ключи, которые \n";
echo "ссылаются на их родительские ключи с именами в таблице Заказчиков и в таблице \n";
echo "Продавцов. Имена внешнего ключа и родительского ключа не обязательно должны быть \n";
echo "одинаковыми, это только соглашение, которому мы следуем, чтобы сделать соединение более понятным.</p>\n";
echo "<h3><a name=\"19.2\">М</a>НОГОСТОЛБЦОВЫЕ ВНЕШНИЕ КЛЮЧИ</h3>\n";
echo "<p>В реальности внешний ключ не обязательно состоит только из одного поля. \n";
echo "Подобно первичному ключу, внешний ключ может иметь любое число полей, которые \n";
echo "все обрабатываются как единый модуль. Внешний ключ и родительский ключ, на \n";
echo "который он ссылается, конечно же, должны иметь одинаковый номер и тип поля и \n";
echo "находиться в одинаковом заказе. Внешние ключи, состоящие из одного поля, - те, \n";
echo "что мы использовали  в наших типовых таблицах, - наиболее распространённые.</p>\n";
echo "<p>Чтобы сохранить простоту нашего обсуждения, мы будем часто говорить о внешнем \n";
echo "ключе как об одиночном столбце. Это не случайно. Если это не отметить, любой \n";
echo "скажет о поле, которое является внешним ключом, что это также относится и к \n";
echo "группе полей, которые являются внешними ключами.</p>\n";
echo "<h3><a name=\"19.3\">С</a>МЫСЛ ВНЕШНЕГО И РОДИТЕЛЬСКОГО КЛЮЧЕЙ</h3>\n";
echo "<p>Когда поле является внешним ключом, оно определённым образом связано с \n";
echo "таблицей, на которую оно ссылается. Вы фактически говорите: &quot;каждое значение в \n";
echo "этом поле (внешнем ключе) непосредственно привязано к значению в другом поле \n";
echo "(родительском ключе).&quot;&nbsp; Каждое значение (каждая строка) внешнего ключа должно \n";
echo "недвусмысленно ссылаться на одно, и только это, значение (строку) родительского \n";
echo "ключа. Если это так, то  ваша система, как говорится, будет в состоянии справочной целостности.</p>\n";
echo "<p>Вы можете увидеть это на примере. Внешний ключ snum в таблице Заказчиков \n";
echo "имеет значение 1001 для строк Hoffman и Clemens.</p>\n";
echo "<p>Предположим, что мы имели две строки в таблице Продавцов со значением в поле \n";
echo "snum = 1001. Как мы узнаем, к которому из двух продавцов были назначены \n";
echo "заказчики Hoffman и Clemens? Аналогично, если нет никаких таких строк в таблице \n";
echo "Продавцов, мы получим Hoffman и Clemens, назначенными к продавцу, которого нет!</p>\n";
echo "<p>Понятно, что каждое значение во внешнем ключе должно быть представлено один, \n";
echo "и только один, раз в родительском ключе.</p>\n";
echo "<p>Фактически данное значение внешнего ключа может ссылаться только к одному \n";
echo "значению родительского ключа, не предполагая обратной возможности: т.е. любое \n";
echo "число внешних ключей может ссылаться на единственное значение родительского \n";
echo "ключа. Вы можете увидеть это в типовых таблицах наших примеров. И Hoffman, и \n";
echo "Clemens назначены к Peel, так что оба их значения внешнего ключа совпадают с \n";
echo "одним и тем же родительским ключом, что очень хорошо. Значение внешнего ключа \n";
echo "должно ссылаться только на одно значение родительского ключа, зато на одно значение \n";
echo "родительского ключа может ссылаться с помощью любого количества значений внешнего ключа.</p>\n";
echo "<h3><a name=\"19.4\">О</a>ГРАНИЧЕНИЕ ВНЕШНЕГО КЛЮЧА/FOREIGN KEY</h3>\n";
echo "<p>SQL поддерживает справочную целостность с ограничением FOREIGN KEY. Хотя \n";
echo "ограничение FOREIGN KEY это новая особенность в SQL, оно ещё не обеспечивает его \n";
echo "универсальности. Кроме того, некоторые его реализации более сложны, чем другие. \n";
echo "Эта функция должна ограничивать значения, которые вы можете ввести в вашу БД, \n";
echo "чтобы заставить внешний ключ и родительский ключ соответствовать принципу \n";
echo "справочной целостности.</p>\n";
echo "<p>Одно из действий ограничения Внешнего Ключа - \n";
echo "отбрасывание значений для полей, ограниченных как внешний ключ, который ещё не \n";
echo "представлен в родительском ключе. Это ограничение также воздействует на вашу \n";
echo "способность изменять или удалять значения родительского ключа (мы будем \n";
echo "обсуждать это позже в этой главе).</p>\n";
echo "<h3><a name=\"19.5\">К</a>АК МОЖНО ПРЕДСТАВИТЬ ПОЛЯ В КАЧЕСТВЕ ВНЕШНИХ КЛЮЧЕЙ</h3>\n";
echo "<p>Вы используете ограничение FOREIGN KEY в команде CREATE TABLE (или ALTER \n";
echo "TABLE), содержащей поле, которое вы хотите объявить внешним ключом. Вы даёте имя \n";
echo "родительскому, ключу на которое вы будете ссылаться внутри ограничения FOREIGN \n";
echo "KEY. Помещение этого ограничения в команду - такое же, что и для других \n";
echo "ограничений, обсуждённых в <a href=\"ch20.php\">предыдущей главе</a>.</p>\n";
echo "<p>Подобно большинству ограничений, оно может быть ограничением таблицы или \n";
echo "столбца, в форме таблицы, позволяющей использовать многочисленные поля как один внешний ключ.</p>\n";
echo "<h3><a name=\"19.6\">В</a>НЕШНИЙ КЛЮЧ КАК ОГРАНИЧЕНИЕ ТАБЛИЦЫ</h3>\n";
echo "<p>Синтаксис ограничения таблицы FOREIGN KEY:</p>\n";
echo "<pre>	FOREIGN KEY &lt;column list&gt; REFERENCES &lt;pktable&gt; [&lt;column list&gt;]</pre>\n";
echo "<p>Первый список столбцов это список из одного или более столбцов таблицы, \n";
echo "которые разделены запятыми и будут созданы или изменены этой командой.<br>\n";
echo "Pktable \n";
echo "это таблица, содержащая родительский ключ. Она может быть таблицей, которая \n";
echo "создаётся или изменяется текущей командой.<br>\n";
echo "Второй список столбцов это список \n";
echo "столбцов, которые будут составлять родительский ключ.</p>\n";
echo "<p>Списки двух столбцов должны быть совместимы, т.е.:</p>\n";
echo "<p>* Они должны иметь одинаковое число столбцов.</p>\n";
echo "<p>* В данной последовательности первый, второй, третий, и т.д. столбцы списка \n";
echo "столбцов внешнего ключа должны иметь те же типы данных и размеры, что и первый, \n";
echo "второй, третий, и т.д. столбцы списка столбцов родительского ключа. Столбцы в \n";
echo "списках обоих столбцов не должны иметь одинаковых имён, хотя мы и использовали \n";
echo "такой способ в наших примерах чтобы сделать связь более понятной.</p>\n";
echo "<p>Создадим таблицу Заказчиков с полем snum, определённым в качестве внешнего \n";
echo "ключа, ссылающегося на таблицу Продавцов:</p>\n";
echo "<pre>            CREATE TABLE Customers\n";
echo "            (cnum    integer NOT NULL PRIMARY KEY\n";
echo "              cname  char(10),\n";
echo "              city   char(10),\n";
echo "              snum   integer,\n";
echo "             FOREIGN KEY (snum) REFERENCES Salespeople (snum);</pre>\n";
echo "<p>Имейте в виду, что, при использовании ALTER TABLE вместо CREATE TABLE для \n";
echo "применения ограничения FOREIGN KEY, значения, которые вы указываете во внешнем \n";
echo "ключе и родительском ключе, должны быть в состоянии справочной целостности. \n";
echo "Иначе команда будет отклонена. Хотя ALTER TABLE очень полезна из-за её удобства, \n";
echo "вы должны будете в вашей системе, по возможности, каждый раз сначала формировать \n";
echo "структурные принципы, типа справочной целостности.</p>\n";
echo "<h3><a name=\"19.7\">В</a>НЕШНИЙ КЛЮЧ КАК ОГРАНИЧЕНИЕ СТОЛБЦОВ</h3>\n";
echo "<p>Вариант ограничения столбца ограничением FOREIGN KEY по-другому называется \n";
echo "ссылочное ограничение (REFERENCES), так как оно фактически не содержит в себе \n";
echo "слов FOREIGN KEY, а просто использует слово REFERENCES и далее имя родительского \n";
echo "ключа, как здесь:</p>\n";
echo "<pre>         CREATE TABLE Customers\n";
echo "          (cnum    integer NOT NULL PRIMARY KEY,\n";
echo "            cname  char(10),\n";
echo "            city   char(10),\n";
echo "            snum   integer REFERENCES Salespeople (snum));</pre>\n";
echo "<p>Поле Customers.snum определяется как внешний ключ, у которого родительский \n";
echo "ключ - Salespeople.snum. Это эквивалентно такому ограничению таблицы:</p>\n";
echo "<pre>    FOREIGN KEY (snum) REGERENCES Salespeople (snum)</pre>\n";
echo "<h3><a name=\"19.8\">Н</a>Е УКАЗЫВАТЬ СПИСОК СТОЛБЦОВ ПЕРВИЧНЫХ КЛЮЧЕЙ</h3>\n";
echo "<p>Используя ограничение FOREIGN KEY таблицы или столбца, вы можете не указывать \n";
echo "список столбцов родительского ключа, если родительский ключ имеет ограничение \n";
echo "PRIMARY KEY. Естественно, в случае ключей со многими полями, порядок столбцов \n";
echo "во внешних и первичных ключах должен совпадать, и, в любом случае, принцип \n";
echo "совместимости между двум ключами всё ещё применим. Например, если мы поместили \n";
echo "ограничение PRIMARY KEY в поле snum таблицы Продавцов, мы могли бы использовать \n";
echo "его как внешний ключ в таблице Заказчиков (подобно предыдущему примеру) в этой \n";
echo "команде:</p>\n";
echo "<pre>         CREATE TABLE Customers\n";
echo "          (cnum    integer NOT NULL PRIMARY KEY,\n";
echo "            cname  char(10),\n";
echo "            city   char(10),\n";
echo "            snum   integer REFERENCES Salespeople);</pre>\n";
echo "<p>Это средство встраивалось в язык, чтобы поощрять вас использовать первичные \n";
echo "ключи в качестве родительских ключей.</p>\n";
echo "<h3><a name=\"19.9\">К</a>АК СПРАВОЧНАЯ ЦЕЛОСТНОСТЬ ОГРАНИЧИВАЕТ ЗНАЧЕНИЯ РОДИТЕЛЬСКОГО КЛЮЧА?</h3>\n";
echo "<p>Поддержание справочной целостности требует некоторых ограничений на значения, \n";
echo "которые могут быть представлены в полях, объявленных как внешний ключ и \n";
echo "родительский ключ. Родительский ключ должен быть структурирован, чтобы \n";
echo "гарантировать, что каждое значение внешнего ключа будет соответствовать одной \n";
echo "указанной строке. Это означает, что он (ключ) должен быть уникальным и не должен \n";
echo "содержать никаких пустых значений (NULL). Этого недостаточно для родительского \n";
echo "ключа в случае выполнения такого требования, как при объявлении внешнего ключа. \n";
echo "SQL должен быть уверен, что двойные значения или пустые значения (NULL) не были \n";
echo "введены в родительский ключ. Следовательно, вы должны убедиться, что все поля, \n";
echo "которые используются как родительские ключи, имеют или ограничение PRIMARY KEY, \n";
echo "или ограничение UNIQUE, наподобие ограничения NOT NULL.</p>\n";
echo "<h3><a name=\"19.10\">П</a>ЕРВИЧНЫЙ КЛЮЧ КАК УНИКАЛЬНЫЙ ВНЕШНИЙ КЛЮЧ</h3>\n";
echo "<p>Ссылка ваших внешних ключей только на первичные ключи, как мы это делали в \n";
echo "типовых таблицах, - хорошая стратегия. Когда вы используете внешние ключи, вы \n";
echo "связываете их не просто с родительскими ключами, на которые они ссылаются; вы \n";
echo "связываете их с определённой строкой таблицы, где этот родительский ключ будет \n";
echo "найден. Сам по себе родительский ключ не обеспечивает никакой информации, \n";
echo "которая не была бы уже представлена во внешнем ключе. Смысл, например, поля snum \n";
echo "как внешнего ключа в таблице Заказчиков - это связь, которую оно обеспечивает, \n";
echo "но не \n";
echo "со значением поля snum, на которое он ссылается, а с другой информацией в \n";
echo "таблице Продавцов. Такой, например, как имена продавцов, их местоположение и так \n";
echo "далее. Внешний ключ это не просто связь между двум идентичными значениями; это \n";
echo "связь - с помощью этих двух значений - между двум строками таблицы, указанной в \n";
echo "запросе.</p>\n";
echo "<p>Это поле snum может использоваться, чтобы связывать любую информацию в строке \n";
echo "из таблицы Заказчиков со ссылочной строкой из таблицы Продавцов, например, чтобы \n";
echo "узнать, живут ли они в том же самом городе, кто имеет более длинное имя, имеет \n";
echo "ли продавец кроме данного заказчика каких-то других заказчиков, и так далее.</p>\n";
echo "<p>Так как цель первичного ключа состоит в том, чтобы идентифицировать \n";
echo "уникальность строки, это более логичный и менее неоднозначный выбор для внешнего \n";
echo "ключа. Для любого внешнего ключа, который использует уникальный ключ как \n";
echo "родительский ключ, вы должны создать внешний ключ, который  использовал \n";
echo "бы первичный ключ той же самой таблицы для того же самого действия.<br>\n";
echo "Внешний ключ, \n";
echo "который не имеет никакой другой цели, кроме связывания строк, напоминает \n";
echo "первичный ключ, используемый исключительно для идентификации строк, и является \n";
echo "хорошим средством сохранить структуру вашей БД ясной и простой и, следовательно, \n";
echo "создающей меньше трудностей.</p>\n";
echo "<h3><a name=\"19.11\">О</a>ГРАНИЧЕНИЯ ВНЕШНЕГО КЛЮЧА</h3>\n";
echo "<p>Внешний ключ, в частности, может содержать только те значения, которые \n";
echo "фактически представлены в родительском ключе, или пустые (NULL). Попытка ввести \n";
echo "другие значения в этот ключ будет отклонена.</p>\n";
echo "<p>Вы можете объявить внешний ключ как NOT NULL, но это не обязательно и, в \n";
echo "большинстве случаев, нежелательно. Например, предположим, что вы вводите \n";
echo "заказчика, не зная заранее, к какому продавцу он будет назначен. Лучший выход в \n";
echo "этой ситуации - использовать значение NOT NULL, которое должно быть изменено \n";
echo "позже на конкретное значение.</p>\n";
echo "<h3><a name=\"19.12\">Ч</a>ТО СЛУЧИТСЯ, ЕСЛИ ВЫ ВЫПОЛНИТЕ КОМАНДУ МОДИФИКАЦИИ?</h3>\n";
echo "<p>Давайте условимся, что все внешние ключи созданные в наших таблицах примеров, \n";
echo "объявлены и предписаны с ограничениями внешнего ключа следующим образом:</p>\n";
echo "<pre>       CREATE TABLE Salespeople\n";
echo "         (snum  integer NOT NULL PRIMARY KEY,\n";
echo "          sname char(10) NOT NULL,\n";
echo "          city  char(10),\n";
echo "          comm  decimal);\n";
echo "\n";
echo "       CREATE TABLE Customers\n";
echo "         (cnum   integer NOT NULL PRIMARY KEY,\n";
echo "          cname  char(10) NOT NULL,\n";
echo "          city   char(10),\n";
echo "          rating integer,\n";
echo "          snum   integer,\n";
echo "          FOREIGN KEY (snum) REFERENCES Salespeople,\n";
echo "          UNIQUE (cnum, snum) ;\n";
echo "\n";
echo "      CREATE TABLE Orders\n";
echo "        (cnum  integer NOT NULL PRIMARY KEY,\n";
echo "         amt   decimal,\n";
echo "         odate date NOT NULL,\n";
echo "         cnum  integer NOT NULL\n";
echo "         snum  integer NOT NULL\n";
echo "         FOREIGN KEY (cnum, snum) REFERENCES\n";
echo "         CUSTOMERS (cnum, snum);</pre>\n";
echo "<h3><a name=\"19.13\">ОПИСАНИЕ</a> ОГРАНИЧЕНИЙ ТАБЛИЦЫ</h3>\n";
echo "<p>Имеется несколько атрибутов таких определений, о которых нужно поговорить. \n";
echo "Причина, по которой мы решили сделать поля cnum и snum в таблице Заказов единым \n";
echo "внешним ключом, это гарантия того, что для каждого заказчика, содержащегося в \n";
echo "заказах, продавец, кредитующий этот заказ - тот же, что и указанный в таблице \n";
echo "Заказчиков.<br>\n";
echo "Чтобы создать такой внешний ключ, мы должны были бы поместить \n";
echo "ограничение таблицы UNIQUE в два поля таблицы Заказчиков, даже если оно \n";
echo "необязательно для самой этой таблицы. Пока поле cnum в этой таблица имеет \n";
echo "ограничение PRIMARY KEY, оно будет уникально в любом случае, и, следовательно, \n";
echo "невозможно получить ещё одну комбинацию поля cnum с каким-то другим полем.</p>\n";
echo "<p>Создание внешнего ключа таким способом поддерживает целостность БД (даже если \n";
echo "при этом вам будет запрещено внутреннее прерывание по ошибке) и кредитование \n";
echo "любого продавца, отличного от того, который назначен именно этому заказчику.</p>\n";
echo "<p>С точки зрения поддержания целостности БД, внутренние прерывания (или \n";
echo "исключения), конечно же, нежелательны. Если вы их допускаете и, в то же время, \n";
echo "хотите поддерживать целостность вашей БД, вы можете объявить поля snum и cnum в \n";
echo "таблице Заказов независимыми внешними ключами этих полей в таблице Продавцов и \n";
echo "таблице Заказчиков, соответственно.</p>\n";
echo "<p>Фактически не обязательно использовать поля snum в таблице Заказов, как  это делали \n";
echo "мы, \n";
echo " \n";
echo "хотя это полезно было сделать для разнообразия. Поле cnum, \n";
echo "связывая каждый заказ заказчиков в таблице Заказчиков и в таблице Заказов, \n";
echo "должно всегда быть общим, чтобы находить правильное поле snum для данного заказа \n";
echo "(не разрешая никаких исключений). Это означает, что мы записываем фрагмент \n";
echo "информации - какой заказчик назначен к какому продавцу - дважды, и нужно будет \n";
echo "выполнять дополнительную работу чтобы удостовериться, что обе версии \n";
echo "согласуются.</p>\n";
echo "<p>Если мы не имеем ограничения внешнего ключа, как сказано выше, эта ситуация \n";
echo "будет особенно проблематична, потому что каждый порядок нужно будет проверять \n";
echo "вручную (вместе с запросом), чтобы удостовериться, что именно соответствующий \n";
echo "продавец кредитовал каждую соответствующую продажу. Наличие такого типа \n";
echo "информационной избыточности в вашей БД называется деморализация \n";
echo "(denormalization), что нежелательно в идеальной реляционной базе данных, хотя \n";
echo "практически и может быть разрешено. Деморализация может заставить некоторые \n";
echo "запросы выполняться быстрее, поскольку запрос в одной таблице выполняется всегда \n";
echo "значительно быстрее, чем в объединении.</p>\n";
echo "<h3><a name=\"19.14\">Д</a>ЕЙСТВИЕ ОГРАНИЧЕНИЙ</h3>\n";
echo "<p>Как ограничения воздействуют на возможность и невозможность использования \n";
echo "команды модификации DML? Для полей, определённых как внешние ключи, ответ \n";
echo "довольно простой: любые значения, которые вы помещаете в эти поля командой INSERT или UPDATE, должны уже быть представлены в их родительских ключах. Вы \n";
echo "можете помещать пустые (NULL) значения&nbsp; в эти поля, несмотря на то что значения \n";
echo "NULL непозволительны в родительских ключах, если они имеют ограничение NOT \n";
echo "NULL. Вы можете удалять (DELETE) любые строки с внешними ключами, не используя \n";
echo "родительские ключи вообще.</p>\n";
echo "<p>Поскольку затронут вопрос об изменении значений родительского ключа, ответ, \n";
echo "по определению ANSI, ещё проще, но, возможно, несколько более ограничен: любое \n";
echo "значение родительского ключа, на который ссылаются с помощью значения внешнего \n";
echo "ключа, не может быть удалено или изменено. Это означает, например, что вы не \n";
echo "можете удалить заказчика из таблицы Заказчиков, пока он ещё имеет заказы в \n";
echo "таблице Заказов. В зависимости от того, как вы используете эти таблицы, это \n";
echo "может быть или желательно, или хлопотно. Однако это, конечно, лучше, чем иметь \n";
echo "систему, которая позволит вам удалить заказчика с текущими заказами и оставить \n";
echo "таблицу Заказов ссылающейся на несуществующих заказчиков. Смысл этой системы \n";
echo "ограничения в том, что создатель таблицы Заказов, используя таблицу Заказчиков и \n";
echo "таблицу Продавцов как родительские ключи, может наложить значительные \n";
echo "ограничения на действия в этих таблицах. По этой причине вы не сможете \n";
echo "использовать таблицу которой вы не распоряжаетесь (т.е. не вы её создавали и не \n";
echo "вы являетесь её владельцем), пока владелец (создатель) этой таблицы специально не \n";
echo "передаст вам на это право (что объясняется в <a href=\"ch22.php\">Главе 22</a>).</p>\n";
echo "<p>Имеются некоторые другие возможные действия изменения родительского ключа, \n";
echo "которые не являются частью ANSI, но могут быть найдены в некоторых коммерческих \n";
echo "программах. Если вы хотите изменить или удалить текущее ссылочное значение \n";
echo "родительского ключа, имеются три возможности:</p>\n";
echo "<p>*&nbsp;&nbsp;&nbsp; Вы можете ограничить или запретить изменение (способом ANSI), обозначив, \n";
echo "что изменения в родительском ключе ограничены.</p>\n";
echo "<p>*&nbsp;&nbsp;&nbsp; Вы можете сделать изменение в родительском ключе и тем самым сделать \n";
echo "изменения во внешнем ключе автоматическим, что называется каскадным изменением.</p>\n";
echo "<p>*&nbsp;&nbsp;&nbsp; Вы можете сделать изменение в родительском ключе и установить внешний \n";
echo "ключ в NULL автоматически (полагая, что NULL разрешены во внешнем ключе), что \n";
echo "называется пустым изменением внешнего ключа.</p>\n";
echo "<p>Даже в пределах этих трёх категорий вы можете не захотеть обрабатывать все \n";
echo "команды модификации таким способом. INSERT, конечно, к делу не относится. Она \n";
echo "помещает новые значения родительского ключа в таблицу, так что ни одно из этих \n";
echo "значений не может быть вызвано в данный момент. Однако вы можете захотеть \n";
echo "позволить модификациям быть каскадными, но без удалений, и наоборот.<br>\n";
echo "Лучшей \n";
echo "может быть ситуация, которая позволит вам определять любую из трёх категорий, \n";
echo "независимо от команд UPDATE и DELETE. Мы будем, следовательно, ссылаться на \n";
echo "эффекты модификации (update effects) и эффекты удаления (delete effects), \n";
echo "которые определяют, что случится, если вы выполните команды UPDATE или DELETE в \n";
echo "родительском ключе. Эти эффекты, о которых мы говорили, называются: Ограниченные \n";
echo "(RESTRICTED) изменения, Каскадируемые (CASCADES) изменения и Пустые (NULL) изменения.</p>\n";
echo "<p>Фактические возможности вашей системы должны строго соответствовать стандарту \n";
echo "ANSI - это эффекты модификации и удаления, оба автоматически ограниченные - для \n";
echo "более идеальной ситуации, описанной выше. В качестве иллюстрации мы покажем \n";
echo "несколько примеров того, что вы можете делать с полным набором эффектов \n";
echo "модификации и удаления. Конечно, эффекты модификации и удаления, являющиеся \n";
echo "нестандартными средствами, испытывают недостаток в стандартном синтаксисе. \n";
echo "Синтаксис, который мы используем здесь, прост в написании и будет служить в \n";
echo "дальнейшем для иллюстрации функций этих эффектов.</p>\n";
echo "<p>Для полноты эксперимента позволим себе предположить, что вы имеете причину \n";
echo "изменить поле snum&nbsp; таблицы Продавцов в случае, когда наша таблица Продавцов \n";
echo "изменяет разделы. (Обычно изменение первичных ключей это не то, что мы \n";
echo "рекомендуем делать практически. Просто это ещё один из доводов, чтобы иметь первичные ключи, которые не умеют делать ничего другого, кроме как действовать \n";
echo "как первичные ключи: они не должны изменяться.)<br>\n";
echo "Когда вы изменяете номер \n";
echo "продавца, вы хотите, чтобы были сохранены все его заказчики. Однако, если этот \n";
echo "продавец покидает свою фирму или компанию, вы можете не захотеть удалить его \n";
echo "заказчиков при удалении его самого из БД. Взамен вы захотите убедиться, что \n";
echo "заказчики назначены кому-нибудь ещё. Чтобы сделать это, вы должны указать UPDATE \n";
echo "с Каскадируемым эффектом, и DELETE с Ограниченным эффектом.</p>\n";
echo "<pre>          CREATE TABLE Customers\n";
echo "            (cnum integer NOT NULL PRIMARY KEY,\n";
echo "             cname char(10) NOT NULL,\n";
echo "             city  char(10),\n";
echo "             rating integer,\n";
echo "             snum   integer REFERENCES Salespeople,\n";
echo "             UPDATE OF Salespeople CASCADES,\n";
echo "             DELETE OF Salespeople RESTRICTED);</pre>\n";
echo "<p>Если вы теперь попробуете удалить Peel из таблицы Продавцов, команда будет \n";
echo "недопустима, пока вы не измените значение поля snum заказчиков Hoffman и Clemens \n";
echo "для другого назначенного продавца. С другой стороны, вы можете изменить значение \n";
echo "поля snum для Peel на 1009, и Hoffman и Clemens будут также автоматически изменены.</p>\n";
echo "<p>Третий эффект - Пустые (NULL) изменения. Бывает, что, когда продавцы \n";
echo "оставляют компанию, их текущие заказы не передаются другому продавцу. С другой \n";
echo "стороны, вы хотите отменить все заказы автоматически для заказчиков, чьи счета \n";
echo "вы удалите. Изменив номера продавца или заказчика, можно просто передать их ему. \n";
echo "Пример ниже показывает, как вы можете создать таблицу Заказов с использованием \n";
echo "этих эффектов.</p>\n";
echo "<pre>        CREATE TABLE Orders\n";
echo "           (onum integer NOT NULL PRIMARY KEY,\n";
echo "            amt decimal,\n";
echo "            odate date NOT NULL\n";
echo "            cnum integer NOT NULL REFERENCES Customers\n";
echo "            snum integer REFERENCES Salespeople,\n";
echo "            UPDATE OF Customers CASCADES,\n";
echo "            DELETE OF Customers CASCADES,\n";
echo "            UPDATE OF Salespeople CASCADES,\n";
echo "            DELETE OF Salespeople NULLS);</pre>\n";
echo "<p>Конечно, в команде DELETE с эффектом Пустого изменения в таблице Продавцов, \n";
echo "ограничение NOT NULL должно быть удалено из поля snum.</p>\n";
echo "<h3><a name=\"19.15\">В</a>НЕШНИЕ КЛЮЧИ, КОТОРЫЕ ССЫЛАЮТСЯ <br>\n";
echo "НА СВОИ ПОДЧИНЁННЫЕ ТАБЛИЦЫ</h3>\n";
echo "<p>Как было упомянуто ранее, ограничение FOREIGN KEY может представить имя это в \n";
echo "частной таблице, как таблице родительского ключа. Будучи далеко не простой, эта \n";
echo "особенность может пригодиться.</p>\n";
echo "<p>Предположим, что мы имеем таблицу Employees с \n";
echo "полем manager (администратор). Это поле содержит номера каждого из служащих, \n";
echo "некоторые из которых являются ещё и администраторами. Но, так как каждый \n";
echo "администратор одновременно является служащим, то он, естественно, будет также \n";
echo "представлен и в этой таблице.</p>\n";
echo "<p>Давайте создадим таблицу, где номер служащего (столбец с именем empno), \n";
echo "объявляется как первичный ключ, а администратор как внешний ключ будет ссылаться на нее:</p>\n";
echo "<pre>     CREATE TABLE Employees\n";
echo "        (empno   integer NOT NULL PRIMARY KEY,\n";
echo "         name    char(10) NOT NULL UNIOUE,\n";
echo "         manager integer REFERENCES Employees);</pre>\n";
echo "<p>(Так как внешний ключ это ссылаемый первичный ключ таблицы, список столбцов \n";
echo "может быть исключен.)</p>\n";
echo "<p>Имеется содержание этой таблицы:</p>\n";
echo "<pre>	EMPNO		NAME		MANAGER\n";
echo "	1003		Terrence	2007\n";
echo "	2007		Atali		NULL\n";
echo "	1688		McKenna		1003\n";
echo "	2002		Collier		2007</pre>\n";
echo "<p>Как вы видите, каждый из них (но не Atali) ссылается на другого служащего в \n";
echo "таблице как на своего администратора. Atali, имеющий наивысший номер в таблице, \n";
echo "должен иметь значение, установленное в NULL. Это дает другой принцип справочной \n";
echo "целостности. Внешний ключ, который ссылается обратно на частную таблицу, должен \n";
echo "позволять значения = NULL. Если это не так, то как бы вы могли вставить первую \n";
echo "строку? Даже если эта первая строка ссылается на саму себя, значение \n";
echo "родительского ключа должно уже быть установлено, когда вводится значение \n";
echo "внешнего ключа. Этот принцип будет верен, даже если внешний ключ ссылается \n";
echo "обратно к частной таблице не напрямую, а с помощью ссылки к другой таблице, \n";
echo "которая затем ссылается обратно к таблице внешнего ключа.</p>\n";
echo "<p>Например, предположим, \n";
echo "что наша таблица Продавцов имеет дополнительное поле, которое ссылается на \n";
echo "таблицу Заказчиков так, что каждая таблица ссылается на другую, как показано в \n";
echo "следующем операторе CREATE TABLE:</p>\n";
echo "<pre>         CREATE TABLE Salespeople\n";
echo "           (snum  integer NOT NULL PRIMARY KEY,\n";
echo "            sname char(10) NOT NULL,\n";
echo "            city  char(10),\n";
echo "            comm  declmal,\n";
echo "            cnum  integer REFERENCES Customers);\n";
echo "\n";
echo "        CREATE TABLE Customers\n";
echo "          (cnum   integer NOT NULL PRIMARY KEY,\n";
echo "           cname  char(10) NOT NULL,\n";
echo "           city     char(10),\n";
echo "           rating  integer,\n";
echo "           snum   integer REFERENCES Salespeople);</pre>\n";
echo "<p>Это называется перекрестной ссылкой. SQL поддерживает это теоретически, но \n";
echo "практически это может составить проблему. Любая таблица из этих двух, созданная \n";
echo "первой, является ссылочной таблицей, которая ещё не существует для другой. В \n";
echo "интересах обеспечения перекрестной ссылки, SQL фактически позволяет это, но \n";
echo "никакая таблица не будет пригодна для использования, пока они обе находятся в \n";
echo "процессе создания.<br>\n";
echo "С другой стороны, если эти две таблицы создаются различными \n";
echo "пользователями, проблема становится ещё более трудной. Перекрестна ссылка может \n";
echo "стать полезным инструментом, но она не без неоднозначности и опасностей. \n";
echo "Предшествующий пример не совсем пригоден для использования, потому что он \n";
echo "ограничивает продавца одиночным заказчиком, и, кроме того, совсем не обязательно \n";
echo "использовать перекрёстную ссылку, чтобы достичь этого.</p>\n";
echo "<p>Мы рекомендуем чтобы вы \n";
echo "были осторожны в его использовании и анализировали, как ваши программы управляют \n";
echo "эффектами модификации и удаления, а также процессами привилегий и диалоговой \n";
echo "обработки запросов, перед тем как вы создаёте перекрестную систему справочной \n";
echo "целостности. (Привилегии и диалоговая обработка запросов будут обсуждаться, \n";
echo "соответственно, в Главах<a href=\"ch22.php\"> 22</a> и<a href=\"ch23.php\"> 23</a>.)</p>\n";
echo "<h3><a name=\"19.16\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы имеете достаточно хорошее управление справочной целостностью. \n";
echo "Основная идея в том, что все значения внешнего ключа ссылаются на указанную \n";
echo "строку родительского ключа. Это означает, что каждое значение внешнего ключа \n";
echo "должно быть представлено один раз, и только один раз, в родительском ключе.</p>\n";
echo "<p>Всякий раз, когда значение помещается во внешний ключ, родительский ключ \n";
echo "проверяется, чтобы удостовериться, что его значение представлено; иначе команда \n";
echo "будет отклонена.</p>\n";
echo "<p>Родительский ключ должен иметь Первичный Ключ (PRIMARY KEY) или \n";
echo "Уникальное (UNIQUE) ограничение, гарантирующее, что значение не будет \n";
echo "представлено более чем один раз. Попытка изменить значение родительского ключа, \n";
echo "которое в настоящее время представлено во внешнем ключе, будет вообще отклонена. \n";
echo "Ваша система может, однако, предложить вам выбор, чтобы получить значение \n";
echo "внешнего ключа, установленного в NULL или для получения нового значения \n";
echo "родительского ключа и указания, какой из них может быть получен независимо для \n";
echo "команд UPDATE и DELETE.</p>\n";
echo "<p>Этим завершается наше обсуждение команды CREATE TABLE. Далее мы представим \n";
echo "вам другой тип команды CREATE. В <a href=\"ch20.php\">Главе 20</a> вы обучитесь \n";
echo "представлению объектов данных, которые выглядят и действуют подобно таблице, но \n";
echo "в действительности являются результатами запросов. Некоторые функции ограничений \n";
echo "могут также выполняться представлениями, так что вы сможете лучше оценить вашу \n";
echo "потребность в ограничениях, после того как вы прочитаете следующие три главы.</p>\n";
echo "<h3><a name=\"19.17\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Создайте таблицу с именем Cityorders. Она должна содержать такие же\n";
echo "   поля onum, amt и snum, что и таблица Заказов, и такие же поля\n";
echo "   cnum и city, что и таблица Заказчиков, так что заказ каждого\n";
echo "   заказчика будет вводиться в эту таблицу вместе с его городом.\n";
echo "   Поле оnum будет первичным ключом Cityorders. Все поля в Cityorders\n";
echo "   должны иметь ограничения при сравнении с таблицами Заказчиков и\n";
echo "   Заказов. Допускается, что родительские ключи в этих таблицах уже\n";
echo "   имеют соответствующие ограничения.\n";
echo "\n";
echo "2. Усложним проблему. Переопределите таблицу Заказов следующим\n";
echo "   образом: добавьте новый столбец с именем prev, который будет\n";
echo "   идентифицирован для каждого заказа, поле onum предыдущего\n";
echo "   заказа для этого текущего заказчика.\n";
echo "   Выполните это с использованием внешнего ключа, ссылающегося на\n";
echo "   саму таблицу Заказов.\n";
echo "   Внешний ключ должен ссылаться также на поле cnum заказчика,\n";
echo "   обеспечивающее определенную предписанную связь между текущим порядком и ссылаемым.\n";
echo "\n";
echo "(См. ответы в<a href=\"a.php#19\"> Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?> 
