﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 22.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 22. КТО И ЧТО МОЖЕТ ДЕЛАТЬ<br>\n";
echo "В БАЗЕ ДАННЫХ?</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе вы научитесь работать с привилегиями. Как сказано в\n";
echo "<a href=\"ch2.php\">Главе 2</a>, SQL используется обычно в средах, которые \n";
echo "требуют распознавания пользователей и различий между пользователями систем.</p>\n";
echo "<p>Вообще говоря, администраторы баз данных сами создают пользователей и дают им \n";
echo "привилегии.<br>\n";
echo "С другой стороны - пользователи, которые создают таблицы, сами имеют \n";
echo "права на управление этими таблицами. Привилегии это то, что определяет, может ли \n";
echo "указанный пользователь выполнить данную команду. Имеется несколько типов \n";
echo "привилегий, соответствующих нескольким типам операций. Привилегии даются и \n";
echo "отменяются двумя командами SQL: GRANT (ДОПУСК) и REVOKE (ОТМЕНА). Эта глава \n";
echo "покажет вам, как эти команды используются.</p>\n";
echo "<h3><a name=\"22.1\">П</a>ОЛЬЗОВАТЕЛИ</h3>\n";
echo "<p>Каждый пользователь в среде SQL имеет специальное идентификационное имя или \n";
echo "номер. Терминология везде разная, но мы выбрали (следуя ANSI) ссылку на имя или \n";
echo "номер как на Идентификатор (ID) доступа. Команда, посланная в базе данных, \n";
echo "ассоциируется с определённым пользователем; или иначе - специальным \n";
echo "Идентификатором доступа. Поскольку это относится к БД SQL, ID разрешения это имя \n";
echo "пользователя, и SQL может использовать специальное ключевое слово USER, которое \n";
echo "ссылается на Идентификатор доступа, связанный с текущей командой. Команда \n";
echo "интерпретируется и разрешается (или запрещается) на основе информации, связанной \n";
echo "с Идентификатором доступа пользователя, подавшего команду.</p>\n";
echo "<h3><a name=\"22.2\">Р</a>ЕГИСТРАЦИЯ</h3>\n";
echo "<p>В системах с многочисленными пользователями имеется некоторый вид процедуры \n";
echo "входа в систему, которую пользователь должен выполнить, чтобы получить доступ к \n";
echo "компьютерной системе. Эта процедура определяет, какой ID доступа будет связан с \n";
echo "текущим пользователем. Обычно каждый человек, использующий БД, должен иметь свой \n";
echo "собственный ID доступа и при регистрации превращается в действительного \n";
echo "пользователям. Однако часто пользователи, имеющие много задач, могут \n";
echo "регистрироваться под различными ID доступа, или наоборот - один ID доступа может \n";
echo "использоваться несколькими пользователями. С точки зрения SQL нет никакой \n";
echo "разницы между этими двум случаями; он воспринимает пользователя просто как его \n";
echo "ID доступа.</p>\n";
echo "<p>БД SQL может использовать собственную процедуру входа в систему или \n";
echo "она может позволить другой программе, вроде операционной системы (основная \n";
echo "программа которая работает на вашем компьютере), обрабатывать файл регистрации и \n";
echo "получать ID доступа из этой программы. Тем или другим способом, но SQL будет \n";
echo "иметь ID доступа, чтобы связать его с вашими действиями, а для вас будет иметь \n";
echo "значение ключевое слово USER.</p>\n";
echo "<h3><a name=\"22.3\">П</a>РЕДОСТАВЛЕНИЕ ПРИВИЛЕГИЙ</h3>\n";
echo "<p>Каждый пользователь БД SQL имеет набор привилегий. Это то, что пользователю \n";
echo "разрешается делать (возможно это - файл регистрации, который может \n";
echo "рассматриваться как минимальная привилегия). Эти привилегии могут изменяться со \n";
echo "временем: новые - добавляться, старые - удаляться. Некоторые из этих привилегий \n";
echo "определены в ANSI SQL, но имеются и дополнительные привилегии, которые  также \n";
echo "являются необходимыми.</p>\n";
echo "<p>SQL-привилегий, как определено ANSI, недостаточно в \n";
echo "большинстве ситуаций реальной жизни. С другой стороны, типы привилегий, которые \n";
echo "необходимы, могут видоизменяться, в зависимости от используемой системы, \n";
echo "относительно которой ANSI не может дать никаких рекомендаций. Привилегии, \n";
echo "которые не являются частью стандарта SQL, могут использовать похожий синтаксис, \n";
echo "не полностью совпадающий со стандартом.</p>\n";
echo "<h3><a name=\"22.4\">С</a>ТАНДАРТНЫЕ ПРИВИЛЕГИИ</h3>\n";
echo "<p>SQL-привилегии, определённые ANSI, это привилегии объекта. Это означает, что \n";
echo "пользователь имеет привилегию для выполнения данной команды только на \n";
echo "определенном объекте в БД. Очевидно, что привилегии должны различать эти \n";
echo "объекты, но система привилегий, основанная исключительно на привилегиях объекта, \n";
echo "не может адресовать всё, что нужно SQL, как мы увидим позже в этой главе.</p>\n";
echo "<p>Привилегии объекта связаны одновременно и с пользователями, и с таблицами. То \n";
echo "есть привилегия дается определенному пользователю в указанной таблице, базовой \n";
echo "таблице или представлении. Вы должны помнить, что пользователь, создавший \n";
echo "таблицу (любого вида), является владельцем этой таблицы.</p>\n";
echo "<p>Это означает, что пользователь имеет все привилегии в этой таблице и может \n";
echo "передавать привилегии другим пользователям  этой таблицы.</p>\n";
echo "<p>Вот привилегии, которые можно назначить пользователю:</p>\n";
echo "<pre>SELECT         Пользователь может выполнять запросы в таблице.\n";
echo "\n";
echo "INSERT         Пользователь может выполнять команду INSERT в таблице.\n";
echo "\n";
echo "UPDATE         Пользователь может выполнять команду UPDATE в таблице.\n";
echo "               Вы можете ограничить эту привилегию для определенных столбцов таблицы.\n";
echo "\n";
echo "DELETE	       Пользователь с этой привилегией может выполнять команду DELETE в таблице.\n";
echo "\n";
echo "REFERENCES     Пользователь определить внешний ключ, который использует один или более\n";
echo "               столбцов этой таблицы, как родительский ключ.\n";
echo "               Вы можете ограничить эту привилегию для определённых \n";
echo "	       столбцов. (Смотрите в <a href=\"ch19.php\">Главе 19</a> \n";
echo "	       подробности относительно внешнего ключа и родительского ключа.)</pre>\n";
echo "<p>Кроме того, вы столкнётесь с такими нестандартными привилегиями объектов, \n";
echo "как, например, INDEX (ИНДЕКС), дающей право создавать индекс в таблице, SYNONYM \n";
echo "(СИНОНИМ), дающей право создавать синоним для объекта, который будет объяснён в\n";
echo "<a href=\"ch23.php\">Главе 23</a>, и ALTER (ИЗМЕНИТЬ), дающей право выполнять \n";
echo "команду ALTER TABLE в таблице.</p>\n";
echo "<p>Механизм SQL назначает пользователям эти \n";
echo "привилегии с помощью команды GRANT.</p>\n";
echo "<h3><a name=\"22.5\">К</a>ОМАНДА GRANT</h3>\n";
echo "<p>Предположим, что пользователь Diane имеет таблицу Заказчиков и хочет \n";
echo "разрешить пользователю Adrian выполнить запрос к ней. Diane должна в этом случае \n";
echo "ввести следующую команду:</p>\n";
echo "<pre>GRANT INSERT ON Salespeople TO Diane;</pre>\n";
echo "<p>Теперь Adrian может выполнить запросы к таблице Заказчиков. Без этой привилегии он \n";
echo "может только выбирать значения, но не может выполнить любое действие, которые  влияло \n";
echo "бы на значения в таблице Заказчиков (включая использование таблицы \n";
echo "Заказчиков в качестве родительской таблицы внешнего ключа, что ограничивает \n";
echo "изменения, которые можно выполнять со значением в таблице Заказчиков).</p>\n";
echo "<p>Когда SQL получает команду GRANT, он проверяет привилегии пользователя, \n";
echo "подавшего эту команду, чтобы определить, допустима ли команда GRANT.</p>\n";
echo "<p>Adrian \n";
echo "самостоятельно не может выдать эту команду. Он также не может предоставить право \n";
echo "SELECT другому пользователю: таблица еще принадлежит Diane (далее мы покажем, \n";
echo "как Diane может дать право Adrian предоставлять SELECT другим пользователям).</p>\n";
echo "<p>Синтаксис - тот же самый, что и для предоставления других привилегий. Если \n";
echo "Adrian - владелец таблицы Продавцов, то он может позволить Diane вводить в неё \n";
echo "строки с помощью следующего предложения:</p>\n";
echo "<pre>GRANT INSERT ON Salespeople TO Diane;</pre>\n";
echo "<p>Теперь Diane имеет право помещать нового продавца в таблицу.</p>\n";
echo "<h4>ГРУППЫ ПРИВИЛЕГИЙ. ГРУППЫ ПОЛЬЗОВАТЕЛЕЙ.</h4>\n";
echo "<p>Вы не обязаны ограничивать себя предоставлением единственной привилегии \n";
echo "отдельному пользователю командой GRANT. Списки привилегий или пользователей, \n";
echo "разделяемых запятыми, являются совершенно приемлемыми.</p>\n";
echo "<p>Stephen может \n";
echo "предоставить и SELECT, и INSERT в таблице Заказов для Adrian:</p>\n";
echo "<pre>GRANT SELECT, INSERT ON Orders TO Adrian;</pre>\n";
echo "<p>или и для Adrian, и для Diane:</p>\n";
echo "<pre>GRANT SELECT, INSERT ON Orders TO Adrian, Diane;</pre>\n";
echo "<p>Когда привилегии и пользователи перечислены таким образом, весь список \n";
echo "привилегий предоставляется всем указанным пользователям. В строгой ANSI \n";
echo "интерпретации вы не можете предоставить привилегии во многих таблицах сразу \n";
echo "одной командой, но в некоторых реализациях это ограничение может быть ослаблено, \n";
echo "что позволяет указывать несколько таблиц, отделяя их запятыми, так чтобы весь \n";
echo "список привилегий мог быть предоставлен для всех указанных таблиц.</p>\n";
echo "<h4>ОГРАНИЧЕНИЕ ПРИВИЛЕГИЙ НА ОПРЕДЕЛЕННЫЕ СТОЛБЦЫ</h4>\n";
echo "<p>Все привилегии объекта используют один и тот же синтаксис, кроме команд UPDATE \n";
echo "и  REFERENCES, в которых не обязательно указывать имена столбцов.</p>\n";
echo "<p>Привилегию UPDATE можно предоставлять наподобие других привилегий:</p>\n";
echo "<pre>GRANT UPDATE ON Salespeople TO Diane;</pre>\n";
echo "<p>Эта команда позволит Diane изменять значения в любом или во всех столбцах \n";
echo "таблицы Продавцов. Однако, если Adrian хочет ограничить Diane в изменении, \n";
echo "например, комиссионных, он может ввести:</p>\n";
echo "<pre>GRANT UPDATE (comm) ON Salespeople TO Diane;</pre>\n";
echo "<p>Другими словами, он просто должен указать конкретный столбец, к которому \n";
echo "привилегия UPDATE должна быть применена, в круглых скобках после имени таблицы. \n";
echo "Имена нескольких столбцов таблицы могут указываться в любом порядке, отделяемые \n";
echo "запятыми:</p>\n";
echo "<pre>GRANT UPDATE (city, comm) ON Salespeople TO Diane;</pre>\n";
echo "<p>REFERENCES следует тому же самому правилу. Когда вы предоставите привилегию \n";
echo "REFERENCES другому пользователю, он сможет создавать внешние ключи, ссылающиеся \n";
echo "на столбцы вашей таблицы как на родительские ключи. Подобно UPDATE, для \n";
echo "привилегии REFERENCES может быть указан список из одного или более столбцов, для \n";
echo "которых ограничена эта привилегия. Например, Diane может предоставить Stephen \n";
echo "право использовать таблицу Заказчиков как таблицу родительского ключа с помощью \n";
echo "такой команды:</p>\n";
echo "<pre>      GRANT REFERENCES (cname, cnum)\n";
echo "         ON Customers TO Stephen;</pre>\n";
echo "<p>Эта команда дает Stephen право использовать столбцы cnum и cname в качестве \n";
echo "родительских ключей по отношению к любым внешним ключам в его таблицах. Stephen \n";
echo "может контролировать то, как это будет выполнено. Он может определить (cname, \n";
echo "cnum) или,  в нашем случае, (cnum, cname), как двухстолбцовый родительский \n";
echo "ключ, совпадающий с помощью внешнего ключа с двумя столбцами в одной из его \n";
echo "собственных таблиц. Или он может создать раздельные внешние ключи, чтобы \n";
echo "ссылаться на поля индивидуально, обеспечив тем самым, чтобы Diane имела \n";
echo "принудительное присвоение родительского ключа (см. <a href=\"ch19.php\">Главу 19</a>).</p>\n";
echo "<p>Не имея ограничений на количество внешних ключей, он должен базироваться на этих \n";
echo "родительских ключах, а родительские ключи различных внешних ключей разрешены для \n";
echo "перекрытия (overlap).</p>\n";
echo "<p>Как и в случае с привилегией UPDATE, вы можете исключить список столбцов и \n";
echo "таким образом позволить всем без исключения столбцам быть используемыми в \n";
echo "качестве родительских ключей.</p>\n";
echo "<p>Adrian может предоставить Diane право сделать это \n";
echo "следующей командой:</p>\n";
echo "<pre>GRANT REFERENCES ON Salespeople TO Diane;</pre>\n";
echo "<p>Естественно, привилегия будет пригодна для использования только в столбцах, \n";
echo "которые имеют ограничения, требуемые для родительских ключей.</p>\n";
echo "<h3><a name=\"22.6\">И</a>СПОЛЬЗОВАНИЕ АРГУМЕНТОВ ALL И PUBLIC</h3>\n";
echo "<p>SQL поддерживает два аргумента для команды GRANT, которые имеют специальное \n";
echo "значение: ALL PRIVILEGES (ВСЕ ПРИВИЛЕГИИ), или просто ALL, и PUBLIC (ОБЩИЕ).</p>\n";
echo "<p>ALL \n";
echo "используется вместо имён привилегий в команде GRANT, чтобы передать все привилегии \n";
echo "в таблице.</p>\n";
echo "<p>Например, Diane может выдать Stephen весь набор привилегий в таблице \n";
echo "Заказчиков с помощью такой команды:</p>\n";
echo "<pre>GRANT REFERENCES ON Salespeople TO Diane;</pre>\n";
echo "<p>(привилегии UPDATE и REFERENCES, естественно, применяются ко всем столбцам.)</p>\n";
echo "<p>А это другой способ высказать ту же мысль:</p>\n";
echo "<pre>GRANT ALL ON Customers TO Stephen;</pre>\n";
echo "<p>PUBLIC больше похож на тип аргумента - он захватывает всё (catch-all), - чем \n";
echo "на пользовательскую привилегию.</p>\n";
echo "<p>Когда вы предоставляете привилегии для \n";
echo "публикации, все пользователи автоматически их получают. Наиболее часто это \n";
echo "применяется для привилегии SELECT в определённых базовых таблицах или \n";
echo "представлениях, которые вы хотите сделать доступными для любого пользователя. \n";
echo "Чтобы позволить любому пользователю видеть таблицу Заказов, вы, например, можете \n";
echo "ввести следующее:</p>\n";
echo "<pre>GRANT SELECT ON Orders TO PUBLIC;</pre>\n";
echo "<p>Конечно, вы можете предоставить любые или все привилегии каждому, но это, \n";
echo "очевидно, нежелательно. Все привилегии, за исключением SELECT, позволяют \n";
echo "пользователю изменять (или, в случае REFERENCES, ограничивать) содержание \n";
echo "таблицы. Разрешение всем пользователям изменять содержание ваших таблиц создаст проблемы.</p>\n";
echo "<p>Даже если вы имеете небольшую компанию и в ней работают все ваши текущие \n";
echo "пользователи, способные выполнять команды модификации в данной таблице, было бы \n";
echo "лучше предоставить привилегии каждому пользователю индивидуально, чем одни и те \n";
echo "же привилегии для всех.</p>\n";
echo "<p>PUBLIC не ограничен в его передаче только текущим \n";
echo "пользователям. Любой новый пользователь, добавляемый к вашей системе, \n";
echo "автоматически получит все привилегии назначенные ранее всем, так что, если вы \n";
echo "захотите ограничить доступ к таблице всем, сейчас или в будущем, лучше всего \n";
echo "предоставить привилегии иные, нежели SELECT для индивидуальных пользователей.</p>\n";
echo "<h3><a name=\"22.7\">П</a>РЕДОСТАВЛЕНИЕ ПРИВИЛЕГИЙ С ПОМОЩЬЮ WITH GRANT OPTION</h3>\n";
echo "<p>Иногда создателю таблицы необходимо, чтобы другие пользователи могли получить \n";
echo "привилегии в его таблице. Обычно это делается в системах, где один человек или более \n";
echo " \n";
echo "создают несколько (или все) базовые таблицы в базе данных, а затем \n";
echo "передают ответственность за них тем, кто будет фактически с ними работать. SQL \n";
echo "позволяет делать это с помощью предложения WITH GRANT OPTION.</p>\n";
echo "<p>Если бы Diane хотела, чтобы Adrian имел право предоставлять привилегию SELECT в таблице Заказчиков \n";
echo "другим пользователям, она дала бы ему привилегию SELECT с использованием \n";
echo "предложения WITH GRANT OPTION:</p>\n";
echo "<pre>          GRANT SELECT ON Customers TO Adrian\n";
echo "            WITH GRANT OPTION;</pre>\n";
echo "<p>После этого Adrian получил право передавать привилегию SELECT третьим лицам; \n";
echo "он может выдать команду</p>\n";
echo "<pre>	 GRANT SELECT ON Diane.Customers TO Stephen;</pre>\n";
echo "<p>или даже</p>\n";
echo "<pre>         GRANT SELECT ON Diane.Customers TO Stephen\n";
echo "          WITH GRANT OPTION;</pre>\n";
echo "<p>Пользователь с помощью GRANT OPTION в особой привилегии в данной таблице \n";
echo "может, в свою очередь, предоставить эту привилегию в той же таблице, с или без GRANT OPTION, любому другому пользователю. Это не меняет принадлежности самой \n";
echo "таблицы; как и прежде таблица принадлежит ее создателю. (Поэтому пользователи, \n";
echo "получившие права, должны устанавливать префикс ID доступа владельца, когда \n";
echo "обращаются к этим таблицам. Следующая глава покажет вам этот способ.) \n";
echo "Пользователь же с помощью GRANT OPTION во всех привилегиях для данной таблицы \n";
echo "будет иметь всю полноту власти в той таблице.</p>\n";
echo "<h3><a name=\"22.8\">О</a>ТМЕНА ПРИВИЛЕГИЙ</h3>\n";
echo "<p>Также как ANSI предоставляет команду CREATE TABLE, чтобы создать таблицу, а \n";
echo "DROP TABLE - чтобы от нее избавиться, так и команда GRANT позволяет вам давать \n";
echo "привилегии пользователям, не предоставляя способа отобрать их обратно.</p>\n";
echo "<p>Удаление привилегии выполняется командой REVOKE, фактически - \n";
echo "стандартному средству с достаточно понятной формой записи. Синтаксис команды \n";
echo "REVOKE похож на GRANT, но имеет обратный смысл.</p>\n";
echo "<p>Чтобы удалить привилегию INSERT \n";
echo "для Adrian в таблице Заказов, вы можете ввести</p>\n";
echo "<pre>	REVOKE INSERT ON Orders FROM Adrian;</pre>\n";
echo "<p>Использование списков привилегий и пользователей здесь допустимы, как и в \n";
echo "случае с GRANT, так что вы можете ввести следующую команду:</p>\n";
echo "<pre>        REVOKE INSERT, DELETE ON Customers\n";
echo "          FROM Adrian, Stephen;</pre>\n";
echo "<p>Однако здесь имеется некоторая неясность. Кто имеет право отменять \n";
echo "привилегии? Когда пользователь с правом передавать привилегии другим, теряет это \n";
echo "право, пользователи, которым он предоставил эти привилегии, также их потеряют?<br>\n";
echo "Так как это нестандартная особенность, нет никаких авторитетных ответов на эти \n";
echo "вопросы, но наиболее общий подход таков:</p>\n";
echo "<ul>\n";
echo "  <li>Привилегии отменяются пользователем, который их предоставил, и отмена \n";
echo "  будет каскадироваться, то есть она будет автоматически распространяться на \n";
echo "  всех пользователей, получивших от него эту привилегию.</li>\n";
echo "</ul>\n";
echo "<h3><a name=\"22.9\">И</a>СПОЛЬЗОВАНИЕ ПРЕДСТАВЛЕНИЙ ДЛЯ ФИЛЬТРАЦИИ ПРИВИЛЕГИЙ</h3>\n";
echo "<p>Вы можете сделать действия привилегий более точными, используя представления. \n";
echo "Всякий раз, когда вы передаёте привилегию в базовой таблице пользователю, она \n";
echo "автоматически распространяется на все строки, а при использовании возможных \n";
echo "исключений UPDATE и REFERENCES - на все столбцы таблицы.</p>\n";
echo "<p>Создавая представление, \n";
echo "которое ссылается на основную таблицу и затем переносит привилегию на \n";
echo "представление, а не на таблицу, вы можете ограничивать эти привилегии любыми \n";
echo "выражениями в запросе, содержащемся в представлении. Это значительно улучшает \n";
echo "базисные возможности команды GRANT.</p>\n";
echo "<h4>КТО МОЖЕТ СОЗДАВАТЬ ПРЕДСТАВЛЕНИЯ?</h4>\n";
echo "<p>Чтобы создавать представление, вы должны иметь привилегию SELECT во всех \n";
echo "таблицах, на которые вы ссылаетесь в представлении. Если это представление \n";
echo "модифицируемое, любая привилегия INSERT, UPDATE и DELETE, которые вы имеете в \n";
echo "базовой таблице, будут автоматически передаваться представлению.</p>\n";
echo "<p>Если у вас отсутствуют привилегии на модификацию в базовых таблицах, вы не \n";
echo "сможете иметь их и в представлениях, которые вы создали, даже если сами эти \n";
echo "представления - модифицируемые.</p>\n";
echo "<p>Так как внешние ключи не используются в \n";
echo "представлениях, привилегия REFERENCES никогда не используется при создании \n";
echo "представлений. Все эти ограничения определяются ANSI.<br>\n";
echo "Нестандартные привилегии \n";
echo "системы (обсуждаемые позже в этой главе) также могут быть включены.</p>\n";
echo "<p>В \n";
echo "последующих разделах мы предположим, что создатели представлений, которые мы \n";
echo "обсуждаем, имеют частные или соответствующие привилегии во всех базовых \n";
echo "таблицах.</p>\n";
echo "<p><b>ОГРАНИЧЕНИЕ ПРИВИЛЕГИИ SELECT ДЛЯ ОПРЕДЕЛЁННЫХ СТОЛБЦОВ</b> </p>\n";
echo "<p>Предположим, вы хотите дать пользователю Claire способность видеть только \n";
echo "столбцы snum и sname таблицы Продавцов. Вы можете сделать это, поместив имена \n";
echo "этих столбцов в представление</p>\n";
echo "<pre>         CREATE VIEW Clairesview\n";
echo "            AS SELECT snum, sname\n";
echo "               FROM Salespeople;</pre>\n";
echo "<p>и предоставить Claire привилегию SELECT в представлении, а не в самой таблице \n";
echo "Продавцов:</p>\n";
echo "<pre>	  GRANT SELECT On Clairesview to Claire;</pre>\n";
echo "<p>Вы можете создать привилегии специально для столбцов, наподобие использования \n";
echo "других привилегий, но для команды INSERT это будет означать вставку значений по \n";
echo "умолчанию, а для команды DELETE ограничение столбца не будет иметь значения.</p>\n";
echo "<p>Привилегии REFERENCES и UPDATE, конечно, могут сделать столбцы специализированными, \n";
echo "не прибегая к представлению.</p>\n";
echo "<p><b>ОГРАНИЧЕНИЕ ПРИВИЛЕГИЙ ДЛЯ ОПРЕДЕЛЁННЫХ СТРОК</b></p>\n";
echo "<p>Обычно более полезный способ фильтровать привилегии с представлениями - это \n";
echo "использовать представление, чтобы привилегия относилась только к определенным \n";
echo "строкам. Вы делаете это, естественно, используя предикат в представлении, \n";
echo "который определит, какие строки являются включенными.</p>\n";
echo "<p>Чтобы предоставить \n";
echo "пользователю Adrian привилегию UPDATE в таблице Заказчиков для всех заказчиков, \n";
echo "размещенных в Лондоне, вы можете создать такое представление:</p>\n";
echo "<pre>       CREATE VIEW Londoncust\n";
echo "          AS SELECT *\n";
echo "             FROM Customers\n";
echo "             WHERE city = 'London'\n";
echo "             WITH CHECK OPTION;</pre>\n";
echo "<p>Затем вы должны передать привилегию UPDATE в этой таблице для Adrian:</p>\n";
echo "<pre>          GRANT UPDATE ON Londoncust TO Adrian;</pre>\n";
echo "<p>В этом отличие привилегии для определённых строк от привилегии UPDATE для \n";
echo "определённых столбцов, которая распространена на все столбцы таблицы Заказчиков, \n";
echo "но не на строки, среди которых строки со значением поля city, иным, чем London, \n";
echo "не будут учитываться. Предложение WITH CHECK OPTION предохраняет Adrian от \n";
echo "замены значения поля city на любое значение кроме London.</p>\n";
echo "<p><b>ПРЕДОСТАВЛЕНИЕ ДОСТУПА ТОЛЬКО К ИЗВЛЕЧЁННЫМ ДАННЫМ</b></p>\n";
echo "<p>Другая возможность состоит в том, чтобы предлагать пользователям доступ к уже \n";
echo "извлечённым данным, а не к фактическим значениям в таблице. Агрегатные функции \n";
echo "могут быть весьма удобными в применении такого способа. Вы можете создавать \n";
echo "представление, которое выдаёт подсчёт, среднее и общее количество  заказов на \n";
echo "каждый день заказов:</p>\n";
echo "<pre>         CREATE VIEW Datetotals\n";
echo "            AS SELECT odate, COUNT (*), SUM (amt), AVG (amt)\n";
echo "               FROM Orders\n";
echo "               GROUP BY odate;</pre>\n";
echo "<p>Теперь вы передаёте пользователю Diane привилегию SELECT в представлении \n";
echo "Datetotals:</p>\n";
echo "<pre>            GRANT SELECT ON Datetotals TO Diane;</pre>\n";
echo "<p><b>ИСПОЛЬЗОВАНИЕ ПРЕДСТАВЛЕНИЙ В КАЧЕСТВЕ АЛЬТЕРНАТИВЫ  ОГРАНИЧЕНИЯМ</b></p>\n";
echo "<p>Одной из последних прикладных программ из серии, описанной в\n";
echo "<a href=\"ch18.php\">Главе 18</a>, является использование представлений с WITH \n";
echo "CHECK OPTION как альтернативы ограничениям.</p>\n";
echo "<p>Предположим,  вы хотели \n";
echo "бы удостовериться, что все значения поля city в таблице Продавцов находятся в одном \n";
echo "из городов, где ваша компания в настоящее время имеет ведомство. Вы можете \n";
echo "установить ограничение CHECK непосредственно на столбец city, но позже может \n";
echo "стать трудно его изменить, если ваша компания, например, откроет там другие \n";
echo "офисы. В качестве альтернативы можно создать представление, которое исключает \n";
echo "неправильные значения city:</p>\n";
echo "<pre>   CREATE VIEW Curcities\n";
echo "       AS SELECT *\n";
echo "         FROM Salespeople\n";
echo "           WHERE city IN ('London', 'Rome', 'San Jose', 'Berlin')\n";
echo "          WITH CHECK OPTION;</pre>\n";
echo "<p>Теперь, вместо того чтобы предоставить пользователям привилегии \n";
echo "модифицирования в таблице Продавцов, вы можете предоставить их в представлении \n";
echo "Curcities. Преимущество такого подхода в том, что, если вам нужно сделать \n";
echo "изменение, вы можете удалить это представление, создать новое и предоставить в \n";
echo "этом новом представлении привилегии пользователям, что проще, чем изменять \n";
echo "ограничения. Недостатком является то, что владелец таблицы Продавцов также \n";
echo "должен использовать это представление, если он не хочет чтобы его собственные \n";
echo "команды были отклонены. С другой стороны, этот подход позволяет владельцу \n";
echo "таблицы и любым другим получить привилегии модификации в самой таблице, а не в \n";
echo "представлении, чтобы делать исключения для ограничений.</p>\n";
echo "<p>Это часто бывает желательно, но невыполнимо, если вы используете ограничения \n";
echo "в базовой таблице. К сожалению, эти исключения нельзя будет увидеть в \n";
echo "представлении. Если вы выберите этот подход, вам захочется создать второе \n";
echo "представление, содержащее только исключения:</p>\n";
echo "<pre>         CREATE VIEW Othercities\n";
echo "           AS SELECT *\n";
echo "             FROM Salespeople\n";
echo "             WHERE city NOT IN ('London', 'Rome', 'San Jose',\n";
echo "              'Berlin')\n";
echo "             WITH CHECK OPTION;</pre>\n";
echo "<p>Вы должны выбрать для передачи пользователям только привилегию SELECT в этом \n";
echo "представлении, чтобы они могли видеть исключенные строки, но не могли помещать \n";
echo "недопустимые значения city в базовую таблицу. Фактически пользователи могли бы \n";
echo "сделать запрос обоих представлений в объединении и увидеть все строки сразу.</p>\n";
echo "<h3><a name=\"22.10\">Д</a>РУГИЕ ТИПЫ ПРИВИЛЕГИЙ</h3>\n";
echo "<p>Вы, разумеется, хотите знать, кто же имеет право первым создать таблицу. Эта \n";
echo "область привилегий не относится к ANSI, но не может игнорироваться. Все \n";
echo "стандартные привилегии ANSI вытекают из этой привилегии - привилегии создателей \n";
echo "таблиц, которые могут передавать привилегии объекта. Если все ваши пользователи \n";
echo "будут создавать в системе базовые таблицы с разными размерами, это приведет к \n";
echo "избыточности в них и к неэффективности системы.</p>\n";
echo "<p>Возникают и другие вопросы:</p>\n";
echo "<ul>\n";
echo "  <li>Кто имеет право изменять, удалять или ограничивать таблицы? </li>\n";
echo "  <li>Должны ли права создания базовых таблиц отличаться от прав создания \n";
echo "  представлений? </li>\n";
echo "  <li>Должен ли иметься суперпользователь - пользователь который отвечает за \n";
echo "  поддержание базы данных и, следовательно, имеющий наибольшие или все \n";
echo "  привилегии, которые не предоставляются индивидуально? </li>\n";
echo "</ul>\n";
echo "<p>Пока ANSI не принимает в этом участия, а SQL используется в различных средах, \n";
echo "мы не можем дать окончательный ответ на эти вопросы. Мы предлагаем рассмотреть \n";
echo "здесь часть наиболее общих выводов.</p>\n";
echo "<p>Привилегии, которые не определяются в терминах специальных объектов данных, \n";
echo "называются привилегиями системы или правами базы данных. На базисном уровне они \n";
echo "будут, вероятно, включать в себя право создавать объекты данных, возможно, \n";
echo "отличающиеся от базовых таблиц (обычно создаваемых несколькими пользователями) и \n";
echo "представлений (обычно создаваемых большинством пользователей).<br>\n";
echo "Привилегии \n";
echo "системы для создания представлений должны дополнять, а не заменять привилегии \n";
echo "объекта, которые ANSI требует от создателей представлений (описанных ранее в \n";
echo "этой главе). Кроме того, в системе любого размера всегда имеются некоторые типы суперпользователей - пользователей, которые автоматически имеют большинство или \n";
echo "все привилегии и которые могут передать свой статус суперпользователя \n";
echo "кому-нибудь с помощью привилегии или группы привилегий. Администратор Базы \n";
echo "Данных (DBA) является термином наиболее часто используемым для такого \n";
echo "суперпользователя и для привилегий, которыми он обладает.</p>\n";
echo "<h3><a name=\"22.11\">Т</a>ИПИЧНЫЕ ПРИВИЛЕГИИ СИСТЕМЫ</h3>\n";
echo "<p>При обычном подходе имеется три базовых привилегии системы: CONNECT \n";
echo "(Подключить), RESOURCE (Ресурс) и DBA (Администратор Базы Данных). Проще можно \n";
echo "сказать, что CONNECT состоит из права зарегистрироваться и права создавать \n";
echo "представления и синонимы (см. <a href=\"ch23.php\">Главу 23</a>), если переданы \n";
echo "привилегии объекта. RESOURCE состоит из права создавать базовые таблицы. DBA это \n";
echo "привилегия суперпользователя, дающая пользователю высокие полномочия в базе \n";
echo "данных. Один или более пользователей с функциями администратора базы данных \n";
echo "может иметь эту привилегию. Некоторые системы кроме того имеют специального \n";
echo "пользователя, иногда называемого SYSADM или SYS (Системный Администратор Базы \n";
echo "Данных), который имеет наивысшие полномочия; это специальное имя, а не просто \n";
echo "пользователь со специальной DBA-привилегией. Фактически только один человек \n";
echo "имеет право зарегистрироваться с именем SYSADM, являющимся его идентификатором \n";
echo "доступа. Различие - весьма тонкое и функционирует по разному в различных \n";
echo "системах.<br>\n";
echo "Для наших целей мы будем ссылаться на высокопривилегированного \n";
echo "пользователя, который разрабатывает БД и управляет ею, имея полномочия DBA, понимая, что фактически эти полномочия - та же самая привилегия. Команда GRANT, в измененной форме, \n";
echo "пригодна для использования как с \n";
echo "привилегиями объекта, так и с системными привилегиями. Для начала передача прав \n";
echo "может быть сделана с помощью DBA. Например, DBA может передать привилегию для \n";
echo "создания таблицы пользователю Rodriguez следующим образом:</p>\n";
echo "<pre>         GRANT RESOURCE TO Rodriguez;</pre>\n";
echo "<h3><a name=\"22.12\">С</a>ОЗДАНИЕ И УДАЛЕНИЕ ПОЛЬЗОВАТЕЛЕЙ</h3>\n";
echo "<p>Естественно, появляется вопрос, откуда возьмётся пользователь с именем \n";
echo "Rodriguez? Как определить его ID допуска? В большинстве реализаций DBA создаёт \n";
echo "пользователя, автоматически предоставляя ему привилегию CONNECT.</p>\n";
echo "<p>В этом случае обычно добавляется предложение IDENTIFIED BY, указывающее \n";
echo "пароль. (Если же нет, операционная система должна определить, можете ли вы \n";
echo "зарегистрироваться в БД с данным ID доступа.) DBA может, например, ввести:</p>\n";
echo "<pre>GRANT CONNECT TO Thelonius IDENTIFIED BY Redwagon;</pre>\n";
echo "<p>что приведет к созданию пользователя с именем Thelonius, даст ему право \n";
echo "регистрироваться и назначит ему пароль Redwagon, и всё это в одном предложении.</p>\n";
echo "<p>Раз Thelonious - уже опознанный пользователь, он или DBA могут использовать \n";
echo "эту же команду, чтобы изменить пароль Redwagon.</p>\n";
echo "<p>Хотя это и удобно, но всё же имеется ограничение и в этом подходе: \n";
echo "невозможность иметь пользователя, который  мог бы зарегистрироваться, хотя бы \n";
echo "временно. Если вы хотите запретить пользователю регистрироваться, вы должны \n";
echo "использовать для REVOKE привилегию CONNECT, которая &quot;удаляет&quot; этого \n";
echo "пользователя. Некоторые реализации позволяют вам создавать и удалять \n";
echo "пользователей, независимо от их привилегий при регистрации. Когда вы \n";
echo "предоставляете привилегию CONNECT пользователю, вы создаете этого пользователя. \n";
echo "При этом, чтобы сделать это вам самим, вы должны иметь DBA-привилегию. Если этот \n";
echo "пользователь будет создавать базовые таблицы (а не только представления), ему \n";
echo "нужно также предоставить привилегию RESOURCE. Но это сразу порождает другую \n";
echo "проблему.</p>\n";
echo "<p>Если вы сделаете попытку удалить привилегию CONNECT пользователя, который \n";
echo "имеет созданные им таблицы, команда будет отклонена, потому что её действие \n";
echo "оставит таблицу без владельца, а это не разрешается. Вы должны сначала удалить \n";
echo "все таблицы, созданные этим пользователем, прежде чем удалить его привилегию \n";
echo "CONNECT. Если эти таблицы - не пустые, то вы, вероятно, захотите передать их \n";
echo "данные в другие таблицы с помощью команды INSERT, которая использует запрос. Вам \n";
echo "не нужно удалять отдельно привилегию RESOURSE; достаточно удалить CONNECT, чтобы \n";
echo "удалить пользователя.</p>\n";
echo "<p>Хотя всё выше сказанное это вполне стандартный подход к привилегиям системы, \n";
echo "он также имеет значительные ограничения. Появились альтернативные подходы, \n";
echo "которые более конкретно определены и точнее управляют привилегиями системы.</p>\n";
echo "<p>Это несколько выводит нас за пределы стандарта SQL, как он определён в \n";
echo "настоящее время, и, в некоторых реализациях, можно полностью выйти за пределы \n";
echo "стандарта SQL. Эти вещи, вероятно, не будут слишком вас касаться, если вы не DBA \n";
echo "или не пользователь высокого уровня. Обычные пользователи просто должны быть \n";
echo "знакомыми с привилегиями системы в принципе, справляясь в своей документации \n";
echo "только в случае специальных сообщений.</p>\n";
echo "<h3><a name=\"22.13\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Привилегии дают вам возможность видеть SQL под новым углом зрения, когда SQL \n";
echo "выполняет действия через специальных пользователей в специальной системе базы \n";
echo "данных.</p>\n";
echo "<p>Сама команда GRANT достаточно проста: с её помощью вы предоставляете те \n";
echo "или иные привилегии объекта одному или более пользователям. Если вы \n";
echo "предоставляете привилегию WITH GRANT OPTION пользователю, этот пользователь \n";
echo "может, в свою очередь, предоставить эту привилегию другим. Теперь вы понимаете \n";
echo "намеки на использование привилегий в представлениях - чтобы усовершенствовать \n";
echo "привилегии в базовых таблицах, или как альтернативы ограничениям - и на \n";
echo "некоторые преимущества и недостатки такого подхода.</p>\n";
echo "<p>Привилегии системы, которые \n";
echo "необходимы, но не входят в область стандарта SQL, обсуждались в их наиболее \n";
echo "общей форме, поэтому вы будете знакомиться с ними на практике.\n";
echo "<a href=\"ch23.php\">Глава 23</a> продолжит обсуждение таких вопросов о выводе в \n";
echo "SQL как \n";
echo "сохранение или восстановление изменений, создание ваших собственных имён для \n";
echo "таблиц, принадлежащих другим людям и понимание того, что происходит, когда \n";
echo "различные пользователи пытаются обращаться к одному и тому же объекту \n";
echo "одновременно.</p>\n";
echo "<h3><a name=\"22.14\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Передайте Janet право на изменение оценки заказчика.\n";
echo "\n";
echo "2. Передайте Stephan право передавать другим пользователям право\n";
echo "   делать запросы в таблице Заказов.\n";
echo "\n";
echo "3. Отнимите привилегию INSERT (ВСТАВКА) в таблице Продавцов\n";
echo "   у Claire и у всех пользователей, которым она была предоставлена.\n";
echo "\n";
echo "4. Передайте Jerry право вставлять в или модифицировать таблицу\n";
echo "   Заказчиков с сохранением его возможности оценивать значения\n";
echo "   в диапазоне от 100 до 500.\n";
echo "\n";
echo "5. Разрешите Janet делать запросы в таблице Заказчиков, но запретите\n";
echo "   ей уменьшать оценки в той же таблице Заказчиков.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#23\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>  
