﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 24.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 24. КАК ДАННЫЕ SQL ХРАНЯТСЯ В УПОРЯДОЧЕННОМ ВИДЕ?</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе вы узнаете, как типовая база данных SQL  сохраняет самоорганизованность. \n";
echo "Самоорганизованность обеспечивается реляционной \n";
echo "базой данных, создаваемой и поддерживаемой с помощью программы. \n";
echo "Вы можете обращаться к  таблицам самостоятельно для получения \n";
echo "информации о привилегиях, таблицах, индексах, и так далее. В этой главе мы \n";
echo "покажем вам некоторые типы содержимого такой БД.</p>\n";
echo "<a name=\"24.1\"></a>\n";
echo "<h3>КАТАЛОГ СИСТЕМЫ</h3>\n";
echo "<p>Чтобы функционировать как БД SQL, ваша компьютерная система \n";
echo "должна следить за многими вещами: таблицами, представлениями, индексами, синонимами, привилегиями, пользователями и т.д. \n";
echo "Имеются различные способы делать это, но ясно, что наиболее логичный, эффективный и согласованный способ делать это в реляционной среде \n";
echo "состоит в том, чтобы сохранять эту информацию в таблицах. Это даёт возможность компьютеру размещать \n";
echo "информацию и управлять ею,  используя те же самые процедуры, которые он использует чтобы размещать и управлять данными, которые он хранит для вас.</p>\n";
echo "<p>Хотя это - вопрос конкретной программы, а не  стандарта ANSI, большинство \n";
echo "БД SQL используют набор SQL-таблиц, хранящих служебную информацию, для своих внутренних потребностей. Этот набор называется в различных публикациях  системный каталог, словарь данных\n";
echo "или просто системные таблицы (Термин &quot;словарь данных&quot; может также относится к общему архиву данных, включая информацию о физических \n";
echo "параметрах БД, - данных, которые хранятся вне SQL. Следовательно, имеются программы баз данных, которые имеют и системный каталог, и словарь данных.)</p>\n";
echo "<p>Таблицы системного каталога напоминают обычные SQL-таблицы: те же строки и столбцы данных. Например, одна таблица каталога обычно содержит информацию о таблицах, существующих в \n";
echo "БД, по одной строке на каждую таблицу базы данных; другая содержит информацию о различных столбцах таблиц, по одной строке на столбец, и так далее.</p>\n";
echo "<p>Таблицы каталога создаются и заполняются с помощью самой БД и идентифицируются с помощью специальных имён, таких, например,\n";
echo "как SYSTEM.</p>\n";
echo "<p>База данных создает эти таблицы и модифицирует их автоматически; таблицы каталога не могут быть непосредственно подвергнуты\n";
echo "действию команды модификации. Если это случится, это значительно запутает всю систему и сделает её неработоспособной. Однако в большинстве систем каталог может быть запрошен пользователем. Это очень полезно, потому что это даёт  возможность узнать кое-что о \n";
echo "БД, которую вы используете. Конечно, не вся информация  всегда доступна всем пользователям. Подобно другим \n";
echo "таблицам, доступ к каталогу ограничен для пользователей без соответствующих привилегий.\n";
echo "Так как каталог принадлежит самой системе, имеется некоторая неясность \n";
echo "относительно того, кто имеет привилегии и кто может предоставить привилегии в этом каталоге. Обычно привилегии каталога предоставляет суперпользователь, например, администратор системы, зарегистрированный как\n";
echo "SYSTEM или DBA. Кроме того, некоторые привилегии могут предоставляться пользователям автоматически.</p>\n";
echo "<a name=\"24.2\"></a>\n";
echo "<h3>ТИПИЧНЫЙ  КАТАЛОГ СИСТЕМЫ</h3>\n";
echo "<p>Давайте рассмотрим некоторые таблицы, которые мы могли бы найти в типовом каталоге системы:</p>\n";
echo "<pre>     Таблицы                     Содержание\n";
echo " -------------      ------------------------------------------- \n";
echo " \n";
echo " SYSTEMCATALOG      Таблицы (базовые и представления)\n";
echo " \n";
echo " SYSTEMCOLUMNS      Столбцы таблицы\n";
echo " \n";
echo " SYSTEMTABLES       Каталог представления в SYSTEMCATALOG\n";
echo " \n";
echo " SYSTEMINDEXES      Индексы в таблице\n";
echo " \n";
echo " SYSTEMUSERAUTH     Пользователи базы данных\n";
echo " \n";
echo " SYSTEMTABAUTH      Объектные привилегии пользователей\n";
echo " \n";
echo " SYSTEMCOLAUTH      Столбцовые привилегии пользователей\n";
echo "\n";
echo " SYSTEMSYNONS       Синонимы таблиц</pre>\n";
echo "<p>Теперь, если наш DBA предоставит пользователю Stephen право просматривать SYSTEMCATALOG такой командой</p>\n";
echo "<pre>     GRANT SELECT ON SYSTEMCATALOG TO Stephen;</pre>\n";
echo "<p>то Stephen сможет увидеть некоторую информацию обо всех таблицах в БД (мы имеем здесь пользователя DBA, пользователя Chris \n";
echo "- \n";
echo "владельца трёх наших типовых таблиц, а также Adrian - владельца представления Londoncust).</p>\n";
echo "<pre>        SELECT tname, owner, numcolumns, type, CO\n";
echo "           FROM SYSTEMCATALOG;\n";
echo "\n";
echo "\n";
echo "         ===============  SQL Execution Log ===============\n";
echo "        |                                                  |\n";
echo "        | SELECT tname, owner, numcolumns, type, CO        |\n";
echo "        | FROM  SYSTEMCATALOG;                             |\n";
echo "        |                                                  |\n";
echo "        | ================================================ |\n";
echo "        |   tname          owner    numcolumns  type  CO   |\n";
echo "        | -------------   -------   ----------  ----  ---  |\n";
echo "        | SYSTEMCATALOG   SYSTEM            4     B        |\n";
echo "        | Salespeople     Chris             4     B        |\n";
echo "        | Customers       Chris             5     B        |\n";
echo "        | Londoncust      Adrian            5     V    Y   |\n";
echo "        | Orders          Chris             5     B        |\n";
echo "        |                                                  |\n";
echo "         ==================================================\n";
echo "\n";
echo "	  Рисунок 24.1 Содержание таблицы SYSTEMCATALOG</pre>\n";
echo "<p>Как видите, каждая строка описывает свою таблицу. \n";
echo "Первый столбец - имя; второй - имя пользователя, который владеет ею; \n";
echo "третий - число столбцов  таблицы; четвертый - код \n";
echo "из одного символа: это или B (для базовой таблицы), или V (для представления). Последний столбец имеет пустые (NULL) значения, если его\n";
echo "тип не равен V, и этот столбец указывает, определена или нет возможность проверки.</p>\n";
echo "<p>Обратите внимание что SYSTEMCATALOG (СИСТЕМНЫЙ КАТАЛОГ) представлен как одна из таблиц в вышесказанном списке. Для\n";
echo "простоты мы исключили остальные каталоги системы из вывода. Таблицы системного каталога обычно показываются в SYSTEMCATALOG.</p>\n";
echo "<a name=\"24.3\"></a>\n";
echo "<h3>ИСПОЛЬЗОВАНИЕ ПРЕДСТАВЛЕНИЙ В ТАБЛИЦАХ КАТАЛОГА</h3>\n";
echo "<p>Поскольку SYSTEMCATALOG это таблица, вы можете использовать \n";
echo "её в представлении. Фактически можно считать, что имеется такое представление с именем SYSTEMTABLES.</p>\n";
echo "<p>Это представление SYSTEMCATALOG содержит только те таблицы, которые входят в системный каталог; это обычно таблицы базы данных, типа\n";
echo "таблицы Продавцов, которые показаны в SYSTEMCATALOG, но не в SYSTEMTABLES.</p>\n";
echo "<p>Давайте предположим, что только таблицы каталога являются собственностью пользователя SYSTEM. Если вы захотите, вы можете определить другое\n";
echo "представление, которое специально исключало бы таблицы каталога из вывода:</p>\n";
echo "<pre>           CREATE VIEW Datatables\n";
echo "              AS SELECT *\n";
echo "                 FROM SYSTEMCATALOG\n";
echo "                 WHERE owner &lt; &gt; 'SYSTEM';\n";
echo "\n";
echo "<b>РАЗРЕШИТЬ ПОЛЬЗОВАТЕЛЯМ ВИДЕТЬ (ТОЛЬКО) ИХ СОБСТВЕННЫЕ ОБЪЕКТЫ</b></pre>\n";
echo "<p>Кроме того, возможно другое использование представлений каталога. \n";
echo "Предположим, вам нужно, чтобы каждый пользователь был способен сделать запрос \n";
echo "каталога для получения информации только из таблиц, которыми он владеет. \n";
echo "Поскольку значение USER в команде SQL постоянно для ID\n";
echo "доступа пользователя, выдающего команду, оно может всегда быть использовано, чтобы давать доступ пользователям только к их собственным таблицам.</p>\n";
echo "<p>Вы можете, для начала, создать следующее представление:</p>\n";
echo "<pre>               CREATE VIEW Owntables\n";
echo "                 AS SELECT *\n";
echo "                    FROM SYSTEMCATALOG\n";
echo "                    WHERE Owner = USER;</pre>\n";
echo "<p>Теперь вы можете предоставить всем пользователям доступ к этому представлению:</p>\n";
echo "<pre>            GRANT SELECT ON Owntables TO PUBLIC;</pre>\n";
echo "<p>Каждый пользователь теперь способен выбирать (SELECT) только те строки из SYSTEMCATALOG, владельцем которых он сам является.</p>\n";
echo "<p><b>ПРЕДСТАВЛЕНИЕ SYSTEMCOLUMNS</b></p>\n";
echo "<p>Одно небольшое добавление к этому позволит каждому пользователю просматривать таблицу SYSTEMCOLUMNS для столбцов из его собственных таблиц.</p>\n";
echo "<p>Сначала давайте рассмотрим ту часть таблицы SYSTEMCOLUMNS, которая описывает наши типовые таблицы (другими словами, исключим сам каталог):</p>\n";
echo "<pre>   tname      cname   datatype  cnumber  tabowner\n";
echo " -----------  -----   --------  -------  --------\n";
echo "\n";
echo " Salespeople  snum    integer      1      Diane\n";
echo "\n";
echo " Salespeople  sname   char         2      Diane\n";
echo "\n";
echo " Salespeople  city    char         3      Diane\n";
echo "\n";
echo " Salespeople  comm    decimal      4      Diane\n";
echo "\n";
echo " Customers    cnum    integer      1      Claire\n";
echo "\n";
echo " Customers    cname   char         2      Claire\n";
echo "\n";
echo " Customers    city    char         3      Claire\n";
echo "\n";
echo " Customers    rating  integer      4      Claire\n";
echo "\n";
echo " Customers    snum    integer      5      Claire\n";
echo "\n";
echo " Orders       onum    integer      1      Diane\n";
echo "\n";
echo " Orders       odate   date         2      Diane\n";
echo "\n";
echo " Orders       amt     decimal      3      Diane\n";
echo "\n";
echo " Orders       cnum    integer      4      Diane\n";
echo "\n";
echo " Orders       snum    integer      5      Diane</pre>\n";
echo "<p>Как видите, каждая строка этой таблицы показывает столбец таблицы в БД. Все столбцы данной таблицы должны иметь разные имена, так же как каждая таблица должна иметь данного пользователя, и, наконец, все комбинации пользователей, таблиц и имён\n";
echo "столбцов должны различаться между собой.</p>\n";
echo "<p>Следовательно, табличные столбцы: tname (имя таблицы), tabowner \n";
echo "(владелец таблицы) и cname (имя столбца) вместе составляют первичный ключ этой таблицы. Столбец datatype (тип данных) говорит\n";
echo "сам за себя. Столбец cnumber (номер столбца) указывает на местоположение этого столбца внутри таблицы. Для упрощения мы опустили параметры длины столбца, точности и масштаба.</p>\n";
echo "<p>Для справки показана строка из SYSTFMCATALOG, которая ссылается на эту таблицу:</p>\n";
echo "<pre>tname           owner  numcolumns     type   CO\n";
echo "-------------  ------  -----------    -----  ---\n";
echo "\n";
echo "SYSTEMCOLUMNS  System   8             B</pre>\n";
echo "<p>Некоторые SQL-реализации будут обеспечивать вас б&#x0301;ольшим количеством данных, чем показано в этих столбцах, но показанное является основой  любых реализаций.</p>\n";
echo "<p>Для иллюстрации процедуры, предложенной в начале этого раздела, имеется способ, позволяющий каждому пользователю видеть информацию SYSTEMCOLUMNS только \n";
echo "в принадлежащих ему таблицах:</p>\n";
echo "<pre>          CREATE VIEW Owncolumns\n";
echo "             AS SELECT *\n";
echo "                FROM SYSTEMCOLUMNS\n";
echo "                WHERE tabowner = USER;\n";
echo "\n";
echo "          GRANT SELECT ON Owncolumns TO PUBLIC;</pre>\n";
echo "<a name=\"24.4\"></a>\n";
echo "<h3>КОММЕНТАРИЙ В СОДЕРЖАНИИ КАТАЛОГА </h3>\n";
echo "<p>\n";
echo "\n";
echo "Большинство версий SQL, позволяют  помещать комментарии (ремарки) в специальные столбцы пояснений таблиц каталогов SYSTEMCATALOG \n";
echo "и SYSTEMCOLUMNS, что удобно, так как эти таблицы не всегда могут объяснить свое содержание. Для простоты мы пока исключали этот столбец из наших иллюстраций.\n";
echo "Можно использовать команду COMMENT ON со строкой текста, чтобы пояснить любую строку в одной из этих таблиц. Состояние TABLE - для комментирования в SYSTEMCATALOG, \n";
echo "а текст COLUMN - для SYSTEMCOLUMNS. Например:</p>\n";
echo "<pre>               COMMENT ON TABLE Chris.Orders\n";
echo "\n";
echo "                 IS 'Current Customer Orders';</pre>\n";
echo "<p>Текст будет помещен в столбец пояснений SYSTEMCATALOG. Обычно максимальная длина таких пояснений - 254 символа.</p>\n";
echo "<p>Сам комментарий указывается для конкретной строки, один с tname=Orders, а \n";
echo "другой owner=Chris. Мы увидим этот комментарий в строке  таблицы Заказов в SYSTEMCATALOG:</p>\n";
echo "<pre>         SELECT tname, remarks\n";
echo "            FROM SYSTEMCATALOG\n";
echo "            WHERE tname = 'Orders'\n";
echo "               AND owner = 'Chris';</pre>\n";
echo "<p> Вывод для этого запроса показан на Рисунке 24.2.</p>\n";
echo "<p>SYSTEMCOLUMNS работает точно так же. Сначала мы создаём комментарий</p>\n";
echo "<pre>             COMMENT ON COLUMN Orders.onum\n";
echo "              IS 'Order #';</pre>\n";
echo "<p>затем выбираем эту строку из SYSTEMCOLUMNS:</p>\n";
echo "<pre>           SELECT cnumber, datatype, cname, remarks\n";
echo "              FROM SYSTEMCOLUMNS\n";
echo "              WHERE tname = 'Orders'\n";
echo "                 AND tabowner = 'Chris'\n";
echo "                 AND cname = onum;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 24.3.</p>\n";
echo "<p>Чтобы изменить комментарий, вы можете просто ввести новую команду COMMENT ON для той же строки. Новый комментарий будет записан \n";
echo "поверх старого. Если вы хотите удалить комментарий, напишите поверх него пустой комментарий:</p>\n";
echo "<pre>            COMMENT ON COLUMN Orders.onum\n";
echo "               IS '';</pre>\n";
echo "<p>и этот пустой комментарий затрёт предыдущий.</p>\n";
echo "<pre>         ===============  SQL Execution Log ===============\n";
echo "        |                                                  |\n";
echo "        | SELECT tname, remarks                            |\n";
echo "        | FROM  SYSTEMCATALOG                              |\n";
echo "        | WHERE tname = 'Orders'                           |\n";
echo "        | AND owner = 'Chris'                              |\n";
echo "        | ;                                                |\n";
echo "        | ================================================ |\n";
echo "        |   tname          remarks                         |\n";
echo "        | -------------   -----------------------          |\n";
echo "        | Orders          Current Customers Orders         |\n";
echo "        |                                                  |\n";
echo "         ==================================================\n";
echo "\n";
echo "	    Рисунок 24.2 Комментарий в SYSTEMCATALOG\n";
echo "\n";
echo "\n";
echo "         ===============  SQL Execution Log ===============\n";
echo "        |                                                  |\n";
echo "        | SELECT cnumber, datatype, cname, remarks         |\n";
echo "        | FROM  SYSTEMCOLUMNS                              |\n";
echo "        | WHERE tname = 'Orders'                           |\n";
echo "        | AND tabowner = 'Chris'                           |\n";
echo "        | AND cname = 'onum'                               |\n";
echo "        | ;                                                |\n";
echo "        | ================================================ |\n";
echo "        |   cnumber      datatype    cname    remarks      |\n";
echo "        | ----------     ---------   ------  ------------  |\n";
echo "        |          1     integer     onum    Orders #      |\n";
echo "        |                                                  |\n";
echo "         ==================================================\n";
echo "\n";
echo "   	   Рисунок 24.3 Комментарий в SYSTEMCOLUMNS</pre>\n";
echo "<a name=\"24.5\"></a>\n";
echo "<h3>ОСТАЛЬНОЕ СОДЕРЖИМОЕ КАТАЛОГА</h3>\n";
echo "<p>\n";
echo "\n";
echo "Здесь показаны определения остальных ваших системных таблиц с типовым запросом для каждого:</p>\n";
echo "<a name=\"24.6\"></a>\n";
echo "<h4>SYSTEMINDEXES - ИНДЕКСАЦИЯ В БАЗЕ ДАННЫХ</h4>\n";
echo "<p>\n";
echo "\n";
echo "Имена столбцов в таблице SYSTEMINDEXES и их описания:</p>\n";
echo "<pre>СТОЛБЕЦ          ОПИСАНИЕ\n";
echo "-------------    ----------------------------------------------- \n";
echo "\n";
echo "iname 		 Имя индекса (используемое для его исключения)\n";
echo "\n";
echo "iowner           Имя пользователя, создавшего индекс\n";
echo "\n";
echo "tname            Имя таблицы, которая содержит индекс\n";
echo "\n";
echo "cnumber          Номер столбца в таблице\n";
echo "\n";
echo "tabowner         Пользователь, который владеет таблицей, содержащей индекс\n";
echo "\n";
echo "numcolumns       Число столбцов в индексе\n";
echo "\n";
echo "cposition        Позиция текущего столбца среди набора индексов\n";
echo "\n";
echo "isunique         Уникален ли индекс (Y или N)</pre>\n";
echo "<p><b><br>\n";
echo "ТИПОВОЙ ЗАПРОС</b> Индекс считается неуникальным, если он вызывает продавца в snum-столбце таблицы Заказчиков:</p>\n";
echo "<pre>SELECT iname, iowner, tname, cnumber, isunique\n";
echo "FROM SYSTEMINDEXES\n";
echo "WHERE iname = 'salesperson';</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 24.4.</p>\n";
echo "<pre> ===============  SQL Execution Log ================\n";
echo "|                                                   |\n";
echo "| SELECT iname, iowner, tname, cnumber, isunique    |\n";
echo "| FROM  SYSTEMINDEXES                               |\n";
echo "| WHERE iname = 'salespeople'                       |\n";
echo "| ;                                                 |\n";
echo "| ================================================= |\n";
echo "|   iname      iowner   tname     cnumber  isunique |\n";
echo "| -----------  ------  ---------- -------  -------- |\n";
echo "| salesperson  Stephan  Customers       5   N       |\n";
echo "|                                                   |\n";
echo " ===================================================\n";
echo "\n";
echo "    Рисунок 24.4 Строка из таблицы SYSTEMINDEXES\n";
echo "</pre>\n";
echo "<a name=\"24.7\"></a>\n";
echo "<h4>SYSTEMUSERAUTH - ПОЛЬЗОВАТЕЛЬСКИЕ И СИСТЕМНЫЕ ПРИВИЛЕГИИ В БАЗЕ ДАННЫХ</h4>\n";
echo "<p>Имена столбцов для SYSTEMUSERAUTH и их описания:</p>\n";
echo "<pre>СТОЛБЕЦ          ОПИСАНИЕ \n";
echo "--------------   ----------------------------------------------- \n";
echo "\n";
echo "username      	 Идентификатор (ID) доступа пользователя\n";
echo "\n";
echo "password   	 Пароль пользователя, вводимый при регистрации\n";
echo "\n";
echo "resource   	 Где пользователь имеет права RESOURCE\n";
echo "\n";
echo "dba        	 Где пользователь имеет права DBA</pre>\n";
echo "<p>Мы будем использовать простую схему системных привилегий из Главы 22, где были представлены три системные привилегии: CONNECT (ПОДКЛЮЧИТЬ), RESOURCE (РЕСУРСЫ)\n";
echo "и DBA.</p><p>Все пользователи получают CONNECT по умолчанию при регистрации, поэтому она не описана в таблице выше. Возможные состояния столбцов \n";
echo "resource и dba: Y (Да, пользователь имеет привилегии) или No (Нет, пользователь не имеет привилегий).</p>\n";
echo "<p>Пароли (password) доступны только высокопривилегированным пользователям, если таковые существуют. Следовательно, запрос этой \n";
echo "таблицы можно вообще делать только для получения информации относительно привилегий системы и пользователей.</p>\n";
echo "<p><b>ТИПОВОЙ ЗАПРОС</b> Чтобы найти всех пользователей, которые имеют привилегию RESOURCE, и увидеть, какие из них - DBA, вы \n";
echo "можете ввести следующее условие:</p>\n";
echo "<pre> SELECT username, dba\n";
echo "    FROM SYSTEMUSERAUTH\n";
echo "    WHERE resource = 'Y';</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 24.5.</p>\n";
echo "<a name=\"24.8\"></a>\n";
echo "<h4>SYSTEMTABAUTH - ПРИВИЛЕГИИ ОБЪЕКТА, КОТОРЫЕ НЕ ОПРЕДЕЛЯЮТ АВТОРИЗАЦИЮ \n";
echo "СТОЛБЦА</h4>\n";
echo "<p>\n";
echo "\n";
echo "Здесь показаны имена столбцов в таблице SYSTEMTABAUTH \n";
echo "и их описания:</p>\n";
echo "<pre>СТОЛБЕЦ         ОПИСАНИЕ\n";
echo "------------    --------------------------------------------- \n";
echo "username      	Пользователь, который имеет привилегии\n";
echo "\n";
echo "grantor       	Пользователь, который передает привилегии по имени пользователя\n";
echo "\n";
echo "tname         	Имя таблицы, в которой существуют привилегии\n";
echo "\n";
echo "owner         	Владелец tname\n";
echo "\n";
echo "selauth       	Имеет ли пользователь привилегию SELECT\n";
echo "\n";
echo "insauth       	Имеет ли пользователь привилегию INSERT\n";
echo "\n";
echo "delauth       	Имеет ли пользователь привилегию DELETE</pre>\n";
echo "<p>Возможные значения  каждой из перечисленных привилегий объекта (имена столбцов которых оканчиваются на auth): Y, N и G.</p>\n";
echo "<p>G указывает, что пользователь имеет привилегию с возможностью передачи привилегий. В каждой строке по крайней мере один из этих \n";
echo "столбцов должен иметь состояние, отличное от N (другими словами, иметь хоть какую-то привилегию).</p>\n";
echo "<pre> ===============  SQL Execution Log ================\n";
echo "|                                                   |\n";
echo "| SELECT username, dba                              |\n";
echo "| FROM  SYSTEMUSERAUTH                              |\n";
echo "| WHERE resource = 'Y'                              |\n";
echo "| ;                                                 |\n";
echo "| ================================================= |\n";
echo "|   username    dba                                 |\n";
echo "| -----------  ------                               |\n";
echo "|  Diane         N                                  |\n";
echo "|  Adrian        Y                                  |\n";
echo "|                                                   |\n";
echo "===================================================\n";
echo "\n";
echo "Рисунок 24.5 Пользователи, имеющие привилегию RESOURCE</pre>\n";
echo "<p>Первые четыре столбца этой таблицы составляют первичный ключ. Это означает что каждая комбинация из tname, владелец-пользователь (не \n";
echo "забудьте, что две различные таблицы с различными владельцами могут иметь одно и тоже имя), пользователь и пользователь, передающий права (грантор), должна быть уникальной. Каждая строка этой таблицы\n";
echo "содержит все привилегии (которые не являются определённым столбцом), предоставляемые одним определённым пользователем другому\n";
echo "определённому пользователю в конкретном объекте.</p>\n";
echo "<p>UPDATE и REFERENCES, являются привилегиями, которые могут \n";
echo "быть определёнными столбцами и находиться в различных таблицах каталога. Если пользователь получает привилегии в таблице от более чем одного пользователя, такие привилегии могут быть отдельными строками, созданными в этой таблице. Это необходимо для каскадного отслеживания при вызове привилегий.</p>\n";
echo "<p><b>ТИПОВОЙ ЗАПРОС</b> Чтобы найти все привилегии SELECT, INSERT \n";
echo "и DELETE, которые Adrian предоставляет пользователям в таблице Заказчиков, вы можете ввести следующее (вывод показан на Рисунке 24.6):</p>\n";
echo "<pre>SELECT username, selauth, insauth, delauth\n";
echo "  FROM SYSTEMTABAUTH\n";
echo "  WHERE grantor = 'Adrian'\n";
echo "     ANDtname = 'Customers';\n";
echo "\n";
echo " ===============  SQL Execution Log ================\n";
echo "|                                                   |\n";
echo "| SELECT username, selauth, insauth, delauth        |\n";
echo "| FROM  SYSTEMTABAUTH                               |\n";
echo "| WHERE grantor = 'Adrian'                          |\n";
echo "| AND tname = 'Customers'                           |\n";
echo "| ;                                                 |\n";
echo "| ================================================= |\n";
echo "|   username   selauth  insauth  delauth            |\n";
echo "| -----------  -------  -------- --------           |\n";
echo "|  Claire      G        Y        N                  |\n";
echo "|  Norman      Y        Y        Y                  |\n";
echo "|                                                   |\n";
echo "===================================================\n";
echo "\n";
echo "Рисунок 24.6 Пользователи, получившие привилегии от Adrian \n";
echo "\n";
echo "</pre>\n";
echo "<p>Выше показано, что Adrian предоставил Claire привилегии INSERT и SELECT в таблице Заказчиков, позднее предоставив ей права на передачу привилегий. \n";
echo "Пользователю Norman он предоставил привилегии SELECT, INSERT и DELETE, но не дал возможность передачи  ни  одной из них. Если Claire \n";
echo "имела привилегию DELETE в таблице Заказчиков от какого-то другого источника, в этом запросе это показано не будет.</p>\n";
echo "<a name=\"24.9\"></a>\n";
echo "<h4>SYSTEMCOLAUTH - ПРИВИЛЕГИИ ОБЪЕКТА, КОТОРЫЕ ОПРЕДЕЛЯЮТ АВТОРИЗАЦИЮ СТОЛБЦА</h4>\n";
echo "<pre>СТОЛБЕЦ		ОПИСАНИЕ\n";
echo "-------------   -------------------------------------------\n";
echo "\n";
echo "username    	Пользователь, который имеет привилегии\n";
echo "\n";
echo "grantor     	Пользователь, который предоставляет привилегии другому пользователю \n";
echo "\n";
echo "tname       	Имя таблицы, в которой существуют привилегии\n";
echo "\n";
echo "cname       	Имя столбца, в котором существуют привилегии\n";
echo "\n";
echo "owner       	Владелец tname\n";
echo "\n";
echo "updauth     	Имеет ли пользователь привилегию UPDATE в этом столбце\n";
echo "\n";
echo "refauth     	Имеет ли пользователь привилегию REFERENCES в этом столбце</pre>\n";
echo "<p>Столбцы updauth и refauth могут быть в состоянии Y, N или G, но не могут быть одновременно в состоянии N в одной и той же строке. \n";
echo "Это первые пять столбцов таблицы, которые не составляют первичный ключ. \n";
echo "Он отличается от первичного ключа SYSTEMTABAUTH, в котором содержится поле cname, указывающее на определенный столбец обсуждаемой таблицы, для которой применяются одна или обе привилегии. Отдельная строка в этой таблице может существовать для каждого столбца в любой данной таблице,\n";
echo "в которой одному пользователю передаются привилегии определенного столбца с помощью другого пользователя.</p>\n";
echo "<p>Как и в случае с SYSTEMTABAUTH, та же привилегия может быть описана в более чем одной строке этой таблицы, если она была передана более чем одним пользователем.</p>\n";
echo "<p><b>ТИПОВОЙ ЗАПРОС</b> Чтобы выяснить, в каких столбцах какой таблицы вы имеете привилегию REFERENCES, вы можете ввести следующий запрос \n";
echo "(вывод показан на Рисунке 24.7):</p>\n";
echo "<pre>SELECT owner, tname, cname\n";
echo "   FROM SYSTEMCOLAUTH\n";
echo "   WHERE refauth IN ('Y', 'G')\n";
echo "      AND username = USE \n";
echo "   ORDER BY 1, 2;</pre>\n";
echo "<p>который показывает, что эти две таблицы,  имеющие различных владельцев, но одинаковые имена, в действительности \n";
echo "- совершенно разные таблицы (т.е. это не  два синонима для одной таблицы).</p>\n";
echo "<pre> ===============  SQL Execution Log ================\n";
echo "|                                                   |\n";
echo "| SELECT OWNER, TNAME, CNAME                        |\n";
echo "| FROM  SYSTEMCOLAUTH                               |\n";
echo "| WHERE refaulth IN ('Y' , 'G' )                    |\n";
echo "| AND username = USER                               |\n";
echo "| ORDER BY 1, 2                                     |\n";
echo "| ;                                                 |\n";
echo "| ================================================= |\n";
echo "|   owner       tname       cname                   |\n";
echo "| -----------  -----------  -------                 |\n";
echo "|  Diane       Customers     cnum                   |\n";
echo "|  Diane       Salespeople   sname                  |\n";
echo "|  Diane       Salespeople   sname                  |\n";
echo "|  Gillan      Customers     cnum                   |\n";
echo "===================================================\n";
echo "\n";
echo "Рисунок 24.7 Столбцы, в которых пользователь имеет привилегию INSERT</pre>\n";
echo "<a name=\"24.10\"></a>\n";
echo "<h4>SYSTEMSYNONS - СИНОНИМЫ ДЛЯ ТАБЛИЦ В БАЗЕ ДАННЫХ</h4>\n";
echo "<p>\n";
echo "\n";
echo "Это  имена столбцов в таблице SYSTEMSYNONS и их описания:</p>\n";
echo "<pre>СТОЛБЕЦ     	ОПИСАНИЕ \n";
echo "-------------   -------------------------------------------- \n";
echo "synonym      	Имя синонима\n";
echo "\n";
echo "synowner     	Пользователь, который является владельцем синонима (может быть PUBLIC (ОБЩИЙ))\n";
echo "\n";
echo "tname        	Имя таблицы, используемой владельцем\n";
echo "\n";
echo "tabowner     	Имя пользователя, который является владельцем таблицы</pre>\n";
echo "<p><b>ТИПОВОЙ ЗАПРОС</b> Предположим, что Adrian имеет синоним Clients для таблицы Заказчиков, принадлежащей Diane, и что имеется \n";
echo "общий синоним Customers для этой же таблицы. Вы делаете запрос таблицы для всех синонимов в таблице Заказчиков (вывод показан на Рисунке 24.8):</p>\n";
echo "<pre>SELECT *\n";
echo "FROM SYSTEMSYNONS\n";
echo "WHERE tname = 'Customers'\n";
echo "\n";
echo "\n";
echo " ===============  SQL Execution Log ================\n";
echo "|                                                   |\n";
echo "| SELECT *                                          |\n";
echo "| FROM  SYSTEMSYNONS                                |\n";
echo "| WHERE tname = 'Customers'                         |\n";
echo "| ;                                                 |\n";
echo "| ================================================= |\n";
echo "| synonym       synowner    tname       tabowner    |\n";
echo "| -----------  -----------  ----------  ----------  |\n";
echo "|  Clients      Adrian      Customers   Diane       |\n";
echo "|  Customers    PUBLIC      Customers   Diane       |\n";
echo "|                                                   |\n";
echo "===================================================\n";
echo "\n";
echo "   Рисунок 24.8 Синонимы для таблицы Заказчиков</pre>\n";
echo "<a name=\"24.11\"></a>\n";
echo "<h3>ДРУГОЕ ИСПОЛЬЗОВАНИЕ КАТАЛОГА </h3>\n";
echo "<p>\n";
echo "\n";
echo "Конечно, вы можете выполнять более сложные запросы в системном каталоге. \n";
echo "Объединения, например, могут быть очень удобны.<br>Эта команда позволит вам увидеть столбцы таблиц и базовые индексы, установленные для каждого \n";
echo "(вывод показан на Рисунке 24.9):</p>\n";
echo "<pre>SELECT a.tname, a.cname, iname, cposition\n";
echo "FROM SYSTEMCOLUMNS a, SYSTEMINDEXES b\n";
echo "WHERE a.tabowner = b. tabowner\n";
echo "   AND a.tname = b.tname\n";
echo "   AND a.cnumber = b.cnumber\n";
echo "ORDER BY 3 DESC, 2;</pre>\n";
echo "<p>Она показывает два индекса: один - для таблицы Заказчиков и один - для таблицы Продавцов.\n";
echo "Последний из них это одностолбцовый индекс с именем salesno в поле snum; он был помещён первым из-за сортировки по убыванию (в обратном \n";
echo "алфавитном порядке) в столбце iname. Другой индекс, custsale, используется продавцами, чтобы отыскивать своих заказчиков. Он основывается на комбинации полей snum и cnum внутри таблицы Заказчиков с полем snum,\n";
echo "приходящим в индексе первым, как это и показано с помощью поля cposition.</p>\n";
echo "<pre> ===============  SQL Execution Log ================\n";
echo "|                                                   |\n";
echo "| SELECT a.tname, a.cname, iname, cposition         |\n";
echo "| FROM  SYSTEMCOLUMNS a, SYSTEMINDEXES b            |\n";
echo "| WHERE a.tabowner = b.tabowner                     |\n";
echo "| AND a.tname = b.tname                             |\n";
echo "| AND a.cnumber = b.cnumber                         |\n";
echo "| ORDER BY 3 DESC, 2;                               |\n";
echo "|                                                   |\n";
echo "| ================================================= |\n";
echo "|    tname        cname   iname     cposition       |\n";
echo "|   -----------  -------  --------  ------------    |\n";
echo "|   Salespeople   sname   salesno              1    |\n";
echo "|   Customers     cnum    custsale             2    |\n";
echo "|   Customers     snum    custsale             1    |\n";
echo "|                                                   |\n";
echo " ===================================================\n";
echo "\n";
echo "	 Рисунок 24.9 Столбцы и их индексы</pre>\n";
echo "<p>Подзапросы также могут быть использованы. Имеется способ увидеть данные столбца только для столбцов из таблиц каталога:</p>\n";
echo "<pre>SELECT *\n";
echo "FROM SYSTEMCOLUMNS\n";
echo "WHERE tname IN\n";
echo "(SELECT tname\n";
echo "    FROM SYSTEMCATALOG);</pre>\n";
echo "<p>Для упрощения мы не будем показывать вывод этой команды, которая состоит из одного входа для каждого столбца каждой таблицы каталога. Вы могли бы \n";
echo "поместить этот запрос в представление, назвав его, например, SYSTEMTABCOLS, для представления SYSTEMTABLES.</p>\n";
echo "<a name=\"24.12\"></a>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Итак, система SQL использует набор таблиц, называемый системным каталогом, в структуре базы данных. Эти таблицы могут запрашиваться, но \n";
echo "не модифицироваться. Кроме того, вы можете добавлять комментарии столбцов в (и удалять их из) таблицы SYSTEMCATALOG и SYSTEMCOLUMNS.</p>\n";
echo "<p>Создание представлений в этих таблицах - превосходный способ точно определить, какая пользовательская информация может быть доступной.</p>\n";
echo "<p>Теперь, когда вы узнали о каталоге, вы завершили ваше обучение SQL в диалоговом режиме. <a href=\"ch25.php\">Следующая глава</a> этой книги расскажет вам, как\n";
echo "SQL используется в программах, которые написаны  на других языках, но которые способны извлечь пользу из возможностей SQL, взаимодействуя с его таблицами баз данных.</p>\n";
echo "<a name=\"24.13\"></a>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<pre>1. Сделайте запрос каталога, чтобы вывести для каждой таблицы, имеющей\n";
echo "   более чем четыре столбца, имя таблицы, имя владельца, а также \n";
echo "   имена столбцов и тип данных этих столбцов.\n";
echo "\n";
echo "2. Сделайте запрос каталога, чтобы выяснить, сколько синонимов существует\n";
echo "   для каждой таблицы в базе данных. Не забудьте, что один и тот же \n";
echo "   синоним, принадлежащий двум различным пользователям - это фактически два разных синонима.\n";
echo "\n";
echo "3. Выясните, сколько таблиц имеют индексы в более чем пятидесяти процентах их столбцов.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#24\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
