﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");   
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 6.</title></head>\n";
echo "<body><h1>Глава. 6&nbsp; ОБОБЩЕНИЕ ДАННЫХ С ПОМОЩЬЮ АГРЕГАТНЫХ ФУНКЦИЙ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе вы перейдёте о простого использования запросов к извлечению \n";
echo "значений из базы данных (БД) и определите, как можно использовать эти значения, \n";
echo "чтобы получить из них информацию. Это делается с помощью агрегатных (обобщающих) \n";
echo "функций, которые берут группы значений из поля и сводят их до одиночного значения.<br>\n";
echo "Вы узнаете, как использовать эти функции, как определить группы значений, к \n";
echo "которым они будут применяться, и как определить, какие группы выбираются для \n";
echo "вывода.<br>\n";
echo "Вы увидите также, при каких условиях вы сможете объединить значения поля с этой полученной информацией в \n";
echo "одном запросе.</p>\n";
echo "<a name=\"6.1\"></a>\n";
echo "<h3>ЧТО ТАКОЕ АГРЕГАТНЫЕ ФУНКЦИИ?</h3>\n";
echo "<p>Запросы могут производить обобщённое групповое значение полей точно так же, как и значение одного поля. Это делается с помощью агрегатных функций. Агрегатные \n";
echo "функции производят одиночное значение для всей группы таблицы.</p><p>Вот список этих функций:</p>\n";
echo "<dl><dt>COUNT</dt><dd>выдаёт количество строк или не-NULL значений полей, которые выбрал запрос.</dd>\n";
echo "<dt>SUM</dt><dd>выдаёт арифметическую сумму всех выбранных значений данного поля.</dd>\n";
echo "<dt>AVG</dt><dd>выдаёт усреднение всех выбранных значений данного поля.</dd>\n";
echo "<dt>MAX</dt><dd>выдаёт наибольшее из всех выбранных значений данного поля.</dd>\n";
echo "<dt>MIN</dt><dd>выдаёт наименьшее из всех выбранных значений данного поля.</dd></dl>\n";
echo "<a name=\"6.2\"></a>\n";
echo "<h3>КАК ИСПОЛЬЗОВАТЬ АГРЕГАТНЫЕ ФУНКЦИИ?</h3>\n";
echo "<p>Агрегатные функции используются, подобно именам полей в предложении SELECT-запроса, но с одним исключением: они берут имена полей как аргументы.</p>\n";
echo "<p>Только числовые поля могут использоваться с SUM и AVG.</p>\n";
echo "<p>С функциями COUNT, MAX и MIN могут использоваться и числовые, и символьные поля.<br>\n";
echo "При использовании с \n";
echo "символьными полями, MAX и MIN будут транслировать их в эквивалент ASCII, который должен сообщать, что MIN будет означать первое, а MAX последнее значение в \n";
echo "алфавитном порядке (алфавитное упорядочивание обсуждается более подробно в <a href=\"ch4.php\">Главе 4</a>).</p>\n";
echo "<p>Чтобы найти SUM всех наших покупок в таблице Заказов, мы можем ввести следующий запрос, с выводом на Рисунке 6.1:</p>\n";
echo "<pre>    SELECT SUM ((amt))\n";
echo "    		FROM Orders;\n";
echo "\n";
echo "\n";
echo "   ===============  SQL Execution Log ============\n";
echo "  |                                               |\n";
echo "  | SELECT SUM (amt)                              |\n";
echo "  | FROM  Orders;                                 |\n";
echo "  | ==============================================|\n";
echo "  |                                               |\n";
echo "  | -------                                       |\n";
echo "  | 26658.4                                       |\n";
echo "  |                                               |\n";
echo "  |                                               |\n";
echo "   ===============================================\n";
echo "\n";
echo "	   Рисунок 6.1 Определение суммы</pre>\n";
echo "<p>Это, конечно, отличается от выбора поля, при котором возвращается одиночное значение, независимо от того, сколько строк находится в таблице. Из-за этого \n";
echo "агрегатные функции и поля не могут выбираться одновременно, если не будет использовано предложение GROUP BY (описанное далее).</p>\n";
echo "<p>Нахождение усреднённой суммы -  похожая операция (вывод следующего запроса показан на Рисунке 6.2):</p>\n";
echo "<pre>    SELECT AVG (amt)\n";
echo "       FROM Orders;\n";
echo "\n";
echo "   ===============  SQL Execution Log ============\n";
echo "  |                                               |\n";
echo "  | SELECT AVG (amt)                              |\n";
echo "  | FROM  Orders;                                 |\n";
echo "  | ==============================================|\n";
echo "  |                                               |\n";
echo "  | -------                                       |\n";
echo "  | 2665.84                                       |\n";
echo "  |                                               |\n";
echo "  |                                               |\n";
echo "   ===============================================\n";
echo "\n";
echo "	 Рисунок 6.2 Выбор средней суммы</pre>\n";
echo "<a name=\"6.3\"></a>\n";
echo "<h3>СПЕЦИАЛЬНЫЙ АТРИБУТ COUNT</h3>\n";
echo "<p>Функция COUNT несколько отличается от всех остальных. Она считает число значений в данном столбце или число строк в таблице. Когда она считает значения столбца, \n";
echo "она используется с DISTINCT, чтобы производить счёт чисел различных значений в данном поле. Мы могли бы использовать её, например, чтобы сосчитать \n";
echo "количество продавцов, описанных в настоящее время  в таблице Заказов (вывод показан на Рисунке 6.3):</p>\n";
echo "<pre>      SELECT COUNT (DISTINCT snum)\n";
echo "	 FROM Orders;</pre>\n";
echo "<h4>ИСПОЛЬЗОВАНИЕ DISTINCT</h4>\n";
echo "<p>Обратите внимание в вышеупомянутом примере, что DISTINCT, сопровождаемый именем поля, с которым он применяется, помещён в круглые скобки, но не сразу после SELECT, как раньше. \n";
echo "Такого использования DISTINCT с COUNT, применяемого к индивидуальным столбцам, требует стандарт ANSI, но большое количество программ не предъявляют такого требования.</p>\n";
echo "<pre>   ===============  SQL Execution Log ============\n";
echo "  |                                               |\n";
echo "  | SELECT COUNT (DISTINCT snum)                  |\n";
echo "  | FROM  Orders;                                 |\n";
echo "  | ==============================================|\n";
echo "  |                                               |\n";
echo "  | -------                                       |\n";
echo "  |       5                                       |\n";
echo "  |                                               |\n";
echo "  |                                               |\n";
echo "   ===============================================\n";
echo "\n";
echo "	 Рисунок 6.3 Подсчет значений поля</pre>\n";
echo "<p>Вы можете выполнять несколько подсчётов (COUNT) в полях с помощью DISTINCT в одиночном запросе, что, как мы видели в <a href=\"ch3.php\">Главе 3</a>, \n";
echo "не выполнялось, когда вы выбирали строки с помощью DISTINCT.<br>DISTINCT может использоваться таким образом с любой агрегатной функцией, но наиболее часто он \n";
echo "используется с COUNT. С MAX и MIN это просто не будет иметь никакого эффекта, а SUM и AVG вы обычно применяете для включения повторяемых значений, так как они \n";
echo "эффективнее общих и средних значений всех столбцов.</p>\n";
echo "<h4>ИСПОЛЬЗОВАНИЕ COUNT СО СТРОКАМИ, А НЕ ЗНАЧЕНИЯМИ</h4>\n";
echo "<p>Чтобы подсчитать общее число строк в таблице, используйте функцию COUNT со звёздочкой вместо имени поля, как  в следующем примере, вывод из которого показан на Рисунке 6.4:</p>\n";
echo "<pre>SELECT COUNT (*)\n";
echo " FROM Customers</pre>\n";
echo "<p>COUNT со звёздочкой включает и NULL, и дубликаты; по этой причине DISTINCT не может быть использован. DISTINCT может производить более высокие числа, чем COUNT особого поля, который удаляет все</p>\n";
echo "<pre>   ===============  SQL Execution Log ============\n";
echo "  |                                               |\n";
echo "  | SELECT COUNT (*)                              |\n";
echo "  | FROM  Customers;                              |\n";
echo "  | ==============================================|\n";
echo "  |                                               |\n";
echo "  | -------                                       |\n";
echo "  |       7                                       |\n";
echo "  |                                               |\n";
echo "  |                                               |\n";
echo "   ===============================================\n";
echo "\n";
echo "     Рисунок 6.4 Подсчет строк вместо значений</pre>\n";
echo "<p>строки, имеющие избыточные или NULL-данные в этом поле. DISTINCT неприменим c COUNT (*), потому что он не имеет никакого действия в хорошо разработанной и \n";
echo "поддерживаемой БД. В такой БД не должно быть ни таких строк, которые  являлись бы полностью пустыми, ни дубликатов (первые не содержат \n";
echo "никаких данных, а последние полностью избыточны). Если всё-таки имеются полностью пустые или избыточные строки, вы, вероятно, не захотите, \n";
echo "чтобы COUNT скрыл от вас эту информацию.</p>\n";
echo "<h4>ВКЛЮЧЕНИЕ ДУБЛИКАТОВ В АГРЕГАТНЫЕ ФУНКЦИИ</h4>\n";
echo "<p>Агрегатные функции могут также (в большинстве реализаций) использовать аргумент ALL, который помещается перед именем поля, подобно DISTINCT, но означает \n";
echo "противоположное: включать дубликаты. ANSI технически не позволяет этого для COUNT, но многие реализации ослабляют это ограничение.</p>\n";
echo "<p>Различия между ALL и * при использовании с COUNT:</p>\n";
echo "<ul><li>ALL использует имя поля как аргумент.</li><li>ALL не может подсчитать  NULL-значения.</li></ul>\n";
echo "<p>Пока * является единственным аргументом который включает NULL-значения, и только он используется с COUNT; функции, кроме COUNT, игнорируют  NULL-значения \n";
echo "в любом случае.</p>\n";
echo "<p>Следующая команда подсчитает (COUNT) число не-NULL-значений в поле rating в таблице Заказчиков (включая повторения):</p>\n";
echo "<pre>     SELECT COUNT (ALL rating)\n";
echo "	FROM Customers;</pre>\n";
echo "<a name=\"6.4\"></a>\n";
echo "<h3>АГРЕГАТЫ, ПОСТРОЕННЫЕ НА СКАЛЯРНОМ ВЫРАЖЕНИИ</h3>\n";
echo "<p>До этого вы использовали агрегатные функции с одиночными полями как аргументами. Вы можете также использовать агрегатные функции с аргументами, \n";
echo "которые состоят из скалярных выражений, включающих одно или более полей. (Если вы это делаете, DISTINCT не разрешается.)</p>\n";
echo "<p>Предположим, что таблица Заказов имеет ещё один столбец, который хранит предыдущий неуплаченный баланс (поле blnc) \n";
echo "для каждого заказчика. Вы должны найти этот текущий баланс добавлением суммы приобретений к предыдущему балансу.</p>\n";
echo "<p>Вы можете найти наибольший неуплаченный баланс следующим образом:</p>\n";
echo "<pre>             SELECT MAX (blnc + (amt))\n";
echo "                FROM Orders;</pre>\n";
echo "<p>Для каждой строки таблицы этот запрос будет складывать blnc и amt для данного заказчика и выбирать самое большое значение, \n";
echo "которое он найдёт. Конечно, пока заказчики могут иметь несколько заказов, их неуплаченный баланс оценивается \n";
echo "отдельно для каждого заказа. Возможно, заказ с более поздней датой будет иметь самый большой неуплаченный баланс. Иначе старый баланс должен быть выбран, как в запросе выше.</p>\n";
echo "<p>Фактически имеется большое количество ситуаций в SQL, где можно использовать скалярные выражения с полями или вместо полей, как вы увидите в\n";
echo "<a href=\"ch7.php\">Главе 7</a>.<a name=\"6.5\"></a></p>\n";
echo "<h3>ПРЕДЛОЖЕНИЕ GROUP BY</h3>\n";
echo "<p>Предложение GROUP BY позволяет вам определять подмножество значений в особом поле в терминах другого поля и применять агрегатную функцию  к подмножеству. Это \n";
echo "дает  возможность объединять поля и агрегатные функции в едином предложении SELECT.</p>\n";
echo "<p>Например, предположим, что вы хотите найти наибольшую сумму продажи, полученную каждым продавцом. Вы можете сделать раздельный запрос для каждого из \n";
echo "них, выбрав MAX (amt) из таблицы Заказов для каждого значения поля snum. GROUP BY, однако, позволит вам поместить  всё в одну команду:</p>\n";
echo "<pre>                 SELECT snum, MAX (amt)\n";
echo "                    FROM Orders\n";
echo "                    GROUP BY snum;\n";
echo "</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 6.5.</p>\n";
echo "<pre>           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT snum, MAX (amt)                          |\n";
echo "          | FROM  Orders                                    |\n";
echo "          | GROUP BY snum;                                  |\n";
echo "          | =============================================== |\n";
echo "          |  snum                                           |\n";
echo "          |  ------   --------                              |\n";
echo "          |   1001      767.19                              |\n";
echo "          |   1002     1713.23                              |\n";
echo "          |   1003       75.75                              |\n";
echo "          |   1014     1309.95                              |\n";
echo "          |   1007     1098.16                              |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "Рисунок 6.5 Нахождение максимальной суммы продажи у каждого продавца</pre>\n";
echo "<p>GROUP BY применяет агрегатные функции, независимо от серий групп, которые определяются с помощью значения поля в целом. В этом случае каждая группа \n";
echo "состоит из всех строк с тем же самым значением поля snum, и MAX функция применяется отдельно для каждой такой группы. Это значение поля, к которому \n";
echo "применяется GROUP BY, имеет, по определению, только одно значение на группу вывода так же, как это делает агрегатная функция. Результатом является \n";
echo "совместимость, которая позволяет агрегатам и полям объединяться таким образом.</p>\n";
echo "<p>Вы можете также использовать GROUP BY с несколькими полями. Совершенствуя вышеупомянутый пример, предположим, что вы хотите увидеть наибольшую сумму \n";
echo "продаж, получаемую каждым продавцом каждый день. Чтобы сделать это, вы должны сгруппировать таблицу Заказов по датам продавцов и применить функцию MAX к каждой такой группе:</p>\n";
echo "<pre>          SELECT snum, odate, MAX ((amt))\n";
echo "              FROM Orders\n";
echo "              GROUP BY snum, odate;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 6.6.</p>\n";
echo "<pre>           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT snum, odate, MAX (amt)                   |\n";
echo "          | FROM  Orders                                    |\n";
echo "          | GROUP BY snum, odate;                           |\n";
echo "          | =============================================== |\n";
echo "          |   snum        odate                             |\n";
echo "          |  ------     ----------     --------             |\n";
echo "          |   1001      10/03/1990       767.19             |\n";
echo "          |   1001      10/05/1990      4723.00             |\n";
echo "          |   1001      10/06/1990      9891.88             |\n";
echo "          |   1002      10/03/1990      5160.45             |\n";
echo "          |   1002      10/04/1990        75.75             |\n";
echo "          |   1002      10/06/1990      1309.95             |\n";
echo "          |   1003      10/04/1990      1713.23             |\n";
echo "          |   1014      10/03/1990      1900.10             |\n";
echo "          |   1007      10/03/1990      1098.16             |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "Рисунок 6.6 Нахождение наибольшей суммы приобретений на каждый день</pre>\n";
echo "<p>Конечно же, пустые группы в дни, когда текущий продавец не имел заказов, не будут показаны в выводе.<a name=\"6.6\"></a></p>\n";
echo "<h3>ПРЕДЛОЖЕНИЕ HAVING</h3>\n";
echo "<p>Предположим, что в предыдущем примере вы хотели бы увидеть только максимальную сумму приобретений, значение которой выше $3000.00. Вы не сможете \n";
echo "использовать агрегатную функцию в предложении WHERE (если вы не используете подзапрос, описанный позже), потому что предикаты оцениваются в терминах \n";
echo "одиночной строки, а агрегатные функции оцениваются в терминах групп строк. Это означает, что вы не сможете сделать что-нибудь подобно следующему:</p>\n";
echo "<pre>              SELECT snum, odate, MAX (amt)\n";
echo "                 FROM Orders\n";
echo "                 WHERE MAX ((amt)) &gt; 3000.00\n";
echo "                 GROUP BY snum, odate;</pre>\n";
echo "<p>Это будет отклонением от строгой интерпретации ANSI. Чтобы увидеть максимальную стоимость приобретений свыше $3000.00, вы можете использовать \n";
echo "предложение HAVING.</p><p>Предложение HAVING определяет критерии, используемые, чтобы удалять \n";
echo "определенные группы из вывода, точно так же, как предложение WHERE делает это для отдельных строк.</p><p>Правильной командой будет следующая:</p>\n";
echo "<pre>                SELECT snum, odate, MAX ((amt))\n";
echo "                    FROM Orders\n";
echo "                    GROUP BY snum, odate\n";
echo "                    HAVING MAX ((amt)) &gt; 3000.00;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 6. 7.</p>\n";
echo "<pre>           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT snum, odate, MAX (amt)                   |\n";
echo "          | FROM  Orders                                    |\n";
echo "          | GROUP BY snum, odate                            |\n";
echo "          | HAVING MAX (amt) &gt; 3000.00;                     |\n";
echo "          | =============================================== |\n";
echo "          |   snum        odate                             |\n";
echo "          |  ------     ----------     --------             |\n";
echo "          |   1001      10/05/1990      4723.00             |\n";
echo "          |   1001      10/06/1990      9891.88             |\n";
echo "          |   1002      10/03/1990      5160.45             |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "	     Рисунок 6.7 Удаление групп агрегатных значений</pre>\n";
echo "<p>Аргументы в предложении HAVING следуют тем же самым правилам, что и в предложении SELECT, состоящем из команд, использующих GROUP BY. Они должны иметь \n";
echo "одно значение на группу вывода.</p>\n";
echo "<p>Следующая команда будет запрещена:</p>\n";
echo "<pre>     SELECT snum, MAX (amt)\n";
echo "        FROM Orders\n";
echo "        GROUP BY snum\n";
echo "        HAVING odate = 10/03/1988;</pre>\n";
echo "<p>Поле оdate не может быть вызвано предложением HAVING, потому что оно может иметь (и действительно имеет) больше чем одно значение на группу вывода. Чтобы \n";
echo "избегать такой ситуации, предложение HAVING должно ссылаться только на агрегаты и поля, выбранные GROUP BY. Имеется правильный способ сделать вышеупомянутый запрос (вывод показан на Рисунке 6.8):</p>\n";
echo "<pre>             SELECT snum, MAX (amt)\n";
echo "                FROM Orders\n";
echo "                WHERE odate = 10/03/1990\n";
echo "                GROUP BY snum;\n";
echo "\n";
echo "\n";
echo "           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT snum, odate, MAX (amt)                   |\n";
echo "          | FROM  Orders                                    |\n";
echo "          | GROUP BY snum, odate;                           |\n";
echo "          | =============================================== |\n";
echo "          |   snum                                          |\n";
echo "          |  ------     --------                            |\n";
echo "          |   1001        767.19                            |\n";
echo "          |   1002       5160.45                            |\n";
echo "          |   1014       1900.10                            |\n";
echo "          |   1007       1098.16                            |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "Рисунок 6.8 Максимальное значение суммы продаж у каждого продавца на 3 октября</pre>\n";
echo "<p>Поскольку поля odate нет, не может быть и выбранных полей, и значение этих данных меньше, чем в некоторых других примерах. Вывод должен, вероятно, включать \n";
echo "что-нибудь такое, что говорит: &quot;это - самые большие заказы на 3 октября&quot;. В <a href=\"ch7.php\">Главе 7</a> мы покажем, как вставлять текст в ваш вывод.</p>\n";
echo "<p>Как говорилось ранее, HAVING может использовать только аргументы, которые имеют одно значение на группу вывода. Практически ссылки на агрегатные функции \n";
echo "- наиболее общие, но и поля, выбранные с помощью GROUP BY, также допустимы. Например, мы хотим увидеть наибольшие заказы для Serres и Rifkin:</p>\n";
echo "<pre>              SELECT snum, MAX (amt)\n";
echo "                 FROM Orders\n";
echo "                 GROUP BY snum\n";
echo "                 HAVING snum B (1002,1007);</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 6.9.</p>\n";
echo "<pre>           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT snum, MAX (amt)                          |\n";
echo "          | FROM  Orders                                    |\n";
echo "          | GROUP BY snum                                   |\n";
echo "          | HAVING snum IN (1002, 1007);                    |\n";
echo "          | =============================================== |\n";
echo "          |   snum                                          |\n";
echo "          |  ------     --------                            |\n";
echo "          |   1002       5160.45                            |\n";
echo "          |   1007       1098.16                            |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "	Рисунок 6.9 Использование HAVING с полями GROUP BY<a name=\"6.7\"></a></pre>\n";
echo "<h3>НЕ ДЕЛАЙТЕ ВЛОЖЕННЫХ АГРЕГАТОВ</h3>\n";
echo "<p>В строгой интерпретации ANSI SQL вы не можете использовать агрегат агрегата. \n";
echo "Предположим, что вы хотите выяснить, в какой день имелась наибольшая сумма \n";
echo "продаж. Если вы попробуете сделать так,</p>\n";
echo "<pre>              SELECT odate, MAX (SUM (amt))\n";
echo "                 FROM Orders\n";
echo "                 GROUP BY odate;</pre>\n";
echo "<p>то ваша команда будет, вероятно, отклонена. (Некоторые реализации не предписывают этого ограничения, \n";
echo "что выгодно, потому что вложенные \n";
echo "агрегаты могут быть очень полезны, даже если они и несколько проблематичны.) В вышеупомянутой команде, например, SUM должен применяться к каждой группе поля odate, а MAX \n";
echo "- ко всем группам, производящим одиночное значение для всех групп. Однако предложение GROUP BY подразумевает, что должна иметься одна строка вывода для каждой группы поля odate.<a name=\"6.8\"></a></p>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы используете запросы несколько по-иному. Способность получать, а не просто размещать значения, очень мощна. Это означает, что вы не обязательно \n";
echo "должны следить за определённой информацией, если вы можете сформулировать запрос так, чтобы её получить. Запрос будет давать вам поминутные результаты, в то время \n";
echo "как таблица общего или среднего значений будет хороша только некоторое время после её модификации. Это не должно наводить на мысль, что агрегатные функции \n";
echo "могут полностью вытеснить потребность в отслеживании информации, такой, например, как эта.</p>\n";
echo "<p>Вы можете применять эти агрегаты для групп значений, определённых предложением GROUP BY. Эти группы имеют значение поля в целом и могут постоянно находиться \n";
echo "внутри других групп, которые имеют значение поля в целом. В то же время, предикаты ещё используются, чтобы определять, какие строки агрегатной функции применяются.</p>\n";
echo "<p>Объединенные вместе, эти особенности делают возможным производить агрегаты, основанные на \n";
echo "чётко определённых подмножествах значений в поле. Затем вы можете \n";
echo "определять другое условие для исключения определенных результатов групп с предложением HAVING.</p>\n";
echo "<p>Теперь, когда вы стали знатоком  того, как запрос производит значения, мы покажем вам, в Главе 7, чт&#x0301;о вы можете \n";
echo "делать со значениями, которые он производит.<a name=\"6.9\"></a></p>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<ol><li><pre>Напишите запрос, который сосчитал бы все суммы продаж на 3 октября.</pre></li>\n";
echo "<li><pre>Напишите запрос, который сосчитал бы число различных не-NULL-значений поля\n";
echo "city в таблице Заказчиков.</pre></li>\n";
echo "<li><pre>Напишите запрос, который выбрал бы наименьшую сумму для каждого заказчика.</pre></li>\n";
echo "<li><pre>Напишите запрос, который выбирал бы в алфавитном порядке заказчиков, чьи имена\n";
echo "начинаются с буквы G.</pre></li>\n";
echo "<li><pre>Напишите запрос, который выбрал бы высший рейтинг в каждом городе.</pre></li>\n";
echo "<li><pre>Напишите запрос, который сосчитал бы число заказчиков, регистрирующих каждый\n";
echo "день свои заказы. (Если продавец имел более одного заказа<span lang=\"en-us\"> </span>в данный день,\n";
echo "он должен учитываться только один раз.)</pre></li></ol>\n";
echo "<pre>(См. ответы в <a href=\"a.php#6\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>  
