﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 9.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 9. ОБЪЕДИНЕНИЕ ТАБЛИЦЫ С СОБОЙ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В <a href=\"ch8.php\">Главе 8</a> мы рассмотрели, как объединить две или более таблиц. \n";
echo "Интересно, что та же самая методика может \n";
echo "использоваться для объединения двух копий одной таблицы. В этой главе мы будем исследовать этот процесс. Как вы \n";
echo "увидите, объединение таблицы с \n";
echo "самой собой - далеко не простая вещь и может быть очень полезна для определения некоторых видов связей между  данными в конкретной таблице.</p>\n";
echo "<a name=\"9.1\"></a>\n";
echo "<h3>КАК ВЫПОЛНИТЬ ОБЪЕДИНЕНИЕ ТАБЛИЦЫ С СОБОЙ?</h3>\n";
echo "<p>Для объединения таблицы с собой вы можете сделать каждую строку таблицы одновременно и комбинацией её с собой, и комбинацией с каждой другой строкой \n";
echo "таблицы. Вы затем оцениваете каждую комбинацию в терминах предиката так же, как в объединениях нескольких таблиц. Это позволит  легко создавать определенные виды \n";
echo "связей между различными позициями внутри одной таблицы с помощью обнаружения, \n";
echo "например, пар строк со значением поля.</p>\n";
echo "<p>Вы можете  представить объединение таблицы с собой как объединение двух копий одной и той же таблицы. Таблица на самом деле не копируется, но SQL выполняет \n";
echo "команду так, как если бы это было сделано. Другими словами: это такое же объединение, как и любое другое объединение между двум таблицами, за исключением \n";
echo "того, что в данном случае обе таблицы идентичны.</p>\n";
echo "<a name=\"9.2\"></a>\n";
echo "<h3>ПСЕВДОНИМЫ</h3>\n";
echo "<p>Синтаксис команды для объединения таблицы с собой - тот же, что и для объединения нескольких таблиц. Когда вы объединяете \n";
echo "таблицу с собой, все одинаковые имена столбца дополняются префиксами имени таблицы. Чтобы ссылаться к этим столбцам внутри запроса, вы должны иметь два \n";
echo "различных имени для этой таблицы.</p><p>Вы можете сделать это с помощью определения временных имён, называемых &quot;переменными диапазона&quot;, \n";
echo "&quot;переменными корреляции&quot; или просто &quot;псевдонимами&quot;.</p><p>Вы определяете их в предложении FROM запроса. Это очень просто: вы \n";
echo "вводите \n";
echo "имя таблицы, оставляете пробел, а затем указываете псевдоним для неё.</p><p>Вот пример, который находит все пары заказчиков, имеющих один и тот же \n";
echo "рейтинг (вывод показан на Рисунке 9.1):</p>\n";
echo "<pre>            SELECT first.cname, second.cname, first.rating\n";
echo "               FROM Customers first, Customers second\n";
echo "               WHERE first.rating = second.rating;\n";
echo "\n";
echo "\n";
echo "            ===============  SQL Execution Log ==============\n";
echo "           |                                                 |\n";
echo "           |    Giovanni     Giovanni                  200   |\n";
echo "           |    Giovanni     Liu                       200   |\n";
echo "           |    Liu          Giovanni                  200   |\n";
echo "           |    Liu          Liu                       200   |\n";
echo "           |    Grass        Grass                     300   |\n";
echo "           |    Grass        Cisneros                  300   |\n";
echo "           |    Clemens      Hoffman                   100   |\n";
echo "           |    Clemens      Clemens                   100   |\n";
echo "           |    Clemens      Pereira                   100   |\n";
echo "           |    Cisneros     Grass                     300   |\n";
echo "           |    Cisneros     Cisneros                  300   |\n";
echo "           |    Pereira      Hoffman                   100   |\n";
echo "           |    Pereira      Clemens                   100   |\n";
echo "           |    Pereira      Pereira                   100   |\n";
echo "           |                                                 |\n";
echo "             ===============================================\n";
echo "\n";
echo "		 Рисунок 9.1 Объединение таблицы с собой</pre>\n";
echo "<p>(Обратите внимание, что на Рисунке 9.1, как и в некоторых дальнейших примерах, полный запрос не может уместиться в окне вывода и, следовательно, будет \n";
echo "усекаться.)</p><p>В вышеприведённой команде, SQL ведёт себя так, как если бы он соединял две \n";
echo "таблицы, называемые 'first' и 'second'. Обе они - фактически - таблица Заказчика, но псевдонимы разрешают им быть обработанными независимо. Псевдонимы &#39;first&#39; и \n";
echo "&#39;second&#39; были установлены в предложении FROM запроса сразу после имени  таблицы.</p><p>Обратите внимание, что псевдонимы могут использоваться в предложении SELECT, даже если они не определены в предложении FROM.\n";
echo "Это очень удобно. SQL будет сначала принимать любые такие псевдонимы на веру, но будет отклонять команду, если они не определены далее в предложении FROM \n";
echo "запроса.</p><p>Псевдоним существует, только пока команда выполняется!</p><p>Когда запрос заканчивается, псевдонимы, используемые в нём, больше не имеют \n";
echo "никакого значения.</p><p>Теперь, когда имеются две копии таблицы Заказчиков, чтобы работать с ними, SQL может обрабатывать эту операцию точно так же, как и любое другое объединение: \n";
echo "берёт каждую строку из одного псевдонима и сравнивает её с каждой строкой из другого псевдонима.</p>\n";
echo "<a name=\"9.3\"></a>\n";
echo "<h3>УСТРАНЕНИЕ ИЗБЫТОЧНОСТИ</h3>\n";
echo "<p>Обратите внимание, что наш вывод имеет два значения для каждой комбинации, причем второй раз \n";
echo "- в обратном порядке. Это потому что каждое значение показано \n";
echo "первый раз в каждом псевдониме, а второй раз (симметрично) - в предикате. Следовательно, значение A в псевдониме сначала выбирается в комбинации со \n";
echo "значением B во втором псевдониме, а затем значение A во втором псевдониме выбирается в комбинации со значением B в первом псевдониме. В нашем примере, \n";
echo "Hoffman выбран вместе с Clemens, а затем Clemens выбран вместе с Hoffman. Тот же самый случай \n";
echo "- с Cisneros и Grass, Liu и Giovanni, и так далее. Кроме того, \n";
echo "каждая строка была сравнена сама с собой, чтобы вывести строки, такие как Liu и Liu. Простой способ избежать этого - \n";
echo "установить порядок на два \n";
echo "значения так, чтобы одно могло быть меньше, чем другое, или предшествовать ему в алфавитном порядке. Это делает предикат асимметричным, поэтому те же самые \n";
echo "значения в обратном порядке не будут выбраны снова, например:</p>\n";
echo "<pre>            SELECT first.cname, second.cname, first.rating\n";
echo "               FROM Customers first, Customers second\n";
echo "               WHERE first.rating = second.rating\n";
echo "                  AND first.cname &lt; second.cname;</pre>\n";
echo "<p>Вывод этого запроса показан на Рисунке 9.2.</p>\n";
echo "<p>Hoffman предшествует Pereira в алфавитном порядке, поэтому комбинация удовлетворяет обоим условиям предиката и появляется в выводе. Когда та же сама \n";
echo "комбинация появляется в обратном порядке - когда Pereira в псевдониме первой таблицы сравнивается с Hoffman во второй таблице псевдонима - второе условие не \n";
echo "выполняется. Аналогично Hoffman не выбирается при наличии того же рейтинга, что и у него самого, потому что его имя не предшествует ему самому в алфавитном порядке. Если \n";
echo "бы вы захотели включить сравнение строк с ними же самими</p>\n";
echo "<pre>              ===============  SQL Execution Log ==============\n";
echo "             |                                                 |\n";
echo "             | SELECT first.cname, second.cname, first.rating  |\n";
echo "             | FROM  Customers first, Customers second         |\n";
echo "             | WHERE first.rating = second.rating              |\n";
echo "             | AND first.cname &lt; second.cname                  |\n";
echo "             | =============================================== |\n";
echo "             |   cname      cname     rating                   |\n";
echo "             |  -------  ---------   -------                   |\n";
echo "             |  Hoffman    Pereira       100                   |\n";
echo "             |  Giovanni   Liu           200                   |\n";
echo "             |  Clemens    Hoffman       100                   |\n";
echo "             |  Pereira    Pereira       100                   |\n";
echo "             |  Gisneros   Grass         300                   |\n";
echo "              =================================================\n";
echo "\n";
echo "	Рисунок 9.2 Устранение избыточности вывода в объединении с собой</pre>\n";
echo "<p>в запросах, подобно этому, вы могли бы просто использовать &lt; = вместо &lt;.</p>\n";
echo "<a name=\"9.4\"></a>\n";
echo "<h3>ПРОВЕРКА ОШИБОК</h3>\n";
echo "<p>Таким образом, мы можем использовать эту особенность SQL для проверки определенных видов ошибок. При просмотре таблицы \n";
echo "Заказов вы  видите, что \n";
echo "поля cnum и snum должны иметь постоянную связь. Так как каждый заказчик должен быть назначен  одному, и только одному, продавцу, каждый раз, когда определенный \n";
echo "номер заказчика появляется в таблице Заказов, он должен совпадать с таким же номером продавца.</p>\n";
echo "<p>Следующая команда будет определять любые несогласованности в этой области:</p>\n";
echo "<pre>             SELECT first.onum, tirst.cnum, first.snum,\n";
echo "              second.onum, second.cnum,second.snum\n";
echo "                FROM Orders first, Orders second\n";
echo "                WHERE first.cnum = second.cnum\n";
echo "                  AND first.snum &lt; &gt; second.snum;</pre>\n";
echo "<p>Хотя это выглядит сложно, логика  достаточно проста. Команда будет брать первую строку таблицы Заказов, запоминать её под первым псевдонимом и \n";
echo "проверять её в комбинации с каждой строкой таблицы Заказов под вторым псевдонимом, одну за другой. Если комбинация строк удовлетворяет предикату, она \n";
echo "выбирается для вывода. В этом случае предикат будет рассматривать эту строку, найдёт строку, где поле cnum=2008, а поле snum=1007, и затем рассмотрит каждую \n";
echo "следующую строку с тем же самым значением поля cnum. Если он находит, что какая-то из \n";
echo "них имеет значение, отличное от значения поля snum, предикат будет верен, и \n";
echo "выведет выбранные поля из текущей комбинации строк. Если же значение snum с данным значением cnum в нашей таблице совпадает, эта команда не произведет никакого вывода.</p>\n";
echo "<a name=\"9.5\"></a>\n";
echo "<h3>БОЛЬШЕ ПСЕВДОНИМОВ</h3>\n";
echo "<p>Хотя объединение таблицы с собой это первая ситуация, когда ясна необходимость наличия псевдонимов, вы не ограничены в их использовании тем, чтобы только \n";
echo "отличать копию одной таблицы от её оригинала. Вы можете использовать псевдонимы в любое время, когда вы хотите создать альтернативные имена для ваших таблиц в \n";
echo "команде. Например, если ваши таблицы имеют очень длинные и сложные имена, вы могли бы определить простые односимвольные псевдонимы, типа a и b, и \n";
echo "использовать их вместо имён таблиц в предложении SELECT и предикате. Они будут также использоваться с соотнесенными подзапросами (обсуждаемыми в <a href=\"ch11.php\">Главе 11</a>).</p>\n";
echo "<a name=\"9.6\"></a>\n";
echo "<h3>КОМПЛЕКСНЫЕ ОБЪЕДИНЕНИЯ</h3>\n";
echo "<p>Вы можете использовать любое количество псевдонимов для одной таблицы в запросе, хотя использование более двух в данном предложении SELECT * будет излишним. \n";
echo "Предположим, что вы ещё не назначили ваших заказчиков  вашему продавцу. Компания должна назначить каждому продавцу первоначально трёх заказчиков, по одному для \n";
echo "каждого рейтингового значения. Вы лично можете решить, какого заказчика какому продавцу назначить, но следующий запрос вы используете, чтобы увидеть все \n";
echo "возможные комбинации заказчиков, которые вы можете назначать (вывод показан на Рисунке 9.3):</p>\n";
echo "<pre>             SELECT a.cnum, b.cnum, c.cnum\n";
echo "                 FROM Customers a, Customers b, Customers c\n";
echo "                 WHERE a.rating = 100\n";
echo "                   AND b.rating = 200\n";
echo "                   AND c.rating = 300;\n";
echo "\n";
echo "              ===============  SQL Execution Log ==============\n";
echo "             |                                                 |\n";
echo "             | AND c.rating = 300;                             |\n";
echo "             | =============================================== |\n";
echo "             |   cnum       cnum        cnum                   |\n";
echo "             |  -----      ------     ------                   |\n";
echo "             |   2001       2002        2004                   |\n";
echo "             |   2001       2002        2008                   |\n";
echo "             |   2001       2003        2004                   |\n";
echo "             |   2001       2003        2008                   |\n";
echo "             |   2006       2002        2004                   |\n";
echo "             |   2006       2002        2008                   |\n";
echo "             |   2006       2003        2004                   |\n";
echo "             |   2006       2003        2008                   |\n";
echo "             |   2007       2002        2004                   |\n";
echo "             |   2007       2002        2008                   |\n";
echo "             |   2007       2003        2004                   |\n";
echo "             |   2007       2003        2008                   |\n";
echo "              =================================================\n";
echo "\n";
echo "Рисунок 9.3 Комбинация пользователей с различными значениями рейтинга</pre>\n";
echo "<p>Как  видите, этот запрос находит все комбинации заказчиков с тремя значениями оценки, поэтому первый столбец состоит из заказчиков с оценкой 100, \n";
echo "второй - с 200, и последний - с оценкой 300. Они повторяются во всех возможных комбинациях. Это сортировка \n";
echo "с группировкой, которая не может быть выполнена с GROUP BY или ORDER BY, поскольку они сравнивают значения только в одном столбце \n";
echo "вывода.</p><p>Вы должны также понимать, что не всегда обязательно использовать в \n";
echo "предложении SELECT каждый псевдоним или таблицу, которые упомянуты в предложении FROM \n";
echo "запроса. Иногда предложение или таблица становятся запрашиваемыми исключительно потому, что они могут вызываться в предикате запроса. Например, \n";
echo "следующий запрос находит всех заказчиков, размещённых в городах, где продавец Serres (snum 1002) имеет заказчиков (вывод показан на Рисунке 9.4):</p>\n";
echo "<pre>                    SELECT b.cnum, b.cname\n";
echo "                       FROM Customers a, Customers b\n";
echo "                       WHERE a.snum = 1002\n";
echo "                          AND b.city = a.city;\n";
echo "\n";
echo "\n";
echo "              ===============  SQL Execution Log ============\n";
echo "             |                                               |\n";
echo "             | SELECT b.cnum, b.cname                        |\n";
echo "             | FROM  Customers a, Customers b                |\n";
echo "             | WHERE a.snum = 1002                           |\n";
echo "             | AND b.city = a.city;                          |\n";
echo "             | ==============================================|\n";
echo "             |   cnum     cname                              |\n";
echo "             | ------   ---------                            |\n";
echo "             |   2003     Liu                                |\n";
echo "             |   2008     Cisneros                           |\n";
echo "             |   2004     Grass                              |\n";
echo "               =============================================\n";
echo "\n";
echo "	Рисунок 9.4 Нахождение заказчиков в городах относящихся к Serres</pre>\n";
echo "<p>Псевдоним a будет делать предикат неверным, за исключением случая, когда его значение столбца snum = 1002. Таким образом, псевдоним опускает всё, кроме \n";
echo "заказчиков продавца Serres. Псевдоним b будет верным для всех строк с тем же самым значением города, что и текущее значение города для a; в ходе запроса \n";
echo "строка псевдонима b будет верна один раз, когда значение города представлено в a. Нахождение этих строк псевдонима b - единственная цель псевдонима a, поэтому мы \n";
echo "не выбираем все столбцы подряд. Как вы можете видеть, собственные заказчики Serres выбираются при нахождении их в том же самом городе, что и он сам, поэтому \n";
echo "выбор их из псевдонима a не обязателен. Короче говоря, псевдоним находит строки заказчиков Serres, Liu и Grass. Псевдоним b находит всех заказчиков, размещенных \n";
echo "в любом из их городов (San Jose и Berlin, соответственно), включая, конечно, самих Liu и Grass.</p>\n";
echo "<p>Вы можете также создать объединение, которое включает и различные таблицы, и псевдонимы одиночной таблицы. Следующий запрос объединяет таблицу Пользователей \n";
echo "с собой, чтобы найти все пары заказчиков, обслуживаемых одним продавцом. В то же самое время этот запрос объединяет заказчика с таблицей Продавцов с именем \n";
echo "этого продавца (вывод показан на Рисунке 9.5):</p>\n";
echo "<pre>        SELECT sname, Salespeople.snum, first.cname\n";
echo "        second.cname\n";
echo "           FROM Customers first, Customers second, Salespeople\n";
echo "           WHERE first.snum = second.snum\n";
echo "              AND Salespeople.snum = first.snum\n";
echo "              AND first.cnum &lt; second.cnum;\n";
echo "\n";
echo "\n";
echo "              ===============  SQL Execution Log ==================\n";
echo "             |                                                     |\n";
echo "             | SELECT cname, Salespeople.snum, first.cname         |\n";
echo "             | second.cname                                        |\n";
echo "             | FROM Customers first, Customers second, Salespeople |\n";
echo "             | WHERE first.snum  = second.snum                     |\n";
echo "             | AND Salespeople.snum = first.snum                   |\n";
echo "             | AND first.cnum &lt; second.cnum;                       |\n";
echo "             | ====================================================|\n";
echo "             |  cname      snum        cname       cname           |\n";
echo "             |  ------   ------      --------    --------          |\n";
echo "             |  Serres     1002        Liu         Grass           |\n";
echo "             |  Peel       1001        Hoffman     Clemens         |\n";
echo "              =====================================================\n";
echo "\n";
echo "	Рисунок 9.5 Объединение таблицы с собой и с другой таблицей</pre>\n";
echo "<a name=\"9.7\"></a>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы понимаете возможности объединения и можете использовать их для ограничения связей с \n";
echo "этой же таблицей, между различными таблицами, или в обоих случаях. \n";
echo "Вы  видели некоторые варианты объединения при использовании его возможностей.</p>\n";
echo "<p>Вы теперь познакомились с терминами \n";
echo "&quot;порядковые переменные&quot;, \n";
echo "&quot;корреляционные переменные&quot; и &quot;предложения&quot; (эта терминология будет меняться от продукта к продукту, так что мы предлагаем вам познакомится со всеми тремя \n";
echo "терминами). Кроме того, вы поняли, немного, как в действительности работают запросы.</p>\n";
echo "<p>Следующим шагом, после комбинации нескольких таблиц или нескольких копий одной таблицы в запросе, будет комбинация \n";
echo "нескольких запросов, где \n";
echo "один запрос будет производить вывод, который будет затем управлять работой другого запроса. Это другое мощное средство SQL, о котором мы расскажем в <a href=\"ch10.php\">Главе 10</a> и более детально - в последующих главах.</p>\n";
echo "<a name=\"9.8\"></a>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<ol><li><pre>Напишите запрос, который вывел бы все пары продавцов, живущих в одном и том же городе.\n";
echo "Исключите комбинации продавцов с самими собой, а также дубликаты строк,\n";
echo "выводимых в обратным порядке.</pre></li>\n";
echo "<li><pre>Напишите запрос, который выведет все пары заказов по данным заказчикам, имена\n";
echo "этих заказчиков и исключит дубликаты из вывода, как в предыдущем вопросе.</pre></li>\n";
echo "<li><pre>Напишите запрос, который вывел бы имена (cname) и города (city) всех заказчиков.</pre></li></ol>\n";
echo "<pre>(Ответы см. в <a href=\"a.php\">Приложении А</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
