﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 13.</title></head>\n";
echo "<body>\n";
echo "<blockquote>\n";
echo "<h1>Глава 13. Использование операторов<br>\n";
echo "ANY, ALL и SOME</h1>\n";
echo "<hr width=\"50%\">\n";
echo "</blockquote>\n";
echo "<p>Теперь, когда вы овладели оператором EXISTS, вы узнаете о трёх специальных \n";
echo "операторах, ориентируемых на подзапросы. (Фактически имеются только два, так как \n";
echo "ANY и SOME - одно и то же.) Если вы поймёте работу этих операторов, вы будете \n";
echo "понимать все типы подзапросов предиката, используемых в SQL. Кроме того, вам \n";
echo "будут представлены различные способы того, как данный запрос может быть \n";
echo "сформирован с использованием различных типов подзапросов предиката, и вы поймёте \n";
echo "преимущества и недостатки каждого из этих подходов.</p>\n";
echo "<p>ANY, ALL и SOME напоминают EXISTS, принимая подзапросы как аргументы; однако \n";
echo "они отличаются от EXISTS тем, что используются совместно с реляционными \n";
echo "операциями. В этом отношении они напоминают оператор IN, когда тот используется \n";
echo "с подзапросами: они берут все значения, выведенные подзапросом и обрабатывают их \n";
echo "как модуль. Однако, в отличие от IN, они могут использоваться только с \n";
echo "подзапросами.</p>\n";
echo "<h3><a name=\"13.1\">С</a>ПЕЦИАЛЬНЫЕ ОПЕРАТОРЫ ANY ИЛИ SOME</h3>\n";
echo "<p>Операторы SOME и ANY взаимозаменяемы везде, и там, где мы используем ANY, \n";
echo "SOME будет работать точно так же. Различие в терминологии состоит в том, чтобы \n";
echo "позволить людям использовать тот термин, который является однозначным. Это может \n";
echo "создать проблему, поскольку, как мы это увидим, наша интуиция может иногда \n";
echo "вводить в заблуждение.</p>\n";
echo "<p>Вот новый способ нахождения продавцов с заказчиками, размещенными в их \n";
echo "городах (вывод для этого запроса&nbsp;показан на Рисунке 13.1):</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Salespeople\n";
echo "               WHERE city = ANY\n";
echo "                  (SELECT city\n";
echo "                     FROM Customers);</pre>\n";
echo "<p>Оператор ANY берёт все значения, выведенные подзапросом, (для этого случая \n";
echo "это все значения city в таблице Заказчиков), и оценивает их как верные, если \n";
echo "любое (ANY) из них равняется значению города текущей строки внешнего запроса.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Salespeople                             |\n";
echo "              | WHERE city = ANY                              |\n";
echo "              | (SELECT  city                                 |\n";
echo "              | FROM Customers);                              |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city         comm        |\n";
echo "              |  -----    --------   ----       --------      |\n";
echo "              |   1001    Peel       London         0.12      |\n";
echo "              |   1002    Serres     San Jose       0.13      |\n";
echo "              |   1004    Motika     London         0.11      |\n";
echo "                =============================================\n";
echo "\n";
echo "		Рисунок 13.1 Использование оператора ANY</pre>\n";
echo "<p>Это означает, что подзапрос должен выбирать значения такого же типа, что и \n";
echo "те, которые сравниваются в основном предикате. В этом его отличие от EXISTS, \n";
echo "который просто определяет, производит ли подзапрос результаты или нет, и \n";
echo "фактически не использует эти результаты.</p>\n";
echo "<h3><a name=\"13.2\">И</a>СПОЛЬЗОВАНИЕ IN ИЛИ EXISTS ВМЕСТО ANY</h3>\n";
echo "<p>Мы можем также использовать оператор IN для создания запроса, аналогичного \n";
echo "предыдущему:</p>\n";
echo "<pre>             SELECT *\n";
echo "                FROM Salespeople\n";
echo "                WHERE city IN\n";
echo "                    (SELECT city\n";
echo "                         FROM Customers);</pre>\n";
echo "<p>Этот запрос даст вывод, показанный на Рисунке 13.2.</p>\n";
echo "<p>Однако оператор ANY может использовать другие реляционные операторы, помимо \n";
echo "равно (=), и, таким образом, делать сравнения, которые превосходят возможности \n";
echo "IN. Например, мы могли бы найти всех продавцов с их заказчиками, которые следуют \n";
echo "в алфавитном порядке (вывод показан на Рисунке 13.3).</p>\n";
echo "<pre>             SELECT *\n";
echo "                FROM Salespeople\n";
echo "                WHERE sname &lt; ANY\n";
echo "                   (SELECT cname\n";
echo "                       FROM Customers);\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Salespeople                             |\n";
echo "              | WHERE city IN                                 |\n";
echo "              | (SELECT  city                                 |\n";
echo "              | FROM Customers);                              |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city         comm        |\n";
echo "              |  -----    --------   ----       --------      |\n";
echo "              |   1001    Peel       London         0.12      |\n";
echo "              |   1002    Serres     San Jose       0.13      |\n";
echo "              |   1004    Motika     London         0.11      |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 13.2 Использование IN в качестве альтернативы ANY\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Salespeople                             |\n";
echo "              | WHERE sname &lt; ANY                             |\n";
echo "              | (SELECT  cname                                |\n";
echo "              | FROM Customers);                              |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city         comm        |\n";
echo "              |  -----    --------   ----       --------      |\n";
echo "              |   1001    Peel       London         0.12      |\n";
echo "              |   1004    Motika     London         0.11      |\n";
echo "              |   1003    Axelrod    New York       0.10      |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 13.3 Использование оператора ANY с операцией &quot;меньше&quot; (&lt;)</pre>\n";
echo "<p>продавцов для их заказчиков, которые упорядочены в алфавитном порядке (вывод \n";
echo "показан на Рисунке 13.3).</p>\n";
echo "<pre>             SELECT *\n";
echo "                FROM Salespeople\n";
echo "                WHERE sname &lt; ANY\n";
echo "                   (SELECT cname\n";
echo "                       FROM Customers);</pre>\n";
echo "<p>Все строки были выбраны для Serres и Rifkin, потому что нет других \n";
echo "заказчиков, чьи имена следовали бы за ними в алфавитном порядке. Обратите \n";
echo "внимание, что это является основным эквивалентом следующему запросу с EXISTS, \n";
echo "вывод которого показан на Рисунке 13.4:</p>\n";
echo "<pre>             SELECT *\n";
echo "                 FROM Salespeople outer\n";
echo "                 WHERE EXISTS\n";
echo "                     (SELECT *\n";
echo "                          FROM Customers inner\n";
echo "                          WHERE outer.sname &lt; inner.cname);\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Salespeople outer                       |\n";
echo "              | WHERE EXISTS                                  |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers inner                          |\n";
echo "              | WHERE outer.sname &lt; inner.cname);             |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city         comm        |\n";
echo "              |  -----    --------   ----       --------      |\n";
echo "              |   1001    Peel       London         0.12      |\n";
echo "              |   1004    Motika     London         0.11      |\n";
echo "              |   1003    Axelrod    New York       0.10      |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 13.4 Использование EXISTS как альтернативы оператору ANY</pre>\n";
echo "<p>Любой запрос, который может быть сформулирован с ANY (или, как мы увидим, с \n";
echo "ALL),&nbsp; мог бы быть сформулирован также с EXISTS, хотя обратное будет неверно. \n";
echo "Строго говоря, вариант с EXISTS не абсолютно идентичен вариантам с ANY или с ALL \n";
echo "из-за различия в обработке пустых (NULL) значений (что будет обсуждаться позже в \n";
echo "этой главе). Тем не менее, с технической точки зрения, вы могли бы делать это без ANY и ALL, если проявите находчивость в использовании EXISTS (и IS NULL).</p>\n";
echo "<p>Большинство пользователей, однако, находят ANY и ALL более удобными в \n";
echo "использовании, чем EXISTS, который требует соотнесённых подзапросов. Кроме того, \n";
echo "в зависимости от реализации, ANY и ALL могут, по крайней мере в теории, быть \n";
echo "более эффективными, чем EXISTS. Подзапросы ANY или ALL могут выполняться один \n";
echo "раз и иметь вывод, используемый, чтобы определять предикат для каждой строки \n";
echo "основного запроса. EXISTS, с другой стороны, берёт соотнесенный подзапрос, \n";
echo "который требует, чтобы весь подзапрос повторно выполнялся для каждой строки \n";
echo "основного запроса. SQL пытается найти наиболее эффективный способ выполнения \n";
echo "любой команды и может попробовать преобразовать менее эффективную формулу \n";
echo "запроса в более эффективную (но вы не можете всегда рассчитывать на получение \n";
echo "самой эффективной формулировки).</p>\n";
echo "<p>Основная причина для формулировки EXISTS как альтернативы ANY и ALL в том, \n";
echo "что ANY и ALL могут быть несколько неоднозначны из-за способа использования \n";
echo "этого термина в английском языке, как вы это скоро увидите. С приходом понимания \n";
echo "различия способов формулирования данного запроса, вы сможете поработать над \n";
echo "процедурами, которые сейчас кажутся вам трудными или неудобными.</p>\n";
echo "<h3><a name=\"13.3\">К</a>АК ANY МОЖЕТ СТАТЬ НЕОДНОЗНАЧНЫМ?</h3>\n";
echo "<p>Как говорилось выше, ANY не полностью однозначен. Если мы создаём запрос, \n";
echo "чтобы выбрать заказчиков, которые имеют больший рейтинг, чем любой заказчик в \n";
echo "Риме, мы можем получить вывод, который несколько отличается от того, что мы \n";
echo "ожидали (как показано в Рисунке 13.5):</p>\n";
echo "<pre>          SELECT *\n";
echo "              FROM Customers\n";
echo "              WHERE rating &gt; ANY\n";
echo "                  (SELECT rating\n";
echo "                      FROM Customers\n";
echo "                      WHERE city = Rome);</pre>\n";
echo "<p>В английском языке способ, которым мы обычно склонны интерпретировать оценку \n";
echo "&quot;больше, чем любой (где city = Rome) &quot;, должен вам сообщить, что это значение \n";
echo "оценки должно быть выше, чем значение оценки в каждом случае, где значение city \n";
echo "= Rome. Однако это не так в случае с ANY, используемом в SQL. ANY оценивает как \n";
echo "true, если подзапрос находит любое значение, которое делает условие верным.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE rating &gt; ANY                            |\n";
echo "              | (SELECT rating                                |\n";
echo "              | FROM Customers                                |\n";
echo "              | WHERE city = 'Rome');                         |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city     rating   snum   |\n";
echo "              |  -----    --------   ----     ------  ------  |\n";
echo "              |   2002    Giovanni   Rome        200    1003  |\n";
echo "              |   2003    Liu        San Jose    200    1002  |\n";
echo "              |   2004    Grass      Berlin      300    1002  |\n";
echo "              |   2008    Cisneros   San Jose    300    1007  |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 13.5 Как операция &quot;больше&quot;(&gt;) интерпретируется ANY</pre>\n";
echo "<p>Если мы оценим ANY способом, использующим грамматику английского языка, то \n";
echo "только заказчики с оценкой 300 будут превышать Giovanni, который находится в \n";
echo "Риме и имеет оценку 200. Однако подзапрос ANY также находит Pereira в Риме с \n";
echo "оценкой 100. Так как все заказчики с оценкой 200 были выше этой, они будут \n";
echo "выбраны, даже если имелся другой заказчик из Рима (Giovanni), чья оценка не была \n";
echo "выше (фактически то, что один из выбранных заказчиков также находится в Риме, \n";
echo "несущественно). Так как подзапрос произвел по крайней мере одно значение, \n";
echo "которое сделает предикат верным в отношении этих строк, строки были выбраны. \n";
echo "Чтобы дать другой пример, предположим, что мы должны были выбирать все заказы на \n";
echo "сумму, которая была больше, чем по крайней мере один из заказов на 6-е октября:</p>\n";
echo "<pre>               SELECT *\n";
echo "                   FROM Orders\n";
echo "                   WHERE amt &gt; ANY\n";
echo "                        (SELECT amt\n";
echo "                             FROM Orders\n";
echo "                             WHERE odate = 10/06/1990);</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 13.6.</p>\n";
echo "<p>Даже если самая высокая сумма приобретений в таблице (9891.88) имелась на 6-е \n";
echo "октября, предыдущая строка имеет более высокое значение суммы, чем другая строка \n";
echo "на 6-е октября, которая имела значение суммы = 1309.95. Имея реляционную \n";
echo "операцию &quot;&gt;=&quot;&nbsp; вместо просто &quot; &gt; &quot;, эта строка будет также выбрана, потому что \n";
echo "она равна самой себе.</p>\n";
echo "<p>Конечно, вы можете использовать ANY с другой SQL-техникой, например, с \n";
echo "техникой объединения.</p>\n";
echo "<p>Этот запрос будет находить все заказы со значением суммы \n";
echo "меньше, чем значение любой суммы для заказчика в San Jose (вывод показан на \n";
echo "Рисунке 13.7):</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Orders\n";
echo "               WHERE amt &lt; ANY\n";
echo "                   (SELECT amt\n";
echo "                        FROM Orders A, Customers b\n";
echo "                        WHERE a.cnum = b.cnum\n";
echo "                            AND b.city = &quot; San Jose');</pre>\n";
echo "<p>Даже если наименьший заказ в таблице был для заказчика из San Jose, то был \n";
echo "второй наибольший; следовательно, почти все строки будут выбраны. Простой \n";
echo "запомните, что &lt; ANY это значение, меньшее, чем наибольшее выбранное значение, \n";
echo "а &gt; ANY - значение, большее, чем наименьшее выбранное значение.</p>\n";
echo "<pre>               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders                                    |\n";
echo "              | WHERE amt &gt; ANY                                 |\n";
echo "              | (SELECT amt                                     |\n";
echo "              | FROM Orders                                     |\n";
echo "              | WHERE odate = 10/06/1990);                      |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----    --------  ----------  -----   ------  |\n";
echo "              |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "              |   3005     5160.45  10/03/1990   2003     1002  |\n";
echo "              |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "              |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "              |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "                ================================================\n";
echo "\n";
echo "	Рисунок 13.6 Выбрано значение, большее чем любое (ANY) на 6-е октября\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | WHERE amt &gt; ANY                                 |\n";
echo "              | (SELECT amt                                     |\n";
echo "              | FROM Orders a, Customers b                      |\n";
echo "              | WHERE a.cnum = b.cnum                           |\n";
echo "              | AND b.city = 'San Jose');                       |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----    --------  ----------  -----   ------  |\n";
echo "              |   3001       18.69  10/03/1990   2008     1007  |\n";
echo "              |   3003      767.10  10/03/1990   2001     1001  |\n";
echo "              |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "              |   3006     1098.10  10/03/1990   2008     1007  |\n";
echo "              |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "              |   3007       75.10  10/04/1990   2004     1002  |\n";
echo "              |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "              |   3010     1309.88  10/06/1990   2004     1002  |\n";
echo "                ================================================\n";
echo "\n";
echo "		 Рисунок 13.7 Использование ANY с объединением</pre>\n";
echo "<p>Фактически вышеуказанные команды весьма похожи на следующие (вывод показан на \n";
echo "Рисунке 13.8):</p>\n";
echo "<pre>             SELECT *\n";
echo "                 FROM Orders\n";
echo "                 WHERE amt &lt;\n";
echo "                    (SELECT MAX amt\n";
echo "                        FROM Orders A, Customers b\n";
echo "                        WHERE a.cnum = b.cnum\n";
echo "                             AND b.city = &quot; San Jose');\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | WHERE amt &lt;                                     |\n";
echo "              | (SELECT MAX (amt)                               |\n";
echo "              | FROM Orders a, Customers b                      |\n";
echo "              | WHERE a.cnum = b.cnum                           |\n";
echo "              | AND b.city = 'San Jose');                       |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----    --------  ----------  -----   ------  |\n";
echo "              |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "              |   3005     5160.45  10/03/1990   2003     1002  |\n";
echo "              |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "              |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "              |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "                ================================================\n";
echo "\n";
echo "	Рисунок 13.8 Использование агрегатной функции вместо ANY</pre>\n";
echo "<h3><a name=\"13.4\">С</a>ПЕЦИАЛЬНЫЙ ОПЕРАТОР ALL</h3>\n";
echo "<p>С помощью ALL, предикат будет верным, если каждое значение, выбранное \n";
echo "подзапросом, удовлетворяет условию в предикате внешнего запроса. Если мы хотим \n";
echo "пересмотреть наш предыдущий пример, чтобы вывести только тех заказчиков, чьи \n";
echo "оценки фактически выше, чем у каждого заказчика в Париже, мы можем ввести \n";
echo "следующее, чтобы получить вывод, показанный в Рисунке 13.9:</p>\n";
echo "<pre>             SELECT *\n";
echo "                FROM Customers\n";
echo "                WHERE rating &gt; ALL\n";
echo "                    (SELECT rating\n";
echo "                        FROM Customers\n";
echo "                        WHERE city = Rome):\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE rating &gt; ALL                            |\n";
echo "              | (SELECT rating                                |\n";
echo "              | FROM Customers                                |\n";
echo "              | WHERE city = 'Rome');                         |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city     rating   snum   |\n";
echo "              |  -----    --------   ----     ------  ------  |\n";
echo "              |   2004    Grass      Berlin      300    1002  |\n";
echo "              |   2008    Cisneros   San Jose    300    1007  |\n";
echo "                ============================================\n";
echo "\n";
echo "		Рисунок 13.9 Использование оператора ALL</pre>\n";
echo "<p>Этот оператор проверяет значения рейтинга всех заказчиков в Риме. Затем он \n";
echo "находит заказчиков с оценкой, большей, чем у любого из заказчиков в Риме. Самая \n";
echo "высокая оценка в Риме - у Giovanni (200). Следовательно, выбираются только \n";
echo "значения выше  200.</p>\n";
echo "<p>Как и в случае с ANY, мы можем использовать EXISTS для  создания \n";
echo "альтернативной формулировки такого же запроса (вывод показан на Рисунке 13.10):</p>\n";
echo "<pre>          SELECT *\n";
echo "             FROM Customers outer\n";
echo "             WHERE NOT EXISTS\n";
echo "                (SELECT *\n";
echo "                   FROM Customers inner\n";
echo "                   WHERE outer.rating &lt; = inner.rating\n";
echo "                   AND inner.city = 'Rome');\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers outer                         |\n";
echo "              | WHERE NOT EXISTS                              |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers inner                          |\n";
echo "              | WHERE outer rating = inner.rating             |\n";
echo "              | AND inner.city = 'Rome');                     |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city     rating   snum   |\n";
echo "              |  -----    --------   ----     ------  ------  |\n";
echo "              |   2004    Grass      Berlin      300    1002  |\n";
echo "              |   2008    Cisneros   San Jose    300    1007  |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 13.10 Использование EXISTS в качестве альтернативы ALL</pre>\n";
echo "<h3><a name=\"13.5\">Р</a>АВЕНСТВА И НЕРАВЕНСТВА</h3>\n";
echo "<p>ALL чаще используется с неравенствами, нежели с равенствами, так как значение \n";
echo "может быть &quot;равным для всех&quot; результатом подзапроса, только если все результаты \n";
echo "фактически идентичны. Посмотрите на следующий запрос:</p>\n";
echo "<pre>              SELECT *\n";
echo "                 FROM Customers\n";
echo "                 WHERE rating = ALL\n";
echo "                    (SELECT rating\n";
echo "                        FROM Customers\n";
echo "                        WHERE city = &quot; San Jose');</pre>\n";
echo "<p>Эта команда допустима, но с этими данными мы не получим никакого вывода. \n";
echo "Только в единственном случае вывод будет выдан этим запросом - если все значения \n";
echo "оценки в San Jose окажутся идентичными. В этом случае можно сказать следующее:</p>\n";
echo "<pre>              SELECT *\n";
echo "                 FROM Customers\n";
echo "                 WHERE rating =\n";
echo "                      (SELECT DISTINCT rating\n";
echo "                         FROM Customers\n";
echo "                         WHERE city = &quot; San Jose');</pre>\n";
echo "<p>Основное различие в том, что эта последняя команда должна потерпеть неудачу, \n";
echo "если подзапрос выведет много значений, в то время как вариант с ALL просто не \n";
echo "даст никакого вывода. В общем, не самая удачная идея - использовать запросы, \n";
echo "которые работают только в определённых ситуациях, подобно этой. Так как ваша БД \n";
echo "будет постоянно меняться, это неудачный способ узнать о её содержании. Однако ALL может более эффективно использоваться с неравенствами, то есть с операцией \n";
echo "&quot;&lt; &gt;&quot;. Но учтите, что сказанное в SQL о значении, которое не равняется всем \n";
echo "результатам подзапроса, будет отличаться от того же, но сказанного с учётом \n";
echo "грамматики английского языка. Очевидно, если подзапрос&nbsp; возвращает много \n";
echo "различных значений, как это обычно бывает, ни одно отдельное значение не может \n";
echo "быть равно им всем в обычном смысле. В SQL выражение &lt; &gt; ALL в действительности \n";
echo "означает &quot;не равен любому&quot; результату подзапроса. Другими словами, предикат \n";
echo "верен, если данное значение не найдено среди результатов подзапроса. \n";
echo "Следовательно, наш предыдущий пример противоположен по смыслу этому примеру (с \n";
echo "выводом, показанным на Рисунке 13.11):</p>\n";
echo "<pre>          SELECT *\n";
echo "             FROM Customers\n";
echo "             WHERE rating &lt; &gt; ALL\n";
echo "             (SELECT rating\n";
echo "                  FROM Customers\n";
echo "                  WHERE city = &quot; San Jose');\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE rating &lt; &gt; ALL                          |\n";
echo "              | (SELECT rating                                |\n";
echo "              | FROM Customers                                |\n";
echo "              | WHERE city = 'San Jose');                     |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city     rating   snum   |\n";
echo "              |  -----    --------   ----     ------  ------  |\n";
echo "              |   2001    Hoffman    London      100    1001  |\n";
echo "              |   2006    Clemens    London      100    1001  |\n";
echo "              |   2007    Pereira    Rome        100    1004  |\n";
echo "                =============================================\n";
echo "\n";
echo "		   Рисунок 13.11 Использование ALL с &lt; &gt;</pre>\n";
echo "<p>Вышеупомянутый подзапрос выбирает все оценки для города San Jose. Он выводит \n";
echo "набор из двух значений: 200 (для Liu) и 300 (для Cisneros). Затем основной \n";
echo "запрос выбирает все строки с оценкой, не совпадающей ни с одной из них, другими \n";
echo "словами - все строки с оценкой 100. Вы можете сформулировать тот же самый запрос \n";
echo "с помощью операторов NOT IN:</p>\n";
echo "<pre>                 SELECT*\n";
echo "                    FROM Customers\n";
echo "                    WHERE rating NOT IN\n";
echo "                        (SELECT rating\n";
echo "                            FROM Customers\n";
echo "                            WHERE city = &quot; San Jose');</pre>\n";
echo "<p>Вы могли бы также использовать оператор ANY:</p>\n";
echo "<pre>          SELECT *\n";
echo "             FROM Customers\n";
echo "             WHERE NOT rating = ANY\n";
echo "                  (SELECT rating\n";
echo "                       FROM Customers\n";
echo "                       WHERE city = &quot; San Jose');</pre>\n";
echo "<p>Вывод будет одинаков для всех трёх условий.</p>\n";
echo "<h3><a name=\"13.6\">П</a>РАВИЛЬНОЕ ПОНИМАНИЕ ANY И ALL</h3>\n";
echo "<p>В SQL, сказать, что значение больше (или меньше), чем любое (ANY) из набора \n";
echo "значений - то же самое, что сказать, что оно больше (или меньше), чем любое \n";
echo "отдельное из этих значений. И наоборот, сказать, что значение не равно всему \n";
echo "(ALL) набору значений, это то же, что сказать, что нет такого значения в наборе \n";
echo "которому оно равно.</p>\n";
echo "<h3><a name=\"13.7\">К</a>АК ANY, ALL И EXIST ПОСТУПАЮТ С ОТСУТСТВУЮЩИМИ И НЕИЗВЕСТНЫМИ ДАННЫМИ?</h3>\n";
echo "<p>Как было сказано, имеются некоторые различия между EXISTS и операторами, \n";
echo "представленными в этой главе, в том, как они обрабатывают оператор NULL. ANY и \n";
echo "ALL также отличаются друг от друга тем, как они реагируют, если подзапрос не \n";
echo "произвел никаких значений, чтобы использовать их в сравнении. Эти различия могут \n";
echo "привести к непредвиденным результатам в ваших запросах, если вы не будете их \n";
echo "учитывать.</p>\n";
echo "<h3><a name=\"13.8\">К</a>ОГДА ПОДЗАПРОС ВОЗВРАЩАЕТСЯ ПУСТЫМ?</h3>\n";
echo "<p>Одно существенное различие между ALL и ANY - способ действия в ситуации, \n";
echo "когда подзапрос не возвращает никаких значений. В принципе всякий раз, когда \n";
echo "допустимый подзапрос не в состоянии сделать вывод, ALL автоматически правилен, а \n";
echo "ANY автоматически неправилен. Это означает, что следующий запрос</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Customers\n";
echo "               WHERE rating &gt; ANY\n";
echo "                  (SELECT rating\n";
echo "                      FROM Customers\n";
echo "                      WHERE city = Boston);</pre>\n";
echo "<p>не произведет никакого вывода, в то время как запрос</p>\n";
echo "<pre>               SELECT\n";
echo "                  FROM Customers\n";
echo "                  WHERE rating &gt; ALL\n";
echo "                     (SELECT rating\n";
echo "                          FROM Customers\n";
echo "                          WHERE city = 'Boston');</pre>\n";
echo "<p>выведет всю таблицу Заказчиков. Когда нет никаких заказчиков в Boston, \n";
echo "естественно, ни одно из этих сравнений не имеет значения.</p>\n";
echo "<h3><a name=\"13.9\">A</a>NY И ALL ВМЕСТО EXISTS С NULL</h3>\n";
echo "<p>Значения NULL также имеют некоторые проблемы с операторами вроде этих. Когда \n";
echo "SQL сравнивает два значения в предикате, одно из которых пустое (NULL), то \n";
echo "результат неизвестен (смотрите <a href=\"ch5.php\">Главу 5</a>). Неизвестный \n";
echo "предикат подобен неверному и является причиной того, что строка не выбирается, \n";
echo "но работать он будет иначе в некоторых похожих запросах, в зависимости от того, \n";
echo "используют они ALL или ANY вместо EXISTS.</p>\n";
echo "<p>Рассмотрим наш предыдущий пример:</p>\n";
echo "<pre>             SELECT *\n";
echo "                FROM Customers\n";
echo "                WHERE rating &gt; ANY\n";
echo "                    (SELECT rating\n";
echo "                        FROM Customers\n";
echo "                        WHERE city = 'Rome');</pre>\n";
echo "<p>и ещё один пример:</p>\n";
echo "<pre>          SELECT *\n";
echo "              FROM Customers outer\n";
echo "              WHERE EXISTS\n";
echo "                 (SELECT *\n";
echo "                     FROM Customers inner\n";
echo "                     WHERE outer.rating &gt; inner.rating\n";
echo "                     AND inner.city = 'Rome');</pre>\n";
echo "<p>В общем, эти два запроса будут вести себя одинаково. Но предположим, что \n";
echo "появилось пустое (NULL) значение в столбце rating таблицы Заказчиков:</p>\n";
echo "<pre>   CNUM        CNAME         CITY        RATING       SNUM\n";
echo "\n";
echo "   2003         Liu          SanJose      NULL        1002</pre>\n";
echo "<p>В варианте с ANY, где оценка Liu выбрана основным запросом, значение NULL \n";
echo "делает предикат неизвестным, а строка Liu не выбирается для вывода. Однако в \n";
echo "варианте с NOT EXISTS, когда эта строка выбрана основным запросом, значение NULL \n";
echo "используется в предикате подзапроса, делая его неизвестным в каждом случае. Это \n";
echo "означает что подзапрос не будет производить никаких значений и EXISTS будет \n";
echo "неправилен. Это, естественно, делает оператор NOT EXISTS верным. Следовательно, \n";
echo "строка Liu будет выбрана для вывода. Это основное расхождение, в отличие от \n";
echo "других типов предикатов, где значение EXISTS, независимо от того, верно оно или \n";
echo "нет, всегда неизвестно. Всё это является аргументом в пользу варианта \n";
echo "формулировки с ANY. Мы не считаем, что значение NULL является выше, чем \n";
echo "допустимое значение. Более того, результат будет тот же, если мы будем проверять \n";
echo "для более низкого значения.</p>\n";
echo "<h3><a name=\"13.10\">И</a>СПОЛЬЗОВАНИЕ COUNT ВМЕСТО EXISTS</h3>\n";
echo "<p>Подчеркнём, что все формулировки с ANY и ALL могут быть в точности выполнены \n";
echo "с EXISTS, в то время как обратное будет неверно. Хотя в этом случае также верно \n";
echo "и то, что подзапросы EXISTS и NOT EXISTS могут проколоть при выполнении тех же \n";
echo "самых подзапросов с COUNT(*) в предложении SELECT подзапроса. Если больше чем \n";
echo "ноль строк в выводе будет подсчитано, это эквивалентно EXISTS; в противном случае \n";
echo "это работает так же, как NOT EXISTS. Следующее является этому примером (вывод \n";
echo "показан на Рисунке 13.12): </p>\n";
echo "<pre>              SELECT *\n";
echo "                 FROM Customers outer\n";
echo "                 WHERE NOT EXISTS\n";
echo "                     (SELECT *\n";
echo "                         FROM Customers inner\n";
echo "                         WHERE outer.rating &lt; = inner.rating\n";
echo "                           AND inner.city = 'Rome');\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers outer                         |\n";
echo "              | WHERE NOT EXISTS                              |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers inner                          |\n";
echo "              | WHERE outer.rating &lt;= inner.rating            |\n";
echo "              | AND inner.city = 'Rome');                     |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city     rating   snum   |\n";
echo "              |  -----    --------   ----     ------  ------  |\n";
echo "              |   2004    Grass      Berlin      300    1002  |\n";
echo "              |   2008    Cisneros   San Jose    300    1007  |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 13.12 Использование EXISTS с соотнесённым подзапросом</pre>\n";
echo "<p>Это должно также быть выполнено как</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Customers outer\n";
echo "               WHERE 1 &gt;\n";
echo "                   (SELECT COUNT (*)\n";
echo "                        FROM Customers inner\n";
echo "                        WHERE outer.rating &lt; = inner.rating\n";
echo "                           AND inner.city = 'Rome');</pre>\n";
echo "<p>Вывод к этому запросу показан на Рисунке 13.13. Теперь вы начинаете понимать, \n";
echo "сколько способов имеется в SQL. Если это всё кажется несколько сложным на данном \n";
echo "этапе, нет причин волноваться. Вы обучаетесь, чтобы использовать ту технику, \n";
echo "которая больше отвечает вашим требованиям и наиболее понятна для вас. Начиная с \n";
echo "этого места, мы хотим показать вам большое количество возможностей, чтобы вы \n";
echo "могли найти ваш собственный стиль.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers outer                         |\n";
echo "              | WHERE 1 &gt;                                     |\n";
echo "              | (SELECT COUNT (*)                             |\n";
echo "              | FROM Customers inner                          |\n";
echo "              | WHERE outer.rating &lt;= inner.rating            |\n";
echo "              | AND inner.city = 'Rome');                     |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city     rating   snum   |\n";
echo "              |  -----    --------   ----     ------  ------  |\n";
echo "              |   2004    Grass      Berlin      300    1002  |\n";
echo "              |   2008    Cisneros   San Jose    300    1007  |\n";
echo "                =============================================\n";
echo "\n";
echo "		Рисунок 13.13 Использование COUNT вместо EXISTS</pre>\n";
echo "<h3><a name=\"13.11\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Итак, вы узнали много нового в этой главе. Подзапросы - непростая тема, и мы \n";
echo "потратили много времени, чтобы показать их варианты и неоднозначность. То, чему \n";
echo "вы теперь научились, вещи достаточно глубокие. Вы знаете несколько технических \n";
echo "решений одной проблемы, и поэтому  можете выбрать то, которое больше подходит \n";
echo "для ваших целей. Кроме того, вы поняли, как различные формулировки будут \n";
echo "обрабатывать пустые значения (NULL) и ошибки.</p>\n";
echo "<p>Теперь, когда вы полностью изучили запросы - наиболее важный, и, вероятно, \n";
echo "наиболее сложный аспект SQL - другой материал будет относительно прост для \n";
echo "понимания.</p>\n";
echo "<p>У нас есть ещё одна глава о запросах, которая покажет вам, как объединить \n";
echo "вывод любого количества запросов в единое тело с помощью формирования \n";
echo "объединения нескольких запросов, используя оператор UNION.</p>\n";
echo "<h3><a name=\"13.12\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Напишите запрос, который выбирал бы всех заказчиков, чьи оценки\n";
echo "   равны или больше, чем любая (ANY) оценка заказчика Serres.\n";
echo "\n";
echo "2. Что будет выведено вышеупомянутой командой?\n";
echo "\n";
echo "3. Напишите запрос, использующий ANY или ALL, который находил бы всех\n";
echo "   продавцов, которые не имеют никаких заказчиков, живущих в их городе.\n";
echo "\n";
echo "4. Напишите запрос, который выбирал бы все заказы с суммой, больше, чем \n";
echo "   любая (в обычном смысле) для заказчиков в Лондоне.\n";
echo "\n";
echo "5. Напишите предыдущий запрос с использованием MAX.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
