﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 20.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 20. ПРЕДСТАВЛЕНИЕ. ВВЕДЕНИЕ.</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>ПРЕДСТАВЛЕНИЕ (VIEW) (я называю его также &quot;просмотр&quot; - <i>прим. ред.) </i>это \n";
echo "объект данных, который не содержит никаких данных его владельца. Это тип \n";
echo "таблицы, чьё содержание выбирается из других таблиц с помощью выполнения \n";
echo "запроса. По мере изменения значений в  таблицах, эти изменения автоматически \n";
echo "отражаются представлением.</p>\n";
echo "<p>В этой главе вы узнаете, что такое представления, как они создаются, и немного \n";
echo "о их возможностях и ограничениях. Использование представлений, основанных на \n";
echo "улучшенных средствах запросов, таких как объединение и подзапрос, разработанных \n";
echo "очень тщательно, в некоторых случаях даст больший выигрыш по сравнению с запросами.</p>\n";
echo "<h3><a name=\"20.1\">Ч</a>ТО ТАКОЕ ПРЕДСТАВЛЕНИЕ?</h3>\n";
echo "<p>Таблицы, с которыми вы имели дело до сих пор, назывались базовыми таблицами. \n";
echo "Это таблицы, которые содержат данные. Однако имеется другой вид таблиц - \n";
echo "представления. Представления это таблицы, чьё содержание выбирается или \n";
echo "получается из других таблиц. Они работают в запросах и операторах DML точно так \n";
echo "же, как и основные таблицы, но не содержат никаких собственных данных.</p>\n";
echo "<p>Представления подобны окнам, через которые вы просматриваете информацию (как \n";
echo "она есть, или в другой форме, как вы потом увидите), которая реально хранится в \n";
echo "базовой таблице. Представление это фактически запрос, который выполняется всякий \n";
echo "раз, когда представление становится темой команды. Вывод запроса при этом в \n";
echo "каждый момент становится содержанием представления.</p>\n";
echo "<h3><a name=\"20.2\">К</a>ОМАНДА CREATE VIEW</h3>\n";
echo "<p>Вы создаёте представление командой CREATE VIEW. Она состоит из слов CREATE \n";
echo "VIEW (СОЗДАТЬ ПРЕДСТАВЛЕНИЕ), имени представления, которое нужно создать, сл&#x0301;ова AS (КАК) и запроса, как в следующем примере:</p>\n";
echo "<pre>       CREATE VIEW Londonstaff\n";
echo "          AS SELECT *\n";
echo "          FROM Salespeople\n";
echo "          WHERE city = 'London';</pre>\n";
echo "<p>Теперь у вас есть представление Londonstaff. Вы можете \n";
echo "использовать это представление точно так же, как и любую другую таблицу. Может \n";
echo "быть выполнен запрос, модификация, вставка в, удаление из и соединение с другими \n";
echo "таблицами и представлениями.</p>\n";
echo "<p>Давайте сделаем запрос  представления (вывод \n";
echo "показан на Рисунке 20.1):</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Londonstaff;\n";
echo "\n";
echo "\n";
echo "         ===============  SQL Execution Log ============\n";
echo "        |                                               |\n";
echo "        | SELECT *                                      |\n";
echo "        | FROM  Londonstaff;                            |\n";
echo "        |                                               |\n";
echo "        | ==============================================|\n";
echo "        |   snum      sname         city         comm   |\n";
echo "        | ------    ----------   -----------   -------  |\n";
echo "        |   1001      Peel         London       0.1200  |\n";
echo "        |   1004      Motika       London       0.1100  |\n";
echo "        |                                               |\n";
echo "         ===============================================\n";
echo "\n";
echo "	     Рисунок 20.1 Представление Londonstaff</pre>\n";
echo "<p>Когда вы приказываете SQL выбрать (SELECT) все строки (*) из представления, \n";
echo "он выполняет запрос, содержащий в определении Loncfonstaff,&nbsp; и возвращает всё из \n";
echo "его вывода. Имея предикат в запросе представления, можно вывести только те \n";
echo "строки представления, которые будут удовлетворять этому предикату. Вы можете вспомнить, что в <a href=\"ch15.php\">Главе 15</a> вы имели таблицу Londonstaff, в которую вы вставляли это же самое содержимое (конечно, мы \n";
echo "понимаем, что таблица не слишком велика. Если это так, вы должны будете выбрать \n";
echo "другое имя для вашего представления).</p>\n";
echo "<p>Преимущество использования представления, \n";
echo "по сравнению с основной таблицей, в том, что представление будет модифицировано \n";
echo "автоматически всякий раз, когда изменится таблица, лежащая в его основе.</p>\n";
echo "<p>Содержание представления не фиксировано и переназначается каждый раз, когда \n";
echo "вы ссылаетесь на представление в команде. Если вы добавите завтра другого \n";
echo "живущего в Лондоне продавца, он автоматически появится в представлении.</p>\n";
echo "<p>Представления значительно расширяют управление вашими данными. Это \n";
echo "превосходный способ дать публичный доступ к некоторой, но не всей, информации в \n";
echo "таблице. Если вы хотите, чтобы ваш продавец был показан в таблице Продавцов, но \n";
echo "при этом не были показаны комиссионные других продавцов, вы могли бы создать \n";
echo "представление с использованием следующего оператора (вывод показан на Рисунке \n";
echo "20.2):</p>\n";
echo "<pre>       CREATE VIEW Salesown\n";
echo "          AS SELECT snum, sname, city\n";
echo "          FROM Salespeople:\n";
echo "\n";
echo "             ===============  SQL Execution Log ============\n";
echo "            |                                               |\n";
echo "            | SELECT *                                      |\n";
echo "            | FROM  Salesown;                               |\n";
echo "            |                                               |\n";
echo "            | ==============================================|\n";
echo "            |   snum      sname         city                |\n";
echo "            | ------    ----------   -----------            |\n";
echo "            |   1001      Peel         London               |\n";
echo "            |   1002      Serres       San Jose             |\n";
echo "            |   1004      Motika       London               |\n";
echo "            |   1007      Rifkin       Barcelona            |\n";
echo "            |   1003      Axelrod      New York             |\n";
echo "             ===============================================\n";
echo "\n";
echo "		 Рисунок 20.2 Представление Salesown</pre>\n";
echo "<p>Другими словами, это представление - такое же, как для таблицы Продавцов, за \n";
echo "исключением того что поле comm не упоминалось в запросе и, следовательно, не \n";
echo "было включено в представление.</p>\n";
echo "<h3><a name=\"20.3\">М</a>ОДИФИЦИРОВАНИЕ ПРЕДСТАВЛЕНИЙ</h3>\n";
echo "<p>Представление может теперь изменяться командами модификации DML, но \n";
echo "модификация не будет воздействовать на само представление. Команды будут на \n";
echo "самом деле перенаправлены в базовую таблицу:</p>\n";
echo "<pre>         UPDATE Salesown\n";
echo "            SET city = 'Palo Alto'\n";
echo "            WHERE snum = 1004;</pre>\n";
echo "<p>Его действие идентично выполнению той же команды в таблице Продавцов. Однако, \n";
echo "если значение комиссионных продавца будет обработано командой UPDATE</p>\n";
echo "<pre>         UPDATE Salesown\n";
echo "            SET comm = .20\n";
echo "            WHERE snum = 1004;</pre>\n";
echo "<p>она будет отвергнута, так как поле comm отсутствует в представлении Salesown. \n";
echo "Это важное замечание, показывающее, что не все представления могут быть \n";
echo "модифицированы. Мы будем исследовать проблемы модификации представлений в\n";
echo "<a href=\"ch21.php%22\">Главе 21</a>.</p>\n";
echo "<h3><a name=\"20.4\">И</a>МЕНОВАНИЕ СТОЛБЦОВ</h3>\n";
echo "<p>В нашем примере поля наших представлений имеют свои имена, полученные прямо \n";
echo "из имён полей основной таблицы. Это удобно. Однако  вам нужно снабдить \n";
echo "ваши столбцы новыми именами:</p>\n";
echo "<ul><li>когда некоторые столбцы являются выводимыми, и поэтому не имеющими имен.</li>\n";
echo "<li>когда два или более столбцов в объединении имеют те же имена, что в их базовой таблице.</li></ul>\n";
echo "<p>Имена, которые могут стать именами полей, даются в круглых скобках () после \n";
echo "имени таблицы. Они не будут запрошены, если совпадают с именами полей \n";
echo "запрашиваемой таблицы. Тип данных и размер этих полей будут отличаться от \n";
echo "запрашиваемых полей, которые &quot;передаются&quot; в них. Обычно вы не указываете новых \n";
echo "имен полей, но если вы всё-таки сделали это, вы должны делать это для каждого \n";
echo "поля в представлении.</p>\n";
echo "<h3><a name=\"20.5\">К</a>ОМБИНИРОВАНИЕ ПРЕДИКАТОВ ПРЕДСТАВЛЕНИЙ И ОСНОВНЫХ ЗАПРОСОВ В ПРЕДСТАВЛЕНИЯХ</h3>\n";
echo "<p>Когда вы делаете запрос представления, вы, собственно, выполняете запрос. \n";
echo "Основной способ для SQL обойти это - объединить предикаты двух запросов в один. \n";
echo "Давайте посмотрим ещё раз на наше представление Londonstaff:</p>\n";
echo "<pre>         CREATE VIEW Londonstaff\n";
echo "            AS SELECT *\n";
echo "            FROM Salespeople\n";
echo "            WHERE city = 'London';</pre>\n";
echo "<p>Если мы выполняем следующий запрос в этом представлении</p>\n";
echo "<pre>         SELECT *\n";
echo "           FROM Londonstaff\n";
echo "           WHERE comm &gt; .12;</pre>\n";
echo "<p>он будет такой же, как если бы мы выполнили следующее в таблице Продавцов:</p>\n";
echo "<pre>       SELECT *\n";
echo "          FROM Salespeople\n";
echo "          WHERE city = 'London'\n";
echo "          AND comm &gt; .12;</pre>\n";
echo "<p>Это прекрасно, за исключением того что появляется возможная проблема с \n";
echo "представлением. Имеется возможность комбинации из двух полностью допустимых \n";
echo "предикатов и получения предиката, который не будет работать. Например, \n";
echo "предположим, что мы создаем (CREATE) следующее представление:</p>\n";
echo "<pre>       CREATE VIEW Ratingcount (rating, number)\n";
echo "          AS SELECT rating, COUNT (*)\n";
echo "          FROM Customers\n";
echo "          GROUP BY rating;</pre>\n";
echo "<p>Это даёт нам число заказчиков, которое мы имеем для каждого уровня оценки \n";
echo "(rating). Вы можете затем сделать запрос этого представления, чтобы выяснить, \n";
echo "имеется ли какая-нибудь оценка в настоящее время, назначенная для трёх \n";
echo "заказчиков:</p>\n";
echo "<pre>       SELECT *\n";
echo "          FROM Ratingcount\n";
echo "          WHERE number = 3;</pre>\n";
echo "<p>Посмотрим, что случится если мы скомбинируем два предиката:</p>\n";
echo "<pre>       SELECT rating, COUNT (*)\n";
echo "          FROM Customers\n";
echo "          WHERE COUNT (*) = 3\n";
echo "          GROUP BY rating;</pre>\n";
echo "<p>Это недопустимый запрос. Агрегатные функции, такие как COUNT (СЧЕТ), не могут \n";
echo "использоваться в предикате. Правильным способом при формировании вышеупомянутого \n";
echo "запроса, конечно же, будет следующий:</p>\n";
echo "<pre>        SELECT rating, COUNT (*)\n";
echo "           FROM Customers\n";
echo "           GROUP BY rating;\n";
echo "           HAVING COUNT (*) = 3;</pre>\n";
echo "<p>Но SQL может не выполнить превращения. Может ли равноценный запрос вместо \n";
echo "запроса Ratingcount потерпеть неудачу? Да может! Это неоднозначная область SQL, \n";
echo "где методика использования представлений может дать хорошие результаты. Самое \n";
echo "лучшее, что можно сделать в случае, когда об этом ничего не сказано в вашей \n";
echo "системной документации, это попытаться  разобраться.</p>\n";
echo "<p>Если команда \n";
echo "допустима, вы можете использовать представления, чтобы установить некоторые \n";
echo "ограничения SQL в синтаксисе запроса.</p>\n";
echo "<h3><a name=\"20.6\">Г</a>РУППОВЫЕ ПРЕДСТАВЛЕНИЯ</h3>\n";
echo "<p>Групповые представления это представления, наподобие запроса Ratingcount в \n";
echo "предыдущем примере, которые содержат предложение GROUP BY или которые \n";
echo "основываются на других групповых представлениях.</p>\n";
echo "<p>Групповые представления могут стать превосходным способом непрерывной обработки \n";
echo "полученной информации. Предположим, что каждый день вы должны следить \n";
echo "за порядком номеров заказчиков, номерами продавцов принимающих заказы, номерами \n";
echo "заказов, средним количеством заказов и общей суммой приобретений в заказах.</p>\n";
echo "<p>Чем конструировать каждый раз сложный запрос, вы можете просто создать \n";
echo "следующее представление:</p>\n";
echo "<pre>   CREATE VIEW Totalforday\n";
echo "        AS SELECT odate, COUNT (DISTINCT cnum), COUNT\n";
echo "                (DISTINCT snum), COUNT (onum), AVG\n";
echo "                (amt), SUM (amt)\n";
echo "                FROM Orders\n";
echo "        GROUP BY odate;</pre>\n";
echo "<p>Теперь вы сможете увидеть всю эту информацию с помощью простого запроса:</p>\n";
echo "<pre>         SELECT *\n";
echo "            FROM Totalforday;</pre>\n";
echo "<p>Как мы видели, SQL-запросы могут дать вам полный комплекс возможностей, так \n";
echo "что представления обеспечивают вас чрезвычайно гибким и мощным инструментом \n";
echo "чтобы определить точно, как ваши данные могут быть использованы.</p>\n";
echo "<p>Они могут также делать вашу работу более простой, переформатируя данные \n";
echo "удобным для вас способом и исключив двойную работу.</p>\n";
echo "<h3><a name=\"20.7\">П</a>РЕДСТАВЛЕНИЯ И ОБЪЕДИНЕНИЯ</h3>\n";
echo "<p>Представления не требуют, чтобы их вывод осуществлялся из одной базовой \n";
echo "таблицы. Так как почти любой допустимый запрос SQL может быть использован в \n";
echo "представлении, оно может выводить информацию из любого числа базовых таблиц или \n";
echo "из других представлений. Мы можем, например, создать представление, которое \n";
echo "показывало бы заказы продавца и заказчика по имени:</p>\n";
echo "<pre>       CREATE VIEW Nameorders\n";
echo "          AS SELECT onum, amt, a.snum, sname, cname\n";
echo "             FROM Orders a, Customers b, Salespeople c\n";
echo "             WHERE a.cnum = b.cnum\n";
echo "               AND a.snum = c.snum;</pre>\n";
echo "<p>Теперь вы можете выбрать (SELECT) все заказы заказчика или продавца (*), или \n";
echo "можете увидеть эту информацию для любого заказа.</p>\n";
echo "<p>Например, чтобы увидеть все заказы продавца Rifkin, вы должны ввести \n";
echo "следующий запрос (вывод показан на Рисунке 20.3):</p>\n";
echo "<pre>          SELECT *\n";
echo "             FROM Nameorders\n";
echo "             WHERE sname = 'Rifkin';\n";
echo "\n";
echo "\n";
echo "            ===============  SQL Execution Log ==============\n";
echo "           |                                                 |\n";
echo "           | SELECT *                                        |\n";
echo "           | FROM  Nameorders                                |\n";
echo "           | WHERE sname = 'Rifkin';                         |\n";
echo "           | =============================================== |\n";
echo "           |   onum       amt       snum   sname     cname   |\n";
echo "           |  ------   --------    -----  -------   -------  |\n";
echo "           |   3001       18.69     1007  Rifkin    Cisneros |\n";
echo "           |   3006     1098.16     1007  Rifkin    Cisneros |\n";
echo "           |                                                 |\n";
echo "             ================================================\n";
echo "\n";
echo "	  Рисунок 20.3 Заказы Rifkin, показанные в Nameorders</pre>\n";
echo "<p>Вы можете также объединять представления с другими таблицами,  базовыми \n";
echo "таблицами или представлениями, поэтому вы можете увидеть все заказы продавца Axelrod и значения его комиссионных в каждом порядке:</p>\n";
echo "<pre>           SELECT a.sname, cname, amt  comm\n";
echo "              FROM Nameorders a, Salespeople b\n";
echo "              WHERE a.sname = 'Axelrod'\n";
echo "                AND b.snum = a.snum;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 20.4. В предикате мы могли бы \n";
echo "написать: &quot;WHERE a.sname = 'Axelrod' AND b.sname = 'Axelrod'&quot;, но предикат, \n";
echo "который мы использовали здесь, более общеупотребителен. Кроме того, поле snum \n";
echo "это первичный ключ таблицы Продавцов, и, следовательно, должно, по определению, \n";
echo "быть уникальным.</p>\n";
echo "<pre>            ===============  SQL Execution Log ==============\n";
echo "           |                                                 |\n";
echo "           | SELECT a.sname, cname, amt * comm               |\n";
echo "           | FROM  Nameorders a, Salespeople b               |\n";
echo "           | WHERE a.sname = 'Axelrod'                       |\n";
echo "           | AND b.snum = a.snum;                            |\n";
echo "           | =============================================== |\n";
echo "           |   onum       amt       snum   sname     cname   |\n";
echo "           |  ------   --------    -----  -------   -------  |\n";
echo "           |   3001       18.69     1007  Rifkin    Cisneros |\n";
echo "           |   3006     1098.16     1007  Rifkin    Cisneros |\n";
echo "           |                                                 |\n";
echo "             ================================================\n";
echo "\n";
echo "	Рисунок 20.4 Объединение основной таблицы с представлением</pre>\n";
echo "<p>Если бы там, например, было два Axelrod, вариант с именем будет объединять \n";
echo "вместе их данные. Более предпочтительный вариант - использовать поле snum, чтобы \n";
echo "хранить его отдельно.</p>\n";
echo "<h3><a name=\"20.8\">П</a>РЕДСТАВЛЕНИЯ И ПОДЗАПРОСЫ</h3>\n";
echo "<p>Представления могут также использовать и подзапросы, включая соотнесённые \n";
echo "подзапросы. Предположим, ваша компания предусматривает премию для тех продавцов, \n";
echo "которые имеют заказчика с самым высоким заказом для любой указанной даты. Вы \n";
echo "можете проследить эту информацию с помощью представления:</p>\n";
echo "<pre>           CREATE VIEW Elitesalesforce\n";
echo "              AS SELECT b.odate, a.snum, a.sname,\n";
echo "                 FROM Salespeople a, Orders b\n";
echo "                 WHERE a.snum = b.snum\n";
echo "                   AND b.amt =\n";
echo "                     (SELECT MAX (amt)\n";
echo "                         FROM Orders c\n";
echo "                         WHERE c.odate = b.odate);</pre>\n";
echo "<p>Если, с другой стороны, премия будет назначаться только продавцу, который \n";
echo "имел самый высокий заказ за последние десять лет, вам необходимо будет \n";
echo "проследить их в другом представлении, основанном на первом:</p>\n";
echo "<pre>            CREATE VIEW Bonus\n";
echo "               AS SELECT DISTINCT snum, sname\n";
echo "                  FROM Elitesalesforce a\n";
echo "                  WHERE 10 &lt; =\n";
echo "                     (SELECT COUNT (*)\n";
echo "                         FROM Elitesalestorce b\n";
echo "                         WHERE a.snum = b.snum);</pre>\n";
echo "<p>Извлечение из этой таблицы продавца, который будет получать премию, \n";
echo "выполняется простым запросом:</p>\n";
echo "<pre>               SELECT *\n";
echo "                  FROM Bonus;</pre>\n";
echo "<p>Теперь мы видим истинную мощность SQL. Извлечение той же полученной \n";
echo "информации программами RPG или COBOL будет более длительной процедурой. В SQL \n";
echo "это - только вопрос из двух комплексных команд, сохранённых как представление \n";
echo "совместно с простым запросом. При самостоятельном запросе мы должны заботится об \n";
echo "этом каждый день, потому что информация которую извлекает запрос, непрерывно \n";
echo "меняется, чтобы отражать текущее состояние базы данных.</p>\n";
echo "<h3><a name=\"20.9\">Ч</a>ТО НЕ МОГУТ ДЕЛАТЬ ПРЕДСТАВЛЕНИЯ?</h3>\n";
echo "<p>Имеется большое количество типов представлений (включая многие из наших \n";
echo "примеров в этой главе), которые являются доступными только для чтения. Это \n";
echo "означает, что их можно запрашивать, но они не могут подвергаться действиям \n";
echo "команд модификации. (Мы будем рассматривать эту тему в <a href=\"ch21.php\">Главе \n";
echo "21</a>.) Имеются также некоторые виды запросов, которые недопустимы в \n";
echo "определениях представлений.</p>\n";
echo "<p>Одиночное представление должно основываться на одиночном запросе.</p>\n";
echo "<p>ОБЪЕДИНИТЬ (UNION) и ОБЪЕДИНИТЬ ВСЁ (UNION ALL) не \n";
echo "разрешаются.</p>\n";
echo "<p>УПОРЯДОЧИТЬ ПО (ORDER BY) никогда не используется в определении \n";
echo "представлений.</p>\n";
echo "<p>Вывод запроса формирует содержание представления, которое \n";
echo "напоминает базовую таблицу и является - по определению - неупорядоченным.</p>\n";
echo "<h3><a name=\"20.10\">У</a>ДАЛЕНИЕ ПРЕДСТАВЛЕНИЙ</h3>\n";
echo "<p>Синтаксис удаления представления из базы данных подобен синтаксису удаления \n";
echo "базовых таблиц:</p>\n";
echo "<pre>DROP VIEW &lt;имя представления&gt;</pre>\n";
echo "<p>В этом нет необходимости, потому что содержимое представления не является \n";
echo "созданным и сохраняется на период действия определенной команды. Базовая таблица, из \n";
echo "которой представление выводится, не задействуется, когда представление удалено. \n";
echo "Помните, вы должны являться владельцем представления, чтобы иметь возможность удалить его.</p>\n";
echo "<h3><a name=\"20.11\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь, когда вы можете использовать представления, ваша способность \n";
echo "отслеживать и обрабатывать содержание  БД значительно расширилась. Всё, что вы можете создать запросом, вы всегда сможете определить как \n";
echo "представление. Запросы этих представлений это, фактически, запрос запроса. \n";
echo "Использование представлений и для удобства, и для защиты также удобно, как и \n";
echo "многие возможности представлений для форматирования и получения значений из \n";
echo "постоянно меняющегося содержания вашей БД.</p>\n";
echo "<p>Имеется один главный вывод \n";
echo "относительно представлений: это способность к модификации.</p>\n";
echo "<p>Как показано, вы можете модифицировать представления так же, как и базовую \n";
echo "таблицу, с помощью изменений, применяемых к таблице, из которой получается \n";
echo "представление, но это не всегда возможно.</p>\n";
echo "<h3><a name=\"20.12\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Создайте представление, которое показывало бы всех заказчиков, имеющих\n";
echo "   самые высокие рейтинги.\n";
echo "\n";
echo "2. Создайте представление, которое показывало бы номер продавца в каждом городе.\n";
echo "\n";
echo "3. Создайте представление, которое показывало бы усреднённый и общий заказы для каждого\n";
echo "   продавца после его имени. Предполагается, что все имена уникальны.\n";
echo "\n";
echo "4. Создайте представление, которое показывало бы каждого продавца с несколькими заказчиками.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#20\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?> 
