﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 23.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 23. ГЛОБАЛЬНЫЕ АСПЕКТЫ SQL</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе будут рассмотрены аспекты языка SQL, имеющие отношение к базе данных \n";
echo "(БД) как к единому целому, включая использование многочисленных имён для объектов данных, размещение запоминаемых данных, восстановление и сохранение изменений в \n";
echo "БД, а также координирование одновременных действий многочисленных пользователей.</p>\n";
echo "<p>Этот материал даст вам возможность сконфигурировать вашу БД, отменять \n";
echo "действия ошибок, и определять, как действия одного пользователя в \n";
echo "БД будут влиять на действия других пользователей.</p>\n";
echo "<a name=\"23.1\"></a>\n";
echo "<h3>ПЕРЕИМЕНОВАНИЕ ТАБЛИЦ</h3>\n";
echo "<p>Каждый раз, когда вы ссылаетесь в команде на базовую таблицу или представление, \n";
echo "не являющиеся вашей собственностью, вы должны установить в команде префикс имени владельца так, чтобы SQL знал, где \n";
echo "искать. Так как это со временем становится неудобным, большинство реализаций SQL \n";
echo "позволяют вам создавать синонимы для таблиц (что не является стандартом ANSI). \n";
echo "Синоним это альтернативное имя, наподобие прозвища.</p>\n";
echo "<p>Когда вы создаёте синоним, вы становитесь его собственником, так что нет никакой необходимости, чтобы он предшествовал другому пользовательскому идентификатору доступа (имени пользователя).</p>\n";
echo "<p>Если вы имеете по крайней мере одну привилегию в одном или более столбцах таблицы, вы можете создать для них синоним. (Некоторое отношение к этому может иметь специальная привилегия для создания синонимов.)</p>\n";
echo "<p>Adrian может создать синоним с именем Clients для таблицы с именем Diane.Customers с помощью команды CREATE SYNONYM:</p>\n";
echo "<pre>      CREATE SYNONYM Clients FOR Diane.Customers;</pre>\n";
echo "<p>Теперь Adrian может использовать таблицу с именем Clients в команде \n";
echo "точно так же, как её использует Diane.Customers. Синоним Clients это собственность, используемая исключительно Adrian.</p>\n";
echo "<a name=\"23.2\"></a>\n";
echo "<h3>ПЕРЕИМЕНОВАНИЕ С ТЕМ ЖЕ САМЫМ ИМЕНЕМ</h3>\n";
echo "<p>Префикс (прозвище) пользователя это фактически часть имени любой таблицы. Всякий раз, когда вы не указываете ваше  имя \n";
echo "пользователя вместе с именем вашей собственной таблицы, SQL сам заполняет для вас это место. Следовательно, два одинаковых имени таблицы, но связанные с различными владельцами, становятся неидентичными и не приводят к какому-нибудь беспорядку (по крайней мере в SQL). Это означает, что два пользователя могут создать две полностью не связанные таблицы с одинаковыми именами, но это также будет означать, что один пользователь может создать представление, основанное на имени другого пользователя, стоящем после имени таблицы.\n";
echo "Это иногда делается, когда представление рассматривается как сама таблица - например, если представление просто использует CHECK OPTION\n";
echo "как заменитель ограничения CHECK в базовой таблице (смотрите подробности в <a href=\"ch22.php\">Главе 22</a>).</p>\n";
echo "<p>Вы можете также создавать ваши собственные синонимы, имена которых будут такими же, что и первоначальные\n";
echo "имена таблиц.</p>\n";
echo "<p>Например, Adrian может определить Customers как свой синоним для таблицы Diane.Customers:</p>\n";
echo "<pre> CREATE SYNONYM Customers FOR Diane.Customers;</pre>\n";
echo "<p>С точки зрения SQL теперь имеются два разных имени одной таблицы: Diane.Customers и Adrian.Customers. Однако каждый из этих пользователей может \n";
echo "обращаться к этой таблице просто Customers. SQL, как говорилось выше, сам добавит  недостающие имена пользователей.</p>\n";
echo "<a name=\"23.3\"></a>\n";
echo "<h3>ОДНО ИМЯ ДЛЯ КАЖДОГО</h3>\n";
echo "<p>Если вы планируете иметь таблицу Заказчиков, используемую большим \n";
echo "числом пользователей, лучше всего, чтобы они обращались к ней с помощью одного и того же имени. Это даст вам возможность, например, использовать это имя в вашем внутреннем общении без ограничений.\n";
echo "Чтобы создать единое имя для всех пользователей, вы создаёте общий синоним.</p>\n";
echo "<p>Например, если все пользователи будут вызывать таблицу \n";
echo "Заказчиков с именем Customers, вы можете ввести</p>\n";
echo "<pre>  CREATE PUBLIC SYNONYM Customers FOR Customers;</pre>\n";
echo "<p>Мы пронимаем, что таблица Заказчиков, это ваша собственность, поэтому никакого префикса имени пользователя в этой команде не указывается. \n";
echo "В основном общие синонимы создаются владельцами объектов или привилегированными пользователями типа DBA. Пользователям, кроме того,\n";
echo "должны ещё быть предоставлены привилегии в таблице Заказчиков, чтобы они могли иметь к ней доступ.</p>\n";
echo "<p>Даже если имя является общим, сама \n";
echo "таблица общей не является. Общие синонимы становятся собственными с помощью команды PUBLIC, а не с помощью их создателей.</p>\n";
echo "<a name=\"23.4\"></a>\n";
echo "<h3>УДАЛЕНИЕ СИНОНИМОВ</h3>\n";
echo "<p>Общие и другие синонимы могут удаляться командой DROP SYNONYM. Синонимы удаляются их владельцами, кроме общих синонимов, которые \n";
echo "удаляются соответствующими привилегированными пользователями, обычно DBA.</p>\n";
echo "<p>Чтобы удалить, например, синоним Clients, когда вместо него уже \n";
echo "появился общий синоним Customers, Adrian может ввести</p>\n";
echo "<pre>           DROP SYNONYM Clients;</pre>\n";
echo "<p>Сама таблица Заказчиков, естественно, становится недействующей.</p>\n";
echo "<a name=\"23.5\"></a>\n";
echo "<h3>КАК БАЗА ДАННЫХ РАСПРЕДЕЛЕНА МЕЖДУ ПОЛЬЗОВАТЕЛЯМИ?</h3>\n";
echo "<p>Таблицы и другие объекты данных сохраняются в БД и находятся там связанными с определёнными пользователями, которые ими владеют. В некотором смысле вы могли бы сказать, что они сохраняются\n";
echo "в &quot;именной области пользователя&quot;, хотя это никак не отражает их физического расположения, но зато, как и большинство вещей в SQL, \n";
echo "является строгой логической конструкцией.<br>\n";
echo "Однако на самом деле объекты данных сохраняются, в физическом смысле; и количество памяти,\n";
echo "которое может использоваться определенным объектом или пользователем в данное время, имеют свой предел.</p>\n";
echo "<p>В конце концов, никакой компьютер не имеет прямого доступа к бесконечному числу аппаратных средств (диску, ленте или внутренней памяти) для хранения данных. Кроме того, эффективность SQL расширится, если логическая структура данных будет отображаться неким физическим\n";
echo "способом, при котором эти команды получат преимущество.</p>\n";
echo "<p>В больших SQL-системах, БД будет разделена на области, так называемые Области Базы Данных или Разделы. \n";
echo "Это области сохраняемой информации размещены так, чтобы информация внутри них находилась близко друг к другу для выполнения \n";
echo "команд; то есть программа не должна искать где-то далеко информацию, сгруппированную в отдельной области базы данных. Хотя её физические \n";
echo "возможности зависят от аппаратного оборудования, целесообразно чтобы команда работала в этих областях внутри самой SQL.</p>\n";
echo "<p>Системы, которые используют области БД (в дальнейшем называемых - DBS (Data Base Spaces)), \n";
echo "которые дают  возможность, с помощью команд\n";
echo "SQL, обрабатывать эти области как объекты.</p>\n";
echo "<p>DBS создаются командами CREATE DBSPACE (СОЗДАТЬ DBS), \n";
echo "ACQUIRE DBSPACE (ПОЛУЧИТЬ DBS) или CREATE TABLE SPACE (СОЗДАТЬ ТАБЛИЧНУЮ ОБЛАСТЬ), в зависимости от используемой реализации.</p>\n";
echo "<p>Одна DBS может вмещать любое число пользователей, и отдельный пользователь может иметь доступ к многим DBS.</p>\n";
echo "<p>Привилегия создавать таблицы, хотя и может быть передана по всей базе данных,\n";
echo "часто передается в конкретной DBS.</p>\n";
echo "<p>Мы можем создать DBS с именем Sampletables следующей командой:</p>\n";
echo "<pre>           CREATE DBSPACE Sampletables\n";
echo "              ( pctindex 10,\n";
echo "                pctfree  25);</pre>\n";
echo "<p>Параметр pctindex определяет, какой процент DBS должен быть оставлен, чтобы сохранять в нём индексы таблиц. Pctfree это процент DBS, который \n";
echo "оставлен, чтобы позволить таблицам расширять размеры их строк (ALTER TABLE может добавлять столбцы или увеличивать размер столбцов, делая \n";
echo "каждую строку длиннее. Это расширяет памяти, отводимой для этого).</p>\n";
echo "<p>Имеются  другие параметры, которые вы также можете определять \n";
echo "и которые меняются от программы к программе. Большинство программ автоматически будут обеспечивать значения по умолчанию, поэтому вы \n";
echo "можете создавать DBS, не определяя эти параметры.</p>\n";
echo "<p>DBS может иметь  определенное ограничение размера, или ей может быть позволено расти неограниченно вместе с таблицами.</p>\n";
echo "<p>Если DBS создана, пользователям предоставляются права создавать в неё объекты.</p>\n";
echo "<p>Вы можете, например, предоставить Diane право создать таблицу Sampletables с помощью следующей команды:</p>\n";
echo "<pre>     GRANT RESOURCE ON Sampletables TO Diane;</pre>\n";
echo "<p>Это даст вам возможность более конкретно определять место хранения данных. \n";
echo "Первая DBS, назначаемая данному пользователю, обычно та, \n";
echo "где все объекты этого пользователя создаются по умолчанию. Пользователи, имеющие доступ к многочисленным DBS, могут определить, \n";
echo "где они хотят разместить определённый объект.</p><p>При разделении вашей БД на DBSы вы должны иметь в виду \n";
echo "типы операций, которые вы будете часто выполнять.</p>\n";
echo "<p>Таблицы, которые, как вам уже известно, будут часто объединяться или которые имеют \n";
echo "одну таблицу, ссылающуюся на другую во внешнем ключе, должны находиться вместе в одной DBS.</p>\n";
echo "<p>Например, вы могли бы сообщить при назначении типовых таблиц, что таблица Заказов будет часто объединяться с одной или обеими из двух \n";
echo "других таблиц, так как таблица Заказов использует значения из обеих этих таблиц. При прочих равных условиях эти три таблицы должны входить в ту же самую область DBS, независимо от того, кто их владелец.\n";
echo "Возможное присутствие ограничения внешнего ключа в таблице Заказов просто приведет к более строгому совместному использованию области DBS.</p>\n";
echo "<a name=\"23.6\"></a>\n";
echo "<h3>КОГДА СДЕЛАННЫЕ ИЗМЕНЕНИЯ СТАНОВЯТСЯ ПОСТОЯННЫМИ ?</h3>\n";
echo "<p>Визуально среда базы данных это картина, которая постоянно отображает для существующих пользователей постоянно вводимые и изменяемые данные, \n";
echo "предполагая, что, если система правильно разработана, она будет функционировать без сбоев. Однако реально, благодаря человеческим или компьютерным сбоям, ошибки время от времени случаются, и поэтому хорошие компьютерные программы стали применять способы отмены действий, вызвавших такие ошибки.</p>\n";
echo "<p>Команда SQL, которая воздействует на содержание или структуру БД - например, команда модификации DML или команда DROP TABLE, \n";
echo "- не обязательно будет необратимой. Вы можете определить после окончания её действия, останутся ли изменения, сделанные данной командой или\n";
echo "группой команд, постоянными в базе данных, или они будут полностью проигнорированы. С этой целью команды обрабатываются группами, называемыми транзакциями.\n";
echo "Транзакция начинается всякий раз, когда вы начинаете сеанс с SQL. Все команды, которые вы введёте, будут частью этой транзакции, пока вы не завершите их вводом команды COMMIT WORK или команды ROLLBACK \n";
echo "WORK. COMMIT может сделать все изменения постоянными с помощью транзакции, а ROLLBACK может откатить их обратно или отменить. Новая \n";
echo "транзакция начинается после каждой команды COMMIT или ROLLBACK. Этот процесс известен как диалоговая обработка запросов или транзакция.</p>\n";
echo "<p>Вот синтаксис, чтобы оставить все ваши изменения постоянными во время регистрации или во время последнего COMMIT или ROLLBACK:</p>\n";
echo "<pre>                     COMMIT WORK;</pre>\n";
echo "<p>Синтаксис отмены изменения:</p>\n";
echo "<pre>                    ROLLBACK WORK;</pre>\n";
echo "<p>В большинстве реализаций вы можете установить параметр, называемый AUTOCOMMIT. Он будет автоматически запоминать все действия, которые будут выполняться. Действия, которые приведут к ошибке, всегда будут\n";
echo "автоматически &quot;прокручены&quot; обратно. Если это предусмотрено в вашей системе, для фиксации всех ваших действий вы можете использовать эту\n";
echo "возможность с помощью команды типа:</p>\n";
echo "<pre>                 SET AUTOCOMMIT ON;</pre>\n";
echo "<p>Вы можете вернуться к обычной диалоговой обработке запросов с помощью такой команды:</p>\n";
echo "<pre>                 SET AUTOCOMMIT OFF;</pre>\n";
echo "<p>Имеется возможность установки AUTOCOMMIT, которую система выполнит автоматически при регистрации. \n";
echo "Если сеанс пользователя завершается аварийно - например, произошел сбой системы или выполнена перезагрузка пользователя, - то текущая транзакция \n";
echo "выполнит автоматический откат изменений. Это - одна из причин, по которой вы можете управлять выполнением вашей диалоговой обработки запросов, \n";
echo "разделив ваши команды на большое количество различных транзакций.</p>\n";
echo "<p>Одиночная транзакция не должна содержать много несвязанных команд; фактически она может состоять из единственной команды.\n";
echo "Транзакции, которые включают всю группу несвязанных изменений, не оставляют вам фактически никакого выбора \n";
echo "- сохранить или отклонить целую группу, если вы хотите отменить только одно \n";
echo "определенное изменение.</p>\n";
echo "<p>Хорошее правило, которому надо следовать: делать ваши транзакции \n";
echo "состоящими из одной команды или нескольких тесно связанных команд.</p>\n";
echo "<p>Например, предположим, вы хотите удалить продавца Motika из базы данных. Прежде чем вы удалите его из таблицы Продавцов, вы сначала должны сделать что-нибудь с его \n";
echo "заказами и его заказчиками. (Если используются ограничения внешнего ключа, и ваша система, следуя ANSI, ограничивает изменение родительского ключа, у вас не будет выбора: делать\n";
echo "или не делать этого. Это будет сделано обязательно.) Одно из логических решений будет состоять в том, чтобы установить поле snum в его \n";
echo "заказах в NULL, вследствие чего ни один продавец не получит комиссионные в этих заказах, пока комиссионные не будут предоставлены \n";
echo "заказчикам для Peel. Затем вы можете удалить их из таблицы Продавцов:</p>\n";
echo "<pre>             UPDATE Orders\n";
echo "                SET snum = NULL\n";
echo "                WHERE snum = 1004;\n";
echo "\n";
echo "             UPDATE Cudomers\n";
echo "                SET snum = 1001\n";
echo "                WHERE snum = 1004;\n";
echo "\n";
echo "             DELETE FROM Salespeople\n";
echo "                WHERE snum = 1004;\n";
echo "\n";
echo "</pre>\n";
echo "<p> Если у вас проблема с удалением Motika (возможно, имеется другой\n";
echo "внешний ключ, ссылающийся на него, о котором вы не знали и который не учитывали), вы могли бы отменить все изменения, которые вы сделали, до тех\n";
echo "пор пока проблема не будет определена и решена. Более того, это должна быть группа команд, чтобы обрабатывать её как \n";
echo "одиночную транзакцию. Вы можете предусмотреть это с помощью команды COMMIT и завершить её с помощью команды COMMIT или ROLLBACK.</p>\n";
echo "<a name=\"23.7\"></a>\n";
echo "<h3>КАК SQL ОБЩАЕТСЯ СРАЗУ С НЕСКОЛЬКИМИ ПОЛЬЗОВАТЕЛЯМИ?</h3>\n";
echo "<p>SQL часто работает в многопользовательской среде - в среде, где \n";
echo "сразу много пользователей одновременно могут выполнять действия в базе данных. Это создает потенциальную возможность конфликта между\n";
echo "различными выполняемыми действиями. Например, предположим, что вы выполняете команду в таблице Продавцов:</p>\n";
echo "<pre>          UPDATE Salespeople\n";
echo "             SET comm = comm * 2\n";
echo "             WHERE sname LIKE 'R%';</pre>\n";
echo "<p>и в это же время Diane вводит такой запрос:</p>\n";
echo "<pre>           SELECT city, AVG (comm)\n";
echo "              FROM Salespeople\n";
echo "              GROUP BY city;</pre>\n";
echo "<p>Может ли усреднённое значение (AVG) Diane отразить изменения, которые вы \n";
echo "делаете в таблице? Не важно, будет это сделано или нет, а важно, чтобы были отражены  все или ни одно из значений комиссионных (comm), для \n";
echo "которых выполнялись изменения. Любой промежуточный результат является случайным или непредсказуемым для \n";
echo "заказа, в котором значения были изменены физически. Вывод запроса не должен быть случайным и непредсказуемым.</p>\n";
echo "<p>Посмотрим на это с другой стороны. Предположим, что вы находите ошибку и \n";
echo "откатываете все ваши модификации уже после того, как Diane получила их результаты в виде вывода. В этом случае Diane получит \n";
echo "ряд усреднённых значений, основанных на тех изменениях, которые были \n";
echo "позже отменены, не зная, что её информации неточна.</p>\n";
echo "<p>Обработка одновременных транзакций называется параллелизмом или совпадением и имеет \n";
echo "несколько возможных проблем, которые могут при этом возникать.</p>\n";
echo "<p>Вот примеры:</p>\n";
echo "<ul><li>Модификация может быть сделана без учета другой модификации. Например, продавец должен сделать запрос в таблице инвентаризации, чтобы найти десять фрагментов пунктов торговцев акциями и упорядочить шесть из \n";
echo "них для заказчика. Прежде чем это изменение было сделано, другой продавец делает запрос к таблице и упорядочивает семь из тех же фрагментов для своего заказчика.</li></ul>\n";
echo "<h5>ПРИМЕЧАНИЕ:</h5>\n";
echo "<p>Термин &quot;упорядочить&quot; аналогичен общепринятому  &quot;заказать&quot;, что, \n";
echo "в принципе, больше соответствует логике запроса, потому что, с точки зрения пользователя, он именно &quot;заказывает&quot; информацию в базе данных, которая \n";
echo "упорядочивает эту информацию в соответствии с &quot;заказом&quot;.</p>\n";
echo "<ul><li>Изменения в БД могут быть прокручены обратно уже после того, как их действия уже были закончены. \n";
echo "Например, если вы отменили вашу ошибку уже после того, как Diane получила свой вывод.</li>\n";
echo "<li>Одно действие может влиять частично на результат другого действия. Например, когда Diane получает среднее \n";
echo "арифметическое значений, в то время как вы выполняете модификацию этих значений. Хотя это не всегда проблематично, в большинстве случаев действие\n";
echo "такое же, как если бы агрегаты должны были отразить состояние БД в пункте относительной стабильности. Например, в ревизионных книгах должна быть возможность вернуться назад и найти это\n";
echo "существующее усреднённое значение для Diane в некоторой временн&#x0301;ой точке, и оставить его без изменений, \n";
echo "которые можно было бы сделать, начиная уже с этого места. Это будет невозможно сделать, если\n";
echo "модификация была выполнена во время вычисления функции.</li>\n";
echo "<li>Тупик. Два пользователя могут попытаться выполнить действия, которые конфликтуют друг с другом. Например, если два\n";
echo "пользователя попробуют изменить  значение внешнего ключа и значение родительского ключа одновременно.</li></ul>\n";
echo "<p>Имеется много сложнейших сценариев, которые нужно было бы последовательно просматривать, если бы одновременные транзакции были неуправляемыми. К счастью, SQL обеспечивает вас средством управления\n";
echo "параллелизмом для точного указания места получения результата.</p>\n";
echo "<p>ANSI указывает, для управления параллелизмом, что все одновременные команды будут выполняться по принципу: ни одна команда не должна быть выдана, пока предыдущая не будет завершена (включая команды COMMIT или ROLLBACK).\n";
echo "Точнее, нужно просто не позволить таблице быть доступной более чем для одной транзакции в данный момент времени. Однако в большинстве ситуаций необходимость иметь базу данных, \n";
echo "доступную сразу многим пользователям, приводит к некоторому компромиссу в управлении параллелизмом.</p>\n";
echo "<p>Некоторые реализации SQL предлагают пользователям \n";
echo "выбор, позволяя им самим находить золотую середину между согласованностью данных и доступом к БД. Этот выбор доступен пользователю, DBA, или тому и другому. \n";
echo "На самом деле они осуществляют это управление вне SQL, даже если и воздействуют на процесс работы самого SQL.</p>\n";
echo "<p>Механизм, используемый SQL для управления параллелизмом операций, называется блокировкой. Блокировки задерживают определенные операции в БД, пока другие операции или транзакции не завершены.\n";
echo "Задержанные операции выстраиваются в очередь и выполняются только тогда, когда блокировка снята (некоторые инструменты блокировок дают вам возможность указывать NOWAIT, которая будет отклонять команду, вместо\n";
echo "того чтобы поставить её в очередь, позволяя вам делать что-нибудь другое).</p>\n";
echo "<p>Блокировки в многопользовательских системах необходимы. Следовательно, должен \n";
echo "быть некий тип схемы блокировки по умолчанию, которая могла бы применяться ко всем командам в базе данных. Такая схема по умолчанию \n";
echo "может быть определена для всей БД, или в качестве параметра в команде CREATE DBSPACE или команде ALTER DBSPACE и таким \n";
echo "образом использовать их по-разному в различных DBS.</p>\n";
echo "<p>Кроме того, системы обычно обеспечиваются неким типом обнаружителя \n";
echo "зависания, который может обнаруживать ситуации, где две операции имеют блокировки, блокирующие друг друга. В этом случае одна из команд\n";
echo "будет прокручена обратно и получит сброс блокировки. Так как терминология и специфика схем блокировок меняются от программы к программе, мы можем смоделировать наши рассуждения на примере\n";
echo "программы базы данных DB2 фирмы IBM. IBM - лидер в этой области (как, впрочем, и во многих других), и поэтому такой подход наиболее \n";
echo "оправдан. С другой стороны, некоторые реализации могут иметь значительные\n";
echo "различия в синтаксисе и в функциях, но в основном их действия должны быть очень похожими.</p>\n";
echo "<a name=\"23.8\"></a>\n";
echo "<h3>ТИПЫ БЛОКИРОВОК</h3>\n";
echo "<p>Имеется два базовых типа блокировок: распределяемые блокировки и специальные блокировки.</p>\n";
echo "<p>Распределяемые (или S-блокировки) могут быть установлены более чем одним пользователем в данный момент времени. Это дает возможность любому числу пользователей обращаться к данным, но не изменять их.\n";
echo "Специальные/исключающие блокировки (или X-блокировки) не позволяют никому, кроме владельца этой блокировки, обращаться к данным.\n";
echo "Специальные блокировки используются для команд, которые изменяют содержание или структуру таблицы. Они действуют до конца транзакции.\n";
echo "Общие блокировки используются для запросов. Насколько они продолжительны, зависит фактически от уровня изоляции.</p>\n";
echo "<p>Что такое уровень изоляции блокировки? Это  то, что определяет, сколько таблиц будет блокировано. \n";
echo "В DB2 имеется три уровня изоляции, два из которых можно применить и к распределенным, и к специальным блокировкам, а третий, ограниченный, \n";
echo "чтобы использовать эти блокировки совместно. Они управляются командами, поданными  вне SQL, так что мы можем обсуждать \n";
echo "их, не указывая  точного синтаксиса. Точный синтаксис команд связанных с блокировками, различен для различных реализаций.</p>\n";
echo "<p>Последующее обсуждение полезно прежде всего на концептуальном уровне. Уровень изоляции &quot;повторное чтение&quot; гарантирует, что внутри данной \n";
echo "транзакции все записи, извлечённые с помощью запросов, не могут быть изменены. Поскольку записи, модифицируемые в транзакции, являются \n";
echo "субъектами специальной блокировки, пока транзакция не завершена, они не могут быть изменены в любом случае. \n";
echo "С другой стороны, для запросов повторное чтение означает, что вы можете решить заранее, какие строки вы хотите заблокировать и выполнить\n";
echo "запрос который их выберет. Выполняя запрос, вы имеете гарантию, что никакие изменения не будут сделаны в этих строках до тех пор, пока вы \n";
echo "не завершите текущую транзакцию.<br>\n";
echo "В то время как повторное чтение защищает пользователя, который поместил блокировку, оно может \n";
echo "одновременно значительно снизить производительность. Уровень указателя стабильности  предохраняет каждую запись от изменений на время, когда она читается, или от чтения на время её изменения.</p>\n";
echo "<p>Второй случай это специальная блокировка, и она применяется, пока изменение не завершено или пока оно не отменено \n";
echo "(т.е. на время отката изменения).<br>\n";
echo "Следовательно, когда вы модифицируете группу записей, использующих указатель стабильности, эти записи будут заблокированы, пока транзакция \n";
echo "не закончится, что аналогично действию, производимому уровнем &quot;повторное чтение&quot;. Различие между этими двум уровнями \n";
echo "- в их воздействии на запросы. В случае уровня &quot;указатель стабильности&quot;, строки таблицы, которые в данное время не используются запросом, могут быть изменены.</p>\n";
echo "<p>Третий уровень изоляции DB2  это уровень &quot;только чтение&quot;. &quot;Только чтение&quot; фиксирует фрагмент данных; хотя на самом деле он блокирует всю таблицу. Следовательно, он не может использоваться с командами модификации. Любое содержание таблицы как единого целого в момент \n";
echo "выполнения команды будет отражено в выводе запроса. Это не обязательно, как в случае с уровнем указатель стабильности. \n";
echo "Блокировка &quot;только чтение&quot; гарантирует, что ваш вывод будет внутренне согласован, если, конечно, нет необходимости во второй блокировке, не связывающей большую часть таблицы с уровнем \n";
echo "&quot;повторное чтение&quot;. Блокировка &quot;только чтение&quot; удобна тогда, когда вы делаете отчёты, которые \n";
echo "должны быть внутренне согласованы, и давать доступ к большинству или ко всем строкам таблицы, не связывая базу данных.</p>\n";
echo "<a name=\"23.9\"></a>\n";
echo "<h3>ДРУГИЕ СПОСОБЫ БЛОКИРОВКИ ДАННЫХ</h3>\n";
echo "<p>Некоторые реализации выполняют блокировку страницы вместо блокировки строки. Это может быть либо возможность вашего управления, \n";
echo "либо нечто, заложенное уже в конструкцию системы.</p>\n";
echo "<p>Страница это блок накопления памяти, обычно равный 1024 байт. \n";
echo "Страница может состоять из одной или более строк таблицы, возможно, сопровождаемых индексами и другой сопутствующей информацией, а \n";
echo "может состоять даже из нескольких строк другой таблицы. Если вы блокируете страницы вместо строк, все данные в этих страницах будут блокированы точно так же, как и в индивидуальных строках,\n";
echo "согласно уровням изоляции, описанным выше.</p>\n";
echo "<p>Основным преимуществом такого подхода является эффективность. \n";
echo "Когда SQL не следит за блокированностью и разблокированностью строк индивидуально, он работает быстрее. С другой стороны, язык SQL был \n";
echo "разработан так, чтобы максимизировать свои возможности, и произвольно блокирует строки, которые не обязательно было блокировать.\n";
echo "Похожая возможность доступна в некоторых системах - это блокировка областей DBS. Области базы данных имеют тенденцию быть больше, чем страница, так что этот подход удовлетворяет и достоинству увеличения производительности и недостатку блокирования страниц.\n";
echo "Вообще-то лучше отключать блокировку низкого уровня, если вам кажется, что появились значительные проблемы с эффективностью.</p>\n";
echo "<a name=\"23.10\"></a>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Ключевые определения, с которыми вы познакомились в этой главе:</p>\n";
echo "<ul><li>Синонимы, или как создавать новые имена для объектов данных.</li>\n";
echo "<li>Области базы данных (DBS), или как распределяется доступная память в базе данных.</li>\n";
echo "<li>Транзакция, или как сохранять или восстанавливать изменения в базе данных.</li>\n";
echo "<li>Управление Параллелизмом, или как SQL предохраняет от конфликта одной команды с другой.</li></ul>\n";
echo "<p>Синонимы это объекты в том смысле, что они имеют имена и (иногда) \n";
echo "владельцев, но, естественно, они не могут существовать без таблицы, чьё \n";
echo "имя они замещают. Они могут быть общими и, следовательно, доступными каждому, кто имеет доступ к объекту, или они могут принадлежать \n";
echo "определенному пользователю.</p>\n";
echo "<p>Области DBS, или просто DBS, это подразделы базы данных, которые \n";
echo "распределены для пользователей. Связанные таблицы, (например, таблицы, которые будут часто объединяться), лучше хранить в общей для\n";
echo "них DBS.</p>\n";
echo "<p>СOMMIT и ROLLBACK это команды, используемые для выполнения изменений в базе данных в то время, когда предыдущая команда COMMIT \n";
echo "или команда ROLLBACK начинают сеанс и оставляют изменения или игнорируют их как группу.</p>\n";
echo "<p>Средство Управление Параллелизмом  определяет, в какой степени одновременно поданные команды будут мешать друг другу. Оно является адаптируемым средством, находящим компромисс между производительностью базы данных и изоляцией действующих команд.</p>\n";
echo "<a name=\"23.11\"></a>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<pre>1. Создайте область базы данных с именем Myspace, которая\n";
echo "   выделяет 15 процентов своей области для индексов и 40 процентов на расширение строк.\n";
echo "\n";
echo "2. Вы получили право SELECT в таблице Заказов продавца Diane.\n";
echo "   Введите команду так, чтобы вы могли ссылаться к этой таблице\n";
echo "   как к &quot;Orders&quot;, не используя имя &quot;Diane&quot; в качестве префикса.\n";
echo "\n";
echo "3. Если произойдёт сбой питания, что случится со всеми изменениями,\n";
echo "   сделанными во время текущей транзакции?\n";
echo "\n";
echo "4. Если вы не можете видеть строку из-за её блокировки, какой это тип блокировки?\n";
echo "\n";
echo "5. Если вы хотите получить общее, максимальное, и усреднённое\n";
echo "   значения сумм приобретений для всех заказов и не хотите при\n";
echo "   этом запрещать другим пользоваться таблицей, какой уровень\n";
echo "   изоляции будет этому соответствовать?\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#23\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?> 
