﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 7.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 8. ФОРМИРОВАНИЕ ВЫВОДА ЗАПРОСОВ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>Эта глава расширит ваши возможности в работе с выводом, производимым запросом. Вы узнаете, как вставлять текст и константы между выбранными полями, как \n";
echo "использовать выбранные поля в математических выражениях, чьи результаты затем становятся выводом, и как сделать, чтобы ваши значения выводились в определенном \n";
echo "порядке. Эта последняя особенность включена, чтобы упорядочивать ваш вывод по любым столбцам, любым полученным значениям этого столбца или по обоим.<a name=\"7.1\"></a></p>\n";
echo "<h3>СТРОКИ И ВЫРАЖЕНИЯ</h3>\n";
echo "<p>Большинство основанных на SQL баз данных предоставляют специальные средства, позволяющие совершенствовать вывод ваших запросов. Конечно, они претерпевают \n";
echo "значительные изменения от программы к программе, и их обсуждения здесь не будет, однако имеются пять особенностей, созданных в стандарте SQL, \n";
echo "которые позволяют вам делать нечто большее, чем просто вывод значений полей и агрегатных данных.</p>\n";
echo "<h4>СКАЛЯРНОЕ ВЫРАЖЕНИЕ С ПОМОЩЬЮ ВЫБРАННЫХ ПОЛЕЙ</h4>\n";
echo "<p>Предположим, вы хотите выполнять простые числовую обработку данных, чтобы затем помещать их в форму, больше соответствующую вашим потребностям. SQL \n";
echo "позволяет вам помещать скалярные выражения и константы среди выбранных полей. Эти выражения могут дополнять или замещать поля в предложениях SELECT и могут \n";
echo "включать в себя одно или более выбранных полей.</p>\n";
echo "<p>Например, вы можете  представить комиссионные вашего продавца в процентном отношении, а не как десятеричные числа.</p>\n";
echo "<p>Для этого достаточно:</p>\n";
echo "<pre>        SELECT snum, sname, city, comm * 100\n";
echo "            FROM Salespeople;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 7.1.</p>\n";
echo "<h4>СТОЛБЦЫ ВЫВОДА</h4>\n";
echo "<p>Последний столбец предшествующего примера не помечен (т.е. без наименования), \n";
echo "потому что это столбец вывода. Столбцы вывода это столбцы данных, созданные в \n";
echo "запросе способом, иным, нежели просто извлечение их из таблицы. Вы создаёте их всякий раз, когда  используете агрегатные функции,</p>\n";
echo "<pre>           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT snum, sname, city, comm * 100          |\n";
echo "          | FROM  Salespeople;                            |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname       city                  |\n";
echo "          | ------    ---------  -----------   ---------  |\n";
echo "          |   1001      Peel       London      12.000000  |\n";
echo "          |   1002      Serres     San Jose    13.000000  |\n";
echo "          |   1004      Motika     London      11.000000  |\n";
echo "          |   1007      Rifkin     Barcelona   15.000000  |\n";
echo "          |   1003      Axelrod    New York    10.000000  |\n";
echo "          |                                               |\n";
echo "           ===============================================\n";
echo "\n";
echo "	  Рисунок 7.1 Помещение выражения в вашем запросе</pre>\n";
echo "<p>константы или выражения в предложении SELECT-запроса. Так как имя столбца - один из атрибутов таблицы, столбцы, которые приходят не из таблиц, не имеют \n";
echo "никаких имён. Другими словами, непомеченные столбцы вывода могут обрабатываться так же, как и столбцы, извлечённые из таблиц, почти во всех ситуациях.</p>\n";
echo "<h4>ПОМЕЩЕНИЕ ТЕКСТА В ВАШЕМ ВЫВОДЕ ЗАПРОСА</h4>\n";
echo "<p>Символ 'A', когда ничего не значит сам по себе, является константой, такой, например, как число 1.</p>\n";
echo "<p>Вы можете вставлять константы в предложение SELECT-запроса, включая и текст. Однако символьные константы, в отличие от числовых констант, не могут \n";
echo "использоваться в выражениях. Вы можете иметь выражение 1 + 2 в вашем предложении SELECT, но вы не можете использовать выражение типа 'A' + 'B'; это приемлемо, \n";
echo "только если мы имеем в виду, что 'A' и 'B' это просто буквы, а не переменные и не символы.</p>\n";
echo "<p>Тем не менее, возможность вставлять текст в вывод ваших запросов - очень удобная штука.</p>\n";
echo "<p>Вы можете усовершенствовать предыдущий пример, представив комиссионные как проценты со знаком процентов (%). Это даст вам возможность помещать в вывод символы и комментарии, как в следующем примере (вывод \n";
echo "показан на Рисунке 7.2):</p>\n";
echo "<pre>            SELECT snum, sname, city, ' % ', comm * 100\n";
echo "               FROM Salespeople;\n";
echo "\n";
echo "\n";
echo "           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT snum, sname, city, '%' comm * 100      |\n";
echo "          | FROM  Salespeople;                            |\n";
echo "          | ==============================================|\n";
echo "          |   snum   sname      city                      |\n";
echo "          | ------  -------- -----------  ----  --------- |\n";
echo "          |   1001   Peel      London       %   12.000000 |\n";
echo "          |   1002   Serres    San Jose     %   13.000000 |\n";
echo "          |   1004   Motika    London       %   11.000000 |\n";
echo "          |   1007   Rifkin    Barcelona    %   15.000000 |\n";
echo "          |   1003   Axelrod   New York     %   10.000000 |\n";
echo "          |                                               |\n";
echo "           ===============================================\n";
echo "\n";
echo "		Рисунок 7.2 Вставка символов в вывод</pre>\n";
echo "<p>Обратите внимание, что пробел перед процентом вставляется как часть строки. Эта же особенность может использоваться, чтобы маркировать вывод вместе с \n";
echo "вставляемыми комментариями.</p>\n";
echo "<p>Вы должны помнить, что этот же самый комментарий будет напечатан в каждой строке вывода, а не просто один раз для всей таблицы. \n";
echo "Предположим, что вы генерируете вывод для отчёта, который указывал бы число заказов, получаемых в течение каждого дня. Вы можете промаркировать ваш вывод \n";
echo "(см. Рисунок 7.3), сформировав запрос следующим образом:</p>\n";
echo "<pre>           SELECT ' For ', odate, ', there are ',\n";
echo "              COUNT (DISTINCT onum), 'orders.'\n";
echo "              FROM Orders\n";
echo "              GROUP BY odate;</pre>\n";
echo "<p>Грамматической некорректности вывода на 5 октября невозможно избежать, не создав запроса, ещё более сложного, чем этот. (Вы должны будете  использовать два запроса с UNION, который</p>\n";
echo "<pre>           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT 'For', odate, ', ' there are ' ,         |\n";
echo "          | COUNT (DISTINCT onum), ' orders '               |\n";
echo "          | FROM Orders                                     |\n";
echo "          | GROUP BY odate;                                 |\n";
echo "          | =============================================== |\n";
echo "          |           odate                                 |\n";
echo "          | ------  ----------   ---------  ------  ------- |\n";
echo "          |   For   10/03/1990 , there are       5  orders. |\n";
echo "          |   For   10/04/1990 , there are       2  orders. |\n";
echo "          |   For   10/05/1990 , there are       1  orders. |\n";
echo "          |   For   10/06/1990 , there are       2  orders. |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "	Рисунок 7.3: Комбинация текста, значений поля, и агрегатов</pre>\n";
echo "<p>мы будем рассматривать в Главе 14.) Как  видите, одиночный неизменный комментарий для каждой строки таблицы может быть очень полезен, но имеет \n";
echo "ограничения. Иногда изящнее и полезнее создать один комментарий для всего вывода в целом или создавать свой собственный комментарии для каждой строки.</p>\n";
echo "<p>Различные программы, использующие SQL, часто обеспечивают специальные средства типа генератора отчетов (например Report Writer), которые разработаны, чтобы \n";
echo "форматировать и совершенствовать вывод. Вложенный SQL может также использовать возможности того языка, в который он вложен. SQL сам по себе \n";
echo "интересен прежде всего при операциях с данными. Вывод, по существу, это информация; и программа, использующая SQL, может часто использовать эту информацию \n";
echo "и помещать её в более привлекательную форму. Это, однако, вне сферы самого SQL.<a name=\"7.2\"></a></p>\n";
echo "<h3>УПОРЯДОЧИВАНИЕ ВЫВОДА ПОЛЕЙ</h3>\n";
echo "<p>Как мы подчеркивали, таблицы это неупорядоченные наборы данных, и данные, которые выводятся из них, не обязательно появляются в какой-то определённой \n";
echo "последовательности. SQL использует команду ORDER BY, чтобы дать возможность упорядочить  вывод. Эта команда упорядочивает вывод запроса согласно \n";
echo "значениям в том или ином количестве выбранных столбцов. Несколько столбцов упорядочиваются один \n";
echo "относительно другого так же, как с GROUP BY, и вы можете \n";
echo "определять возрастание (ASC) или убывание (DESC) для каждого столбца. По умолчанию установлено возрастание. Давайте рассмотрим нашу таблицу заказа, \n";
echo "приводимую в заказ с помощью номера заказчика (обратите внимание на значения в cnum столбце):</p>\n";
echo "<pre>               SELECT *\n";
echo "                  FROM Orders\n";
echo "                  ORDER BY cnum DESC;</pre>\n";
echo "<p>Вывод показан на Рисунке 7.4.</p>\n";
echo "<pre>           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT *                                        |\n";
echo "          | FROM  Orders                                    |\n";
echo "          | ORDER BY cnum DESC;                             |\n";
echo "          | =============================================== |\n";
echo "          |   onum       amt      odate      cnum     snum  |\n";
echo "          |  ------   --------  ----------  -----    -----  |\n";
echo "          |   3001       18.69  10/03/1990   2008     1007  |\n";
echo "          |   3006     1098.16  10/03/1990   2008     1007  |\n";
echo "          |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "          |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "          |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "          |   3007       75.75  10/04/1990   2004     1002  |\n";
echo "          |   3010     1309.95  10/06/1990   2004     1002  |\n";
echo "          |   3005     5160.45  10/03/1990   2003     1002  |\n";
echo "          |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "          |   3003      767.19  10/03/1990   2001     1001  |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "	Рисунок 7.4 Упорядочивание вывода с помощью убывания поля</pre>\n";
echo "<a name=\"7.3\"></a>\n";
echo "<h3>УПОРЯДОЧИВАНИЕ С ПОМОЩЬЮ НЕСКОЛЬКИХ СТОЛБЦОВ</h3>\n";
echo "<p>Мы можем также упорядочивать таблицу с помощью другого столбца, например, с помощью поля amt, внутри упорядочивания поля cnum. (вывод показан в Рисунке 7.5):</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Orders\n";
echo "               ORDER BY cnum DESC, amt DESC;\n";
echo "\n";
echo "           ===============  SQL Execution Log ==============\n";
echo "          |                                                 |\n";
echo "          | SELECT *                                        |\n";
echo "          | FROM  Orders                                    |\n";
echo "          | ORDER BY cnum DESC, amt DESC;                   |\n";
echo "          | =============================================== |\n";
echo "          |   onum       amt      odate      cnum     snum  |\n";
echo "          |  ------   --------  ----------  -----    -----  |\n";
echo "          |   3006     1098.16  10/03/1990   2008     1007  |\n";
echo "          |   3001       18.69  10/03/1990   2008     1007  |\n";
echo "          |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "          |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "          |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "          |   3010     1309.95  10/06/1990   2004     1002  |\n";
echo "          |   3007       75.75  10/04/1990   2004     1002  |\n";
echo "          |   3005     5160.45  10/03/1990   2003     1002  |\n";
echo "          |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "          |   3003      767.19  10/03/1990   2001     1001  |\n";
echo "          |                                                 |\n";
echo "            ================================================\n";
echo "\n";
echo "	Рисунок 7.5: Упорядочивание вывода с помощью нескольких полей</pre>\n";
echo "<p>Вы можете использовать ORDER BY таким  способом одновременно с любым числом столбцов. Обратите внимание, что во всех случаях столбцы, которые \n";
echo "упорядочиваются, должны быть указаны в выборе SELECT. Это требование ANSI, которое в большинстве случаев, но не всегда, предписано системе. Следующая команда, например, будет запрещена:</p>\n";
echo "<pre>              SELECT cname, city\n";
echo "                 FROM Customers\n";
echo "                 GROUP BY cnum;</pre>\n";
echo "<p>Так как поле cnum не было выбранным полем, GROUP BY не сможет найти его, чтобы использовать для упорядочивания вывода. Даже если ваша система позволяет это, \n";
echo "смысл упорядочивания не будет понятен из вывода, так что включение (в предложение SELECT) всех столбцов, используемых в предложении ORDER BY, в принципе желательно.<a name=\"7.4\"></a></p>\n";
echo "<h3>УПОРЯДОЧИВАНИЕ АГРЕГАТНЫХ ГРУПП</h3>\n";
echo "<p>ORDER BY может, кроме того, использоваться с GROUP BY для упорядочивания \n";
echo "групп. При этом ORDER BY всегда  идёт последним.</p>\n";
echo "<p>Вот пример из предыдущей главы с добавлением предложения ORDER BY. Перед группированием вывода порядок групп был произвольным; и мы теперь заставим группы размещаться в последовательности:</p>\n";
echo "<pre>                  SELECT snum, odate, MAX (amt)\n";
echo "                     FROM Orders\n";
echo "                     GROUP BY snum, odate\n";
echo "                     ORDER BY snum;</pre>\n";
echo "<p>Вывод показан на Рисунке 7.6.</p>\n";
echo "<pre>               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT snum, odate, MAX (amt)                   |\n";
echo "              | FROM  Orders                                    |\n";
echo "              | GROUP BY snum, odate                            |\n";
echo "              | ORDER BY snum ;                                 |\n";
echo "              | =============================================== |\n";
echo "              |    snum       odate        amt                  |\n";
echo "              |   -----     ----------  --------                |\n";
echo "              |    1001     10/06/1990    767.19                |\n";
echo "              |    1001     10/05/1990   4723.00                |\n";
echo "              |    1001     10/05/1990   9891.88                |\n";
echo "              |    1002     10/06/1990   5160.45                |\n";
echo "              |    1002     10/04/1990     75.75                |\n";
echo "              |    1002     10/03/1990   1309.95                |\n";
echo "              |    1003     10/04/1990   1713.23                |\n";
echo "              |    1004     10/03/1990   1900.10                |\n";
echo "              |    1007     10/03/1990   1098.16                |\n";
echo "              |                                                 |\n";
echo "                ================================================\n";
echo "\n";
echo "		  Рисунок 7.6 Упорядочивание с помощью группы</pre>\n";
echo "<p>Так как мы не указывали на возрастание или убывание порядка, возрастание используется по умолчанию.<a name=\"7.5\"></a></p>\n";
echo "<h3>УПОРЯДОЧИВАНИЕ ВЫВОДА ПО НОМЕРУ СТОЛБЦА</h3>\n";
echo "<p>Вместо имён столбцов вы можете использовать их порядковые номера для указания поля, используемого при упорядочивании вывода. Эти номера могут ссылаться не на \n";
echo "порядок столбцов в таблице, а на их порядок в выводе. Другими словами, поле, упомянутое в предложении SELECT первым, для ORDER BY -  поле 1, независимо от \n";
echo "того, каким по порядку оно стоит в таблице. Например, вы можете использовать следующую команду, чтобы увидеть определенные поля таблицы Продавцов \n";
echo "упорядоченными по убыванию к наименьшему значению комиссионных (вывод показан на Рисунке 7.7):</p>\n";
echo "<pre>              SELECT sname, comm\n";
echo "                 FROM Salespeople\n";
echo "                 ORDER BY 2 DESC;\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | (SELECT sname, comm                           |\n";
echo "              | FROM Salespeople                              |\n";
echo "              | ORDER BY 2 DESC;                              |\n";
echo "              | ============================================= |\n";
echo "              |    sname       comm                           |\n";
echo "              |   --------   --------                         |\n";
echo "              |   Peel           0.17                         |\n";
echo "              |   Serres         0.15                         |\n";
echo "              |   Rifkin         0.13                         |\n";
echo "              |                                               |\n";
echo "               ===============================================\n";
echo "\n";
echo "	       Рисунок 7.7 Упорядочивание, использующее номера</pre>\n";
echo "<p>Одна из основных целей этого свойства ORDER BY - дать вам возможность использовать GROUP BY со столбцами вывода, так же как и со столбцами таблицы. \n";
echo "Столбцы, производимые агрегатной функцией, константы или выражения в предложении SELECT запроса абсолютно пригодны для использования с GROUP BY, если&nbsp; \n";
echo "на них ссылаются  с помощью номера.</p>\n";
echo "<p>Например, давайте сосчитаем заказы каждого из наших продавцов и выведем результаты в убывающем порядке, как показано в Рисунке 7.8:</p>\n";
echo "<pre>            SELECT snum, COUNT (DISTINCT onum)\n";
echo "               FROM Orders\n";
echo "               GROUP BY snum\n";
echo "               ORDER BY 2 DESC;\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT snum, odate, MAX (amt)                   |\n";
echo "              | FROM Orders                                     |\n";
echo "              | GROUP BY snum                                   |\n";
echo "              | ORDER BY 2 DESC;                                |\n";
echo "              | =============================================== |\n";
echo "              |    snum                                         |\n";
echo "              |   -----     ----------                          |\n";
echo "              |    1001             3                           |\n";
echo "              |    1002             3                           |\n";
echo "              |    1007             2                           |\n";
echo "              |    1003             1                           |\n";
echo "              |    1004             1                           |\n";
echo "              |                                                 |\n";
echo "                ================================================\n";
echo "\n";
echo "	      Рисунок 7.8 Упорядочивание с помощью столбца вывода</pre>\n";
echo "<p>В этом случае вы должны использовать номер столбца, так как столбец вывода не имеет имени; и вы не должны использовать саму агрегатную функцию. Строго \n";
echo "говоря, по правилам ANSI SQL, следующее не будет работать, хотя некоторые системы и пренебрегают этим требованием:</p>\n";
echo "<pre>        SELECT snum, COUNT (DISTINCT onum)\n";
echo "           FROM Orders\n";
echo "           GROUP BY snum\n";
echo "           GROUP BY COUNTОМ (DISTINCT onum) DESC;</pre>\n";
echo "<p>Это будет отклонено большинством систем!<a name=\"7.6\"></a></p>\n";
echo "<h3>УПОРЯДОЧИВАНИЕ С ПОМОЩЬЮ  NULL</h3>\n";
echo "<p>Если имеются пустые значения (NULL) в поле, которое вы используете для упорядочивания вашего вывода, они могут или следовать за, или предшествовать каждому \n";
echo "другому значению в поле. Это  возможность, которую ANSI оставил для отдельных программ. Программа использует ту или иную форму.<a name=\"7.7\"></a></p>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>В этой главе вы изучили, как заставить ваши запросы делать больше, чем просто выводить значения полей или объединять функциональные данные таблиц. Вы можете \n";
echo "использовать поля в выражениях: например, вы можете умножить числовое поле на 10 или даже умножить его на другое числовое поле. Кроме того, вы можете помещать \n";
echo "константы, включая и символы, в ваш вывод, что позволяет  помещать текст непосредственно в запрос и получать его в выводе вместе с данными таблицы. Это дает  возможность помечать или объяснять ваш вывод различными способами.</p>\n";
echo "<p>Вы также изучили, как упорядочивать ваш вывод. Даже если таблица сама по себе остаётся неупорядоченной, предложение ORDER BY даёт вам возможность управлять \n";
echo "порядком вывода строк данного запроса. Вывод запроса может быть в порядке возрастания или убывания, и столбцы могут быть вложенными один внутрь другого.</p>\n";
echo "<p>Понятие выводимых столбцов объяснялось в этой главе. Вы теперь знаете, что выводимые столбцы можно использовать, чтобы упорядочить вывод запроса, но эти \n";
echo "столбцы - без имени и, следовательно, должны определяться их порядковым номером в предложении ORDER BY.</p>\n";
echo "<p>Теперь, когда вы увидели, что можно делать с выводом запроса, основанного на одиночной таблице, настало время  перейти к возможностям улучшенного \n";
echo "запроса и узнать, как сделать запрос любого числа таблиц в одной команде, определив связи между ними. Это будет темой \n";
echo "<a href=\"ch8.php\">Главы 8</a>.<a name=\"7.8\"></a></p>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<ol><li><pre>Предположим, что каждый продавец имеет 12% комиссионных. Напишите запрос\n";
echo "к таблице Заказов, который выведет номер заказа, номер продавца\n";
echo "и сумму комиссионных продавца по этому заказу.</pre></li>\n";
echo "<li><pre>Напишите запрос к таблице Заказчиков, который мог бы найти высший рейтинг\n";
echo "в каждом городе. Вывод должен быть в такой форме:</pre>\n";
echo "<pre>       For the city (city), the highest rating is: (rating).</pre></li>\n";
echo "<li><pre>Напишите запрос, который выводил бы список заказчиков в нисходящем порядке.\n";
echo "Вывод поля оценки/рейтинга (rating) должен сопровождаться именем заказчика и его номером.</pre></li>\n";
echo "<li><pre>Напишите запрос, который выводил бы общие заказы на каждый день и помещал\n";
echo "результаты в нисходящем порядке.</pre></li></ol><pre>(См. ответы в <a href=\"a.php#7\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?> 
