﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Приложение D.</title></head>\n";
echo "<body>\n";
echo "<h1>Приложение D</h1><hr width=\"50%\">\n";
echo "<h3>СИНТАКСИС И СПРАВКА ПО КОМАНДАМ</h3>\n";
echo "<p>В этом приложении содержатся сокращённые описания различных команд SQL. Цель \n";
echo "состоит в том, чтобы дать вам быструю и точную справку и определение SQL.</p>\n";
echo "<p>Первый раздел этого приложения определяет элементы, используемые для создания команд \n";
echo "SQL; второй - подробности синтаксиса и предложения с кратким описанием самих команд.</p>\n";
echo "<p>Вот стандартные условные обозначения (они называются BNF-условиями):</p>\n";
echo "<li>Ключевые слова набираются в верхнем регистре.</li>\n";
echo "<li>SQL и другие специальные условия заключаются в угловые скобки и набираются \n";
echo "курсивом.(&lt;<i>и</i>&gt;)</li>\n";
echo "<li>Необязательные части команд находятся в квадратных скобках ( [ и ] ).</li>\n";
echo "<li>Многоточие ( .... ) указывает на то, что предшествующая часть команды может повторяться любое число раз.</li>\n";
echo "<li>Вертикальная полоса ( | ) означает: то, что ей предшествует, может быть заменено на то, что следует за ней.</li>\n";
echo "<li>Фигурные Скобки ( { и } ) указывают: всё, что внутри них, должно быть расценено как целое, для оценки других символов (например, вертикальных полос или эллипсов).</li>\n";
echo "<li>Двойное двоеточие и знак равенства (:: = ) означают: то, что следует за ними, \n";
echo "является определением того, что им предшествует.<p>Кроме того, мы будем использовать следующую последовательность ( .,.. ) чтобы указывать, что предшествующее этому может повторяться любое число раз, с \n";
echo "индивидуальными событиями, отделяемыми запятыми. Атрибуты, которые не являются частью официального стандарта, будут отмечены в описании как (*нестандартные*).</p>\n";
echo "<h5>ОБРАТИТЕ ВНИМАНИЕ: Терминология которую мы используем здесь - не является официальной \n";
echo "терминологией ANSI. Официальная терминология может вас сильно запутать, поэтому мы несколько ее упростили.</h5>\n";
echo "<h5>По этой причине мы иногда используем условия, отличающиеся от ANSI, или используем те же самые условия, но несколько по-иному. Например, наше \n";
echo "определение &lt;predicate&gt; отличается от используемой в ANSI комбинации стандартного определения &lt;predicate&gt; с &lt;search condition&gt;<span style=\"font-weight: 400\">.</span></h5>\n";
echo "<hr width=\"50%\">\n";
echo "<h3>ЭЛЕМЕНТЫ SQL</h3>\n";
echo "<p>Этот раздел определяет элементы команд SQL.</p>\n";
echo "<p>Они разделены на две категории:\n";
echo "<b>Основные элементы языка</b> и <b>Функциональные элементы языка</b>.</p>\n";
echo "<p><b>Основные элементы</b> - это создаваемые блоки языка; когда SQL исследует команду, то он сначала оценивает каждый символ в тексте команды в терминах \n";
echo "этих элементов. Разделитель &lt;separator&gt; отделяет одну часть команды от другой; всё, что находится между разделителями &lt;separator&gt;, обрабатывается как модуль. \n";
echo "Основываясь на этом разделении, SQL интерпретирует команду.</p>\n";
echo "<p><b>Функциональные элементы</b> - это разнообразные элементы, отличающиеся от ключевых слов, которые могут интерпретироваться как модули. Это части команды, \n";
echo "отделяемые с помощью разделителей &lt;separator&gt;, имеющие специальное значение в SQL. Некоторые из них являются специальными для определенных команд и \n";
echo "будут описаны вместе с этими командами позже в этом приложении.</p>\n";
echo "<p>Перечисленные здесь являются общими элементами для всех описываемых команд.</p>\n";
echo "<p>Функциональные элементы могут определяться в терминах друг друга или даже в собственных терминах. Например, предикат &lt;predicate&gt;, наш последний и наиболее сложный \n";
echo "случай, содержит предикат &lt;predicate&gt; внутри собственного определения. Это потому, что предикат &lt;predicate&gt;, использующий AND или OR, может содержать любое число предикатов &lt;predicate&gt;, которые могут работать автономно. Мы представляли вам предикат &lt;predicate&gt; в отдельной секции в этом приложении из-за разнообразия и сложности \n";
echo "этого функционального элемента языка. Он будет постоянно присутствовать при обсуждении других функциональных частей команд.</p>\n";
echo "<center><p><b>БАЗОВЫЕ ЭЛЕМЕНТЫ ЯЗЫКА</b></p></center>\n";
echo "<pre>ЭЛЕМЕНТ           ОПРЕДЕЛЕНИЕ\n";
echo "\n";
echo "&lt;separator&gt;     &lt;comment&gt; | &lt;space&gt; | &lt;newline&gt;\n";
echo "\n";
echo "&lt;comment&gt;       --&lt;string&gt; &lt;newline&gt;\n";
echo "\n";
echo "&lt;space&gt;         пробел\n";
echo "\n";
echo "&lt;newline&gt;       определяемый реализацией конец символьной строки\n";
echo "\n";
echo "&lt;identifier&gt;    &lt;letter&gt;[{&lt;letter or digit&gt; | &lt;underscore}... ]\n";
echo "                  ИМЕЙТЕ В ВИДУ: Следуя строгому стандарту ANSI, символы\n";
echo "                  должны быть набраны в верхнем регистре, а идентификатор\n";
echo "		  &lt;identifier&gt; не должен быть длиннее 18-ти символов.\n";
echo "\n";
echo "\n";
echo "ЭЛЕМЕНТ            ОПРЕДЕЛЕНИЕ\n";
echo "&lt;underscore&gt;     -\n";
echo "\n";
echo "&lt;percent sign&gt;   %\n";
echo "\n";
echo "&lt;delimiter&gt;      любое из следующих: , ( ) &lt;&gt; . : = + &quot; - | &lt;&gt;\n";
echo "		  &gt;= &lt;= или &lt;string&gt;\n";
echo "\n";
echo "&lt;string&gt;         [любой печатаемый текст в одинарных кавычках]\n";
echo "                   Примечание: В &lt;string&gt;, две последовательных одинарных\n";
echo "                   кавычки ( ' ' ) интерпретируются как одна ( ' ).\n";
echo "\n";
echo "&lt;SQL term&gt;       окончание/терминатор, зависящее от главного языка.\n";
echo "(*только вложенный SQL*)</pre>\n";
echo "<h4>ФУНКЦИОНАЛЬНЫЕ ЭЛЕМЕНТЫ</h4>\n";
echo "<pre>Следующая таблица  показывает функциональные элементы команд SQL и их определения:\n";
echo "\n";
echo "ЭЛЕМЕНТ                  ОПРЕДЕЛЕНИЕ \n";
echo "\n";
echo "&lt;query&gt;                Предложение SELECT \n";
echo "\n";
echo "&lt;subquery&gt;             Заключённое в круглые скобки предложение\n";
echo "		         SELECT внутри другого условия, которое фактически\n";
echo "		         оценивается отдельно для каждой строки-кандидата\n";
echo "		         другого предложения.\n";
echo "\n";
echo "&lt;value expression&gt;      &lt;primary&gt;\n";
echo "			 | &lt;primary&gt; &lt;operator&gt; &lt;primary&gt;\n";
echo "			 | &lt;primary&gt; &lt;operator&gt; &lt;value expression&gt;\n";
echo "\n";
echo "&lt;operator&gt;             любое из следующих:  +  -  /  *\n";
echo "\n";
echo "&lt;primary&gt;              &lt;column name&gt;\n";
echo "			 | &lt;literal&gt;\n";
echo "			 | &lt;aggregate function&gt;\n";
echo "			 | &lt;built-in constant&gt;\n";
echo "			 | &lt;nonstandard function&gt;\n";
echo "\n";
echo "&lt;literal&gt;              &lt;string&gt; | &lt;mathematical expressio&gt;\n";
echo "\n";
echo "\n";
echo "ЭЛЕМЕНТ                    ОПРЕДЕЛЕНИЕ\n";
echo "\n";
echo "&lt;built-in constant&gt;     USER | &lt;implementation-defined constant&gt;\n";
echo "\n";
echo "&lt;table name&gt;            &lt;identifier&gt;\n";
echo "\n";
echo "&lt;column spec&gt;           [&lt;table name&gt; | &lt;alias&gt;.]&lt;column name&gt;\n";
echo "\n";
echo "&lt;grouping column&gt;   	  &lt;column spec&gt; | &lt;integer&gt;\n";
echo "\n";
echo "&lt;ordering column&gt;       &lt;column spec&gt; | &lt;integer&gt;\n";
echo "\n";
echo "&lt;colconstraint&gt;         NOT NULL | UNIQUE\n";
echo "			  | CHECK (&lt;predicate&gt;) \n";
echo "			  | PRIMARY KEY\n";
echo "			  | REFERENCES &lt;table name&gt;[(&lt;column name&gt;)]\n";
echo "\n";
echo "&lt;tabconstraint&gt;         UNIQUE (&lt;column list&gt;)\n";
echo "			  | CHECK (&lt;predicate&gt;)\n";
echo "			  | PRIMARY KEY (&lt;column list&gt;)\n";
echo "			  | FOREIGN KEY (&lt;column list&gt;)\n";
echo "			  | REFERENCES &lt;table name&gt;[(&lt;column list&gt;)]\n";
echo "\n";
echo "&lt;defvalue&gt;          	  ЗНАЧЕНИЕ ПО УМОЛЧАНИЮ = &lt;value expression&gt;\n";
echo "\n";
echo "&lt;data type&gt;         	  Допустимый тип данных (См. в <a href=\"b.php\">Приложении B</a>\n";
echo "	       		  описание типов, обеспечиваемых ANSI, или в\n";
echo "	       		  <a href=\"c.php\">Приложении C</a> - другие общие типы.)\n";
echo "\n";
echo "&lt;size&gt;                  Значение зависит от &lt;data type&gt;(См. <a href=\"b.php\">Приложение B</a>.)\n";
echo "\n";
echo "&lt;cursor name&gt;           &lt;identifier&gt;\n";
echo "\n";
echo "&lt;index name&gt;            &lt;identifier&gt;\n";
echo "\n";
echo "&lt;synonym&gt;               &lt;identifier&gt;(*нестандартный*)\n";
echo "\n";
echo "&lt;owner&gt;                 &lt;Authorization ID&gt;\n";
echo "\n";
echo "&lt;column list&gt;           &lt;column spec&gt; .,..\n";
echo "\n";
echo "&lt;value list&gt;            &lt;value expression&gt; .,..\n";
echo "\n";
echo "&lt;table reference&gt;       { &lt;table name&gt; [&lt;alias&gt;] } .,..\n";
echo "\n";
echo "</pre>\n";
echo "<hr width=\"50%\">\n";
echo "<h4>ПРЕДИКАТЫ</h4>\n";
echo "<p>Здесь определён список различных типов предиката &lt;predicate&gt;, описанных \n";
echo "на следующих страницах:</p>\n";
echo "<p><b>&lt;predicate&gt; ::= [NOT]</b></p>\n";
echo "<pre>	     { &lt;comparison predicate&gt;\n";
echo "	     | &lt;in predicate&gt;\n";
echo "	     | &lt;null predicate&gt;\n";
echo "	     | &lt;between predicate&gt;\n";
echo "	     | &lt;like predicate&gt;\n";
echo "	     | &lt;quantified predicate&gt;\n";
echo "	     | &lt;exists predicate&gt; }\n";
echo "	       [ANDI OR &lt;predicate&gt; ]</pre>\n";
echo "<p>&lt;predicate&gt; - это выражение, которое может быть true, false или неизвестным, за исключением<br>\n";
echo "&lt;exists predicate&gt; и &lt;null predicate&gt;, которые могут быть только верными или неверными.</p>\n";
echo "<p>Будет получено &quot;неизвестно&quot;, если NULL-значения предотвращают вывод полученного ответа. Это будет случаться всякий раз, когда NULL-значение сравнивается с любым \n";
echo "значением. Стандартные булевы операторы - AND, OR и NOT - могут использоваться с предикатом<predicate />. NOT true = false, NOT false = true, а NOT \n";
echo "неизвестно = неизвестно. Результаты AND и OR в комбинации с предикатами, показаны в следующих таблицах:</p>\n";
echo "<pre>		  AND\n";
echo "\n";
echo "AND              True           False           Неизвестно\n";
echo "\n";
echo "True             true           false           неизвестно\n";
echo "False            false          false           false\n";
echo "Неизвестно       неизвестно     false           неизвестно\n";
echo "\n";
echo "\n";
echo "		  OR\n";
echo "\n";
echo "OR               True          False           Неизвестно\n";
echo "\n";
echo "True             true          true            true\n";
echo "False            true          false           неизвестно\n";
echo "Неизвестно       true          неизвестно      неизвестно</pre>\n";
echo "<p>Эти таблицы читаются способом, наподобие таблицы умножения: вы объединяете верные, неверные, или неизвестные значения из строк с их столбцами, чтобы на \n";
echo "перекрестье получить результат. В таблице AND, например, третий столбец (Неизвестно) и первая строка (Тrue) на пересечении в верхнем правом углу дают \n";
echo "результат - неизвестно, другими словами: Верно AND Неизвестно = неизвестно. Порядок вычислений определяется круглыми скобками. Они не представляются каждый \n";
echo "раз. NOT оценивается первым, далее AND и OR. Различные типы предикатов &lt;predicate&gt; рассматриваются отдельно в следующем разделе.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<p><b>&lt;comparison predicate&gt; (предикат сравнения)</b></p>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>&lt;value expresslon&gt; &lt;relational op&gt; &lt;value expresslon&gt; |<br>\n";
echo "&lt;subquery&gt;<br>\n";
echo "<br>\n";
echo "&lt;relatlonal op&gt; :: =<br>\n";
echo "=<br>\n";
echo "| &lt;<br>\n";
echo "|&gt;<br>\n";
echo "| &lt;<br>\n";
echo "|&gt;=<br>\n";
echo "| &lt;&gt;<br>\n";
echo "</p>\n";
echo "<p>Если либо &lt;value expression&gt; = NULL, либо &lt;comparison predicate&gt; \n";
echo "= неизвестно;<br>\n";
echo "другими словами, это true, если сравнение true, или false, если сравнение false.<br><br>\n";
echo "&lt;relational op&gt; имеет стандартные математические значения для числовых \n";
echo "значений; для других типов значений эти значения определяются конкретной реализацией.</p>\n";
echo "<p>Оба &lt;value expression&gt; должны иметь сравнимые типы данных. Если подзапрос &lt;subquery&gt; используется, он должен содержать одно выражение \n";
echo "&lt;value expression&gt; \n";
echo "в предложении SELECT, чьё значение будет заменять второе выражение &lt;value expression&gt; \n";
echo "в предикате сравнения &lt;comparision predicate&gt; каждый раз, когда &lt;subquery&gt; действительно выполняется.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<p><b>&lt;between predicate&gt;</b></p>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>&lt;value expression&gt; [NOT] BETWEEN &lt;value expression&gt;<br>AND &lt;value expression&gt;</p>\n";
echo "<p>&lt;between predicate&gt; - A BETWEEN B AND C имеет такое же значение, что и &lt;predicate&gt; - ( A&gt;= B AND \n";
echo "&lt;= C). &lt;between predicate&gt;, для которого A NOT \n";
echo "BETWEEN B AND C, имеет такое же значение, что и NOT (BETWEEN B AND C).<br>\n";
echo "&lt;value expression&gt; может быть выведено с помощью нестандартного запроса &lt;subquery&gt; (*nonstandard*).</p>\n";
echo "<hr width=\"40%\">\n";
echo "<p><b>&lt;in prediicate&gt;</b></p>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>&lt;value expression&gt; [NOT] IN &lt;value list&gt; | &lt;subquery&gt;</p>\n";
echo "<p>Список значений &lt;value list&gt; будет состоять из одного или более \n";
echo "значений в круглых скобках с разделением запятыми, которые имеют сравнимый с &lt;value expression&gt; \n";
echo "тип данных. Если используется подзапрос &lt;subquery&gt;, он должен содержать только одно выражение \n";
echo "&lt;value expression&gt; в предложении SELECT (возможно и больше, но это уже будет вне стандарта ANSI).<br>\n";
echo "Подзапрос &lt;subquery&gt; фактически выполняется отдельно для каждой строки-кандидата основного запроса, и значения, которые он выведет, будут \n";
echo "составлять список значений &lt;value list&gt; для этой строки. В любом случае предикат \n";
echo "&lt;in predicate&gt; будет верен, если выражение &lt;value expression&gt; \n";
echo "представленное в списке значений &lt;value list&gt;, если не указан NOT.<br>\n";
echo "Фраза A NOT IN (B, C) является эквивалентом фразы NOT (A IN (B, C)).</p>\n";
echo "<hr width=\"40%\">\n";
echo "<p><b>&lt;like predicate&gt;</b></p>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>&lt;charvalue&gt; [NOT] LIKE &lt;pattern&gt; [ESCAPE<br>\n";
echo "&lt;escapechar&gt;]</p>\n";
echo "<p>&lt;charvalue&gt;  это любое *нестандартное* выражение &lt;value expression&gt; алфавитно-цифрового типа.<br>\n";
echo "&lt;charvalue&gt; может быть, в соответствии со стандартом, только определенным \n";
echo "столбцом &lt;column spec&gt;. Образец &lt;pattern&gt; \n";
echo "состоит из строки,<string /> которая будет проверена на совпадение с &lt;charvalue&gt;. \n";
echo "Символ окончания &lt;escapechar&gt;  это одиночный алфавитно-цифровой символ. \n";
echo "Совпадение произойдет, если верны следующие условия:</p></li>\n";
echo "<li>Для каждого символа подчёркивания &lt;underscore&gt; в образце &lt;pattern&gt;, который \n";
echo "не предшествует символу окончания &lt;escapechar&gt;, имеется один соответствующий ему \n";
echo "символ &lt;charvalue&gt;.</li>\n";
echo "<li>Для каждого &lt;percent sign&gt; в образце &lt;pattern&gt;, который не предшествует &lt;escapechar&gt;, \n";
echo "имеются нуль или более соответствующих символов в &lt;charvalue&gt;.</li>\n";
echo "<li>Для каждого &lt;escapechar&gt; в &lt;pattern&gt;, который не предшествует другому &lt;escapechar&gt;, \n";
echo "нет никакого соответствующего символа в &lt;charvalue&gt;.</li>\n";
echo "<li>Для каждого иного символа в &lt;pattern&gt;, один и тот же символ устанавливается \n";
echo "у соответствующей отметке в &lt;charvalue&gt;.<p>Если совпадение произошло, &lt;like predicate&gt; верен, если не был указан NOT. Фраза NOT LIKE 'текст' - эквивалентна NOT (A LIKE 'текст').</p>\n";
echo "<hr width=\"40%\">\n";
echo "<p><b>&lt;null predicate&gt;</b></p>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>&lt;column spec&gt; IS [NOT] NULL</p>\n";
echo "<p>&lt;column spec&gt; = IS NULL, если NULL значение представлено в этом столбце. Это \n";
echo "сделает &lt;null predicate&gt; верным, если не указан NULL. Фраза &lt;column spec&gt; IS NOT NULL, имеет тот же результат что и NOT \n";
echo "(&lt;column spec&gt; IS NULL).</p>\n";
echo "<hr width=\"40%\">\n";
echo "<p><b>&lt;quantified predicate&gt;</b></p>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>&lt;value expression&gt; &lt;relational op&gt;<br>&lt;quantifier&gt; &lt;subquery&gt;<br>&lt;quantifier&gt; :: = ANY | ALL | SOME</p>\n";
echo "<p>Предложение SELECT подзапроса &lt;subquery&gt; должно содержать одно, и только одно, выражение значения \n";
echo "&lt;value expression&gt;. Все значения, выведенные подзапросом &lt;subquery&gt;, составляют \n";
echo "набор результатов &lt;result set&gt;. &lt;value expression&gt; сравнивается, используя \n";
echo "оператор связи &lt;relational operator&gt;, с каждым членом набора результатов &lt;result set&gt;. Это сравнение оценивается следующим образом:</p></li>\n";
echo "<li>Если &lt;quantifier&gt; = ALL и каждый член набора результатов &lt;result set&gt; делает \n";
echo "это сравнение верным, &lt;quantified predicate&gt;  верен.</li>\n";
echo "<li>Если &lt;quantifier&gt; = ANY и имеется по крайней мере один член из набора \n";
echo "результатов &lt;result set&gt;, который делает верным это сравнение, то &lt;quantified predicate&gt; является верным.</li>\n";
echo "<li>Если набор результатов &lt;result set&gt; пуст, то &lt;quantified predicate&gt; верен, \n";
echo "если &lt;quantifier&gt; = ALL , и неверен а ином случае.</li>\n";
echo "<li>Если &lt;quantifier&gt; = SOME, эффект - тот же, что и для ANY.</li>\n";
echo "<li>Если &lt;quantified predicate&gt; неверен и не неверен, он  неизвестен.<p>&nbsp;</p>\n";
echo "<hr width=\"40%\"><p><b>&lt;exists predicate&gt;</b></p><p><b><i>Синтаксис:</i></b></p><p>EXISTS \n";
echo "(&lt;subquery&gt;)</p>\n";
echo "<p>Если подзапрос &lt;subquery&gt; выводит одну или более строк вывода, &lt;exists predicate&gt; верен; и неверен в ином случае.</p>\n";
echo "<hr width=\"70%\">\n";
echo "<h3>SQL КОМАНДЫ</h3>\n";
echo "<p>Этот раздел подробно описывает синтаксис различных команд SQL. Это даст вам возможность быстро отыскивать команду, находить синтаксис и краткое описание её работы.</p>\n";
echo "<p><b>ИМЕЙТЕ ВВИДУ:</b> команды, которые начинаются словами - EXEC SQL, а также \n";
echo "команды или предложения, заканчивающиеся словом, &lt;sql term&gt; могут использоваться только во вложенном SQL.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>BEGIN DECLARE SECTION (НАЧАТЬ РАЗДЕЛ ОБЪЯВЛЕНИЙ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>EXEC SQL BEGIN DECLARE SECTION &lt;SQL term&gt; &lt;host-language variable declarations&gt; EXEC SQL END DECLARE SECTION \n";
echo "&lt;SQL term&gt;</p>\n";
echo "<p>Эта команда создает главный раздел программы  для объявления в ней главных переменных, которые будут использоваться во вкладываемых операторах SQL. \n";
echo "Переменная SQLCODE должна быть включена как одна из объявляемых переменных главного языка.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>CLOSE CURSOR (ЗАКРЫТЬ КУРСОР)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>EXEC SQL CLOSE CURSOR &lt;cursor name&gt; &lt;SQL term&gt;;</p>\n";
echo "<p>Эта команда указывает курсору закрыться, после чего ни одно значение не сможет быть выбрано из него до тех пор, пока он не будет снова открыт.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>COMMIT (WORK) (ПОДТВЕРДИТЬ (ТРАНЗАКЦИИ))</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>COMMIT WORK;</p>\n";
echo "<p>Эта команда оставляет неизменными все изменения, сделанных в базе данных, до тех пор, пока начавшаяся транзакция не закончится и не начнется новая транзакция.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>CREATE INDEX (СОЗДАТЬ ИНДЕКС)</h5>\n";
echo "<p>(*NONSTANDARD*) (НЕСТАНДАРТНАЯ)</p>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>CREATE [UNIQUE] INDEX &lt;Index name&gt;<br>ON &lt;table name&gt; (&lt;column list&gt;);<br></p>\n";
echo "<p>Эта команда создает эффективный маршрут с быстрым доступом для поиска строк, содержащих указанные столбцы. Если UNIQUE указана, таблица не сможет содержать дубликаты (двойники) значений в этих столбцах.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>CREATE SYNONYM (*NONSTANDARD*)<br>\n";
echo "(СОЗДАТЬ СИНОНИМ) (*НЕСТАНДАРТНЫЙ*)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>CREATE IPUBLICl SYNONYM &lt;synonym&gt; FOR<br>&lt;owner&gt;.&lt;table name&gt;;</p>\n";
echo "<p>Эта команда создает альтернативное (синоним) имя таблицы. Синоним принадлежит его создателю, а сама таблица - обычно другому пользователю. \n";
echo "Используя синоним, его владелец может не ссылаться на таблицу её полным (с включением имени владельца) именем. Если PUBLIC указан, синоним принадлежит каталогу SYSTEM и, следовательно, доступен всем пользователям.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>CREATE TABLE (СОЗДАТЬ ТАБЛИЦУ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>CREATE TABLE &lt;table name&gt;<br>({&lt;column name&gt; &lt;data type&gt;[&lt;size&gt;]<br>\n";
echo "[&lt;colconstralnt&gt; . . .]<br>[&lt;defvalue&gt;]} . , . . &lt;tabconstraint&gt; . , . .);</p>\n";
echo "<p>Команда создает таблицу в базе данных. Эта таблица будет принадлежать её создателю. Столбцы будут рассматриваться в поимённом порядке.<br>\n";
echo "&lt;data type&gt; определяет тип данных, которые столбец будет содержать. Стандарт &lt;data type&gt; описывается в\n";
echo "<a href=\"b.php\">Приложении B</a>; все прочие используемые типы данных &lt;data type&gt; обсуждались \n";
echo "в <a href=\"c.php\">Приложении C</a>. Значение размера &lt;size&gt; зависит от типа \n";
echo "данных &lt;data type&gt;.<br>\n";
echo "&lt;colconstraint&gt; и &lt;tabconstraint&gt; налагают ограничения на значения, которые могут быть введены в столбце.<br>\n";
echo "&lt;defvalue&gt; определяет значение (по умолчанию), которое будет вставлено автоматически, если никакого другого значения не указано для этой строки. (См. в\n";
echo "<a href=\"ch17.php\">Главе 17</a> подробности о самой команде CREATE TABLE и в Главах <a href=\"ch18.php\">18</a> И\n";
echo "<a href=\"ch19.php\">19</a> - подробности об ограничениях и о &lt;defvalue&gt;).</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>CREATE VIEW (СОЗДАТЬ ПРОСМОТР)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>CREATE VIEW &lt;table name&gt;<br>\n";
echo "AS &lt;query&gt;<br>\n";
echo "[WITH CHECK OPTION];</p>\n";
echo "<p>Просмотр обрабатывается как любая таблица в командах SQL. Когда команда \n";
echo "ссылается на имя таблицы &lt;table name&gt;, запрос &lt;query&gt; выполняется, и его \n";
echo "вывод соответствует содержанию таблицы, указанной в этой команде.<br>Некоторые \n";
echo "просмотры могут модифицироваться, что означает, что команды модификации могут \n";
echo "выполняться в этих просмотрах и передаваться в таблицу, на которую была ссылка в \n";
echo "запросе &lt;query&gt;. Если указано предложение WITH CHECK \n";
echo "OPTION, эта модификация должны также удовлетворять условию предиката &lt;predicate&gt; \n";
echo "в запросе &lt;query&gt;.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>DECLARE CURSOR (ОБЪЯВИТЬ КУРСОР)</h5>\n";
echo "<p><i><b>Синтаксис</b></i></p>\n";
echo "<p>EXEC SQL DECLARE &lt;cursor name&gt; CURSOR FOR<br>&lt;query&gt;&lt;SQL term&gt;</p>\n";
echo "<p>Эта команда связывает имя курсора &lt;cursor name&gt; с запросом &lt;query&gt;. Когда \n";
echo "курсор открыт (см. OPEN CURSOR ), запрос &lt;query&gt; выполняется, и его результат может быть выбран (командой FETCH) \n";
echo "для вывода. Если курсор - модифицируемый, таблица, на которую ссылается запрос &lt;query&gt;, может получить изменение содержания с помощью операции модификации в курсоре (См. в\n";
echo "<a href=\"ch25.php\">Главе 25</a> о модифицируемых курсорах).</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>DELETE (УДАЛИТЬ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>DELETE FROM &lt;table name&gt;<br>\n";
echo "{ [WHERE &lt;predicate&gt;]; }<br>\n";
echo "| WHERE CURRENT OF &lt;cursorname&gt;&lt;SQL term&gt;</p>\n";
echo "<p>Если предложение WHERE отсутствует, ВСЕ строки таблицы удаляются. Если предложение WHERE \n";
echo "использует предикат &lt;predicate&gt;, строки, которые удовлетворяют условию этого \n";
echo "предиката &lt;predicate&gt;, удаляются. Если предложение WHERE имеет аргумент CURRENT OF \n";
echo "(ТЕКУЩИЙ) в имени курсора &lt;cursor name&gt;, строка из таблицы &lt;table name&gt;, на \n";
echo "которую в данный момент имеется ссылка с помощью имени курсора &lt;cursor name&gt;, будет удалена. Форма WHERE CURRENT может \n";
echo "использоваться только во вложенном SQL и только с модифицируемыми курсорами.</p>\n";
echo "<hr eidth=\"40%\" color=\"#000000\" width=\"40%\">\n";
echo "<h5>EXEC SQL (ВЫПОЛНИТЬ SQL)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>EXEC SQL &lt;embedded SQL command&gt; &lt;SQL term&gt;</p>\n";
echo "<p>EXEC SQL используется, чтобы указывать начало всех команд SQL, вложенных в другой язык.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>FETCH (ВЫБОРКА/ИЗВЛЕЧЕНИЕ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>EXEC SQL FETCH &lt;cursorname&gt;<br>\n";
echo "INTO &lt;host-varlable llst&gt;&lt;SQL term&gt;</p>\n";
echo "<p>FETCH принимает вывод из текущей строки запроса &lt;query&gt;, вставляет её в \n";
echo "список главных переменных &lt;host-variable list&gt;, и перемещает курсор на следующую \n";
echo "строку. Список &lt;host-variable list&gt; может включать переменную indicator в качестве целевой переменной (См.\n";
echo "<a href=\"ch25.php\">Главу 25</a>).</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>GRANT (ПЕРЕДАТЬ ПРАВА)</h5>\n";
echo "<p><b><i>Синтаксис (стандартный)</i></b></p>\n";
echo "<p>GRANT ALL [PRIVILEGES]<br>\n";
echo "| {SELECT<br>\n";
echo "| INSERT<br>\n";
echo "| DELETE<br>\n";
echo "| UPDATE [(&lt;column llst&gt;)]<br>\n";
echo "| REFERENCES [(&lt;column llst&gt;)l } . , . .<br>\n";
echo "ON &lt;table name&gt; . , . .<br>\n";
echo "TO PUBLIC | &lt;Authorization ID&gt; . , . .<br>\n";
echo "[WITH GRANT OPTION];</p>\n";
echo "<p>Аргумент ALL (ВСЕ), с или без PRIVILEGES (ПРИВИЛЕГИИ), включает каждую привилегию в список привилегий. PUBLIC (ОБЩИЙ) включает всех существующих \n";
echo "пользователей и всех созданных в будущем. Эта команда даёт возможность передать права для выполнения действий в таблице с указанным именем. REFERENCES \n";
echo "позволяет дать права на использование столбцов в списке столбцов &lt;column list&gt; как родительский ключ для внешнего ключа. Другие привилегии состоят из права \n";
echo "выполнять команды, для которых привилегии указаны их именами в таблице. UPDATE подобен REFERENCES и может накладывать ограничения на определенные столбцы. GRANT OPTION даёт возможность передавать эти привилегии другим пользователям.</p>\n";
echo "<p><b><i>Синтаксис (нестандартный)</i></b></p>\n";
echo "<p>GRANT DBA<br>\n";
echo "| RESOURCE<br>\n";
echo "| CONNECT ... .<br>\n";
echo "TO &lt;Authorization ID&gt; . , . .<br>\n";
echo "[IDENTIFIED BY&gt; password&gt;</p>\n";
echo "<p>CONNECT дает возможность передавать право на регистрацию и некоторые другие ограниченные права.<br>\n";
echo "RESOURCE дает пользователю право создавать таблицы.<br>DBA дает возможность передавать почти все права.<br>\n";
echo "IDENTIFIED BY используется вместе с CONNECT для создания или изменения пароля пользователя.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>INSERT (ВСТАВИТЬ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>INSERT INTO &lt;table name&gt; (&lt;column llst&gt;)<br>\n";
echo "VALUES (&lt;value llst&gt;) I &lt;query&gt;;</p>\n";
echo "<p>INSERT создает одну или больше новых строк в таблице &lt;table name&gt;. \n";
echo "Если используется предложение VALUES, значения строк вставляются в таблицу &lt;table name&gt;. \n";
echo "Если запрос &lt;query&gt; указан, каждая строка вывода будет вставлена в таблицу &lt;table name&gt;. \n";
echo "Если список столбцов &lt;column list&gt; отсутствует, все столбцы таблицы &lt;table name , принимаются в упорядоченном виде.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>OPEN CURSOR (ОТКРЫТЬ КУРСОР)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>EXEC SQL OPEN CURSOR &lt;cursorname&gt;&lt;SQL term&gt;</p>\n";
echo "<p>OPEN CURSOR выполняет запрос, связанный с курсором &lt;cursor name&gt;. Вывод может теперь извлекать по одной строке для каждой команды FETCH.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>REVOKE (*NONSTANDARD*)<br>\n";
echo "(ОТМЕНИТЬ ПОЛНОМОЧИЯ) (НЕСТАНДАРТНАЯ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>REVOKE { ALL [PRIVILEGES]<br>\n";
echo "| &lt;privilege&gt; . , . . } [ON &lt;table name&gt;]<br>\n";
echo "FROM { PUBLIC<br>\n";
echo "| &lt;Authorization ID&gt; . , . . };</p>\n";
echo "<p>Привилегия &lt;privelege&gt; может быть любой из указанных в команде GRANT. \n";
echo "Пользователь, дающий REVOKE, должен иметь те же привилегии, что и пользователь, \n";
echo "который давал GRANT. Предложение ON может быть использовано, если применяется привилегия специального типа для особого объекта.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>ROLLBACK (WORK)<br>\n";
echo "(ОТКАТ) (ТРАНЗАКЦИИ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>ROLLBACK WORK;</p>\n";
echo "<p>Команда отменяет все изменения в базе данных, сделанные в течение текущей транзакции. Она, кроме того, заканчивается текущую и начинает новую транзакцию.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>SELECT (ВЫБОР)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>SELECT { IDISTINCT | ALL] &lt;value expression&gt; . , . . } / *<br>\n";
echo "[INTO &lt;host variable list&gt; (*только внедрённый*)]<br>\n";
echo "FROM &lt;table reference&gt; . , . .<br>\n";
echo "[WHERE &lt;predicate&gt;]<br>\n";
echo "[GROUP BY &lt;grouping column&gt; . , . .]<br>\n";
echo "[HAVING &lt;predicate&gt;]<br>\n";
echo "[ORDER BY &lt;ordering column&gt; [ASC | DESC] . , . . ];</p>\n";
echo "<p>Это предложение организует запрос и выводит значения из базы данных (см. \n";
echo "Главы 3 -  14 ).</p>\n";
echo "<p>Применяются следующие правила:</p>\n";
echo "<p></li>\n";
echo "<li>Если ни ALL, ни DISTINCT не указаны, принимается ALL.</li>\n";
echo "<li>Выражение &lt;value expression&gt; состоит из &lt;column spec&gt;, агрегатной функции &lt;aggregate funct&gt;, \n";
echo "нестандартной функции &lt;nonstandard function&gt;, постоянной &lt;constant&gt; или любой их комбинации с операторами в допустимых \n";
echo "выражениях.</li>\n";
echo "<li>Таблица, на которую ссылаются, &lt;table reference&gt;, состоит из имени таблицы, \n";
echo "включая префикс владельца, если текущий пользователь не владелец, или синоним \n";
echo "(нестандартно) таблицы. Таблица может быть или базовой таблицей, или просмотром. \n";
echo "В принципе псевдоним может указать, какой синонимом используется для таблицы, \n";
echo "только на время текущей команды. Имя таблицы или синоним должны отделяться от \n";
echo "псевдонима одним или более разделителями &lt;separator&gt;.</li>\n";
echo "<li>Если используется GROUP BY, все столбцы &lt;column spec&gt;, используемые в \n";
echo "предложении SELECT, должны будут использоваться как группа столбцов &lt;grouping \n";
echo "column&gt;, если они не содержатся в агрегатной функции &lt;aggregate funct&gt;. Вся \n";
echo "группа столбцов &lt;grouping column&gt; должна быть представлена среди выражений &lt;value expressions&gt;, указанных в предложении SELECT. \n";
echo "Для каждой отдельной комбинации значений группы столбцов &lt;grouping column&gt; будет иметься одна, и \n";
echo "только одна, строка вывода.</li>\n";
echo "<li>Если HAVING используется, предикат &lt;predicate&gt; применяется к каждой строке, \n";
echo "произведённой предложением GROUP BY, и те строки, которые сделают этот предикат \n";
echo "верным, будут выведены.</li>\n";
echo "<li>Если ORDER BY используется, вывод имеет определенную последовательность. \n";
echo "Каждый идентификатор столбца &lt;column identifer&gt; ссылается на указанное &lt;value expression&gt; в предложении SELECT. Если это \n";
echo "&lt;value expression&gt; является указанным столбцом &lt;column spec&gt;, &lt;column identifier&gt; \n";
echo "может быть таким же, как &lt;column spec&gt;. Иначе &lt;column identifier&gt; может быть положительным целым \n";
echo "числом, указывающим место, где находится &lt;value expression&gt; в \n";
echo "последовательности предложения SELECT. Вывод будет сформирован так, чтобы \n";
echo "помещать значения, содержащиеся в &lt;column identifier&gt;, в порядке возрастания, \n";
echo "если DESC не указан. Имя идентификатора столбца &lt;column identifier&gt;, стоящее \n";
echo "первым в предложении ORDER BY, будет предшествовать позже стоящим именам в \n";
echo "определении последовательности вывода.<p>Предложение SELECT оценивает каждую строку-кандидат таблицы, в которой строки \n";
echo "показаны независимо.</p>\n";
echo "<p>Строка-кандидат определяется следующим образом:</p></li>\n";
echo "<li>Если только одна ссылаемая таблица &lt;table reference&gt; включена, каждая \n";
echo "строка этой таблица в свою очередь является строкой-кандидатом.</li>\n";
echo "<li>Если более одной ссылаемой таблицы &lt;table reference&gt; включено, каждая \n";
echo "строка каждой таблицы должна быть скомбинирована, в свою очередь, с каждой \n";
echo "комбинацией строк из всех других таблиц. Каждая такая комбинация будет, в свою \n";
echo "очередь, строкой-кандидатом.<p>Каждая строка-кандидат производит значения, \n";
echo "которые делают предикат &lt;predicate&gt; в предложении WHERE верным, неверным, или неизвестным. Если GROUP BY \n";
echo "не используется, каждое &lt;value expression&gt; применяется, в свою очередь, для \n";
echo "каждой строки-кандидата, чьё значение делает предикат верным, и результатом этой \n";
echo "операции является вывод.<br>\n";
echo "Если GROUP BY используется, строки-кандидаты комбинируются, используя агрегатные \n";
echo "функции. Если никакого предиката &lt;predicate&gt; не установлено, каждое выражение &lt;value expression&gt; применяется к каждой строке-кандидату или к каждой группе. \n";
echo "Если указан DISTINCT, дубликаты (двойники) строк будут удалены из вывода.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>UNION (ОБЪЕДИНЕНИЕ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>&lt;query&gt; {UNION [ALL] &lt;query&gt; } . . . ;</p>\n";
echo "<p>Вывод двух или более запросов &lt;query&gt; будет объединён. Каждый запрос &lt;query&gt; должен содержать один и тот же номер \n";
echo "&lt;value expression&gt; в предложении SELECT и в таком порядке, что 1.. n каждого \n";
echo "совместим по типу данных &lt;data type&gt; и размеру &lt;size&gt; с 1.. n всех других.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>UPDATE (МОДИФИКАЦИЯ)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>UPDATE &lt;table name&gt;<br>\n";
echo "SET { &lt;column name&gt; = &lt;value expression&gt; } . , . .<br>\n";
echo "{[ WHERE &lt;predlcate&gt;]; }<br>\n";
echo "| {[WHERE CURRENT OF &lt;cursorname&gt;]<br>\n";
echo "&lt;SQL term&gt;]}</p>\n";
echo "<p>UPDATE изменяет значения в каждом столбце &lt;column name&gt; на \n";
echo "соответствующее значение &lt;value expression&gt;. Если предложение WHERE использует \n";
echo "предикат &lt;predicate&gt;, то только строки таблиц, чьи текущие значения делают этот \n";
echo "предикат &lt;predicate&gt; верным, могут быть изменены. Если WHERE использует \n";
echo "предложение CURRENT OF, то значения в строке таблицы &lt;table name&gt;, находящиеся в \n";
echo "курсоре &lt;cursor name&gt;, меняются. WHERE CURRENT OF \n";
echo "пригодно для использования только во вложенном SQL, и только с модифицируемыми \n";
echo "курсорами. При отсутствии предложения WHERE, все строки меняются.</p>\n";
echo "<hr width=\"40%\">\n";
echo "<h5>WHENEVER (ВСЯКИЙ РАЗ КАК)</h5>\n";
echo "<p><b><i>Синтаксис</i></b></p>\n";
echo "<p>EXEC SQL WHENEVER &lt;SQLcond&gt; &lt;actlon&gt; &lt;SQL term&gt;<br>\n";
echo "&lt;SQLcond&gt; :: = SQLERROR | NOT FOUND | SQLWARNING<br>\n";
echo "(последнее - нестандартное)<br>\n";
echo "&lt;action&gt; :: = CONTINUE | GOTO &lt;target&gt; | GOTO &lt;target&gt;<br>\n";
echo "&lt;target&gt; :: = зависит от главного языка</li>\n";
echo "</body></html>\n";
require_once ("../incfiles/end.php");  

?>  
