<?php 
/**
 * Скрипт поиска музыки.
 * Ищет с ресурса Вконтате. 
 *
 * Автор: ofroke 
 * ICQ: 531103
 * 
 * Скрипт написан на PHP с использованием MySQL. 
 * Высокая скорость работы скрипта, мизерная нагрузка.
 * Полная поддержка по скрипту.
 *
 * Все права защищены © 2010 - 2011
 */
 
class main {

	public static function randcode($length = 10) {
		return substr(str_shuffle(implode('', array_merge(range('A', 'Z'), range('a', 'z'), range(0, 9)))),0, $length);
		
	}

	public static function selected($a, $b) {
		return ($a == $b ? ' selected="selected"' : '');

	}
	
	public static function checked($a, $b) {
		return ($a == $b ? ' checked="checked"' : '');

	}

	public static function filesize($filesize = 0)
	{
		$filesize_ed = ' B';
		if ($filesize >= 1024)
		{
			$filesize = round($filesize / 1024, 2);
			$filesize_ed = ' KB';
		}
		if ($filesize >= 1024)
		{
			$filesize = round($filesize / 1024, 2);
			$filesize_ed = ' MB';
		}
		return $filesize . $filesize_ed;
	}
	public static function time($time) {
		
		$date = date('dmy', $time);
		if($date == date('dmy', time()))
			return date('Сегодня в H:i', $time);
			
		elseif($date == date('dmy', time() - 86400))
			return date('Вчера в H:i', $time);
			
		else 
		return strtr(date($GLOBALS['config']['system']['date'], $time),
		array(
			'Jan' => 'Января', 
			'Feb' => 'Февраля', 
			'Mar' => 'Марта', 
			'Apr' => 'Апреля', 
			'May' => 'Мая', 
			'Jun' => 'Июня', 
			'Jul' => 'Июля', 
			'Aug' => 'Августа', 
			'Sep' => 'Сентября', 
			'Oct' => 'Октября', 
			'Nov' => 'Ноября', 
			'Dec' => 'Декабря'
		));
	} 
	
	/**
	* Подстройка окончания
	* @param int, string, string, string
	* @using echo end_str(2,'сообщение','сообщения','сообщений');
	*/
	public static function text_ends($count, $k_1, $k_234, $k_many, $cnt = false) {
	    $count  = (string)$count;
	     $num_xx = (int)@$count[strlen($count)-2].@$count[strlen($count)-1];
	    $num_x  = (int)$count[strlen($count)-1];
	    if($num_xx<>11 && $num_xx<>12 && $num_xx<>13 && $num_xx<>14)
	    {
	        if($num_x==1)
	        {
	            return ($cnt ? $count . ' ' : '') . $k_1;
	        }else
	        if($num_x==2 || $num_x==3 || $num_x==4)
	        {
	            return ($cnt ? $count . ' ' : '') . $k_234;
	        }else{
	            return ($cnt ? $count . ' ' : '') . $k_many;
	        }
	    }else{
	        return ($cnt ? $count . ' ' : '') . $k_many;
	    }
	}
	
	public static function detranslit($str){
		$str=strtr($str, array(' '=>'_','а'=>'a','б'=>'b','в'=>'v','г'=>'g','д'=>'d','е'=>'e','ё'=>'yo','ж'=>'zh','з'=>'z','и'=>'i','й'=>'j','к'=>'k','л'=>'l','м'=>'m','н'=>'n','о'=>'o','п'=>'p','р'=>'r','с'=>'s','т'=>'t','у'=>'u','ф'=>'f','х'=>'h','ц'=>'c','ч'=>'ch','ш'=>'sh','щ'=>'sch','ь'=>'q','ы'=>'x','э'=>'ye','ю'=>'yu','я'=>'ya',
	  							'А'=>'A','Б'=>'B','В'=>'V','Г'=>'G','Д'=>'D','Е'=>'E','Ё'=>'YO','Ж'=>'ZH','З'=>'Z','И'=>'I','Й'=>'J','К'=>'K','Л'=>'L','М'=>'M','Н'=>'N','О'=>'O','П'=>'P','Р'=>'R','С'=>'S','Т'=>'T','У'=>'U','Ф'=>'F','Х'=>'H','Ц'=>'C','Ч'=>'CH','Ш'=>'SH','Щ'=>'SCH','Ь'=>'Q','Ы'=>'X','Э'=>'YE','Ю'=>'YU','Я'=>'YA')
	  	);
	   	return $str;
	}
	
	public static function clear_cache($dir = 'data') {
	
		foreach(array_diff(scandir($dir . '/', 0), array('.', '..')) as $f) {

			$file = $dir . '/' . $f;
			
			if(is_dir($file))
				self::clear_cache($file);
				
			elseif(@filemtime($file) < (time() - 86400)) {
				@unlink($file);
			}
			
			@rmdir(dirname($file));
			
		}
	
	}
	
	public static function str_to_utf8($str)
	{
		if (@iconv('UTF-8', 'UTF-8//IGNORE', $str) != $str) {
			$str = iconv('Windows-1251', 'UTF-8//TRANSLIT', $str);
		}
		return $str;
	}

}
?>