<?php
/**
 * Скрипт поиска музыки.
 * Ищет с ресурса Вконтате. 
 *
 * Автор: ofroke 
 * ICQ: 531103
 * 
 * Скрипт написан на PHP с использованием MySQL. 
 * Высокая скорость работы скрипта, мизерная нагрузка.
 * Полная поддержка по скрипту.
 *
 * Все права защищены © 2010 - 2011
 */
 
class search extends controller {

	function __construct($registry) {
		parent::__construct($registry);
		main::clear_cache('data');
	}
	
	function title() {
		return 'Поиск по запросу: '.xss(rawurldecode($_GET['query'])).'';
	}
	
	function keywords() {
		$search = xss(rawurldecode($_GET['query']));
		return 'Искать '.$search.', скачать '.$search.', слушать онлайн '.$search.', скачать '.$search.' бесплатно.';
	}
	
	function content() {
		
		$offset = (isset($_GET['page']) ? (intval($_GET['page'])-1).'0' : 0);
		$sort = ($_GET['sort'] == 1 ? 1 : 0);
		$duration = (isset($_GET['duration']) ? 1 : 0);
		$lyrics = (isset($_GET['lyrics']) ? 1 : 0);
		

		$sig  = vk::$set['user_id'];
		$sig .= 'api_id='.vk::$set['api_id'];
		$sig .= 'count='.PAGES;
		$sig .= 'lyrics='.$lyrics;
		$sig .= 'method=audio.search';
		$sig .= 'offset='.$offset;
		$sig .= 'q='.rawurldecode($_GET['query']);
		$sig .= 'sort='.$sort;
		$sig .= 'test_mode=1';
		$sig .= 'v=2.0';
		$sig .= vk::$set['key'];
		$sig  = md5($sig);
	 
		$query  = 'api_id='.vk::$set['api_id'];
		$query .= '&count='.PAGES;
		$query .= '&lyrics='.$lyrics;
		$query .= '&method=audio.search';
		$query .= '&offset='.$offset;
		$query .= '&q='.rawurldecode($_GET['query']);
		$query .= '&sort='.$sort;
		$query .= '&test_mode=1';
		$query .= '&v=2.0';
		$query .= '&sig='.$sig;

		$send_post = vk::send_post('http://api.vkontakte.ru/api.php', $query, 'http://vkontakte.ru/app'.vk::$set['api_id'].'_'.vk::$set['user_id']);
		
		$xml = new SimpleXMLElement($send_post);
	
		$count = ($xml->count >= 1000) ? 1000 : $xml->count;

		if($count && !empty($xml->audio)) {
			
			$this->db->unbuffered_query("REPLACE INTO `".SEARCH."` (`value`, `data`) VALUES ('".real(xss(rawurldecode($_GET['query'])))."', UNIX_TIMESTAMP());");
			$this->db->unbuffered_query("DELETE FROM `".SEARCH_COUNT."` WHERE `data` < (UNIX_TIMESTAMP() - 86400) LIMIT " . SEARCH_COUNT);
			
			$n = new Navigation($count, PAGES, URL . 'search/?query='.rawurlencode($_GET['query']).'&amp;sort='.$sort . ($duration ? '&amp;duration=1' : '') . ($lyrics ? '&amp;lyrics=1' : '').'&amp;page='); 
			$n->start();
			$i = 0;
			
			echo '<div class="block">
			Запрос: <b>'.xss(rawurldecode($_GET['query'])).'</b> <br/>
			Найдено: <b>'.$xml->count.'</b> '.main::text_ends($count, 'композиция', 'композиции', 'композиций').' <br/>
			</div>';
			
			$sql = "INSERT IGNORE INTO `".AUDIO."` (`aid`, `owner_id`, `title`, `artist`, `duration`, `lyrics_id`) VALUES";
			
			foreach($xml->audio as $audio) {
			
				$replace = array ("'<[\/\!]*?[^<>]*?>'si", "'&#([\w\d]+);'i", "'&#'i");   
				
				$audio->duration1 = ($duration ? '<span class="gr">('.floor($audio->duration / 60) . ':' . floor($audio->duration % 60) .')</span>' : '');
				$audio->title = preg_replace($replace, ' ', iconv_substr($audio->title, 0, 60, 'UTF-8'));
				$audio->artist = preg_replace($replace, ' ', iconv_substr($audio->artist, 0, 60, 'UTF-8'));
				
				echo '<div  class="'.($i++ % 2 ? 'line' : 'line2').'" style="padding: 5px;">
				<a href="'.URL.'track/'.base64_encode($audio->aid.';'.$audio->owner_id).'/"><strong>'.$audio->artist.'</strong> - '.$audio->title.'</a> '.$audio->duration1.'</div>';
				
				$sql .= "('".$audio->aid."', '".$audio->owner_id."', '".real($audio->title)."', '".real($audio->artist)."', '".$audio->duration."', '".(isset($audio->lyrics_id) ? $audio->lyrics_id : NULL)."'),";
				
			}
			
			echo $n->navi();
		
			$this->db->unbuffered_query(rtrim($sql, ','));
			
		} else
			echo '<div class="error">Нет результатов по данному запросу</div>';
			
		echo '<div class="downnav"><a href="/">Главная</a>|<a href="'.URL.'">Поиск</a>|<b>Результаты поиска</b></div>';
	}


}

?>