<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

defined('_IN_JOHNADM') or die('Error: restricted access');

// Проверяем права доступа
if ($rights < 9) {
    header('Location: http://johncms.com/?err');
    exit;
}
$panel_lng = core::load_lng('panel_lng');

/*
-----------------------------------------------------------------
Читаем каталог с файлами языков
-----------------------------------------------------------------
*/
$lng_list = array();
$lng_desc = array();
foreach (glob('../incfiles/languages/*/_core.ini') as $val) {
    $dir = explode('/', dirname($val));
    $iso = array_pop($dir);
    $desc = parse_ini_file($val);
    $lng_list[$iso] = isset($desc['name']) && !empty($desc['name']) ? $desc['name'] : $iso;
    $lng_desc[$iso] = $desc;
}

/*
-----------------------------------------------------------------
Автоустановка языков
-----------------------------------------------------------------
*/
if(isset($_GET['refresh'])){
    mysql_query("DELETE FROM `cms_settings` WHERE `key` = 'lng_list'");
    core::$lng_list = array();
    echo '<div class="gmenu"><p>' . $lng['refresh_descriptions_ok'] . '</p></div>';
}
$lng_add = array_diff(array_keys($lng_list), array_keys(core::$lng_list));
$lng_del = array_diff(array_keys(core::$lng_list), array_keys($lng_list));
if (!empty($lng_add) || !empty($lng_del)) {
    if (!empty($lng_del) && in_array($set['lng'], $lng_del)) {
        // Если удаленный язык был системный, то меняем на первый доступный
        mysql_query("UPDATE `cms_settings` SET `val` = '" . key($lng_list) . "' WHERE `key` = 'lng' LIMIT 1");
    }
    $req = mysql_query("SELECT * FROM `cms_settings` WHERE `key` = 'lng_list'");
    if (mysql_num_rows($req)) {
        mysql_query("UPDATE `cms_settings` SET `val` = '" . serialize($lng_list) . "' WHERE `key` = 'lng_list' LIMIT 1");
    } else {
        mysql_query("INSERT INTO `cms_settings` SET `key` = 'lng_list', `val` = '" . serialize($lng_list) . "'");
    }
}

switch ($mod) {
    case 'set':
        /*
        -----------------------------------------------------------------
        Меняем системный язык
        -----------------------------------------------------------------
        */
        $iso = isset($_POST['iso']) ? trim($_POST['iso']) : false;
        if ($iso && array_key_exists($iso, $lng_list)) {
            mysql_query("UPDATE `cms_settings` SET `val` = '" . mysql_real_escape_string($iso) . "' WHERE `key` = 'lng'");
        }
        header('Location: index.php?act=languages');
        break;

    case 'edit':
        /*
        -----------------------------------------------------------------
        Редактируем язык
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        if (isset($_POST['submit']) && !empty($_POST['name'])) {
            $name = trim($_POST['name']);
            $author = isset($_POST['author']) ? trim($_POST['author']) : '';            
            $author_email = isset($_POST['author_email']) ? trim($_POST['author_email']) : '';
            $author_url = isset($_POST['author_url']) ? trim($_POST['author_url']) : '';
            $description = isset($_POST['description']) ? trim($_POST['description']) : '';
            $text = 'name = "' . $name . '"' . "\r\n" . 'author = "' . $author . '"' . "\r\n" . 'author_email = "' . $author_email . '"' . "\r\n" . 'author_url = "' . $author_url . '"' . "\r\n" . 'description = "' . $description . '"';
            // Перезаписываем файл
            $open_file = fopen('../incfiles/languages/' . $language . '/_core.ini', w);
            fputs($open_file, $text);
            fclose($open_file);
            header('Location: index.php?act=languages&do=edit');
            exit;
        } else {
            $lng_core = parse_ini_file('../incfiles/languages/' . $language . '/_core.ini');
            echo '<div class="phdr"><a href="index.php?act=languages"><b>' . $panel_lng['languages'] . '</b></a> | <b>' . $lng_list[$language] . '</b>: ' . $panel_lng['edit'] . '</div>' .
                 '<form name="form" action="?act=languages&amp;mod=edit&amp;language=' . $language . '" method="POST">' .
                 '<div class="menu"><p><ul><li>' . $lng['title'] . ':&#160;<br /><input type="text" name="name" value="' . $lng_core['name'] . '"/></li>' .
                 '<li>' . $lng['author'] . ':&#160;<br /><input type="text" name="author" value="' . $lng_core['author'] . '"/></li>' .
                 '<li>E-mail:&#160;<br /><input type="text" name="author_email" value="' . $lng_core['author_email'] . '"/></li>' .
                 '<li>URL:&#160;<br /><input type="text" name="author_url" value="' . $lng_core['author_url'] . '"/></li>' .
                 '<li>' . $lng['description'] . ':&#160;<br />' .   
                 '<textarea rows="' . $set_user['field_h'] . '" name="description">' . $lng_core['description'] . '</textarea></li></ul></p></div>' .
                 '<div class="gmenu"><input type="submit" name="submit" value="' . $lng['save'] . '"/>' .
                 '</div></form>' .
                 '<div class="phdr"><a href="?act=languages"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'add':
        /*
        -----------------------------------------------------------------
        Добавляем язык
        -----------------------------------------------------------------
        */
        if (isset($_POST['submit']) && !empty($_POST['name']) && !empty($_POST['iso'])) {
            $name = trim($_POST['name']);
            $iso_lng = trim(mb_substr($_POST['iso'], 0, 2));     
            if (!preg_match("/^[a-z]+$/", $iso_lng)) {
                header('Location: index.php?act=languages&do=error');
                exit;
            }
            $author = isset($_POST['author']) ? trim($_POST['author']) : '';            
            $author_email = isset($_POST['author_email']) ? trim($_POST['author_email']) : '';
            $author_url = isset($_POST['author_url']) ? trim($_POST['author_url']) : '';
            $description = isset($_POST['description']) ? trim($_POST['description']) : '';
            $text = 'name = "' . $name . '"' . "\r\n" . 'author = "' . $author . '"' . "\r\n" . 'author_email = "' . $author_email . '"' . "\r\n" . 'author_url = "' . $author_url . '"' . "\r\n" . 'description = "' . $description . '"';
            if (is_dir('../incfiles/languages/' . $iso_lng)) {
                header('Location: index.php?act=languages&do=error');
                exit;
            }
            $add_dir = mkdir('../incfiles/languages/' . $iso_lng, 0777);
            if ($add_dir == true) {
                @ chmod('../incfiles/languages/' . $iso_lng, 0777);
                // Перезаписываем файл
                $open_file = fopen('../incfiles/languages/' . $iso_lng . '/_core.ini', w);
                fputs($open_file, $text);
                fclose($open_file);
                @ chmod('../incfiles/languages/' . $iso_lng . '/_core.ini', 0777);
                header('Location: index.php?act=languages&do=add');
                exit;
            } else {
                header('Location: index.php?act=languages&do=error');
                exit;
            }
        } else {
            echo '<div class="phdr"><a href="index.php?act=languages"><b>' . $panel_lng['languages'] . '</b></a> | ' . $panel_lng['add'] . '</div>' .
                 '<form name="form" action="?act=languages&amp;mod=add" method="POST">' .
                 '<div class="menu"><p><ul><li>ISO:&#160;<br /><input type="text" name="iso" size="2" maxlength="2"/></li>' .
                 '<li>' . $lng['title'] . ':&#160;<br /><input type="text" name="name"/></li>' .
                 '<li>' . $lng['author'] . ':&#160;<br /><input type="text" name="author"/></li>' .
                 '<li>E-mail:&#160;<br /><input type="text" name="author_email"/></li>' .
                 '<li>URL:&#160;<br /><input type="text" name="author_url"/></li>' .
                 '<li>' . $lng['description'] . ':&#160;<br />' .   
                 '<textarea rows="' . $set_user['field_h'] . '" name="description"></textarea></li></ul></p></div>' .
                 '<div class="gmenu"><input type="submit" name="submit" value="' . $lng['save'] . '"/>' .
                 '</div></form>' .
                 '<div class="phdr"><a href="?act=languages"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'delete':
        /*
        -----------------------------------------------------------------
        Удаляем выбранный язык
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header("Location: index.php?act=languages&do=error");
            exit;
        }
        if (isset($_GET['yes'])) {        
            $mass_file = opendir('../incfiles/languages/' . $language);
            while ($dir_file = readdir($mass_file)) {
                unlink('../incfiles/languages/' . $language . '/' . $dir_file);
            }
            closedir($mass_file);
            rmdir('../incfiles/languages/' . $language . '/');
            header('Location: index.php?act=languages&do=delete');
            exit;
        } else {
            echo '<div class="phdr"><a href="index.php?act=languages"><b>' . $panel_lng['languages'] . '</b></a> | <b>' . $lng_list[$language] . '</b>: ' . $panel_lng['delete'] . '</div>' .
                 '<div class="rmenu"><p>' . $panel_lng['language_deletes'] . '</p>' .
                 '<p><a href="?act=languages&amp;mod=delete&amp;language=' . $language . '&amp;yes"><b>' . $lng['continue'] . '</b></a></p>' .
                 '</div>' .
                 '<div class="phdr"><a href="?act=languages"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'module':
        /*
        -----------------------------------------------------------------
        Вводим список языковых модулей
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        $mass_file = opendir('../incfiles/languages/' . $language);
        while ($dir_file = readdir($mass_file)) {
            if ($dir_file != "." && $dir_file != ".." && $dir_file != 'index.php' && $dir_file != '.svn' && $dir_file != '_core.ini') {
                $mass_module[] = $dir_file;
            }
        }
        closedir($mass_file);
        $total = count($mass_module);
        echo '<div class="phdr"><a href="index.php?act=languages"><b>' . $panel_lng['languages'] . '</b></a> | <b>' . $lng_list[$language] . '</b>: ' . $lng['modules'] . '</div>';
        switch ($do) {
            case 'add':
                echo '<div class="gmenu"><b>' . $panel_lng['modul_add'] . '!</b></div>';
                break;
    
            case 'delete':
                echo '<div class="gmenu"><b>' . $panel_lng['modul_delete'] . '!</b></div>';
                break;
    
            case 'edit':
                echo '<div class="gmenu"><b>' . $panel_lng['module_edit'] . '!</b></div>';
                break;
    
            case 'error':
                echo '<div class="rmenu"><b>' . $panel_lng['error'] . '!</b></div>';
                break;

            default :
                echo '';
        }
        if ($total) {
            $count = $start + $kmess > $total ? $total : $start + $kmess;
            for ($i = $start; $i < $count; $i++) {
                echo is_integer($i / 2) ? '<div class="list1">' : '<div class="list2">';
                $mass_line = file('../incfiles/languages/' . $language . '/' . $mass_module[$i]);
                echo '<a href="index.php?act=languages&amp;mod=edit_module&amp;language=' . $language . '&amp;module=' . $mass_module[$i] . '"><b>' . substr($mass_module[$i], 0, strrpos($mass_module[$i], ".")) . '</b></a>' .
                     '<div class="sub">' .
                     '<a href="?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $mass_module[$i] . '&amp;start=' . $start . '">' . $panel_lng['phrases'] . ' (' . count($mass_line) . ')</a> - ' .
                     '<a href="?act=languages&amp;mod=delete_module&amp;language=' . $language . '&amp;module=' . $mass_module[$i] . '&amp;start=' . $start . '">' . $lng['delete'] . '</a>' .
                     '</div></div>';
            }
            echo '<div class="gmenu"><form name="form" action="?act=languages&amp;mod=add_module&amp;language=' . $language . '&amp;start=' . $start . '" method="POST">' .
                 '<input type="submit" name="submit" value="' . $panel_lng['module_adds'] . '"/>&#160;' .
                 '</form></div>' .
                 '<div class="phdr">' . $lng['total'] . ': <b>' . $total . '</b></div>';
            if ($total > $kmess) {
                echo '<div class="topmenu">' . functions::display_pagination('?act=languages&amp;mod=module&amp;language=' . $language . '&amp;', $start, $total, $kmess) . '</div>' .
                     '<p><form action="?act=languages&amp;mod=module&amp;language=' . $language . '&amp;" method="post">' .
                     '<input type="text" name="page" size="2"/>' .
                     '<input type="submit" value="' . $lng['to_page'] . ' &gt;&gt;"/></form></p>';
            }
        } else {
            echo '<div class="rmenu"><p>' . $lng['list_empty'] . '!</p></div>' .
                 '<div class="gmenu"><form name="form" action="?act=languages&amp;mod=add_module&amp;language=' . $language . '&amp;start=' . $start . '" method="POST">' .
                 '<input type="submit" name="submit" value="' . $panel_lng['module_adds'] . '"/>&#160;' .
                 '</form></div>' .
                 '<div class="phdr"><a href="?act=languages"><b>' . $lng['back'] . '</b></a></div>';
        }
        echo '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        break;

    case 'add_module':
        /*
        -----------------------------------------------------------------
        Добавляем языковой модуль
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        if (isset($_POST['submit']) && !empty($_POST['name'])) {
            $name = isset($_POST['name']) ? trim(mb_substr($_POST['name'], 0, 30)) : false;
            if (!preg_match("/^[a-z0-9_]+$/", $name)) {
                header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
                exit;
            }
            if (!$name || is_file('../incfiles/languages/' . $language . '/' . $name . '.lng')) {
                header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
                exit;
            }
            $open_file = fopen('../incfiles/languages/' . $language . '/' . $name . '.lng', w);
            fclose($open_file);
            @ chmod('../incfiles/languages/' . $language . '/' . $name . '.lng', 0777);
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=add');
            exit;
        } else {
            echo '<div class="phdr"><b>' . $lng_list[$language] . '</b>: <a href="index.php?act=languages&amp;mod=module&amp;language=' . $language . '"><b>' . $lng['modules'] . '</b></a> | ' . $panel_lng['add'] . '</div>' .
                 '<form name="form" action="?act=languages&amp;mod=add_module&amp;language=' . $language . '&amp;start=' . $start . '" method="POST">' .
                 '<div class="menu"><p><h3>' . $lng['title'] . '</h3>' .   
                 '<input type="text" name="name" maxlength="30"/></p></div>' .
                 '<div class="gmenu"><input type="submit" name="submit" value="' . $lng['save'] . '"/>' .
                 '</div></form>' .
                 '<div class="phdr"><a href="?act=languages&amp;mod=module&amp;language=' . $language . '&amp;start=' . $start . '"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'edit_module':
        /*
        -----------------------------------------------------------------
        Переименовываем языковой модуль
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        $module = isset($_GET['module']) ? trim($_GET['module']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        if (!$module || !is_file('../incfiles/languages/' . $language . '/' . $module)) {
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
            exit;
        }
        if (isset($_POST['submit']) && !empty($_POST['name'])) {
            $name = isset($_POST['name']) ? trim(mb_substr($_POST['name'], 0, 30)) : false;
            if (!preg_match("/^[a-z0-9_]+$/", $name)) {
                header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
                exit;
            }
            if ($module != $name . '.lng') {
                copy('../incfiles/languages/' . $language . '/' . $module, '../incfiles/languages/' . $language . '/' . $name . '.lng');
                @ chmod('../incfiles/languages/' . $language . '/' . $name . '.lng', 0777);
                unlink('../incfiles/languages/' . $language . '/' . $module);
            }
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=edit');
            exit;
        } else {
            echo '<div class="phdr"><b>' . $lng_list[$language] . '</b>: <a href="index.php?act=languages&amp;mod=module&amp;language=' . $language . '"><b>' . $lng['modules'] . '</b></a> | ' . $panel_lng['edit'] . '</div>' .
                 '<form name="form" action="?act=languages&amp;mod=edit_module&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '" method="POST">' .
                 '<div class="menu"><p><h3>' . $lng['title'] . '</h3>' .   
                 '<input type="text" name="name" maxlength="30" value ="' . substr($module, 0, strrpos($module, ".")) . '"/></p></div>' .
                 '<div class="gmenu"><input type="submit" name="submit" value="' . $lng['save'] . '"/>' .
                 '</div></form>' .
                 '<div class="phdr"><a href="?act=languages&amp;mod=module&amp;language=' . $language . '&amp;start=' . $start . '"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'delete_module':
        /*
        -----------------------------------------------------------------
        Удаляем языковой модуль
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        $module = isset($_GET['module']) ? trim($_GET['module']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        if (!$module || !is_file('../incfiles/languages/' . $language . '/' . $module)) {
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
            exit;
        }
        if (isset($_GET['yes'])) {
            unlink('../incfiles/languages/' . $language . '/' . $module);
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=delete');
            exit;
        } else {
            echo '<div class="phdr"><b>' . $lng_list[$language] . '</b>: <a href="index.php?act=languages&amp;mod=module&amp;language=' . $language . '"><b>' . $lng['modules'] . '</b></a> | ' . $panel_lng['delete'] . '</div>' .
                 '<div class="rmenu"><p>' . $panel_lng['language_deletes'] . '</p>' .
                 '<p><a href="?act=languages&amp;mod=delete_module&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '&amp;yes"><b>' . $lng['continue'] . '</b></a></p>' .
                 '</div>' .
                 '<div class="phdr"><a href="?act=languages&amp;mod=module&amp;language=' . $language . '&amp;start=' . $start . '"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'phrases':
        /*
        -----------------------------------------------------------------
        Выводим список фраз модуля
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        $module = isset($_GET['module']) ? trim($_GET['module']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        if (!$module || !is_file('../incfiles/languages/' . $language . '/' . $module)) {
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
            exit;
        }
        $mass_line = file('../incfiles/languages/' . $language . '/' . $module);
        $total = count($mass_line);
        echo '<div class="phdr"><b>' . $lng_list[$language] . '</b>: <a href="index.php?act=languages&amp;mod=module&amp;language=' . $language . '"><b>' . $lng['modules'] . '</b></a> | ' . $panel_lng['phrases'] . '</div>';
        switch ($do) {
            case 'add':
                echo '<div class="gmenu"><b>' . $panel_lng['phrase_add'] . '!</b></div>';
                break;

            case 'delete':
                echo '<div class="gmenu"><b>' . $panel_lng['phrase_delete'] . '!</b></div>';
                break;

            case 'edit':
                echo '<div class="gmenu"><b>' . $panel_lng['phrase_edit'] . '!</b></div>';
                break;

            case 'error':
                echo '<div class="rmenu"><b>' . $panel_lng['error'] . '!</b></div>';
                break;

            default :
                echo '';
        }
        if ($total) {
            $count = $start + $kmess > $total ? $total : $start + $kmess;
            for ($i = $start; $i < $count; $i++) {
                if (trim($mass_line[$i])) {
                    $text = explode('"', $mass_line[$i]);
                    $key = trim(str_replace('=', '', $text[0]));
                    $value = functions::checkout($text[1]);
                    echo is_integer($i / 2) ? '<div class="list1">' : '<div class="list2">';
                    echo $key . '<br />' . $value .
                         '<div class="sub">' .
                         '<a href="?act=languages&amp;mod=edit_phrase&amp;language=' . $language . '&amp;module=' . $module . '&amp;line=' . $i . '&amp;start=' . $start . '">Ред.</a> - ' .
                         '<a href="?act=languages&amp;mod=delete_phrase&amp;language=' . $language . '&amp;module=' . $module . '&amp;line=' . $i . '&amp;start=' . $start . '">' . $lng['delete'] . '</a>' .
                         '</div></div>';
                }
            }
            echo '<div class="gmenu"><form name="form" action="?act=languages&amp;mod=add_phrase&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '" method="POST">' .
                 '<input type="submit" name="submit" value="' . $panel_lng['phrase_adds'] . '"/>&#160;' .
                 '</form></div>' .
                 '<div class="phdr">' . $lng['total'] . ': <b>' . $total . '</b></div>';
            if ($total > $kmess) {
                echo '<div class="topmenu">' . functions::display_pagination('?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '&amp;', $start, $total, $kmess) . '</div>' .
                     '<p><form action="?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '&amp;" method="post">' .
                     '<input type="text" name="page" size="2"/>' .
                     '<input type="submit" value="' . $lng['to_page'] . ' &gt;&gt;"/></form></p>';
            }
        } else {
            echo '<div class="rmenu"><p>' . $lng['list_empty'] . '!</p></div>' .
                 '<div class="gmenu"><form name="form" action="?act=languages&amp;mod=add_phrase&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '" method="POST">' .
                 '<input type="submit" name="submit" value="' . $panel_lng['phrase_adds'] . '"/>&#160;' .
                 '</form></div>' .
                 '<div class="phdr"><a href="?act=languages&amp;mod=module&amp;language=' . $language . '"><b>' . $lng['back'] . '</b></a></div>';
        }
        echo '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        break;

    case 'edit_phrase':
        /*
        -----------------------------------------------------------------
        Редактируем отдельную фразу языкового модуля
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        $module = isset($_GET['module']) ? trim($_GET['module']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        if (!$module || !is_file('../incfiles/languages/' . $language . '/' . $module)) {
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
            exit;
        }
        $line = isset($_GET['line']) ? intval($_GET['line']) : 0;
        if (isset($_POST['submit']) && !empty($_POST['key']) && !empty($_POST['value'])) {
            $mass_line = file('../incfiles/languages/' . $language . '/' . $module);
            $total = count($mass_line); 
            if ($line > $total - 1) {
                header('Location: index.php?act=languages&mod=phrases&language=' . $language . '&module=' . $module . '&start=' . $start . '&do=error');
                exit;
            }
            // Формируем данные для записи 
            $key = trim(mb_substr($_POST['key'], 0, 27));
            if (!preg_match("/^[a-z0-9_]+$/", $key)) {
                header('Location: index.php?act=languages&mod=phrases&language=' . $language . '&module=' . $module . '&start=' . $start . '&do=error');
                exit;
            }
            $value = trim($_POST['value']);                
            $value = trim(str_replace('"', '', $value));
            $value = str_replace("\r\n", '', $value);
            $mass_line[$line] = $key . ' = "' . $value . '"' . "\r\n";
            $text = implode('', $mass_line);
            // Перезаписываем файл
            $open_file = fopen('../incfiles/languages/' . $language . '/' . $module, w);
            fputs($open_file, $text);
            fclose($open_file);
            @ chmod('../incfiles/languages/' . $language . '/' . $module, 0777);
            header('Location: index.php?act=languages&mod=phrases&language=' . $language . '&module=' . $module . '&start=' . $start . '&do=edit');
            exit;
        } else {
            $mass_line = file('../incfiles/languages/' . $language . '/' . $module);
            $total = count($mass_line);
            $text = explode('"', $mass_line[$line]);
            $key = trim(str_replace('=', '', $text[0]));
            $value = trim($text[1]);
            echo '<div class="phdr"><b>' . $lng_list[$language] . '</b>: <a href="index.php?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '"><b>' . $panel_lng['phrases'] . '</b></a> | ' . $panel_lng['edit'] . '</div>' .
                 '<form name="form" action="?act=languages&amp;mod=edit_phrase&amp;language=' . $language . '&amp;module=' . $module . '&amp;line=' . $line . '&amp;start=' . $start . '" method="POST">' .
                 '<div class="menu"><p><h3>' . $panel_lng['key'] . '</h3>' .   
                 '<input type="text" name="key" maxlength="27" value="' . htmlentities($key, ENT_QUOTES, 'UTF-8') . '"/></p>' .
                 '<p><h3>' . $panel_lng['value'] . '</h3>' .
                 '<textarea rows="' . $set_user['field_h'] . '" name="value">' . htmlentities($value, ENT_QUOTES, 'UTF-8') . '</textarea></p></div>' .
                 '<div class="gmenu"><input type="submit" name="submit" value="' . $lng['save'] . '"/>' .
                 '</div></form>' .
                 '<div class="phdr"><a href="?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'add_phrase':
        /*
        -----------------------------------------------------------------
        Добавляем фразу в языковой модуль
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        $module = isset($_GET['module']) ? trim($_GET['module']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header('Location: index.php?act=languages&do=error');
            exit;
        }
        if (!$module || !is_file('../incfiles/languages/' . $language . '/' . $module)) {
            header('Location: index.php?act=languages&mod=module&language=' . $language . '&start=' . $start . '&do=error');
            exit;
        }
        if (isset($_POST['submit']) && !empty($_POST['key']) && !empty($_POST['value'])) {
            $mass_line = file('../incfiles/languages/' . $language . '/' . $module);
            // Формируем данные для записи 
            $key = trim(mb_substr($_POST['key'], 0, 27));
            if (!preg_match("/^[a-z0-9_]+$/", $key)) {
                header("Location: index.php?act=languages&mod=phrases&language=$language&module=$module&start=$start&do=error");
                exit;
            }
            $value = trim($_POST['value']);                
            $value = trim(str_replace('"', '', $value));
            $value = str_replace("\r\n", '', $value);
            $text = implode('', $mass_line);
            $text .= $key . ' = "' . $value . '"' . "\r\n";
            // Перезаписываем файл
            $open_file = fopen('../incfiles/languages/' . $language . '/' . $module, w);
            fputs($open_file, $text);
            fclose($open_file);
            @ chmod('../incfiles/languages/' . $language . '/' . $module, 0777);
            header("Location: index.php?act=languages&mod=phrases&language=$language&module=$module&start=$start&do=add");
            exit;
        } else {
            echo '<div class="phdr"><b>' . $lng_list[$language] . '</b>: <a href="index.php?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '"><b>' . $panel_lng['phrases'] . '</b></a> | ' . $panel_lng['add'] . '</div>' .
                 '<form name="form" action="?act=languages&amp;mod=add_phrase&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '" method="POST">' .
                 '<div class="menu"><p><h3>' . $panel_lng['key'] . '</h3>' .   
                 '<input type="text" name="key" maxlength="27"/></p>' .
                 '<p><h3>' . $panel_lng['value'] . '</h3>' .
                 '<textarea rows="' . $set_user['field_h'] . '" name="value"></textarea></p></div>' .
                 '<div class="gmenu"><input type="submit" name="submit" value="' . $lng['save'] . '"/>' .
                 '</div></form>' .
                 '<div class="phdr"><a href="?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    case 'delete_phrase':
        /*
        -----------------------------------------------------------------
        Удаляем отдельную фразу из языкового модуля
        -----------------------------------------------------------------
        */
        $language = isset($_GET['language']) ? trim($_GET['language']) : false;
        $module = isset($_GET['module']) ? trim($_GET['module']) : false;
        if (!$language || !array_key_exists($language, $lng_list)) {
            header("Location: index.php?act=languages&do=error");
            exit;
        }
        if (!$module || !is_file('../incfiles/languages/' . $language . '/' . $module)) {
            header("Location: index.php?act=languages&mod=module&language=$language&start=$start&do=error");
            exit;
        }
        $line = isset($_GET['line']) ? intval($_GET['line']) : 0;
        if (isset($_GET['yes'])) {
            $mass_line = file('../incfiles/languages/' . $language . '/' . $module);
            $total = count($mass_line); 
            if ($line > $total - 1) {
                header("Location: index.php?act=languages&mod=phrases&language=$language&module=$module&start=$start&do=error");
                exit;
            }
            // Формируем данные для записи 
            $mass_line[$line] = '';
            $text = implode('', $mass_line);
            // Перезаписываем файл
            $open_file = fopen('../incfiles/languages/' . $language . '/' . $module, w);
            fputs($open_file, $text);
            fclose($open_file);
            header("Location: index.php?act=languages&mod=phrases&language=$language&module=$module&start=$start&do=delete");
            exit;
        } else {
            $mass_line = file('../incfiles/languages/' . $language . '/' . $module);
            $total = count($mass_line);
            $text = explode('"', $mass_line[$line]);
            $key = trim(str_replace('=', '', $text[0]));
            $value = trim($text[1]);
            echo '<div class="phdr"><b>' . $lng_list[$language] . '</b>: <a href="index.php?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '"><b>' . $panel_lng['phrases'] . '</b></a> | ' . $panel_lng['delete'] . '</div>' .
                 '<div class="rmenu"><p>' . $panel_lng['phrase_deletes'] . '</p>' .
                 '<p><a href="?act=languages&amp;mod=delete_phrase&amp;language=' . $language . '&amp;module=' . $module . '&amp;line=' . $line . '&amp;start=' . $start . '&amp;yes"><b>' . $lng['continue'] . '</b></a></p>' .
                 '</div>' .
                 '<div class="phdr"><a href="?act=languages&amp;mod=phrases&amp;language=' . $language . '&amp;module=' . $module . '&amp;start=' . $start . '"><b>' . $lng['back'] . '</b></a></div>' .
                 '<p><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
        }
        break;

    default:
        /*
        -----------------------------------------------------------------
        Выводим список доступных языков
        -----------------------------------------------------------------
        */
        echo '<div class="phdr"><a href="index.php"><b>' . $lng['admin_panel'] . '</b></a> | ' . $lng['language_default'] . '</div>';
        switch ($do) {
            case 'add':
                echo '<div class="gmenu"><b>' . $panel_lng['language_add'] . '!</b></div>';
                break;
    
            case 'delete':
                echo '<div class="gmenu"><b>' . $panel_lng['language_delete'] . '!</b></div>';
                break;
    
            case 'edit':
                echo '<div class="gmenu"><b>' . $panel_lng['language_edit'] . '!</b></div>';
                break;
    
            case 'error':
                echo '<div class="rmenu"><b>' . $panel_lng['error'] . '!</b></div>';
                break;

            default :
                echo '';
        }
        echo '<div class="menu"><form action="index.php?act=languages&amp;mod=set" method="post"><p>';
        echo '<table><tr><td>&nbsp;</td><td style="padding-bottom:4px"><h3>' . $lng['language_system'] . '</h3></td></tr>';
        foreach ($lng_desc as $key => $val) {            
            $lng_menu = array(
                ('<a href="index.php?act=languages&amp;mod=module&amp;language=' . $key . '">' . $lng['modules'] . '</a> | <a href="index.php?act=languages&amp;mod=delete&amp;language=' . $key . '">' . $lng['delete'] . '</a>'),
                (!empty($val['author']) ? '<span class="gray">' . $lng['author'] . ':</span> ' . $val['author'] : ''),
                (!empty($val['author_email']) ? '<span class="gray">E-mail:</span> ' . $val['author_email'] : ''),
                (!empty($val['author_url']) ? '<span class="gray">URL:</span> ' . $val['author_url'] : ''),
                (!empty($val['description']) ? '<span class="gray">' . $lng['description'] . ':</span> ' . $val['description'] : '')
            );
            echo '<tr>' .
                 '<td valign="top"><input type="radio" value="' . $key . '" name="iso" ' . ($key == $set['lng'] ? 'checked="checked"' : '') . '/></td>' .
                 '<td style="padding-bottom:6px">' .
                 (file_exists('../images/flags/' . $key . '.gif') ? '<img src="../images/flags/' . $key . '.gif" alt=""/>&#160;' : '') .
                 '<a href="?act=languages&amp;mod=edit&amp;language=' . $key . '"><b>' . $val['name'] . '</b></a>&#160;<span class="green">[' . $key . ']</span>' .
                 '<div class="sub">' . functions::display_menu($lng_menu, '<br />') . '</div></td>' .
                 '</tr>';
        }
        echo '<tr><td>&nbsp;</td><td><input type="submit" name="submit" value="' . $lng['save'] . '" /></td></tr>' .
             '</table></p>' .
             '</form></div>' .
             '<div class="gmenu"><form name="form" action="?act=languages&amp;mod=add" method="POST">' .
             '<input type="submit" name="submit" value="Добавить язык"/>&#160;' .
             '</form></div>' .
             '<div class="phdr">' . $lng['total'] . ': ' . count($lng_desc) . '</div>' .
             '<p><a href="index.php?act=languages&amp;refresh">' . $lng['refresh_descriptions'] . '</a><br /><a href="index.php">' . $lng['admin_panel'] . '</a></p>';
}
?>