<?php
include_once 'scades_statistic.php';

class Scades_stat_viewer extends Scades_statistic
{
   private $limit;
   private $start;

   function __construct()
   {
   parent::__construct();
   
   $this -> connect();
   
   $this -> referers = Array();
   $this -> ref_sites = Array();
   $this -> user_agents = Array();
   $this -> page_in = Array();
   $this -> page_out = Array();
   $this -> search_words = Array();
   $this -> bots = Array();
   $this -> hits = 0;
   $this -> sred_time = 0;
   $this -> dif_time = 0;
   $this -> start = 0;
   $this -> limit = 100;
   }
   
   function set_limit($limit)
   {
   $this -> limit = abs((int)$limit);
   }
   
   function set_start($start)
   {
   $this -> start = abs((int)$start);
   }

   
   //Хитов
   function get_hits($start, $end)
   {
   $hits = 0;
   $start = (int)$start;
   $end = (int) $end;
   
   $res = $this -> db -> prepare("SELECT SUM(`hits`) AS `hits` FROM `scades_stat` WHERE `time` > ? AND `time` < ?;");   
   $res -> execute(Array($start, $end));   

        if($row = $res -> fetch())
        {
        $hits = (int)$row['hits'];
        }
   return $hits;
   }
   
   //Среднее время посещения--
   function sred_time($start, $end)
   {
   if($this -> sred_time > 0)return $this -> sred_time;
   
   $hits = 0;
   $start = (int)$start;
   $end = (int) $end;
   
   $res = $this -> db -> prepare("SELECT SUM(`last_time`-`time`) AS `time` FROM `scades_stat` WHERE `time` > ? AND `time` < ?;");   
   $res -> execute(Array($start, $end));
        if($row = $res -> fetch())
        {
        $this -> dif_time = $row['time'];
        }
        else
        {
        $this -> dif_time = 0;
        }
   
   $res = $this -> db -> prepare("SELECT COUNT(*) AS cnt FROM `scades_stat` WHERE `time` > ? AND `time` < ?;");   
   $res -> execute(Array($start, $end));
        if($row = $res -> fetch())
        {
        $this -> cnt = $row['cnt'];
        }
        else
        {
        $this -> cnt = 0;
        }
    
   if(!$cnt)return 0;
   $this -> sred_time = round($time / $cnt);
        
   return $this -> sred_time;
   }
   
   //хостов
   function hosts($start, $end)
   {
   $hosts = 0;
   $start = (int)$start;
   $end = (int) $end;
   
   $res = $this -> db -> prepare("SELECT COUNT(*) AS `hosts` FROM `scades_stat` WHERE `time` > ? AND `time` < ?;");   
   $res -> execute(Array($start, $end));   

        if($row = $res -> fetch())
        {
        $hosts = (int)$row['hosts'];
        }

   return $hosts;
   }
   
   
   //Общая статистика
   function get_stat($start, $end)
   {
   $start = (int)$start;
   $end = (int) $end;
      
        $arr = Array();   
        $res = $this -> db -> prepare("SELECT * FROM `scades_stat` WHERE `time` > ? AND `time` < ? ORDER BY `time`;");
        $res -> execute(Array($start, $end));
    
    $i = 0;
   $end_i = $this -> start + $this -> limit;
        while($row = $res -> fetch())
        {        
            if($i < $end_i AND $i >= $this -> start)
            {
            $arr[] = $row;
            }
                
        $i++;
        
            if($row['ref'])
            {
            $this -> referers[] = $row['ref'];
                if($ar = parse_url($row['ref']) AND isset($ar['host']))
                {
                $this -> ref_sites[] = $ar['host'];
                
                    //Поисковые запросы----
                    if(isset($ar['query']))
                    {
                    parse_str($ar['query'], $query);
                    $query_str = '';
                        if(isset($query['q']))   //google
                        {
                        $query_str = $query['q'];
                        }
                        elseif(isset($query['text']))  //yandex
                        {
                        $query_str = $query['text'];
                        }
                        elseif(isset($query['rg'])) //nigma
                        {
                        $query_str = $query['rg'];
                        }
                        elseif(isset($query['r'])) //aport
                        {
                        $query_str = $query['r'];
                        }
                        elseif(isset($query['query'])) //rambler
                        {
                        $query_str = $query['query'];
                        }
                        
                        if($query_str)
                        {
                           if($this -> is_utf8($query_str))
                           {
                           $this -> search_words[] = $query_str;
                           }
                           else
                           {
                           $this -> search_words[] = iconv('cp1251', 'utf-8', $query_str);
                           }
                        }
                    }                    
                    //-------
                
                }
            }
            
            if($row['ua'])
            {
            $ua = strtolower($row['ua']);
                if(substr_count($ua, 'bot') OR substr_count($ua, 'spider') OR substr_count($ua, 'indexer') OR substr_count($ua, 'ant'))
                {
                $this -> bots[] = $row['ua'];
                }
                else
                {
                $this -> user_agents[] = $row['ua'];
                }
            }
            if($row['page_in'])$this -> page_in[] = $row['page_in'];
            if($row['page_out'])$this -> page_out[] = $row['page_out'];
        }
               
        
        $this -> referers = array_count_values($this -> referers);
        arsort($this -> referers);
        
        $this -> search_words = array_count_values($this -> search_words);
        arsort($this -> search_words);
        
        $this -> ref_sites = array_count_values($this -> ref_sites);
        arsort($this -> ref_sites);
     
        $this -> user_agents = array_count_values($this -> user_agents);
        arsort($this -> user_agents);
        
        $this -> bots = array_count_values($this -> bots);
        arsort($this -> bots);
        
        $this -> page_in = array_count_values($this -> page_in);
        arsort($this -> page_in);
        
        $this -> page_out = array_count_values($this -> page_out);
        arsort($this -> page_out);
        
   return $arr;
   }
   
   function selected($selected)
   {
   return $selected?'selected="selected"':'';
   }
   

   // Returns true if $string is valid UTF-8 and false otherwise.
function is_utf8($string) {
  
   // From http://w3.org/International/questions/qa-forms-utf-8.html
   return preg_match('%^(?:
         [\x09\x0A\x0D\x20-\x7E]            # ASCII
       | [\xC2-\xDF][\x80-\xBF]            # non-overlong 2-byte
       |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
       | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
       |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
       |  \xF0[\x90-\xBF][\x80-\xBF]{2}    # planes 1-3
       | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
       |  \xF4[\x80-\x8F][\x80-\xBF]{2}    # plane 16
   )*$%xs', $string);
  
}


/*
$kolvo - число записей
$on_page- записей на страницу

$arr['page'] -  текущая страница
$arr['start'] - начальная запись для sql запроса в LIMIT $arr['start'],$on_page
$arr['max_page'] - максимальная страница
*/
function pages_arr($kolvo,$on_page)
{	
		$max_page=ceil($kolvo/$on_page);		
		if($max_page<1)$max_page=1;	
        
        $page = 1;
		if(!empty($_GET['p']))
        {
            if($_GET['p'] == 'end')
            {
            $page = $max_page;
            }
            else
            {
            $page = (int)$_GET['p'];
                if($page < 1)
                {
                $page = 1;
                }
                elseif($page > $max_page)
                {
                $page = $max_page;
                }
            }
        }
		
		$start=($page-1)*$on_page;
		$arr=Array();
		$arr['start']=$start;		
		$arr['max_page']=$max_page;
		$arr['page']=$page;
	return $arr;
}

//Формируем строку страниц
//page - текущая страница
//max - кол-во страниц
//shablon - http://site.ru/big_text.php?p={page}
//-------------------------------
function pages($page,$max,$shablon,$size=5)
{
$page_str='';
$page=(int)$page;
$max=(int)$max;
$size=(int)$size;
	
	if($max>1)
		{
		    if($page>1)$page_str.='<a href="'.str_replace('{page}',1,$shablon).'"><span>&lt;&lt;</span></a>';
			if($page>1)$page_str.='<a href="'.str_replace('{page}',$page-1,$shablon).'"><span>&lt;</span></a>';
			for($i=1;$i<=$max;$i++)
			{
            if($i<$page-$size OR $i>$page+$size)continue;
				if($page==$i)
				{
                $page_str.='<span class="checked">'.$i.'</span>';                
				}
				else
				{
				$page_str.='<a href="'.str_replace('{page}',$i,$shablon).'"><span>'.$i.'</span></a>';                
				}			            
			}
			if($page<$max)$page_str.='<a href="'.str_replace('{page}',$page+1,$shablon).'"><span>&gt;</span></a>';
			if($page<$max)$page_str.='<a href="'.str_replace('{page}',$max,$shablon).'"><span>&gt;&gt;</span></a>';
		}
return $page_str; 
}
//--------------------------








}

function time_sort($a, $b){
    if ($a['time'] == $b['time']) {
        return 0;
    }
    return ($a['time'] < $b['time']) ? -1 : 1;
}
?>