<?php

/**
 * Класс с настройками для BugagaCurlClass
 *
 * @author GoGo
 * @version 2 alfa
 */
class BugagaCurlClassConfig
{
    /**
     * Юзер-агент
     */
    public $userAgent;
    
    /**
     * Реферер
     */
    public $referer;
    
    /**
     * Использовать ли прокси?
     */
    public $isUseProxy = FALSE;
    
    /**
     * Адрес прокси
     */
    public $proxyUrl;
    
    /**
     * Использовать ли cookies?
     */
    public $isUseCookies = FALSE;
    
    /**
     * Файл с для cookies (относительно текущей папки)
     */
    public $cookiesFile;
}

/**
 * Небольшой классец для работы с курлом
 *
 * @author GoGo
 */
class BugagaCurlClass
{

    /**
     * Дескриптор соединения (меняется для каждой новой страницы)
     */
    private $_ch;
    
    
    
    /**
     * Инициализируем сеанс CURL
     */
    public function __construct ()
    {
        if (!$this->_ch = curl_init ()) throw new Exception ('Неудалось установить сеанс CURL');
    }
    
    /**
     * Закрываем сеанс
     */
    public function __destruct ()
    {
        curl_close ($this->_ch);
    }

        
    
    /**
     * Выполнение запроса
     * @param $config BugagaCurlClassConfig Объект с настройками запроса
     */
    protected function execute (BugagaCurlClassConfig $config)
    {
        // Скачанные данные не выводить в поток (указывает, что функция curl_exec должна вернуть полученный ответ, а не отправить его сразу браузеру)
        curl_setopt ($this->_ch, CURLOPT_RETURNTRANSFER, TRUE);

        // Назначаем ЮЗЕР-АГЕНТ
        curl_setopt ($this->_ch, CURLOPT_USERAGENT, $config->userAgent);

        // Назначаем РЕФЕРЕР
        curl_setopt ($this->_ch, CURLOPT_REFERER, $config->referer);

        
        
        // Назначаем прокси-сервер
        if ($config->isUseProxy)
            curl_setopt ($this->_ch, CURLOPT_PROXY, $config->proxyUrl);
        
        
        
        // Из-за особенностей curl КУКИ НАДО ИСПОЛЬЗОВАТЬ ПЕРЕД КАЖДЫМ CURL-ЗАПРОСОМ
        // Используем куки
        if ($config->isUseCookies)
        {
            // !!! Внимание! В Windows надо исправить пути к файлу с куками
            if (substr (PHP_OS, 0, 3) == 'WIN')
            {
                $config->cookiesFile = str_replace ('\\', '/', getcwd () . '/' . $config->cookiesFile);
            }

            curl_setopt ($this->_ch, CURLOPT_COOKIEFILE, $config->cookiesFile);
            curl_setopt ($this->_ch, CURLOPT_COOKIEJAR, $config->cookiesFile);
        }
        
        
        
        $data = curl_exec ($this->_ch);
        
        if (curl_errno ($this->_ch) == 5)
        {
            curl_close ($this->_ch);
            throw new Exception ('Нерабочая прокся :-(');
        }
        
        return $data;
    }
    
    

    /**
     * Загрузить страницу
     * 
     * @param $config BugagaCurlClassConfig Объект с настройками запроса
     * @param $url string Url получаемой страницы
     * @return string Исходный код страницы
     */
    public function getPage (BugagaCurlClassConfig $config, $url)
    {
        // Пишем url страницы
        curl_setopt ($this->_ch, CURLOPT_URL, $url);
            
        // Выполняем запрос
        return $this->execute ($config);
    }
    
    /**
     * Послать Post запрос. Внимание, передаваемые параметры никак экранировать не надо, они и так экранируются
     * 
     * @param $config BugagaCurlClassConfig Объект с настройками запроса
     * @param $url string Url страницы, на которую надо отправить запрос (другими словами, Action формы)
     * @param $params array Массив с параметрами
     * @return string Возвращенная страница
     */
    public function sendPost (BugagaCurlClassConfig $config, $url, $params)
    {
        /**
         * Отправляем POST запрос
         */
        
        // Пишем url страницы
        curl_setopt ($this->_ch, CURLOPT_URL, $url);
        
        // Да, да, старый добрый foreach
        // Собираем массив из подготовленных параметров (Объединенных и ЭКРАНИРОВАННЫХ)
        foreach ($params as $key => $value)
        {
            $paramArray[] = urlencode ($key) . '=' . urlencode ($value);
        }
        // Хотя вместо всей этой гомосятины можно было заюзать http_build_query ()...
        
        curl_setopt ($this->_ch, CURLOPT_POST, TRUE);
        // Назначаем значения передаваемых переменных
        curl_setopt ($this->_ch, CURLOPT_POSTFIELDS, implode ('&', $paramArray));
        
        // Выполняем запрос
        return $this->execute ($config);
    }
    
    /**
     * Послать Get запрос
     */
    public function sendGet (BugagaCurlClassConfig $config, $url, $params)
    {
        
    }

}