<?php
/***************************************************************************
 *                  memberlist.php  (phpBB-WAP v5)
 *                            -------------------
 *      : phpBB Group.
 *        WAP:   (  ).
 *          2008 
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_VIEWMEMBERS);
init_userprefs($userdata);

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;
$start = ($start < 0) ? 0 : $start;

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

if (isset($HTTP_GET_VARS['ban']))
{

$template->set_filenames(array(
	'body' => 'banlist_body.tpl')
);

$sql = "SELECT username, user_id, user_posts 
	FROM " . USERS_TABLE . "
	WHERE user_id <> " . ANONYMOUS . " AND user_warnings > 0 
	ORDER BY user_posts DESC LIMIT $start, " . $board_config['topics_per_page'];
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$user_id = $row['user_id'];

		$sql = "SELECT expire, modification 
			FROM " . REPUTATION_TABLE . "
			WHERE user_id = $user_id";
		if( !($resultat = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
		}
		$roww = $db->sql_fetchrow($resultat);

		$username = $row['username'];
		$posts = ( $row['user_posts'] ) ? $row['user_posts'] : 0;
		$expire = create_date('d M, G:i', $roww['expire'], $board_config['board_timezone']);
		$tip = ( $roww['modification'] == 4 ) ? '#' : '!';

		$template->assign_block_vars('banrow', array(
			'USERNAME' => $username,
			'POSTS' => $posts,
			'EXPIRE' => $expire,
			'TIP' => $tip,
			'U_VIEWPROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id"))
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
	$db->sql_freeresult($result);
} else {
message_die(GENERAL_MESSAGE, $lang['No_banlist']);
}

if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = "SELECT count(*) AS total
		FROM " . USERS_TABLE . "
		WHERE user_id <> " . ANONYMOUS . " AND user_warnings > 0";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_members = $total['total'];

		$pagination = generate_pagination("memberlist.$phpEx?ban&amp;", $total_members, $board_config['topics_per_page'], $start). '';
	}
	$db->sql_freeresult($result);
}
else
{
	$pagination = '';
	$total_members = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination)
);
$template->pparse('body');

} elseif (isset($HTTP_GET_VARS['admin'])) {

	$exclude_users = '';
	$template->assign_block_vars('switch_list_staff', array());
	$template->set_filenames(array('body' => 'staff_body.tpl'));

	$is_auth_ary = array();
	$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata, $forums);

	$sql_forums = "SELECT ug.user_id, f.forum_id, f.forum_name
		           FROM ". AUTH_ACCESS_TABLE ." aa, ". USER_GROUP_TABLE ." ug, ". FORUMS_TABLE ." f
		           WHERE aa.auth_mod = ". TRUE ." AND ug.group_id = aa.group_id AND f.forum_id = aa.forum_id
		           ORDER BY f.forum_order";
	if( !$result_forums = $db->sql_query($sql_forums) )
	{
		message_die(GENERAL_ERROR, 'could not query forums.', '', __LINE__, __FILE__, $sql_forums);
	}
	while( $row = $db->sql_fetchrow($result_forums) )
	{
		$display_forums = ( $is_auth_ary[$row['forum_id']]['auth_view'] ) ? true : false;
		if( $display_forums )
		{
			$forum_id = $row['forum_id'];
			$staff2[$row['user_id']][$row['forum_id']] = '<a href="'. append_sid("viewforum.$phpEx?f=$forum_id") .'" class="gen">'. $row['forum_name'] .'</a>';
		}
	}
	$db->sql_freeresult($result_forums);

	$level_cat = $lang['Staff_level'];
	for( $i = 0; $i < count($level_cat); $i++ )
	{
		$user_level = $level_cat[$i];

		$template->assign_block_vars('switch_list_staff.user_level', array('USER_LEVEL' => $user_level));

		if( $level_cat['0'] )
		{
			$where = 'user_level = '. ADMIN;
		}
		else if( $level_cat['1'] )
		{
			$where = 'user_level = '. MOD;
		}
		$level_cat[$i] = '';

		$sql_exclude_users = ( !empty($exclude_users) ) ? ' AND user_id NOT IN ('. $exclude_users .')' : '';
		$sql_user = "SELECT * FROM ". USERS_TABLE ." WHERE $where $sql_exclude_users ORDER BY user_regdate";
		if( !($result_user = $db->sql_query($sql_user)) )
		{
			message_die(GENERAL_ERROR, 'could not obtain user information.', '', __LINE__, __FILE__, $sql_user);
		}
		if( $staff = $db->sql_fetchrow($result_user) )
		{
			$k = 0;
			do
			{
				$user_id = $staff['user_id'];
				$user_status = ( $staff['user_session_time'] >= (time() - 60) ) ? (( $row['user_allow_viewonline'] ) ? $lang['Staff_online'] : (( $userdata['user_level'] == ADMIN || $userdata['user_id'] == $user_id ) ? $lang['Staff_online'] : '')) : '';

				$forums = '';
				if( !empty($staff2[$staff['user_id']]) )
				{
					asort($staff2[$staff['user_id']]);
					$forums = implode(', ',$staff2[$staff['user_id']]);
				}

				$template->assign_block_vars('switch_list_staff.user_level.staff', array(
					'USERNAME' => $staff['username'],
					'POSTS' => $staff['user_posts'],
					'USER_STATUS' => $user_status,
					'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;". POST_USERS_URL ."=$user_id"),
					'FORUMS' => $forums,
				));
				$k++;
			}
			while( $staff = $db->sql_fetchrow($result_user) );
			$db->sql_freeresult($result_user);
		}
	}

$template->pparse('body');

} else {

$template->set_filenames(array(
	'body' => 'memberlist_body.tpl')
);

$sql = "SELECT username, user_id, user_level, user_posts 
	FROM " . USERS_TABLE . "
	WHERE user_id <> " . ANONYMOUS . " 
	ORDER BY user_posts DESC LIMIT $start, " . $board_config['topics_per_page'];
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$username = $row['username'];

			if ( $row['user_level'] == ADMIN )
			{
				$username = '<span style="color:#1581DA">' . $row['username'] . '</span>';
			}
			else if ( $row['user_level'] == MOD )
			{
				$username = '<span style="color:#943043">' . $row['username'] . '</span>';
			}

		$user_id = $row['user_id'];
		$posts = ( $row['user_posts'] ) ? $row['user_posts'] : 0;

		$template->assign_block_vars('memberrow', array(
			'USERNAME' => $username,
			'POSTS' => $posts,
			'U_VIEWPROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id"))
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
	$db->sql_freeresult($result);
}

if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = "SELECT count(*) AS total
		FROM " . USERS_TABLE . "
		WHERE user_id <> " . ANONYMOUS;

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_members = $total['total'];

		$pagination = generate_pagination("memberlist.$phpEx?", $total_members, $board_config['topics_per_page'], $start). '';
	}
	$db->sql_freeresult($result);
}
else
{
	$pagination = '';
	$total_members = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination)
);

$template->pparse('body');

}
include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>