<?php

/*
////////////////////////////////////////////////////////////////////////////////
// JohnCMS                Mobile Content Management System                    //
// Project site:          http://johncms.com                                  //
// Support site:          http://gazenwagen.com                               //
////////////////////////////////////////////////////////////////////////////////
// Lead Developer:        Oleg Kasyanov   (AlkatraZ)  alkatraz@gazenwagen.com //
// Development Team:      Eugene Ryabinin (john77)    john77@gazenwagen.com   //
//                        Dmitry Liseenko (FlySelf)   flyself@johncms.com     //
////////////////////////////////////////////////////////////////////////////////
*/

defined('_IN_JOHNCMS') or die('Error: restricted access');

/*
-----------------------------------------------------------------
Проверяем права доступа
-----------------------------------------------------------------
*/
if ($user['id'] != $user_id && ($rights < 7 || $user['rights'] > $rights)) {
    echo functions::display_error('Доступ запрещен');
    require('../incfiles/end.php');
    exit;
}
$textl = htmlspecialchars($user['name']) . ': Меняем пароль';
require('../incfiles/head.php');

switch ($mod) {
    case 'change':
        /*
        -----------------------------------------------------------------
        Меняем пароль
        -----------------------------------------------------------------
        */
        $error = array ();
        $oldpass = isset($_POST['oldpass']) ? trim($_POST['oldpass']) : '';
        $newpass = isset($_POST['newpass']) ? trim($_POST['newpass']) : '';
        $newconf = isset($_POST['newconf']) ? trim($_POST['newconf']) : '';
        $autologin = isset($_POST['autologin']) ? 1 : 0;
        if ($user['id'] != $user_id) {
            if (!$newpass || !$newconf)
                $error[] = 'Нужно заполнить все поля формы';
        } else {
            if (!$oldpass || !$newpass || !$newconf)
                $error[] = 'Нужно заполнить все поля формы';
        }
        if (!$error && $user['id'] == $user_id && md5(md5($oldpass)) !== $user['password'])
            $error[] = 'Старый пароль введен неверно';
        if ($newpass != $newconf)
            $error[] = 'Подтверждение нового пароля введено неверно';
        if (preg_match("/[^\da-zA-Z_]+/", $newpass) && !$error)
            $error[] = 'Недопустимые символы';
        if (!$error && (strlen($newpass) < 3 || strlen($newpass) > 10))
            $error[] = 'Длина пароля должна быть минимум 3 и максимум 10 символов';
        if (!$error) {
            // Записываем в базу
            mysql_query("UPDATE `users` SET `password` = '" . mysql_real_escape_string(md5(md5($newpass))) . "' WHERE `id` = '" . $user['id'] . "'");
            // Проверяем и записываем COOKIES
            if (isset($_COOKIE['cuid']) && isset($_COOKIE['cups']))
                setcookie('cups', md5($newpass), time() + 3600 * 24 * 365);
            echo '<div class="gmenu"><p><b>Пароль успешно изменен</b><br />' .
                '<a href="' . ($user_id == $user['id'] ? '../login.php' : 'profile.php?user=' . $user['id']) . '">Далее</a></p>';
            if ($autologin) {
                // Показываем ссылку на Автологин
                echo '<p>Ссылка на Автологин:<br />' .
                    '<input type="text" value="' . $set['homeurl'] . '/login.php?id=' . $user['id'] . '&amp;p=' . $newpass . '" /></p>' .
                    '<p><b>Внимание!</b><br />В целях безопасности, никогда не используйте Автологин в ненадежных местах (интернет-кафе, чужие компьютеры и др.)</p>';
            }
            echo '</div>';
        } else {
            echo functions::display_error($error, '<a href="profile.php?act=password&amp;user=' . $user['id'] . '">Повторить</a>');
        }
        break;

    default:
        /*
        -----------------------------------------------------------------
        Форма смены пароля
        -----------------------------------------------------------------
        */
        echo '<div class="phdr"><b>Меняем пароль:</b> ' . $user['name'] . '</div>';
        echo '<form action="profile.php?act=password&amp;mod=change&amp;user=' . $user['id'] . '" method="post">';
        if ($user['id'] == $user_id)
            echo '<div class="menu"><p>Введите старый пароль:<br /><input type="password" name="oldpass" /></p></div>';
        echo '<div class="gmenu"><p>Введите новый пароль:<br />' .
            '<input type="password" name="newpass" /><br />Повторите пароль:<br />' .
            '<input type="password" name="newconf" /></p>' .
            '<p><input type="checkbox" value="1" name="autologin" />&#160;Показать ссылку на Автологин' .
            '</p><p><input type="submit" value="Сменить" name="submit" />' .
            '</p></div></form>' .
            '<div class="phdr"><small>Длина пароля мин. 3, макс. 10 символов, разрешены буквы Латинского алфавита и цифры.</small></div>' .
            '<p><a href="profile.php?user=' . $user['id'] . '">Анкета</a></p>';
}
?>