<?php

abstract class Controller extends Storage {
    
    protected $currentPath;
    
    public abstract function index();
    
    public function __construct($storage)
    {

        $this->storage = $storage;
        $this->currentPath = ROOTDIR . $this->Conf->route['modulesDir'] . DIRECTORY_SEPARATOR . strtolower(get_class($this)) . DIRECTORY_SEPARATOR;
        $this->Tpl->tplPath = $this->currentPath . '_tpl_' . DIRECTORY_SEPARATOR;
        
    }
    
   	public final function redirect($url) 
    {
        
        if (headers_sent())
        {
            
            throw new Exception ('Can not redirect to ' . $url . '<br />Headers already sent');
            
        }
        
		header('Location: ' . $url);
		exit;
        
	}
    
    protected final function loadModel($name)
    {
        
        $model = $this->currentPath . 'model' . DIRECTORY_SEPARATOR . strtolower($name) . $this->Conf->route['ext'];
        
        if (!file_exists($model))
        {
            
            throw new Exception('Model: ' . $model . ' is not exists');
            
        }
        
        include $model;
        
        if (!class_exists($name))
        {
            
            throw new Exception('Model: class ' . $name . ' is not exists');
            
        }
        
        $name .= 'Model';
        
        return new $name($this->Db);
        
    }
    
}