<?php

ini_set('display_errors', TRUE);

error_reporting(-1);

if (version_compare(phpversion(), '5.3.0', '<') === TRUE)
{

    exit('PHP version < 5.3');

}


date_default_timezone_set('UTC');
mb_internal_encoding('UTF-8');

/* Loading constants */
$conf = require dirname(__FILE__) . DIRECTORY_SEPARATOR . 'conf.php';

spl_autoload_register(
    function ($class) use ($conf)
    {

        $class = str_replace('_', '.', strtolower($class));

        if (file_exists($conf['MainDir'] . 'classes' . DIRECTORY_SEPARATOR . $class . '.php'))
        {

            require_once $conf['MainDir'] . 'classes' . DIRECTORY_SEPARATOR . $class . '.php';
            return TRUE;
        }
        else
        {

            throw new Base_Exception('Loading class - ' . $class . ' failed');

        }

    }
);

/* log file for exceptions */
Base_Exception::$logFile = $conf['LogDir'] . 'error.log';
/* Output exceptions. into log or on display */
Base_Exception::$displayMessage = $conf['OutputExceptions'];
unset($conf['OutputExceptions']);
set_exception_handler(array('Base_Exception', 'handler'));
set_error_handler(array('Base_Exception', 'errorHandler'),-1);

new Front($conf);