<?php

/**
 * Response
 *
 * Send headers and output data.
 *
 * @package System
 * @author Screamer <nwotnbm@gmail.com>
 * @version 0.1
 */

class Response {

    /**
     * @var (array)
     * @access protected
     * Location of headers
     */
    protected $headers = array();

    /**
     * Add header to storage
     * @access public
     * @param (string) $header header
     * @return (void)
     */
	public function addHeader($header)
    {

		$this->headers[] = $header;

	}

    /**
     * Redirect
     * @param $url (string) URL
     * @return (void)
     */
    public function redirect($url)
    {

        if (headers_sent())
        {

            throw new Base_Exception ('Can not redirect to ' . $url . '<br />Headers already sent', __CLASS__);

        }

    	header('Location: ' . $url);
    	exit;

    }

    /**
     * Output data
     * Send headers and output data
     * @access public
     * @param (string) $output Data for display
     * @return (void)
     */
	public function output($output = '')
    {

		if (!empty($output))
        {

			if (!headers_sent())
            {

				foreach ($this->headers as $header)
                {

                    header($header, true);

                }

            }

            echo $output;

        }

    }

}
?>