<?php

/**
 * Storage
 *
 * Interface of access to overloaded data
 *
 * @package System
 * @author Screamer <nwotnbm@gmail.com>
 * @version 0.1
 */

class Storage {

    /**
     * @var Location for overloaded data
     * @access protected
     */
    protected $storage;

    public function __construct(array $storage)
    {

        $this->storage = $storage;

    }

    /**
     * Get variable
     * is utilized for reading data from inaccessible properties.
     * @access public
     * @param  (string) $name name of variable
     * @return (mixed)
     */
    public function __get($name)
    {

        if (isset($this->storage[$name]))
        {

            if(is_array($this->storage[$name]))
            {

                $this->storage[$name] = new Storage($this->storage[$name]);

            }

            return $this->storage[$name];

        }
        else
        {

            return NULL;

        }


    }

    /**
     * Setup variable
     * is run when writing data to inaccessible properties.
     * @access public
     * @param  (string) $name  name of variable
     * @param  (mixed)  $value value of variable
     * @throws Base_Exception
     * @return (void)
     */
    public function __set($name, $value = '')
    {

        $this->storage[$name] = $value;

    }

    /**
     * Check the existence of variable
     * is triggered by calling isset() or empty() on inaccessible properties.
     * @access public
     * @param  (string) $name name of variable
     * @return (boolean)
     */
    public function __isset($name)
    {

        return isset($this->storage[$name]);

    }

    /**
     * Delete variable
     * is invoked when unset() is used on inaccessible properties.
     * @access public
     * @param  (string) $name name of variable
     * @return (void)
     */
    public function __unset($name)
    {

        if (isset($this->storage[$name]))
        {

            unset($this->storage[$name]);

        }

    }

}