﻿<?
/*
u.BD v.0.1b. 
-----------------------------------------------------------------------------------------
Все права защищены! G-XPert © http://g-xpert.com/
-----------------------------------------------------------------------------------------
Допускается для распространения только на сайте phpexample.ucoz.net и g-xpert.com
-----------------------------------------------------------------------------------------
Распространение скрипта на других сайтах без указания обратной ссылки (g-xpert.com) запрещено!
=========================================================================================
Данный скрипт предназначен для быстрой и удобной работы с данными на PHP-серверах uCoz.
-----------------------------------------------------------------------------------------
Доступные функции:
- Создание таблиц;
- Добавление строки в таблицу (новые строки добавляются в конец таблицы);
- Получение нужного значения из таблицы с помощью указания номера строки и столбца;
- Получение нужного значения из таблицы с помощью поиска уникального идентификатора в заданном столбце;
- Замена нужного значения в таблице с помощью указание номера строки и столбца;
- Замена нужного значения в таблице с помощью поиска уникального идентификатора в заданном столбце;
- Удаление нужного значения в таблице с помощью указания номера строки и столбца (вставляется «null»);
- Удаление нужного значения в таблице с помощью поиска уникального идентификатора в заданном столбце (вставляется «null»);
- Удаление нужной строки с помощью указания её номера;
- Удаление нужной строки с помощью поиска уникального идентификатора в одном из её столбцов;
- Удаление таблицы
- Переименование таблицы
- Проверка таблицы на существование;
- Получение значения последней строки из указанного столбца;
- Получение значения последнего столбца из указанной строки;
- Получение значения последнего столба в последней строке;
- Получение значений таблицы, начиная со строки n, заканчивая строкой m в виде двухмерного массива (строки + столбцы);
- Получение всех значений таблицы в виде двухмерного массива (строки + столбцы);
- Проверка значения на существование (указывается столбец, по которому производится поиск заданного значения).
-----------------------------------
Примечания:
- Под словом «таблица» понимается специальный файл, где будут храниться данные;
- Под словом «значение» понимается одна запись в определённой строке определённого столбца;
- Все файлы, где хранятся данные доступны только PHP-скрипту. Обычный пользователь, перейдя по ссылке на файл, не увидит его содержимого;
-----------------------------------
Все файлы будут храниться в папке _bd (относительно данного скрипта).
*/

$___notjson=1;

function u_write() { // Запись данных в таблицу (если таблица отсутствует - она создаётся; выводит "1" в случае успеха)
if (func_get_arg(0)) { // Проверяем, что имя таблицы передано
$path = '_bd/'.func_get_arg(0).'.u';
if (func_get_arg(1)) { // Проверяем, что передаётся хотя бы один параметр
$n = func_num_args();
$data = "";
for($i=1;$i<$n;$i++) {$data.= func_get_arg($i)."|u|";}; // Преобразуем данные в нужный формат
file_put_contents($path, "\n".$data, FILE_APPEND | LOCK_EX);
return '1';
} else {
return 'Не задано ни одного параметра!';
}
} else {
return 'Не задано имя таблицы!';
}
}

function u_get($name,$num_1,$num_2) { // Получение значения столбца $num_2 строки $num_1 из таблицы $name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
$str = $data[$num_1]; // Выбираем нужную строку
if ($str) {
$value = explode('|u|',$str);
if ($value[$num_2-1]) {
return $value[$num_2-1]; // Выбираем нужный столбец
} else {
return 'Ошибка! Такого столбца не существует.';
}
} else {
return 'Ошибка! Такой строки не существует.';
}
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_check($name,$search,$num_1) { // Проверка на существование значения $search столбца $num_1 в таблице $name (для использования в условиях)
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
$data = file($path); // Получаем массив со строками таблицы
$num = count($data);
for($i=1;$i<$num;$i++) {
$value = explode('|u|',$data[$i]);
if ($value[$num_1-1] == $search) {
return true;
exit();
break;
}
}
return false;
}

function u_search($name,$search,$num_1,$num_2) { // Получение нужного значения в столбце $num_2 из таблицы $name с помощью поиска уникального идентификатора $search в столбце $num_1
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
$data = file($path); // Получаем массив со строками таблицы
$num = count($data);
for($i=1;$i<$num;$i++) {
$value = explode('|u|',$data[$i]);
if ($value[$num_1-1] == $search) {
if ($value[$num_2-1]) {
$val = $value[$num_2-1];
return $val;
} else {
return 'У строки со значением "'.$search.'" не существует столбца '.$num_2.'!';
}
exit();
break;
}
}
return 'Значение '.$search.' не найдено в столбце '.$num_1.'!';
}

function u_replace($name,$replace,$num_1,$num_2) { // Замена значения в строке $num_1 и в столбце $num_2 на $replace в таблице $name (выводит "1" в случае успеха)
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
$str = $data[$num_1]; // Выбираем нужную строку
if ($str) {
$value = explode('|u|',$str);
if ($value[$num_2-1]) {
$value[$num_2-1] = $replace;
$str = implode($value,'|u|');
$data[$num_1] = $str;
$file = fopen($path,'w');
flock($fd, LOCK_EX); // Блокировка файла для предотвращения одновременного обращения к файлу
fwrite($file,implode($data,"")); // Записываем изменённые данные
fflush($fd);
flock($fd, LOCK_UN);
fclose($file);
return '1';
} else {
return 'Ошибка! Такого столбца не существует.';
}
} else {
return 'Ошибка! Такой строки не существует.';
}
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_search_replace($name,$search,$num_1,$replace,$num_2) { // Замена значения на $replace в столбце $num_2, в таблице $name, в строке где содержится уникальный идентификатор $search в столбце $num_1
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
$num = count($data);
for($i=1;$i<$num+1;$i++) {
$value = explode('|u|',$data[$i]);
if ($value[$num_1-1] == $search) {
if ($value[$num_2-1] || $value[$num_2-1] == 0) {
$value[$num_2-1] = $replace;
$str = implode($value,'|u|');
$data[$i] = $str;
$file = fopen($path,'w');
flock($fd, LOCK_EX); // Блокировка файла для предотвращения одновременного обращения к файлу
fwrite($file,implode($data,"")); // Записываем изменённые данные
fflush($fd);
flock($fd, LOCK_UN);
fclose($file);
return '1';
} else {
return 'У строки со значением "'.$search.'" не существует столбца '.$num_2.'!';
}
exit();
break;
}
}
return 'Значение '.$search.' не найдено в столбце '.$num_1.'!';
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_val_remove($name,$num_1,$num_2) { // Удаление значения из строки $num_1, столбца $num_2 и таблицы $name (вставляется "null")
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
$str = $data[$num_1]; // Выбираем нужную строку
if ($str) {
$value = explode('|u|',$str);
if ($value[$num_2-1]) {
$value[$num_2-1] = 'null';
$str = implode($value,'|u|');
$data[$num_1] = $str;
$file = fopen($path,'w');
flock($fd, LOCK_EX); // Блокировка файла для предотвращения одновременного обращения к файлу
fwrite($file,implode($data,"")); // Записываем изменённые данные
fflush($fd);
flock($fd, LOCK_UN);
fclose($file);
return '1';
} else {
return 'Ошибка! Такого столбца не существует.';
}
} else {
return 'Ошибка! Такой строки не существует.';
}
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_search_val_remove($name,$search,$num_1,$num_2) { // Удаление значения в таблице $name, столбца $num_1, строки, где содержится уникальный идентификатор $search в строке $num_2 (вставляется "null")
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
$num = count($data);
for($i=1;$i<$num;$i++) {
$value = explode('|u|',$data[$i]);
if ($value[$num_1-1] == $search) {
if ($value[$num_2-1]) {
$value[$num_2-1] = 'null';
$str = implode($value,'|u|');
$data[$num_1] = $str;
$file = fopen($path,'w');
flock($fd, LOCK_EX); // Блокировка файла для предотвращения одновременного обращения к файлу
fwrite($file,implode($data,"")); // Записываем изменённые данные
fflush($fd);
flock($fd, LOCK_UN);
fclose($file);
return '1';
} else {
return 'У строки со значением "'.$search.'" не существует столбца '.$num_2.'!';
}
exit();
break;
}
}
return 'Значение '.$search.' не найдено в столбце '.$num_1.'!';
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_str_remove($name,$num) { // Удаление строки $num в таблице $name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
if ($data[$num]) {
$data[$num] = "";
$rec = implode($data,"");
$rec = str_replace("\n\n","\n",$rec);
$file = fopen($path,'w');
flock($fd, LOCK_EX); // Блокировка файла для предотвращения одновременного обращения к файлу
fwrite($file,$rec); // Записываем изменённые данные
fflush($fd);
flock($fd, LOCK_UN);
fclose($file);
return '1';
} else {
return 'Строка с номером '.$num.' не найдена!';
}
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_search_str_remove($name,$search,$num) { // Удаление строки, где в столбце $num содержится уникальный идентификатор $search, в таблице $name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
if ($data[$num-1]) {
$num_n = count($data);
for($i=1;$i<$num_n;$i++) {
$value = explode('|u|',$data[$i]);
$cc = count($value)+1;
if ($value[$num-1] == $search) {
$data[$i] = "";
$rec = implode($data,"");
$rec = str_replace("\n\n","\n",$rec);
$file = fopen($path,'w');
flock($fd, LOCK_EX); // Блокировка файла для предотвращения одновременного обращения к файлу
fwrite($file,$rec); // Записываем изменённые данные
fflush($fd);
flock($fd, LOCK_UN);
fclose($file);
if (!substr_count(implode($data,""),'|u|')) {
u_remove($name); // Удаление таблицы, если удалённая строка была единственной
};
return '1';
break;
exit();
}
}
} else {
return 'Строка с номером '.$num.' не найдена!';
}
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_rename($name,$new_name) { // Переименование таблцы $name в $new_name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
if (rename($path,'_bd/'.$new_name.'.u')) {
return '1';
} else {
return 'Ошибка при переименовании таблицы!';
};
} else {
return 'Таблицы с именем "'.$name.'" не найдена!';
}
}

function u_remove($name) { // Удаление таблицы $name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
if (unlink($path)) {
return '1';
} else {
return 'Ошибка при удалении таблицы!';
};
} else {
return 'Таблицы с именем "'.$name.'" не найдена!';
}
}

function u_table($name) { // Проверка таблцы $name на существование (для использования в условиях)
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
return true;
} else {
return false;
}
}

function u_get_col_last($name,$num) { // Получение значения последнего столбца в строке $num таблицы $name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
if (count($data)-1 > $num) {
$str = $data[$num]; // Выбираем нужную строку
$value = explode('|u|',$str);
$col = count($value)-2;
return $value[$col]; // Выбираем нужный столбец
} else {
return 'Ошибка! Такой строки не существует.';
}
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_get_str_last($name,$num) { // Получение значения столбца $num в последней строке таблицы $name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
$str = $data[count($data)-1]; // Выбираем нужную строку
$value = explode('|u|',$str);
if ($value[$num-1]) {
return $value[$num-1]; // Выбираем нужный столбец
} else {
return 'Ошибка! Такого столбца не существует.';
}
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_get_last($name) { // Получение значения последнего столбца в последней строке таблицы $name
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = file($path); // Получаем массив со строками таблицы
$str = $data[count($data)-1]; // Выбираем нужную строку
$value = explode('|u|',$str);
$col = count($value)-2;
return $value[$col]; // Выбираем нужный столбец
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_get_content($name,$num_1,$num_2,$reverse) { // Получение содержимого таблицы $name, начиная со строки $num_1, заканчивая строкой $num_2, в виде двухмерного массива. Отсчёт начинается с [1][0]. Необязательный параметр $reverse задаёт обратную сортировку.
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
if ($reverse == 1) {
$data = array_reverse(file($path)); // Получаем массив со строками таблицы
} else {
$data = file($path); // Получаем массив со строками таблицы
}
for ($i=$num_1-1;$i<$num_2;$i++) {
$str[$i] = explode('|u|',$data[$i]);
}
global $count;
$count = count($data);
return $str;
} else {
global $status;
$status = 0;
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_content($name,$reverse) { // Получение всего содержимого таблицы $name в виде двухмерного массива. Отсчёт начинается с [1][0]. Необязательный параметр $reverse задаёт обратную сортировку.
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
if ($reverse == 1) {
$data = array_reverse(file($path)); // Получаем массив со строками таблицы
} else {
$data = file($path); // Получаем массив со строками таблицы
}
$num = count(file($path));
for ($i=0;$i<$num-1;$i++) {
$str[$i] = explode('|u|',$data[$i]);
}
global $count;
$count = count($data);
return $str;
} else {
global $status;
$status = 0;
return 'Таблица "'.$name.'" не найдена!';
}
}

function u_count($name) {
$path = '_bd/'.$name.'.u';
$exist = file_exists($path);
if ($exist) {
$data = array_diff(file($path), array(''));
$count = count($data);
return $count;
} else {
return 'Таблица "'.$name.'" не найдена!';
}
}

?>