<?php
/*
 * @Author: Papezhuk M. V.
 * @Site:   http://nurd-cms.ru
 * @NAME:	UNIChat 2.0
 */

/*	CMS Start	BEGIN	*/
define('_IN_JOHNCMS', 1);
require('../incfiles/core.php');
$textl = 'UNIChat';
$headmod = 'unichat';
require('../incfiles/head.php');
/*	CMS Start	END	*/


/*	Load ini BEGIN	*/
$_SETTINGS = array();
if (file_exists('config.ini'))
	$_SETTINGS = parse_ini_file('config.ini');
/*	Load ini END	*/


/*	UNICHAT	Func	BEGIN	*/

// Отправка запроса и получение ответа от сервера
function getRequest ($query = null)
{
	global $_SETTINGS;
	$reqTo = $_SETTINGS['SERVER'] . $query;
	return json_decode(file_get_contents($reqTo), true);
}

// Кеширование ответа
function getCache ($newCache = false)
{
	global $_SETTINGS;
	if ($_SETTINGS['CACHE'] == 'y')
	{
		$reCache = 0;
		$request = array();
		if (file_exists('cache/dump.ini') && $newCache == false)
		{
			$reCache = intval(file_get_contents('cache/dump.ini'));

			if ($reCache > time())
				include 'cache/dump.php';
			else
			{
				$request = getRequest('uc_read.php?num=' . $_SETTINGS['MSGS_NUM']);
				file_put_contents('cache/dump.php', "<?php\nunset(\$request);\n\$request = ". var_export($request, true) .";\n?>");
				file_put_contents('cache/dump.ini', time()+$_SETTINGS['RECACHE']);
			}
		}
		else
		{
			$request = getRequest('uc_read.php?num=' . $_SETTINGS['MSGS_NUM']);
			file_put_contents('cache/dump.php', "<?php\nunset(\$request);\n\$request = ". var_export($request, true) .";\n?>");
			file_put_contents('cache/dump.ini', time()+$_SETTINGS['RECACHE']);
		}
		return $request;
	}
	else
	{
		return getRequest('uc_read.php?num=' . $_SETTINGS['MSGS_NUM']);
	}
}

// Получение и кеширование онлайна
function getOnline($newCache = false)
{
	$reCache = 0;
	if (file_exists('cache/dump_online.ini') && $newCache === false)
	{
		$reCache = intval(file_get_contents('cache/dump_online.ini'));

		$request = array();
		if ($reCache > time())
			include 'cache/dump_online.php';
		else
		{
			$request = getRequest('update.php');
			file_put_contents('cache/dump_online.php', "<?php\nunset(\$request);\n\$request = ". var_export($request, true) .";\n?>");
			file_put_contents('cache/dump_online.ini', time()+300);
		}
	}
	else
	{
		$request = getRequest('update.php');
		file_put_contents('cache/dump_online.php', "<?php\nunset(\$request);\n\$request = ". var_export($request, true) .";\n?>");
		file_put_contents('cache/dump_online.ini', time()+300);
	}
	return $request;
}

// Получение ника пользователя
function getNick() {
	global $login;
	return $login;
}

/*	UNICHAT	Func	END	*/
?>